#define     NULL        0
#define     TRUE        1
#define     FALSE       0
#define     ON          1
#define     OFF         0
#define     YES         1
#define     NO          0

/* ADinfo.ErrorFlg Definition */
#define     ADSUCCESS           0
/* Disassembler Error Flag */
#define     ERRORCODE           1
#define     INSUFFICIENTCODE    2
/* Assembler Error Flag */
#define     NMONICERR           3
#define     DSTOPRERR           NMONICERR+1
#define     SRCOPRERR           DSTOPRERR+1

/* ID code definition */
/*
#define IDCODE      0x1F
#define IDXDATA     0x01
#define IDDATA      0x02
#define IDIDATA     0x03
#define IDBDATA     0x04
#define IDCONST     0x05
*/

/* Constant Limitted */
#define     MAXDIGBYTE      4
#define     MAXCODELEN      3   /* byte */
#define     MAXNMONIC       5   /* Maxmun characters of nmonic string */
#define     MAXASMSTR       50  /* Maxmun characters of assembler string */
#define     BASEBYTELEN     1

/* Refer To 'Addressing Type Definition' */
#define     NULLTYPE         0      /* null                 */
#define     A                1      /* Accumulator          */
#define     AB               2      /* AB                   */
#define     C                3      /* Carry flg            */
#define     DPTR             4      /* DPTR                 */
#define     INDIR_DPTR       5      /* @DPTR                */
#define     INDIR_ADPTR     6      /* @A+DPTR              */
#define     INDIR_APC       7      /* @A+PC                */
#define     IMM_DATA1        8      /* #data (byte 1)       */
#define     IMM_DATA2        9      /* #data (byte 2)       */
#define     IMM_DATA16      10      /* #data16              */
#define     ADDR11          11      /* addr11               */
#define     ADDR16          12      /* addr16               */
#define     RN              13      /* Rn                   */
#define     INDIR_RI        14      /* @Ri                  */
#define     DIRECT1         15      /* direct address   */
#define     DIRECT2         16      /* direct (byte2)       */
#define     BITADR          17      /* bit address   */
#define     CBITADR         18      /* /bit                 */
#define     RELADR1         19      /* rel (byte 1          */
#define     RELADR2         20      /* rel (byte 2)         */
#define     DIR_REL         21      /* direct,rel           */
#define     IMM_DATA_REL    22      /* #data,rel            */

/* Nmonic Ordinal difination */
#define     ODN_ACALL       0
#define     ODN_ADD         1
#define     ODN_ADDC        2
#define     ODN_AJMP        3
#define     ODN_ANL         4
#define     ODN_CJNE        5
#define     ODN_CLR         6
#define     ODN_CPL         7
#define     ODN_DA          8
#define     ODN_DEC         9
#define     ODN_DIV         10
#define     ODN_DJNZ        11
#define     ODN_INC         12
#define     ODN_JB          13
#define     ODN_JBC         14
#define     ODN_JC          15
#define     ODN_JMP         16
#define     ODN_JNB         17
#define     ODN_JNC         18
#define     ODN_JNZ         19
#define     ODN_JZ          20
#define     ODN_LCALL       21
#define     ODN_LJMP        22
#define     ODN_MOV         23
#define     ODN_MOVC        24
#define     ODN_MOVX        25
#define     ODN_MUL         26
#define     ODN_NOP         27
#define     ODN_ORL         28
#define     ODN_POP         29
#define     ODN_PUSH        30
#define     ODN_RET         31
#define     ODN_RETI        32
#define     ODN_RL          33
#define     ODN_RLC         34
#define     ODN_RR          35
#define     ODN_RRC         36
#define     ODN_SETB        37
#define     ODN_SJMP        38
#define     ODN_SUBB        39
#define     ODN_SWAP        40
#define     ODN_XCH         41
#define     ODN_XCHD        42
#define     ODN_XRL         43
#define     ODN_ERR         255

typedef struct nmoicbasecode{
    BYTE *Nmonic;
    BYTE *AvailableBase;
    }NMONICBASE, *PNMONICBASE;
/*
typedef struct sfrname{
    BYTE *Name;
    BYTE DirAdr;
    WORD AvailableCPU;
    }SFRNAME, *PSFRNAME;
*/
typedef struct adopr{
BYTE NmonicOrdinal;
BYTE DstType;
BYTE SrcType;
}ADOPERAND, *PADOPERAND;


/* Structure */
typedef struct dsmstr{
BYTE Ptr;
BYTE Txt[MAXASMSTR];
}ADSTRING, *PADSTRING;

typedef struct dsminfo{
BYTE NmonicOrdinal;
BYTE DstType;
BYTE SrcType;
BYTE InsLength;
BYTE ErrorFlg;
BYTE EffectivePtr;
BYTE Code[MAXCODELEN];
}ADINFO, *PADINFO;


/* External Global Data */
extern code NMONICBASE NmonicAvailBase[];
extern code BYTE *AdrType[];
extern code SFRNAME SFRbyte[];
extern code SFRNAME SFRbit[];
extern WORD CurrentPC;
extern WORD CPUmode;
extern ADSTRING ADstr;
extern ADINFO ADinfo;

void asm(BYTE *);
void dsm();
//void put_char(BYTE);


#define put_char(chr) ADstr.Txt[ADstr.Ptr++] = chr;
