#include "dtype.h"
#include "cmddef.h"
#include "ad52.h"
#include "epdef.h"

PMEMOPRANGE pADMemOpRange;

extern BYTE CmdGroup;

PFINALMSG pADFinal;
FINALMSG AssumFinal;
short TraceDsmFrame;
BYTE TraceFinal;
#define TRACE_IF   1
#define TRACE_PR   2

code FINALMSG DstErr=
    {
    {0,CMDERR},
    "Destination Error!"
    };

code FINALMSG SrcErr=
    {
    {0,CMDERR},
    "Source Error!"
    };

code FINALMSG NmonicErr=
    {
    {0,CMDERR},
    "Nmonic Error!"
    };

PFINALMSG get_PC(pAdr)
PMEMADR pAdr;
{
BYTE i;

pAdr->AdrType.Low= 1;           /*program type*/
pAdr->AdrType.Hi=0x22;
pADFinal= get_a_reg(0/*PC*/, pAdr->Adr);
for (i=2; i<8; i++)
    pAdr->Adr[i]=0;
return pADFinal;
}

BYTE Trace_dsm(sFrame, pTraceBfr)
short sFrame;
BYTE *pTraceBfr;
{

   if (((PTRACFIELD)pTraceBfr)->Status==TRACE_IF) {
      CurrentPC= ((PTRACFIELD)pTraceBfr)->Adr.Low
                 + (((WORD)(((PTRACFIELD)pTraceBfr)->Adr.Hi))<<8);
      TraceDsmFrame= sFrame;
      TraceFinal= TRUE;
      dsm();
      if (TraceFinal==FALSE) {
         ADstr.Ptr = 0;
         put_char('?');
         put_char('\0');
      }
      return TRUE;
   }

   return FALSE;
}


PFINALMSG dsm_ent(pMemOpRange)
PMEMOPRANGE pMemOpRange;
{
// Add 4/14/94
//WORD tmpCPUmode ;


   pADMemOpRange=pMemOpRange;
   CurrentPC= ((WORD)(pADMemOpRange->StartAdr[1])<<8)+pADMemOpRange->StartAdr[0];
   AssumFinal.FinalCode.Hi=0;
   pADFinal=&AssumFinal;

// tmpCPUmode == CPUmode ; //+
// if ((tmpCPUmode == CM_VAR) || (tmpCPUmode == CM51FA)) //+
//    CPUmode = CM32 ; //+

   dsm();

// CPUmode = tmpCPUmode ; //+

   return pADFinal;
}

static WORD TraceLastAdr;
unsigned char get_opcode(indx)
unsigned char indx;
{
EVENTQUALIFY Qualify;
TRACFIELD TraceBfr;
WORD CurAdr;
MEMOPRANGE MemOpRange;
PFINALMSG pTraceFinal;

   if (CmdGroup != CMD_TRACE) {
      if (pADFinal->FinalCode.Hi)
         return 0;
      while (indx >= ADinfo.EffectivePtr) {
         copy_mem((BYTE *)&MemOpRange, (BYTE *)pADMemOpRange, sizeof(MEMOPRANGE));
         advance_adr((PMEMADR)&MemOpRange, (DWORD)ADinfo.EffectivePtr);
         pADFinal=read_mem(&MemOpRange,&ADinfo.Code[ADinfo.EffectivePtr]);
         ADinfo.EffectivePtr += 1;
      }
   }
   else {
      while (indx >= ADinfo.EffectivePtr) {
         Qualify.Address.Low = 0 ; /* no qualify */
         Qualify.Address.Hi = 0 ;
         Qualify.Data.Low = 0 ;
         Qualify.Data.Hi = 0 ;
         Qualify.Status = 0 ;
         pTraceFinal= read_trace(TraceDsmFrame++, READ_FORWARD, &Qualify, (BYTE *)&TraceBfr);
         if (pTraceFinal->FinalCode.Low== FALSE) {
            TraceFinal= FALSE;
            return 0;
         }
         if (ADinfo.EffectivePtr == 0) {
            TraceLastAdr= CurrentPC;
            ADinfo.Code[0]= TraceBfr.Data;
            ADinfo.EffectivePtr += 1;
         }
         else
            if (TraceBfr.Status == TRACE_PR) {
               CurAdr= ((WORD)TraceBfr.Adr.Hi << 8) + TraceBfr.Adr.Low;
               if (CurAdr != (TraceLastAdr+1)) {
                  TraceFinal= FALSE;
                  return 0;
               }
               TraceLastAdr= CurAdr;
               ADinfo.Code[ADinfo.EffectivePtr]= TraceBfr.Data;
               ADinfo.EffectivePtr += 1;
            }
      }
   }
   return ADinfo.Code[indx];
}

PFINALMSG asm_ent(pAsmAdr,pTxt)
PMEMADR pAsmAdr;
BYTE *pTxt;
{
BYTE i;
MDFYMEM MdfyMem;
// Add 4/14/94
//WORD tmpCPUmode ;


   CurrentPC = ((WORD)(pAsmAdr->Adr[1])<<8) + pAsmAdr->Adr[0];
   AssumFinal.FinalCode.Hi=0;
   pADFinal=&AssumFinal;

// tmpCPUmode == CPUmode ; //+
// if ((tmpCPUmode == CM_VAR) || (tmpCPUmode == CM51FA)) //+
//    CPUmode = CM32 ; //+

   asm(pTxt);

// CPUmode = tmpCPUmode ; //+

   switch(ADinfo.ErrorFlg) {
      case ADSUCCESS:
         copy_data((BYTE *)pAsmAdr,(BYTE *)&MdfyMem.Range.AdrType.Low, sizeof(MEMADR));
         MdfyMem.Range.AdrLen[0]= ADinfo.InsLength;
         MdfyMem.Range.AdrLen[1]= 0;
         MdfyMem.DataLen.Low=ADinfo.InsLength;
         MdfyMem.DataLen.Hi=0;
         for(i=0; i<ADinfo.InsLength; i++)
            MdfyMem.Data[i]= ADinfo.Code[i];
         pADFinal= fill_mem(&MdfyMem);
         return pADFinal;
      case NMONICERR:
         return &NmonicErr;
      case DSTOPRERR:
         return &DstErr;
      case SRCOPRERR:
      default:
         return &SrcErr;
   }
}

void copy_data(pD1,pD2,Cnt)
BYTE * pD1;
BYTE * pD2;
BYTE Cnt;
{
BYTE i;

   for (i=0; i<Cnt; i++)
      pD2[i]= pD1[i];
}

static MEMOPRANGE MemOpRange;

void ini_ent(void) {
BYTE i;

   pre_msg_form();
   MemOpRange.AdrType.Low= 1;              /*program type*/
   MemOpRange.AdrType.Hi=0x22;
   for (i=0; i < 8; i++) {
      MemOpRange.StartAdr[i]=0;
      MemOpRange.AdrLen[i]=0;
   }
   MemOpRange.AdrLen[0]=2;
   MemOpRange.OpSize.Low=0x10;
   MemOpRange.OpSize.Hi=0;
}

static BYTE cmp_str(BYTE *, BYTE *);
static BYTE cnv_case(BYTE);
PFINALMSG change_cpu_model(BYTE *);

static BYTE cmp_str(str1, str2)
BYTE *str1, *str2;
{
WORD i;

   while (*str1) {
      if (cnv_case(*str1) != cnv_case(*str2))
         return FALSE;
      str1++;
      str2++;
   }
   if (*str2)
      return FALSE;
   return TRUE;
}

static BYTE cnv_case(chr)
BYTE chr;
{
   if (chr >= 'a' && chr <= 'z')
      chr -= ('a'-'A');
   return chr;
}

typedef struct cpumlst{
   BYTE *name;
   WORD modelBit;
   BYTE subVer ;
} CPULST, *PCPULST;


code CPULST cpuModelList[]=
    {
    {"8031",    EP8031  ,'A'},
    {"8032",    EP8032  ,'A'},
    {"8344",    EP8344  ,'A'},
    {"8044",    EP8044  ,'A'},
    {"8051",    EP8051  ,'A'},
    {"8052",    EP8052  ,'A'},
    {"80154",   EP80154 ,'A'},
    {"83154",   EP83154 ,'A'},
    {"80152JA", EP80152A,'A'},
    {"80152JB", EP80152B,'A'},
    {"80152JC", EP80152C,'A'},
    {"80152JD", EP80152D,'A'},
    {"83152JA", EP83152A,'A'},
    {"83152JC", EP83152C,'A'},
    {"80C51FA", EP8051FA,'A'},
    {"83C51FA", EP8351FA,'A'},
    {"80CL31",  EP80CL31,'A'},
    {"80CL51",  EP80CL51,'A'},
//  {"80C451",  EP80C451,'A'},
//  {"83C451",  EP83C451,'A'},
//  {"80C528",  EP80C528,'A'},
//  {"83C528",  EP83C528,'A'},   Dec/27/1994 deng modify for 750
    {"80C750",  EP80C750,'A'},
    {"83C750",  EP83C750,'A'},

    {"80C550",  EP80C550,'A'},
    {"83C550",  EP83C550,'A'},
//  {"80C552",  EP80C552,'A'},   Dec/28/1994 Deng modify for 751
//  {"83C552",  EP83C552,'A'},
   {"80C751",  EP80C751,'A'},
   {"83C751",  EP83C751,'A'},

    {"80C562",  EP80C562,'A'},
    {"83C562",  EP83C562,'A'},
    {"80C575",  EP80C575,'A'},
    {"83C575",  EP83C575,'A'},
    {"80C592",  EP80C592,'A'},
    {"83C592",  EP83C592,'A'},
    {"80C652",  EP80C652,'A'},
    {"83C652",  EP83C652,'A'},
    {"83C752",  EP83C752,'A'},
    {"\0", 0, 0}
    };
static code FINALMSG ModelErr=
    {
    {0,CMDERR},
    "Invalid CPU model name!"
    };
void set_cpu_model();
PFINALMSG change_cpu_model(pModelName)
BYTE *pModelName; {
WORD TmpMode;
BYTE i;

   for (TmpMode=1, i= 0; cpuModelList[i].name[0]; i++, TmpMode << 1) {
      if (cmp_str(cpuModelList[i].name, pModelName)) {
         CPUmode = cpuModelList[i].modelBit;
         set_cpu_model();
         pre_msg_form();
         AssumFinal.FinalCode.Hi=0;
         return (&AssumFinal);
      }
   }
   return (&ModelErr);
}
