#define M8051
/* #define DSPC320C25 */

/* Limit defintion */
#define CELLLEN     128 /* definition Must same as fwasm.a51 (254>CELLLEN>127) */
#define MAXCELL     120 /* definition Must same as fwasm.a51 (>= 20) */
#define MAX_ADRCNT  100 /* for group address  trace/event qualify */

/* PARALLEL PORT DEFINITION */
sbit RXDRDY  = 0x95;
sbit TXDRDY  = 0x94;
sbit DISTXD  = 0x93;

typedef struct tracetitle{
    PACKWORD type;
    PACKWORD TitleLoc;
    }TRACETITLE, *PTRACETITLE;

typedef struct bfr{
	PACKWORD LineWidth; /* line with per text line */
	PACKWORD LineCnt;   /* the number of text line */
	BYTE String[1];     /* with terminater character per text line */
	}LINETXT, *PLINETXT;

typedef struct traceform{
    PACKWORD FrameLen;
    BYTE QlfyType[12];
    PACKWORD  FieldCnt;
    TRACETITLE Field[5];
    BYTE Title[1];
    }TRACEFORM, *PTRACEFORM;

typedef struct tracerec{
    PACKWORD Frame;
    PACKWORD Adr;
    BYTE Data;
    BYTE Status;
    BYTE Port ;
    BYTE Extrn;
    }TRACFIELD, *PTRACFIELD;


typedef struct iceset{
    WORD LineWidth;
    WORD LineCnt;
    BYTE String[1];
}ICESET, *PICESET;

typedef struct sfrname{
    BYTE *Name;
    BYTE DirAdr;
    WORD AvailableCPU;
    }SFRNAME, *PSFRNAME;

/* Occrence definition */
#define ET_STATIC       0x0001
#define ET_EPSTATUS     0x0002 /* EP Run/Stop, Verify On/Off, Trace On/Off */
#define ET_TRACEOFF     0x0004
#define ET_EPSTOP       0x0008
#define ET_REGMODIFY    0x0010
#define ET_PCCHANGE     0x0020
#define ET_MEMMODIFY    0x0040
#define ET_MAPCHANGE    0x0080
#define ET_SETSTATUS    0x0100
#define ET_BPCHANGE     0x0200

/* Memory Commands */
#define     CMD_MEMORY          0x05
#define     READ_MEM            0x01
#define     READ_VAR            0x03
#define     MONITOR_VAR         0x04
#define     FILL_MEM            0x05
#define     SRCH_DATA           0x06
#define     BLK_TRANS           0x07
#define     MEM_TEST            0x08
#define     CMP_MEM             0x09
#define     DISM                0x0A
#define     LINE_ASM            0x0B
/* #define     CMP_VARS            0x0C */
#define     SHOWMEMMAP          0x0D
#define     SETMEMMAP           0x0E
#define     WRITE_VAR           0x0F
#define     DSMRNGMODIY         0x10
#define     READ_STRING         0x11
#define     CAL_CHECKSUM        0x12
#define     MEMVERIFY           0x20
#define     READSTACK           0x21
#define     INPUT_DATA          0x41   
/* #define     CMP_INPUT           0xC2 */
#define     OUTPUT_DATA         0x43
/* Event Commands */
#define     CMD_EVENT           0x06
#define     SET_EVENT_QULFY     0x01
#define	    CLR_EVENT           0x02
#define	    TRIG_STATUS         0x04
#define	    SET_EXEBP           0x05
#define	    CLR_EXEBP           0x06
#define	    LINESET_EXEBP       0x09
#define	    LINECLR_EXEBP       0x0A
#define     SET_TRIGLEVEL       0x0B
#define     SET_TRIGGER         0x0C

typedef struct bfrlnk{
BYTE BlkLen;                /* Length of data in this block                 */
                            /* (not include BlkLen & ParmLnk)               */
BYTE *ParmLnk;     /* Next bffer cell  Index                       */
                            /* If pParmLnk =  ENDOFBLK indicates no more    */
BYTE Data[CELLLEN+1]; /* reserve one byte for data length */
}BFRLNK, *PBFRLNK;

typedef struct cmdqueue{
BYTE Current;
BYTE Last;
BYTE Len;
PBFRLNK pCell[MAXCELL];
}BFRQUEUE, *PBFRQUEUE;

typedef struct memradr{
    PACKWORD AdrType;
    BYTE Adr[8];
}MEMADR, *PMEMADR;

typedef struct inistatus{
    WORD Status;
    PACKWORD AdrType;
    BYTE Adr[8];
}INISTATUS, PINISTATUS;
#define MAXINIMSG   50
typedef struct statusq{
BYTE Current;
BYTE Last;
BYTE Len;
INISTATUS IniStatus[MAXINIMSG];
}STATUSQ, PSTATUSQ;

typedef struct finalmsg{
    PACKWORD FinalCode;
    BYTE *pDetail;
}FINALMSG, *PFINALMSG;

typedef struct memoprange{
    PACKWORD AdrType;
    BYTE StartAdr[8];
    BYTE AdrLen[8];
    PACKWORD OpSize;
}MEMOPRANGE, *PMEMOPRANGE;

typedef struct memrange{
    PACKWORD AdrType;
    BYTE StartAdr[8];
    BYTE AdrLen[8];
}MEMRANGE, *PMEMRANGE;

typedef struct memvar{
    PACKWORD VarType;
    PACKWORD AdrType;
    BYTE VarAdr[8];
    BYTE Data[32];
}MEMVAR, *PMEMVAR;

typedef struct ioport{
PACKDWORD Msk;
PACKDWORD Port;
}IOPORT, *PIOPORT;

typedef struct outparm{
PACKDWORD Msk;
PACKDWORD Port;
BYTE Data[4];
}OUTPARM, *POUTPARM;

typedef struct eventqualify{
/*PACKWORD SetMode;*/
PACKWORD StartEvent; 
PACKWORD EndEvent; 
PACKWORD Address; 
PACKWORD Data; 
BYTE Status;
BYTE External;
BYTE Count;
BYTE Reserve1;
BYTE Data1[4];
BYTE Data2[4];
BYTE status[4];
BYTE Extern[4];
BYTE Extmsk[4];
PACKDWORD count;
PACKWORD Reserved2[3];
PACKWORD AdrCnt;
BYTE Adr1[8];
BYTE Adr2[8];
}EVENTQUALIFY, *PEVENTQUALIFY;

/*
typedef struct exebrk{
PACKWORD BrkNp;
PACKWORD AdrType;
BYTE Adr[8];
}EXEBRK, *PEXEBRK;
*/

typedef struct setevresult{
PACKWORD Result; 	/* 0 Setting fail */
		 	/* 1 Set OK       */
PACKWORD NoOfExclsv; 	/* Number of exclusiv events */
PACKWORD ExclsvLst[1];
}SETEVRESULT, *PSETEVRESULT;

typedef struct mdfymem{
MEMRANGE Range;
PACKWORD Reserved;
PACKWORD DataLen;
BYTE Data[256];
}MDFYMEM, *PMDFYMEM;

typedef struct srchmem{
MEMRANGE MemRange;
PACKWORD Reserved;
PACKWORD SrchFlg;
PACKWORD DataLen;
BYTE Data[1];
}SRCHMEM, *PSRCHMEM;

typedef struct logblt{
PACKWORD OpCode;
PACKWORD OpSize;
MEMADR	SrcAdr;
MEMADR	DstAdr;
BYTE BlkLen[4];
}LOGBLT, *PLOGBLT;

typedef struct cmpmem{
PACKWORD OpSize;
MEMADR	SrcAdr;
MEMADR	DstAdr;
BYTE BlkLen[4];
}CMPMEM, *PCMPMEM;


/*
typedef struct lineasm{
MEMADR Adr;
BYTE SrcCode[1];
}LINEASN, *PLINEASM;
*/

typedef struct regdata{
PACKWORD RegOdn;
BYTE Data[4];
}REGDATA, *PREGDATA;

typedef struct bpqueue{
BYTE Status;
BYTE LastCell;
BYTE Index;
WORD StartID;
WORD EndID;
MEMADR sAdr;
MEMADR eAdr;
PBFRLNK pCell[MAXCELL];
}BPQUEUE, *PBPQUEUE;

typedef struct rngstep{
WORD Len;
WORD Over;    /* 0 step into */
              /* 1 step over */
}RNGSTEP, *PRNGSTEP;

typedef struct runparm{
BYTE RunFlg;    /* 0    without RUN             */
                /* 1    with RUN                */
BYTE FlyFlg;    /* 0    without on-the-fly      */
                /* 1    with on-the-fly         */
MEMADR FromAdr; /* address type=0	from PC     */
                /* ~=0	go from "FromAdr"       */
MEMADR TillAdr; /* address type=0	free run    */
                /* ~=0	go untill "TillAdr"     */
}RUNPARM, *PRUNPARM;
#define WITHOUTRUN  0
#define WTHRUN      1
#define WITHOUTFLY  0
#define WITHFLY     1

/* Command Head definition */
#define CMD_NO   0x00        /* Command code                                 */
#define CMD_ID   0x02        /* Command ID                                   */
#define CMD_PARM 0x04        /* Command parameter start                      */

/* Message Head definition */
#define MSG_ID       0x00   /* Message code                                 */
#define MSG_CMDNO    0x02   /* Command which the message echos              */
#define MSG_CMDID    0x04   /* Command ID which the message echos           */
#define MSG_RECNO    0x06   /* Record No.                                   */
#define MSG_FINAL    0x08   /* Final code                                   */ 
#define MSG_PARM     0x0A   /* Dependent message start here                 */


/* 0107 Message Form Demand */
#define CMD_MSGFORMID       0x04

/* 0189: Run EP when condition match */
/*
#define EPFREERUN       0
#define EPSTEP          1    
*/
/* Run Flag */
/*
#define RUNDISABLE      0
#define RUNANYWAY       1
#define RUNALLTRUE      2
#define RUNALLFALSE     3
#define RUNANYONETRUE   4
#define RUNANYONFALSE   5
*/

typedef struct eprun{
    BYTE RunFlg;
    BYTE StepRun;
    }EPRUN, *PEPRUN;
/*
#define CMD_RUNFLG      0x04
#define CMD_STEPRUN     0x05
#define CMD_CONDCNT     0x06
#define	CMD_CONDCMD     0x08
#define	CMD_CONDID      0x0A
*/

/* Init message definition */

/* 010A Report when EP status changed */
/* #define CMD_EPSFLG      0x04 */

/* 0203 Compare Register with Variable */
#define CMD_CMPREG_REPFLG       0x04
#define CMD_CMPREG_REGTYPE      0x06
#define CMD_CMPREG_REGODN       0x08
#define CMD_CMPREG_VARTYPE      0x0A
#define CMD_CMPREG_ADRTYPE      0x0C
#define CMD_CMPREG_VARADR       0x0E
/********************************************/
#define MSG_CMPREG_REPFLG       0x0A
#define MSG_CMPREG_REGDATA      0x0C
#define MSG_CMPREG_VARDATA      0x10

/* 0204 READ A REGISTER */
#define     CMD_READ_A_REG_ODN      0x04
/********************************************/
#define     MSG_READ_A_REG_ODN      0x0A
#define     MSG_READ_A_REG_DATA     0x0C



/* 0301 Read Trace Buffer */
#define READ_FORWARD    0
#define READ_BACKWARD   1
#define END_TRACEREC    0x00
#define TRACE_REC       0x01
#define DSM_REC         0x02
/* #define LAST_TRACEREC   0x03 */

#define CMD_RDTRACE_READMODE    0x04
#define CMD_RDTRACE_STARTFRM    0x06
#define CMD_RDTRACE_LENFRM      0x08
#define CMD_RDTRACE_QUALIFY     0x0A
/*******************************/
#define MSG_RDTRACE_DATA        0x0A

/* 0406 Line step command */
#define CMD_LSTEP_SCMDID        0x04
#define CMD_LSTEP_ECMDID        0x06

/* 0407 Next line step command */
#define CMD_NLSTEP_SCMDID       0x04
#define CMD_NLSTEP_ECMDID       0x06
#define CMD_NLSTEP_SADRTYPE      0x08
#define CMD_NLSTEP_SADR          0x0A
#define CMD_NLSTEP_EADRTYPE      0x12
#define CMD_NLSTEP_EADR          0x14

/* 0501 Read memory content */
#define CMD_RDMEM_ADRLEN        0x0E
/*************************/
#define MSG_READMEM_DATA        0x1E

/* 0511 Read a string */
#define CMD_READSTR_MAXLEN        0x0E  /* maxmun length(include NULL) of read*/
#define CMD_READSTR_DIRECT        0x10  /* word flag 0 indirect */
                                        /*           1 direct   */
/*************************/
#define MSG_READSTR_DATA        0x1E

/* 0503 Read variable */
/* 0504 Read EMM variable */
/*************************/
#define MSG_READ_VAR_DATA       0x16

/* 0505 */
#define CMD_FILL_MEM_DATALEN	0x18
/*************************/

/* 0506 */
#define CMD_SRCH_DATA_DATALEN	0x1A
/*************************/

/* 050A Disassembler */
#define CMD_DSM_MODE        0x04
#define         FROME_ADDR          0
#define         FROME_PC            1
#define         DSM_CONTINUE        2
#define         FROME_PC_RANGE      3
#define         FROME_ADDR_RANGE    4
#define         FROME_LAST_RANGE    5

#define CMD_DSM_SAVFLG      0x06
#define CMD_DSM_WITHBP      0x07
#define CMD_DSM_ADRTYPE     0x08
#define CMD_DSM_ADR         0x0A
#define CMD_DSM_FRMTYPE     0x06
#define CMD_DSM_LINELEN     0x12
#define CMD_DSM_ADRLEN      0x14
/**************************/
#define MSG_DSM_ADRTYPE     0x0A
#define MSG_DSM_ADR         0x0C
#define MSG_DSM_RESULT      0x14

/* 050B Assembler */
#define CMD_ASM_ADRTYPE     0x04
#define CMD_ASM_ADR         0x06
#define CMD_ASM_TXT         0x0E
/***********************/
#define MSG_ASM_ADRTYPE     0x0A
#define MSG_ASM_ADR         0x0C
#define MSG_ASM_CODELEN     0x14
#define MSG_ASM_CODE        0x16

/* 050C Compare variables */
#define CMD_CMPVARS_REPFLG      0x04
#define CMD_CMPVARS_VARTYPE1    0x06
#define CMD_CMPVARS_ADRTYPE1    0x08
#define CMD_CMPVARS_VAR1        0x0A
#define CMD_CMPVARS_VARTYPE2    0x12
#define CMD_CMPVARS_ADRTYPE2    0x14
#define CMD_CMPVARS_VAR2        0x16
/*******************************/
#define MSG_CMPVARS_REPFLG  0x0C
#define MSG_CMPVARS_VAR1    0x0E
#define MSG_CMPVARS_VAR2    0x12

/* 050D Show map */
/*******************************/
#define CMD_SHOWMEMMAP_ADRTYPE   0x0A
#define CMD_SHOWMEMMAP_LINEWIDTH 0x0C


/* 0508 Show BP */
#define CMD_SHOWBP_ADRTYPE  0x04
#define CMD_SHOWBP_ADR      0x06
#define CMD_SHOWBP_ADRLEN   0x0E
#define CMD_SHOWBP_MAXLST   0x16

/* 0510 Disassembler range modigy */
#define CMD_DSMRNG_SADRTYPE 0x04
#define CMD_DSMRNG_LEN      0x0E

/* 0541 Input Data */
#define CMD_INPUT_PORT          0x04
#define CMD_INPUT_MSK           0x06
/*************************/
#define MSG_INPUT_PORT          0x0A
#define MSG_INPUT_MSK           0x0C
#define MSG_INPUT_DATA          0x0E

/* 0521 Read stack */
#define CMD_READSTK_START    	0x04
#define CMD_READSTK_COUNT		0x06
/*****************************************/
#define MSG_READSTK_START    	0x0A
#define MSG_READSTK_COUNT		0x0C
#define MSG_READSTK_DTYPE   	0x0E
#define MSG_READSTK_DATA       	0x10

typedef struct stackdata{
    PACKWORD AdrType;
    BYTE StkAdr[8];
    BYTE Data[4];
}STACKDATA, *PSTACKDATA;

typedef struct{
PACKWORD StackPtr;
PACKWORD Length;
PACKWORD DataType;
STACKDATA StackData[1];
}STACKMSG, *PSTACKMSG;

/* 0542 Compare Input with Variable */
#define CMD_CMPIN_REPFLG    0x04
#define CMD_CMPIN_INDTYPE   0x06
#define CMD_CMPIN_PORT      0x08
#define CMD_CMPIN_OPFLG     0x0A
#define CMD_CMPIN_VARTYPE   0x0C
#define CMD_CMPIN_ADRTYPE   0x0E
#define CMD_CMPIN_VARADR    0x10
/*****************************************/
#define MSG_CMPIN_REPFLG    0x0A
#define MSG_CMPIN_INDATA    0x0C
#define MSG_CMPIN_VARDATA   0x10

/* 0601 Set event */
#define GROUPADR 0x40
/********************************/
#define CMD_SETEV_MODE   0x04
#define CMD_SETEV_QUALIFY 0x06
#define CMD_SETEV_ADRCNT 0x28
#define CMD_SETEV_ADR1   0x2A
#define CMD_SETEV_ADR2   0x32
/********************************/
#define MSG_SETEV_EXCLSV 0x0C

/* 0602 Clear event */
#define CMD_CLREV_START	0x04
#define CMD_CLREV_END	0x06

/* 0609 Line execution break point setting */
#define CMD_LINEBPSET_ADRLEN 0x04
#define CMD_LINEBPSET_ADRTYP 0x08
#define CMD_LINEBPSET_ADR    0x0A
#define CMD_LINEBPSET_OFST   0x12

/* bfrcell.c51 function */
void alloc_bfr(PBFRLNK *);
/*void free_cell(PBFRLNK);*/
void release_cell(PBFRLNK);
void free_lnkcell(PBFRLNK);
BYTE * take_addr(PBFRLNK, WORD);
BYTE take_byte(PBFRLNK, WORD);
WORD take_word(PBFRLNK, WORD);
DWORD take_dword(PBFRLNK, WORD);
BYTE take_cmdbyte(WORD);
WORD take_cmdword(WORD);
DWORD take_cmddword(unsigned  short);

/* H/W library */
PFINALMSG init_EP(PMEMADR);
PFINALMSG start_EP(PRUNPARM);
PFINALMSG stop_EP();
PFINALMSG get_reg(BYTE **);
PFINALMSG modify_reg(PREGDATA);
PFINALMSG get_a_reg(WORD, BYTE *);
PFINALMSG read_var(PMEMVAR , BYTE *);
PFINALMSG read_trace(WORD, WORD, PEVENTQUALIFY, BYTE *);
PFINALMSG inst_step();
PFINALMSG call_step();
PFINALMSG range_step(PRNGSTEP);
PFINALMSG cycle_step(PLINETXT *);
PFINALMSG cycle_wait(PLINETXT *);
PFINALMSG read_EMM(PMEMOPRANGE, DWORD, BYTE *);
PFINALMSG read_mem(PMEMOPRANGE, BYTE *);
PFINALMSG cmp_mem(PCMPMEM, PMEMADR);
PFINALMSG input(PIOPORT, BYTE *);
PFINALMSG read_var(PMEMVAR, BYTE *);
PFINALMSG fill_mem(PMDFYMEM);
PFINALMSG srch_mem(PSRCHMEM, PMEMADR);
PFINALMSG log_blt(PLOGBLT);
PFINALMSG tst_mem(PMEMOPRANGE, PMEMADR);
PFINALMSG set_verify(BYTE);
PFINALMSG output(POUTPARM);
PFINALMSG set_event(WORD,PEVENTQUALIFY/*, PSETEVRESULT*/);
PFINALMSG clr_event(WORD,WORD);
PFINALMSG clr_exbp(PMEMADR);
PFINALMSG set_trig_logic(BYTE *);
PFINALMSG set_trig_level(BYTE *);
PFINALMSG set_trig_status(BYTE);
PFINALMSG set_exbp(PMEMADR);
PFINALMSG cle_exbp(PMEMADR);
PFINALMSG dsm_ent(PMEMOPRANGE);
PFINALMSG asm_ent(PMEMADR, BYTE *);
PFINALMSG get_PC(PMEMADR);
PFINALMSG query_exebp(PMEMADR, PMEMADR);
PFINALMSG transparent_cmd(WORD, WORD);
PFINALMSG read_a_stack(short, PSTACKDATA);
PFINALMSG set_map(BYTE *);
PFINALMSG show_setting(PICESET *);
PFINALMSG set_lineBP(BYTE *, PMEMADR, PMEMADR);
PFINALMSG clr_lineBP(BYTE *, PMEMADR, PMEMADR);
PFINALMSG ini_timer(BYTE);
PFINALMSG ini_trace(BYTE);
PFINALMSG show_map(WORD,PLINETXT *);
PFINALMSG checksum(PMEMOPRANGE, PACKDWORD *);
PFINALMSG self_test(PLINETXT *);
PFINALMSG EPROM_func(BYTE *,PLINETXT *);
PFINALMSG select_port(WORD);
PFINALMSG change_PC(PMEMADR);
PFINALMSG download_config(BYTE *);
PFINALMSG upload_config(BYTE *);
BYTE is_trace_qualified();
void read_stack(short, WORD);
void set_groupbp(BYTE);
void clr_groupbp();
void save_exebp();
void reset_exebp();
void free_cell(PBFRLNK);

/* cmdproc.c51 function */
void cmd_proc();
void send_msg(BYTE);
void alloc_msg();
void putmsg_word(WORD, WORD);
void putmsg_dword(WORD, DWORD);
void putmsg_blk(WORD, BYTE *, WORD);
void put_assume_msg();
void cmd_error();
void init_CP();
void set_errmsg(BYTE, BYTE *);
void putmsg_str(WORD,BYTE *);
void putmsg_byte(WORD,BYTE);
void copy_data(BYTE *, BYTE *, BYTE);
void copy_str(BYTE *, BYTE *, WORD);
void ini_ent();
short adjust_stack(short);
WORD get_stktype();
BYTE advance_adr(PMEMADR, DWORD);
BYTE is_last_adr(PMEMADR, PMEMADR);
void show_exebp(PBFRLNK);
void nxt_msg();
void send_inimsg();
BYTE in_range(PMEMADR, PMEMADR, PMEMADR);
void pre_msg_form();
void free_cell(PBFRLNK);
void readstr_cmd();
void copy_cmdtobfr(WORD, BYTE *, WORD);
void copy_cmdtomsg(WORD, WORD, WORD);
void copy_mem(BYTE *, BYTE *, WORD); // dest, src, length

/***************************************/
/* Dependent defineition               */
/* Need Modify If Deferent ICE Model   */
/***************************************/
#ifndef M8051
error ICE module
#endif

#if 0
// move to epdef.h
/* CPU Mode bit definition */
#define     CM31            0x0001
#define     CM32            0x0002
#define     CM44            0x0004
#define     CM154           0x0008
#define     CM152A          0x0100
#define     CM152B          0x0200
#define     CM152C          0x0400
#define     CM152D          0x0800
#define     CM51FA          0x4000
#endif

PFINALMSG write_var(PMEMVAR);
/* not neceserry command supported */
/*
#define     SEL_MODEL           0x00
#define     CMD_TRACE           0x03
#define     READ_TRACE          0x01
#define     SEL_TRPORT          0x02
#define     SEEK_TRACE          0x03
#define     CYCLE_STEP          0x04
#define     CYCLE_WAIT          0x05
#define     READ_EMM            0x02
#define	    SHOW_EVENT          0x07
#define     SHOW_EXEBP          0x08
#define     EPROM_CMD           0x20
*/

#define CMDCNT 10
#define     SEL_MODEL           0x00
/* Trace Commands */
#define     CMD_TRACE           0x03
#define     READ_TRACE          0x01
#define     SEL_TRPORT          0x02
#define     SEEK_TRACE          0x03
/* Instruction Step Commands */
#define     STEP_RANGE_PC       0x03
#define     CYCLE_STEP          0x04

/* Memory Commands */
#define     INPUT_DATA          0x41   
#define     OUTPUT_DATA         0x43
/* event command */
#define     SHOW_EXEBP          0x08
/* Miscellaneous command */
#define     EPROM_CMD           0x20

/* About final code */
#define     LASTMSG     0x00
#define     MOREMSG     0x01
#define     TRACEON     0x04
#define     TRIGGER     0x08
#define     EPSTATUS    0x70
#define     EPSTOP      0x40
#define     EPSTOPBREAK     0x00
#define     EPSTOPUSER      0x10
#define     EPSTOPWRITE     0x20
#define     EPSTOPGUARD     0x30
#define     EPRUNNING       0x40
#define     EPWAIT          0x50
#define     EPHALT          0x60
#define     MVERIFY         0x80

/* Bp status definition */
#define ORGBP       0
#define LSTEPBP     1
#define NLSTEPBP    2

/* Final code definition */
#define SYSERR      0x10
#define CMDERR      0x20
#define PROCERR     0x30
#define EPRUNGERR   0x40
#define TRACERUNERR 0x60
#define VERIFYERR   0x70
#define WARNINGMSG  0x80
