/******************************************************************/
/* DEF51.INC: Some definetion of MICE51                           */
/*        This file could be included by C or Assembler program   */
/******************************************************************/


/* MICE 51 address type definition */
#define MICE51_CODE         0x2201
#define MICE51_XDATA        0x2202
#define MICE51_IDATA        0x2103
#define MICE51_SFR          0x2104
#define MICE51_BDATA        0x2105

/* Register ordinal */
#define REG_PC              0
#define REG_SP              4

/* block transfer operation flag */
#define DSTINV              0x0001
#define BLTOPMSK            0x00F0 
#define BLTCOPY             0x0010
#define BLTOR               0x0020
#define BLTAND              0x0030
#define BLTXOR              0x0040
#define SRCINV              0x0100

/* Map status definetion */
#define MAP_I               0           /* internal memory              */
#define MAP_IR              1           /* internal memory & read only  */
#define MAP_E               2           /* external memory              */
#define MAP_ER              3           /* external memory & read only  */
#define MAP_C               4           /* memory combine               */
#define MAP_CR              5           /* memory combine & read only   */
#define MAP_G               6           /* memory guard                 */
