;*******************************************************************
;* DEF51.INC: Some definetion of MICE51                            *
;*        This file must identify def51.h                          *
;*******************************************************************

;*** MICE 51 address type definition ***/
MICE51_CODE             equ 2201H
MICE51_XDATA            equ 2202H
MICE51_IDATA            equ 2103H
MICE51_SFR              equ 2104H
MICE51_BDATA            equ 2105H

;*** Register ordinal ***/
REG_PC                  equ 0
REG_SP                  equ 4

;*** block transfer operation flag ***/
DSTINV                  equ 0001H
BLTOPMSK                equ 00F0H
BLTCOPY                 equ 0010H
BLTOR                   equ 0020H
BLTAND                  equ 0030H
BLTXOR                  equ 0040H
SRCINV                  equ 0100H

;*** Map status definetion ***/
MAP_I                   equ 0           ;internal memory
MAP_IR                  equ 1           ;internal memory & read only
MAP_E                   equ 2           ;external memory
MAP_ER                  equ 3           ;external memory & read only
MAP_C                   equ 4           ;memory combine
MAP_CR                  equ 5           ;memory combine & read only
MAP_G                   equ 6           ;memory guard
