#
#  Name: makefile.mak
#
#  Description: Make definitions for EZ8052 firmware
#               for FrankLin C make.exe
#
#  $Log$
#
#  $Header$
#
#  COPYRIGHT (C) 1993 MICROTEK INTERNATIONAL, INC.
#


#
# files
#
SRC = .
BIN = bin
FCDIR = r:\tool\c51.v24
#FCDIR = D:\c51.v32
INC = $(FCDIR)\inc
CCDIR = $(FCDIR)
#CCDIR = $(FCDIR)\BIN
ASMDIR = $(FCDIR)
#ASMDIR = $(FCDIR)\BIN
#LNKDIR = $(FCDIR)
LNKDIR = $(FCDIR)\BIN
USDDIR = c:\USD
LIBDIR = $(FCDIR)\LIB
#DEEMAX = c:\deemax
TMPDIR = c:
# Verison number
VER = 13

.SUFFIXES:      .HEX .ABS .OBJ .C .A51 .H .A${VER}

#		*Translator Definitions*
#  Macros definition
#
ASM = $(ASMDIR)\A51
ASMFLAG = DEBUG
#LINK = $(LNKDIR)\xlink86
#LINK = $(LNKDIR)\xlink86e
LOC = $(ASMDIR)\L51
OH51 = $(ASMDIR)\oh51
CONV = $(USDDIR)\CONVERT
CONVEZ = CONVEZ
#OMFCONV = $(DEEMAX)\omfconv
CODEGEN = conv52
CHKSUM = omfcksum
CC = $(CCDIR)\c51
CFLAG = large debug oe OT(0) CODE


#		*Implicit Rules*
.C.obj:
 SET C51INC=${INC}
 SET C51TEMP=${TMPDIR}
 ${CC} ${SRC}\$*.c ${CFLAG} PR(${TMPDIR}\ERR.LST) OJ(${BIN}\$*.obj)
#find "error " ${TMPDIR}\err.lst > $*.lst
#find "warning " ${TMPDIR}\err.lst >> $*.lst

.A${VER}.obj:
 ${ASM} ${SRC}\$*.A${VER} ${ASMFLAG} NOPR EP(${TMPDIR}\err.lst) OJ(${BIN}\$*.obj)

.A51.obj:
 $(ASM) ${SRC}\$*.A51 ${ASMFLAG} NOPR EP(${TMPDIR}\err.lst) OJ(${BIN}\$*.obj)

# define all objs
LNK_depends = ${BIN}\hwtst52.obj ${BIN}\hwSUB52.obj ${BIN}\LLFW52.OBJ ${BIN}\icehwlib.obj ${BIN}\FWASM.OBJ \
              ${BIN}\VERIFY.OBJ ${BIN}\PROGRAM.OBJ ${BIN}\LOAD.OBJ ${BIN}\BLANKCK.OBJ ${BIN}\EPROMINI.OBJ \
              ${BIN}\SWSUB52.OBJ ${BIN}\DATA52.OBJ ${BIN}\ADENT52.OBJ ${BIN}\EPROM.obj ${BIN}\PROG45.OBJ \
              ${BIN}\sfr52.OBJ ${BIN}\INITDATA.OBJ
#
${BIN}\FW52.ABS : ${LNK_depends}
 SET C51LIB=$(LIBDIR)
 echo ${BIN}\fwmain.obj,       &  > ${TMPDIR}\tmp.lnk
 echo ${BIN}\CMDPROC.OBJ,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\BFRCELL.OBJ,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\SWSUB52.OBJ,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\FWASM.OBJ,        & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\DATA52.OBJ,       & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\DSM52.OBJ,        & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\ASM52.OBJ,        & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\ADATA52.OBJ,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\ADENT52.OBJ,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\icehwlib.obj,     & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\PROG45.OBJ,       & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\hwtst52.obj,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\initdata.obj,     & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\BLANKCK.OBJ,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\LOAD.OBJ ,        & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\VERIFY.OBJ,       & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\EPROM.OBJ,        & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\EPROMINI.obj,     & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\LLfw52.obj,       & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\SFR52.obj,        & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\hwsub52.obj       & >> ${TMPDIR}\tmp.lnk
#to ${BIN}\fw52.abs IXREF MAP SYMBOLS NOOVERLAY
 echo to ${BIN}\fw52.abs       & >> ${TMPDIR}\tmp.lnk
#BIT(BVAR(60h))          &
 echo IXREF MAP SYMBOLS        & >> ${TMPDIR}\tmp.lnk
 ${LOC}  @${TMPDIR}\tmp.lnk
 del ${TMPDIR}\tmp.lnk
#$(CONV) ${BIN}\fw52.abs
 ${CHKSUM} ${BIN}\fw52.abs 0ffff
#$(OMFCONV) ${BIN}\fw52.abs
 if exist ${TMPDIR}\ERR.LST del ${TMPDIR}\TMP.LST
 if exist ${SRC}\fw52.HDF del ${SRC}\fw52.HDF
 if exist ${BIN}\fw52.hex del ${BIN}\fw52.hex
 copy ${BIN}\fw52.abs .
 set TMP=C:
 ${CONVEZ} fw52.abs

#FW52.HEX : FW52.ABS
# $(PROM) ${BIN}\main186.abs to ${BIN}\main186.hex hex ad(0d0000h, 0fffffh)\
#         INITDATA EA

#		*Explicit Rules*
#FWMAIN.OBJ: ${SRC}\FWMAIN.c

${BIN}\LLFW52.OBJ : ${SRC}\LLFW52.A$(VER) ${SRC}\IO.equ

#${BIN}\hwtst52.OBJ : ${SRC}\hWtst52.A$(VER) ${SRC}\IO.equ

${SRC}\can_ez52.dw : ${SRC}\can_ez52.A$(VER)
 $(ASM) ${SRC}\$*.A$(VER) NOOJ
 $(CODEGEN) ${SRC}\$*.LST ${SRC}\$*.DW ${SRC}\$*.EQU ${SRC}\$*.TBL

${SRC}\can_ez52.tbl : ${SRC}\can_ez52.A$(VER)
 $(ASM) ${SRC}\$*.A$(VER) NOOJ
 $(CODEGEN) ${SRC}\$*.LST ${SRC}\$*.DW ${SRC}\$*.EQU ${SRC}\$*.TBL

${SRC}\can_ez52.EQU : ${SRC}\can_ez52.A$(VER)
 $(ASM) ${SRC}\$*.A$(VER) NOOJ
 $(CODEGEN) ${SRC}\$*.LST ${SRC}\$*.DW ${SRC}\$*.EQU ${SRC}\$*.TBL


${BIN}\DATA52.obj : ${SRC}\DATA52.A$(VER)


${BIN}\hwsub52.obj : ${SRC}\hwsub52.A$(VER) ${SRC}\can_ez52.dw ${SRC}\CAN_EZ52.EQU ${SRC}\IO.equ


#${BIN}\initdata.obj : ${SRC}\INITDATA.A$(VER)


${BIN}\icehwlib.obj: ${SRC}\icehwlib.c ${SRC}\icehwlib.h ${SRC}\io.h ${SRC}\can_ez52.tbl ${SRC}\basetype.h


${BIN}\ADENT52.OBJ : ${SRC}\ADENT52.C ${SRC}\cmddef.h ${SRC}\ad52.h


${BIN}\SWSUB52.OBJ : ${SRC}\SWSUB52.C ${SRC}\cmddef.h ${SRC}\ad52.h


${BIN}\SFR52.OBJ : ${SRC}\SFR52.C ${SRC}\cmddef.h ${SRC}\ad52.h


#${BIN}\FWASM.OBJ : ${SRC}\FWASM.A$(VER)


#${BIN}\EPROM.OBJ : ${SRC}\EPROM.A$(VER)


#${BIN}\VERIFY.OBJ : ${SRC}\VERIFY.A$(VER)


#${BIN}\PROG45.OBJ : ${SRC}\PROG45.A$(VER)


#${BIN}\LOAD.OBJ : ${SRC}\LOAD.A$(VER)


#${BIN}\BLANKCK.OBJ : ${SRC}\BLANKCK.A$(VER)


#${BIN}\PROGRAM.OBJ : ${SRC}\PROGRAM.A$(VER)


#${BIN}\EPROMINI.obj : ${SRC}\EPROMINI.A$(VER)

