/****************************************************************************
**
**  Name:  icehwlib.c
**
**  Description:
**     This is the h/w lib program of the EZ8052 firmware.
**
**  Status:  PRELIMINARY
**
**  $Log$
**
**  $Header$
**
**  Copyright (C) 1993 Microtek International.  All rights reserved.
*****************************************************************************/
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#define _ICEHWLIB_C

#include <reg51.h>
#include <string.h>
#include <stdio.h>

#include "basetype.h"
#include "icehwlib.h"
#include "fwmain.h"
#include "can_ez52.tbl"

#include "io.h"
#include "epdef.h"

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

static FINALMSG   fwMsg ;
U8         traceQualifyOn ; /* bit 0 -> current trace qualify setting */
                            /* bit 1 -> before stop trace qualify setting */
U8         cmdBuf[20] ;
#if 0
static code FINALMSG INVAILD_EVENT = {
0, CMD_SYNTAX_ERR,
"Invaild event no!" };
#endif
code FINALMSG INVAILD_LEVEL = {
0, CMD_SYNTAX_ERR,
"Invaild level no!" };

//static code U8 RESET_ENABLE[] = "RESET ENABLED         " ;
//static code U8 DISABLE_MSG[] = "DISABLED" ;

extern code FINALMSG ErrStackOv ;  /* Out of the stack range!  */
extern code FINALMSG ErrEpRun  ;   /* Command ignored because EP running! */
extern code FINALMSG ErrEpWait ;   /* Command ignored because EP wait! */
extern code FINALMSG ErrEpHalt ;   /* Command ignored because EP halt! */
extern code FINALMSG ErrTraceRun ; /* Command ignored because Trace running! */


U8  LdFail ;
/* EP bit flag, bit 0 -> .EA, bit 1 -> .TR0, bit 2 -> .TR1,bit 3 -> .TR2 */
/*                            TR2 , TR1 , TR0 , EA  */
//static code U8 MASK_FLG[4] = {0x08, 0x04, 0x02, 0x01} ;
// static code U8 SFR_ADR[4]  = {0xCA, 0x8E, 0x8C, 0xAF} ;
#define  SETB  0xD2
#define  CLR   0xC2

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

extern U8  timerHigh ;
extern U32 timerLow  ;
extern U8  initTrigger ; /* bit 0-> timer, bit 1 -> trace */
extern U8  fwMsgString[100] ;
extern U8  tmpBuf[] ; /* for PLINETXT type use */
extern U8  tmpRnBuf[8] ;
extern U32 ev1Count ;

extern U16  CPUmode ; /* CPU Mode bit definition */
extern bit  coldStart ;         /* =1 -> cold start */

/* llfw52.a00 */
void OutHex16(U8 *bPtr) ; /* out bAddrH, bAddrL as hex string to bPtr */
void WVFail(U8 *) ;
U8   CheckBR_OVER(PFINALMSG) ;
/* hwtst52.a00 */
U8   RomChksum(void) ;
U8   SramTest(void) ;
U16  EpTest(void) ;
void InitHW(void) ;
U32  ChkTraSize(void) ;
/* sub52.a00 */
void Out_Trig(U8) ;
U8   CanRW(void) ;
U8   CanRdPara(void) ;
U8   CanWr(void) ;
U8   CanWrPara(void) ;
void WrEV_D(void) ;
U8   RdEV_D(void) ;
void WrEV_A(void) ;
U8   RdEV_A(void) ;
void WrMap(void) ;
U8   RdMap(void) ;
//void ReadElTimer(void) ;
//U16  Read_CTC(U8 channel) ;
//void Write_CTC(U8 channel, U16 cData) ;
void ClrEvent(U8 evNo) ;
void ClrEvARam(U8 fillData) ;
U8   CanRun(U8 mode) ;
void SpRamRd(U8 *sBuf, U16 sLen) ;
void SpRamWr(U8 *sBuf, U16 sLen) ;
void PrepareGo(void) ;
U8   LoadDecode(void) ;
U8   SaveTrace(TRACE_DATA tBuf[], U8 saveCnt) ;
void ClrTraceCnt(void) ;
void CountTraceCnt(void) ;
U8   RstEp(void) ;
void init_EP_1(void) ;
U8   CheckClockRate(void) ;
U8   GetRegAll(U8 *) ;
void WrCanRam(void) ;
void RdCanRam(void) ;
void WrEmRam(void) ;
void RdEmRam(void) ;
U16  CheckEpType(void) ;
//void RdSpToTbuf(void) ;
U8   MemFill(U8 *) ;
U8   MemDump(U8 *cmdBuf, U8 *bPtr) ;
U8   MemTest(U8 *) ;
U16  MemCkSum(U8 *) ;
U8   GoSpoon(void) ;
void EnableAdrBuf(void) ;
void EnableMapRam(void) ;
void EnEvLogic(void) ;
void DisableAdrBuf(void) ;
void DisableMapRam(void) ;
void DisEvLogic(void) ;
void LdStopSp(void) ; /* load stop spoon into spoon ram(SDATA = 0, counter from 0 to 80h) */
U8   StopEP(void) ;
U8   CycleStep(void) ;
U8   LoadTrigIni(U8 control) ;
//U8   ScanExBp(void) ;
U8   SetTracePort(void) ;
U8   GetFrame(U16 , U8 *) ;
U8   GetRN(U8 *) ; /* get register R0-7, will destory A, DPH, DPL in EP */
U16  GetOpRange(PMEMOPRANGE mPtr, U8 *cmdBuf) ;
U8   GetData(U8 *) ;
U8   DispCycle(void) ;
//
void ini_msg(void) ;
void InitElTimer(void) ;
void SetTriggerHW(U8 event, U8 action) ;
void SetRunFromAdr(RUNPARA *pRunParm) ;
void UpdateTraceCnt(void) ; /* read back traceCnt */
void ControlEA(U8) ; /* 0 disable EA, 1 enable EA */
void ControlRst(U8) ; /* 0 disable Rst, 1 enable Rst */


                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

void GetRegister(void) ;
void SaveRegister(void) ;
void InitFwMsg(void) ;
//void RecallRn(void) ;


                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

U16 lenRegData ;
/******************************************************************************
**  called when power on & handshake(cold/warm start)
**  output:
**     SysTst=0     SYSOK      test OK
**           =1     SYSRAMERR  system RAM test error
**           =2     EPERR      EP test falure
**           =4     UNERR      component Un test error
**     CEBUFFER                detal infomation about SysTst=UNERR
*****************************************************************************/
void sysini(void) {
//U16  resetFlag ;
//static ADRSTRUCT tPc ;


   EA  = 0 ;  /* disable interrupt during system init */
   EX0 = 0 ;  /* EP status changed */
// EX1 = 0 ;  /* PCE interface */
   IT0 = 0 ;
   IT1 = 0 ;
/* clear timer 0, 1 interrupt */
   ET0 = 0 ;
   ET1 = 0 ;
   TR0 = 0 ;
   TR1 = 0 ;
   TF0 = 0 ;
   TF1 = 0 ;

   lenRegData = sizeof(REGDATA) ;

   TMOD = 0x11 ; /* program timer 0, 1 as 16 bits timer */

   P1 = 0xff ;

// SysTst = 0 ;
   InitHW() ;  /* disable H/W */
// if (resetFlag != 0x55aa) { /* Do selftest if cold start */
   if ((coldStart == 1) || (SysTst != 0)) { /* Do selftest if cold start */
      epFail = 0 ;
      SysTst = 0 ;
      /* do rom checksum, ram test, ep test */
      if (RomChksum() != OK)
         SysTst = 1 ;
      if (SramTest() != OK) /* ram test will destory buffer */
         SysTst = SysTst | 2 ;
      InitHW() ; /* recall port data in sram */
      /* finish selftest, set coldstart finish flag */
//    resetFlag = 0x55AA ;
   }
   traceSize = ChkTraSize() ;
   RstEp() ;

   /* trace condition init */
   ev3Buf = 0 ;
   ev1Count = 1 ;
   traceDlyCnt = 0l ;
   tLogic[0] = 1 ;     /* set flag */
   tLogic[1] = 0 ;     /* run flag */
   tLogic[2] = 1 ;     /* level[0] */
   tLogic[3] = 0xff ;  /* level[1] */
   tLevel1[0] = 1 ;    /* set flag */
   tLevel1[1] = 0xff ; /* trace, timer */
   tLevel1[2] = 0xfe ; /* event condition : ev1|ev2|ev3 */
   tLevel2[0] = 0 ;
   /* clear event */
   traceQualifyOn = 0 ;
   getTraceCnt = 1 ;
   /* clear ev address compare ram, LoadDecode() will clear data ram */
   ClrEvARam(0xCf) ; /* default qualify all match */
   tracePort = 1 ; /* default trace in is port 1 */

   /* Load decode, map data, can program */
   LdFail = LoadDecode() ;
   CanRW() ;
   CanRdPara() ; /* load init data into canBuf */
   LdStopSp() ; /* load stop spoon into spoon ram */

   /* clear trace counter */
   traceCnt = 0 ;
   trigStatus = 1 ; /* default trigger is on */
   cycleFlag = 0 ;
   initTrigger = 3 ; /* default trace and timer is on */
   fw_verify = 1 ; /* default f/w verify is on */

// podModel = STATUS1B & 0x0f ;
   ControlRst(0) ; // disable target reset
   ControlEA(1) ; // eanble target EA before check EA
   targetEA = STATUS0B & CHKEA ;

   if (STATUS0B & TVCC) // if no target VCC, disable reset
      reset_flg = 1 ;
   else
      reset_flg = 0 ;
   ControlEA(0) ;
   /* reset ep */
// init_EP(&tPc) ;
   RstEp() ;   // RstEP will read back pod id and store to podModel

   SysTst = SysTst & ~0x18 ; // clear bit 3, 4
   switch (podModel) {
      case 0: // EPH/EPL-52F
//       epModel = CheckEpType() ; /* will destory ep register */
         break ;
      case 0xff:
         SysTst = SysTst | 8 ; // no probe connect
         return;

      case 1: // EPH/EPL-87C552
/*
         if (targetEA)
            epModel = EP83C552 ;
         else
            epModel = EP80C552 ;
         break ;
*/
         break ;
      case 2: // EPH/EPL-83C752    Hardware check if EPL-750 is on.
        if ( STATUS0B & 0x40 )
         {
            epModel = EP83C752 ;
         }
         else
         {
            epModel = EP83C750 ;

         };

//       epModel = EP83C752 ; default ep mode is 83C752 Sep/29/1994 deng
         break ;

      default:

         epModel = EP83C752 ; // default ep mode is 83C752 Sep/29/1994 deng

         SysTst = SysTst | 0x10 ; // not supply in this firmware
         return;
//       epModel = EP8031 ; /* no pod connected!!! */
//       break ;
   }
   ControlEA(targetEA) ;
   epMode = epModel ;
   canBuf[EP_TYPE] = (U8)epModel ;  // Dec/27/1994 Deng ADD

   /* after check EP, must reset ep again*/
   init_EP_1() ;  /* like init_EP but no Status and Occurrence update */
   Status = 0x88 ; /* verify on, trigger on */

   EA = 1 ; /* enable interrupt */
}
/****************************************************************************
**
**  start_EP
**
**  struct{
**          BYTE RunFlg;             0    without RUN
**                                   1    with RUN
**          BYTE Reserved ;
**          ADRSTRUCT fromAdr;       address type =0      no from address
**                                               ~=0      go from "FromAdr"
**          ADRSTRUCT tillAdr;       address type =0      free run
**                                               ~=0      go untill "TillAdr"
**          }
*****************************************************************************/
PFINALMSG start_EP(RUNPARA *pRunParm) { /* force EP started */
U16 i, j ;
U8  k ;


   if (epRunFlag == 1)
      return &ErrEpRun ;   /* aleardy going */
   InitFwMsg() ;
   Occurrence = Occurrence | 0x0002 ;
// Status = (Status & 0xff8f) | 0x14C ;  /* EP running */
   Status = (Status & 0xfe8b) | 0x040 ;  /* EP running */

   EX0 = 0 ;

   GetRegister() ;
   if (BR_OVER == 0)
      SaveRegister() ;
   CheckBR_OVER(&fwMsg) ;
   if (BR_OVER != 0)
      return &fwMsg ;
   /* clear timer, 8254 */
// timerHigh = 0 ;
// TH0 = 0 ;
// TL0 = 0 ;
// Write_CTC(TIMER_CH, 0) ;
// ET0 = 1 ; /* enable timer 0 interrupt */
   InitElTimer() ;
   SetRunFromAdr(pRunParm) ;

   /* clear trace counter */
// traceStart = 0 ;
// traceEnd = 0 ;
   traceCnt = 0 ;
// ClrTraceCnt() ;
// if ((RDTCNTL | RDTCNTH) != 0) { /* trace counter logic fail! */
//    return &fwMsg ;
// }

   /* set trigger, trace control */
   if ((traceQualifyOn & 1) != 0)
      traceQualifyOn = traceQualifyOn | 2 ;
   else
      traceQualifyOn = traceQualifyOn & 0xfd ;

   /* enable trace, compare ram and buffer */
// bCtrl3 = bCtrl3 & (~DISEP) & (~NTDIN) ;
// LDCTRL3 = bCtrl3 ;

   /* set address,.EA, .TR0, .TR1, .TR2,  go ep */
   epRunFlag = 1 ;
   getTraceCnt = 0 ;
// getRegFlg = 0 ;
// bCtrl2 = bCtrl2 & (~SDATA) ;
// LDCTRL2 = bCtrl2 ;

   PrepareGo() ; /* put run spoon data into spoon ram */

   /* set default timer and trace */
   SetTracePort() ;
   LoadTrigIni(initTrigger) ; /* set ev1 cnt will destory trigger init value */

   bBufen = (~NENTDBUF) & (~NENTABUF) ;
// bCtrl0 = bCtrl0 & ~GORUN ; /* turn off GORUN */
   bCtrl0 = bCtrl0 | ENTRACE ; /* enable trace */

   /* if trace on, enable trace ram cs */
   bRamen = 0 ;

   /* Set trigger */
   if (goRunFlag == 0) {
      if ((tLogic[0] == 1) && (trigStatus != 0)) { /* trigger set and enable */
         for (k = 2; k <= 3; k++) {
            bDataL = tLogic[k] ;
            switch (bDataL) {
               case 1:
                  if ((k == 3) || (tLogic[3] == 0xff))
                     /* last level */
                     SetTriggerHW(tLevel1[2], tLevel1[1] & 0xef) ;
                  else
                     SetTriggerHW(tLevel1[2], tLevel1[1]) ;
                  break ;

               case 2:
                  if ((k == 3) || (tLogic[3] == 0xff))
                     /* last level */
                     SetTriggerHW(tLevel2[2], tLevel2[1] & 0xef) ;
                  else
                     SetTriggerHW(tLevel2[2], tLevel2[1]) ;
                  break ;

               case 0xff:  /* only one level */
                  if (k == 3)
                     SetTriggerHW(0, 0xef) ;
                  break ;
            } /* end switch */
         } /* end for loop */

         if (tLogic[1] != 0)
            /* with go run */
            bCtrl0 = bCtrl0 | GORUN ; /* turn on GORUN */
         else
            bCtrl0 = bCtrl0 & ~GORUN ; /* turn off GORUN */
//       Status = Status | 0x0008 ; /* trigger on */
      }
      else  { /* trigger off */
         SetTriggerHW(0, 0xff) ;
         SetTriggerHW(0, 0xff) ;
      }
   }
   else { /* Gorun, disable trigger */
      SetTriggerHW(0, 0xff) ;
      SetTriggerHW(0, 0xff) ;
      bRamen = bRamen | NACEN ;  /* disable address compare ram to disable ev, exebp */
   }
   ini_msg() ; /* update status call back */
   LDCTRL0 = bCtrl0 ;
   LDBUFEN = bBufen ;
   LDRAMEN = bRamen ;

   IT0 = 0 ; /* level of external interrup */
// EX0 = 1 ; /* enable status change */


   GoSpoon() ; /* if go run then disable ENMAPBP */

   ET1 = 1 ;
   TR1 = 1 ; /* enable status changed polling */
   EX0 = 1 ; /* enable status change */
   return &fwMsg ;
}
/****************************************************************************
**   range_step
**
**   input:
**      int Len;         length of the range
**      int Over;        0 step into
**                       1 step over
**   description: force EP step to next stement
*****************************************************************************/
PFINALMSG range_step(U16 Len, U16 Over) {


   InitFwMsg() ;

// GetRegister() ;
// SaveRegister() ;
// Occurrence = Occurrence | 0x0038 ;
// CheckBR_OVER(&fwMsg) ;

   return &fwMsg ;
}

extern xdata U8 clockMsg[] ;
U8 ConvTimerToMhz(U16 timerValue) {
U8 timer ;
U16 timer0, timer1 ;


   if (timerValue < 5721)
      timer0 = 60128 ; /* >= 21Mhz */
   else
      timer0 = 60080 ; /* < 21Mhz */
// V1.3 update for 40MHZ
   if (timerValue < 3010)
      timer0 = 60160 ;  // 40Mhz

   timer = timer0 / timerValue ;     /* 120160(120256) / timerValue */

   clockMsg[0] = '0' + (timer / 5) ;
   timer = timer * 2 ;
   clockMsg[1] = '0' + (timer % 10) ;


   timer1 = timer0 % timerValue ;
   timer1 = timer1 * 20 ;
   timer = timer1 / timerValue ;
   clockMsg[3] = '0' + timer ;

   timer1 = timer1 % timerValue ;
   timer1 = timer1 * 10 ;
   timer = timer1 / timerValue ;
   clockMsg[4] = '0' + timer ;

   return(0) ;
}
static code U8 TIMER_OFFSET[14] = {
// 100000000L us =  1 Hr 11 min 34.967296
   0, 0, 0, 1, 1, 1, 3, 4, 9, 6, 7, 2, 9, 6} ;
extern xdata U8 elTimerMsg[] ;
U8 ConvElTimer(void) {
U8 i ;
U16 tmpVal1 ;
U32 tmpVal ;
/* total 40 bits timer, unit is 1 us
   'Elapsed: 00 day,00 hr'
	     01     23
   '00 min,00.000.000 sec'
    45     67 89A BCD
*/

   i = 14 ;
   tmpVal = timerLow ;
   do {
      i-- ;
      switch(i) {
	 case 3: // Hour
	    elTimerMsg[i] = (tmpVal % 24L) ;
	    tmpVal = tmpVal / 24L ;
	    if (timerHigh > 0) {
	       tmpVal1 = elTimerMsg[i] + (TIMER_OFFSET[i] * timerHigh) ;
	       tmpVal += (tmpVal1 / 24) ;
	       tmpVal1 = tmpVal1 % 24 ;
	       elTimerMsg[3] = '0' + (tmpVal1 % 10) ;
	       elTimerMsg[2] = tmpVal1 / 10 ;
	    }
	    i--;
            break ;

         case 4:
         case 6:
            elTimerMsg[i] = (tmpVal % 6L) ;
            tmpVal = tmpVal / 6L ;
	    if (timerHigh > 0) {
	       tmpVal1 = elTimerMsg[i] + (TIMER_OFFSET[i] * timerHigh) ;
	       elTimerMsg[i] = tmpVal1 % 6 ;
	       tmpVal += (tmpVal1 / 6) ;
	    }
            break ;

         default:
            elTimerMsg[i] = (tmpVal % 10L) ;
            tmpVal = tmpVal / 10L ;
	    if (timerHigh > 0) {
	       tmpVal1 = elTimerMsg[i] + (TIMER_OFFSET[i] * timerHigh) ;
	       elTimerMsg[i] = tmpVal1 % 10 ;
	       tmpVal += (tmpVal1 / 10) ;
	    }
            break ;
      }
      elTimerMsg[i] += '0' ;
// } while ((i > 3) && (tmpVal != 0)) ;
   } while ((i != 0) && ((tmpVal != 0) || (timerHigh != 0))) ;

   return(0) ;
}
//;$$$ NO.8
void set_cpu_model(void) {

   epMode = CPUmode ;

   switch (epModel)
      {
      case EP80C752:
      case EP83C752:
         epMode = EP83C752;
      break;
      case EP80C750:
      case EP83C750:
         if( (epMode != EP80C751) && (epMode != EP83C751) )
         epMode = EP83C750;
         else
         init_EP_1();

      break;
      case EP80C751:
      case EP83C751:
         if( (epMode != EP80C750) && (epMode != EP83C750) )
         epMode = EP83C751;
         else
         init_EP_1();

      break;
      default:
         epMode = epModel ;
      break;
      }

   canBuf[EP_TYPE] = (U8)epMode ;  // Dec/27/1994 Deng ADD
   return ;
}

void InitFwMsg(void) {

   fwMsg.FinalCode.Lo = 0 ;
   fwMsg.FinalCode.Hi = 0 ;
   fwMsg.DetailString = fwMsgString ;
}
