

#ifndef _ICEHWLIB_H


typedef struct {
   PACKWORD LevelID ;      /* 1    level A */
                           /* 2    level B */
                           /* ..........   */
   unsigned char TraceFlg; /* 0 trace unchanged    */
                           /* 1 trace ON           */
                           /* 2 trace OFF          */
   unsigned char TimerFlg; /* 0 timer unchanged    */
                           /* 1 timer ON           */
                           /* 2 timer OFF          */
   PACKDWORD Condition ;   /* condition list       */
                           /* EV1  AAAAAAAAH       */
                           /* EV2  CCCCCCCCH       */
                           /* EV3  F0F0F0F0H       */
                           /* EV4  FF00FF00H       */
                           /* EV5  FFFF0000H       */
                           /* EV1 OR EV2           */
                           /* DDDDDDDDH            */
                           /* EV2 AND EV3          */
                           /* C0C0C0C0H            */
                           /* EV3 AND EV4 AND EV5  */
                           /* F0000000H            */
                           /* .................    */
}  TRIGGERLEVEL;

typedef struct {
        unsigned char setFlag ; /* 0 -> level clear, 1 -> level set */
	unsigned char TraceFlg;	/* 0 trace unchanged	*/
                                /* 1 trace ON           */
                                /* 2 trace OFF          */
	unsigned char TimerFlg;	/* 0 timer unchanged	*/
                                /* 1 timer ON           */
                                /* 2 timer OFF          */
        PACKDWORD Condition   ; /* condition list       */
                                /* EV1  AAAAAAAAH       */
                                /* EV2  CCCCCCCCH       */
                                /* EV3  F0F0F0F0H       */
                                /* EV4  FF00FF00H       */
                                /* EV5  FFFF0000H       */
                                /* EV1 OR EV2           */
                                /* DDDDDDDDH            */
                                /* EV2 AND EV3          */
                                /* C0C0C0C0H            */
                                /* EV3 AND EV4 AND EV5  */
                                /* F0000000H            */
                                /* .................    */
        }  TLEVELDATA ;

typedef struct {
	unsigned char TrigFlg;	/* 0 delay count	*/
                                /* 1 foreward           */
                                /* 2 backward           */
                                /* 3 center             */
	unsigned char RunFlg;	/* 0 without run	*/
                                /* with run             */
        PACKDWORD DlayCnt  ;    /* delay count(TrigFlg=0 used) */
        PACKWORD LevelCount ;
        PACKWORD LevelID[4];/* level ID list*/
        } TRIGGERLOGIC ;

typedef struct{
        U8 runFlg;         /*  0    without RUN                 */
                           /*  1    with RUN                    */
        U8 reserved;       /*  0    without on-the-fly          */
                           /*  1    with on-the-fly             */
        ADRSTRUCT fromAdr; /* address type=0      no from address */
                           /*              ~=0     go from "FromAdr" */
        ADRSTRUCT tillAdr; /*       address type =0       free run      */
                           /*                   ~=0       go untill "TillAdr" */
   } RUNPARA ;

typedef struct {
        U8      addrLo;
        U8      addrHi;
        U8      dataL ;
        U8      status;
        U8      port;
} TRACE_DATA ;

typedef struct {
        PACKDWORD Port;
        PACKDWORD MskFlg;
        U8        Data[10];
} *OutPortPtr;

typedef struct {
	PACKWORD LineWidth; /* line with per text line */
	PACKWORD LineCnt; /* the number of text line */
        U8   String[100]; /* with terminater character per text line */
} LINETXT, *PLINETXT;

typedef struct {
        PACKWORD setmode;                               /* 0 occupied setting *
                                                        /* 1 set if not present */
                                                        /* 2 add setting */
        U8        QlfyType[12];                         /* (see table 4) */
        PACKDWORD data1;                                /* Qualified data */
        PACKDWORD data2;                                /* End data2 (when Qlfy_Type=Range) */
        PACKDWORD status;                               /* Qualified status */
        PACKDWORD extrn;                                /* Qualified external signals*/
        PACKDWORD extmsk;                               /* External Mask */
        PACKDWORD  count;                               /* Address count (for only) */
        U8        adr1[8] ;                             /* Qualified address */
        U8        adr2[8] ;                             /* End address if Qlfy_Type= range)
                                                           address mask if Qlfy_Type= wildcard
                                                           2nd address if Qlfy_Type=group */
//      U8        adr[8][Count-2];                      /* for Qlfy_Type=group only */
} QUALIFY, *PQUALIFY ;

typedef struct {
        PACKWORD adrType;       /* 0 = DATA, 1 = CODE, 2 = XDATA */
        U8       startAdr[8];
        U8       byteLen[8];
} MEMRANGE, *PMEMRANGE;

typedef struct {
        PACKWORD adrType;
        U8       startAdr[8];
        U8       bytesLen[8];
        PACKWORD opSize;
} MEMOPRANGE, *PMEMOPRANGE;

/****************************************************************************
**
**  sysini
**
**  called when power on & handshake(cold/warm start)
**  output:
**          SysTst=0        SYSOK   test OK
**                   =1     SYSRAMERR       system RAM test error
**                   =2     EPERR   EP test falure
**                   =4     UNERR   component Un test error
**          CEBUFFER                        detal infomation about SysTst=UNERR
*****************************************************************************/
void sysini(void) ;

PFINALMSG init_EP(PADRSTRUCT pPC) ; /* reset EP */

PFINALMSG stop_EP(void) ; /* force EP stoped */

PFINALMSG change_PC(PADRSTRUCT pNewPC) ; /* PC jump */

/****************************************************************************
**
**  start_EP
**
**  struct{
**          BYTE RunFlg;             0    without RUN
**                                   1    with RUN
**          BYTE FlyFlg              0    without on-the-fly
**                                   1    with on-the-fly
**          ADRSTRUCT TillAdr;       address type =0       free run
**                                               ~=0       go untill "TillAdr"
**          }
*****************************************************************************/
PFINALMSG start_EP(RUNPARA *pRunParm) ; /* force EP started */

/****************************************************************************
**
**  get_reg
**
**  output:
**  PREGDATA RegDataPtr;
**
**  description:Read all registers and save them to RegDataPtr.
*****************************************************************************/
//PFINALMSG get_reg(PREGDATA RegDataPtr) ;

/****************************************************************************
**
**  get_reg
**
**  input:
**     unsigned short RegOdn;     Register ordinal
**     unsigned char DataPtr[?];    Databuffer saved by this function
**  output:
**     save data to DataPtr
**  description:
**     Read a register and save them to DataPtr.
*****************************************************************************/
PFINALMSG get_a_reg(unsigned short RegOdn, unsigned char DataPtr) ;

/****************************************************************************
**  modify_reg
**
**  input:
**  struct {
**     PACKWORD RegOrdinal;
**     unsigned char RegData[?]
**     } *mdfyptr;
*****************************************************************************/
PFINALMSG modify_reg(U8 *MdfyPtr) ;


/****************************************************************************
**  read_trace
**
**  input:
**     unsigne short StartFrame;  from this frame to serch qualified trace record
**     PQUALIFY TraceQlfyPtr;     see table 4
**     PTRACEREC BfrPtr;
**  return:
**     FinalCode.Low= 0 no more qualified trace record
**     FinalCode.Low= 1 a effective trace record in BfrPtr
**
**  decription: Read trace buffer content and save them to BfrPtr.
*****************************************************************************/
PFINALMSG read_trace(PACKWORD RdDirect, PACKWORD StartFrame, PQUALIFY traceQlfyPtr, U8 **) ;

/****************************************************************************
**  inst_step
**
**  description: force EP step into
*****************************************************************************/
PFINALMSG inst_step(void) ; /* step into */

/****************************************************************************
**  call_step
**
**  description: force EP step over
*****************************************************************************/
PFINALMSG call_step(void) ;/* step over */



/****************************************************************************
**   range_step
**
**   input:
**      int Len;         length of the range
**      int Over;        0 step into
**                       1 step over
**   description: force EP step to next stement
*****************************************************************************/
PFINALMSG range_step(U16 Len, U16 Over) ;


/****************************************************************************
**   ini_timer
**
**   input:
**      BYTE status;   0 OFF
**                     1 ON
*****************************************************************************/
PFINALMSG ini_timer(U8 status) ;

/****************************************************************************
**   ini_trace
**
**   input:
**      BYTE status;   0 OFF
**                     1 ON
*****************************************************************************/
PFINALMSG ini_trace(U8 status) ;


/****************************************************************************
**   cycle_step
**
**   PLINETXT pCycleMsg;
**   description: force EP step a cycle and put cycle message to pCycleMsg.
*****************************************************************************/
PFINALMSG cycle_step(PLINETXT pCycleMsg) ;

/****************************************************************************
**   cycle_wait
**
**   PLINETXT pCycleMsg;
**   description: force EP step a cycle and put cycle message to pCycleMsg.
*****************************************************************************/
PFINALMSG cycle_wait(PLINETXT pCycleMsg) ;


/****************************************************************************
**   read_mem
**
**   input:
**      PMEMOPRANGE MemRangePtr;
**      unsigned char *BfrPtr
**   output: save memory content to BfrPtr
*****************************************************************************/
PFINALMSG read_mem(PMEMOPRANGE MemRangePtr, U8 *BfrPtr) ;


/****************************************************************************
**    checksum
**
**    input:
**       PMEMOPRANGE MemRangePtr;
**       PACKDWORD *pResult;
**    output: save checksum to pResult
**
**    decription: read a range memory content
**                MemRangePtr: a range assign structor
*****************************************************************************/
PFINALMSG checksum(PMEMOPRANGE MemRangePtr, PACKWORD *pResult) ;


/****************************************************************************
**   fill_mem
**
**   input:
**   struct  {
**      MEMRANGE MemRange;
**      PACKWORD Reserve;
**      PACKWORD DataLen;
**      unsigned char NewData[DataLen]; Maxmun data length is 128 bytes
**      } *MdfyMemPtr;
*****************************************************************************/
PFINALMSG fill_mem(U8 *MdfyMemPtr) ; /* Fill Memory Content */

/****************************************************************************
**   srch_mem
**
**   input:
**      struct  {
**         MEMRANGE MemRange;
**         PACKWORD Reserved;
**         PACKWORD SrchFlg;     SrchFlg:
**                               bit0    =0 case-sensitive
**                                       =1 case-insensitive
**         PACKWORD DataLen;
**         unsigned char SrchData[DataLen];
**         } *SrchMemPtr;
**   PADRSTRUCT MatchPtr;    MatchPtr->AdrType=0 indicates search false
**   output: save match to MatchPtr
*****************************************************************************/
PFINALMSG srch_mem(U8 *SrchMemPtr, PADRSTRUCT MatchPtr) ; /*Search Specific Data In The Memory */

/****************************************************************************
**  log_blt
**
**  input:
**     struct{
**        PACKWORD OpCode;    see Note
**        PACKWORD OpSize;
**        ADRSTRUCT SrcAdr;   source address
**        ADRSTRUCT DstAdr;   destination address
**        PACKDWORD BlckLen;
**        } *TransBlockPtr;
**  *Note :
**     OpCode:
**        bit0~3: destination
**                0 transfer without changing destination
**                1 invert destination
**        bit4~7: transfer operation
**                0 no operation
**                1 copy
**                2 or
**                3 and
**                4 xor
**        bit8~B: source
**                0 transfer without changing source content
**                1 transfer the the 1's complement source content
*****************************************************************************/
PFINALMSG log_blt(TransBlockPtr) ; /*Block Memory Transfer With Logical Operation */

/****************************************************************************
**  tst_mem
**
**  input:
**     PMEMOPRANGE TstRangePtr;
**     PADRSTRUCT ErrAdrPtr;  ErrAdrPtr->AdrType=0 indicates test OK
**  output: save error address to ErrAdrPtr
*****************************************************************************/
PFINALMSG tst_mem(PMEMOPRANGE tstRangePtr, PADRSTRUCT errAdrPtr) ; /* test memory */

/****************************************************************************
**  set_map
**
**  input:
**     PMAPRANGE MapRangePtr;
*****************************************************************************/
PFINALMSG set_map(U8 *mapRangePtr) ;


/****************************************************************************
**  cmp_mem
**
**  input:
**     struct{
**        PACKWORD Opsize;
**        ADRSTRUCT SrcAdr;  source address
**        ADRSTRUCT DstAdr;  destination address
**        PACKDWORD BlckLen;
**        } *CompBlockPtr;
**  PADRSTRUCT DfrAdrPtr;   ouput:save deffrenet address to DfrAdrPtr
**             DfrAdrPtr->AdrType=0 indicates no diffrent
*****************************************************************************/
PFINALMSG cmp_mem(CompBlockPtr, PADRSTRUCT dfrAdrPtr) ;

/****************************************************************************
**   set_verify
**
**   input:
**      unsigned char flg;      0 OFF
**                              1 ON
*****************************************************************************/
PFINALMSG set_verify(U8 flg) ;

/****************************************************************************
**   output
**
**   input:
**      struct iop{
**         PACKDWORD Port;
**         PACKDWORD MskFlg;
**         unsigned char Data[?];
**      } *OutPortPtr;
**   *Note MskFlg:
**      00FF: extract low byte
**      FFFF: extract whole word
**      0001: extract LSB only
**      0002: .............
**      ..................
**      8000: extract MSB only
*****************************************************************************/
PFINALMSG output(OutPortPtr IOportPtr) ;

/****************************************************************************
**    set_event
**
**    input:
**       WORD     setMode ;
**       PQUALIFY QlfyPtr;
*****************************************************************************/
PFINALMSG set_event(U16 setMode, U8 *QlfyPtr) ;

/****************************************************************************
**    clr_event
**
**    input:
**       PACKWORD EventNo;
*****************************************************************************/
PFINALMSG clr_event(PACKWORD eventNo) ;


/****************************************************************************
**     set_trig_level
**
**
*****************************************************************************/
PFINALMSG set_trig_level(TRIGGERLEVEL *pTriggerLevel) ;

/****************************************************************************
**   set_trig_logic
**
**
*****************************************************************************/
PFINALMSG set_trig_logic(TRIGGERLOGIC *pTriggerLogic) ;

/****************************************************************************
**   set_trig_Status
**
**   input:
**   unsigned short status;   0 disable
**                            1 enable
*****************************************************************************/
PFINALMSG set_trig_Status(status) ;


/****************************************************************************
**   set_exbp
**
**   input:
**      PADRSTRUCT BrkAdrPtr;
*****************************************************************************/
PFINALMSG set_exbp(PADRSTRUCT brkAdrPtr) ;

/****************************************************************************
**  clr_exbp
**
**  input:
**  PADRSTRUCT BrkAdrPtr;  if BrkAdrPtr->AdrType= 0 that is meaning
**                         clear all of the excution points
*****************************************************************************/
PFINALMSG clr_exbp(PADRSTRUCT brkAdrPtr) ;

/****************************************************************************
**   query_exebp
**
**   input:
**      PADRSTRUCT pStartAdr;  query start address
**      PADRSTRUCT pEndAdr;    query end address
**      PADRSTRUCT pResultAdr; result address save here
**   output:
**      FinalCode.Low= 0 there isn't bp in the adress range
**      FinalCode.Low= 1 there is effective BP address in pReseltAdr
**   description:
**      Query the first BP in the range from pStartAdr to pEndAdr.
*****************************************************************************/
PFINALMSG query_exebp(PADRSTRUCT pStartAdr,PADRSTRUCT pEndAdr,PADRSTRUCT pResultAdr) ;
#if 0
/****************************************************************************
**  transparent_cmd
**
**  WORD TransparentNO, TransparentID;
*****************************************************************************/
PFINALMSG transparent_cmd(U16 TransparentNO, U16 TransparentID) ;
/****************************************************************************
**  show_setting
**
**  PLINETXT *ppBfr; save setting infommation in ppBfr
*****************************************************************************/
PFINALMSG show_setting(PLINETXT ppBfr) ;

/****************************************************************************
**  SHOW_MAP
**
**  PLINETXT *ppBfr;  show map table in ppBfr
*****************************************************************************/
PFINALMSG SHOW_MAP(WORD AdrType, PLINETXT ppBfr) ;
#endif
/****************************************************************************
**  is_trace_qualified
**
**  return:
**          0 Trace content aren't qualified
**          1 Trace content are qualied
*****************************************************************************/
BYTE is_trace_qualified(void) ;

void set_cpu_model(void) ;

/* Finalcode.Hi: */
#define SYSTEM_ERR      01      /* system error */
#define FP_HALT         11      /* EP halt */
#define CMD_SYNTAX_ERR  12      /* Command syntax error */
#define CMD_PROC_ERR    13      /* Error in command process */
#define CMD_EP_RUNNING  14      /* Can not process the command because EP running */
#define CMD_TR_RUNNING  15      /* Can not process the command because trace running */

/* About final code */
#define     LASTMSG     0x00
#define     MOREMSG     0x01
#define     ENRESI      0x02
#define     TRACEON     0x04
#define     TRIGGER     0x08
#define     EPSTATUS    0x70
#define     EPSTOP      0x40
#define     EPSTOPBREAK     0x00
#define     EPSTOPUSER      0x10
#define     EPSTOPWRITE     0x20
#define     EPSTOPGUARD     0x30
#define     EPRUNNING       0x40
#define     EPWAIT          0x50
#define     EPHALT          0x60
#define     MVERIFY         0x80
/* Final code definition */
#define SYSERR      0x10
#define CMDERR      0x20
#define PROCERR     0x30
#define EPRUNGERR   0x40
#define RESIFULL    0x50
#define TRACERUNERR 0x60
#define VERIFYERR   0x70
#define WARNINGMSG  0x80

#define EXE_BP          0x003
#define TRACE_QUALIFY   4               /* EV4 is trace qualify */
#define SAVE_TRACE      10              /* save 10 trace frame */
//#define TRACE_LENGTH	  0x8000	  /* 32K trace */

#define EVCNT_CH        0x00
#define DLY_CH          0x01
#define TIMER_CH        0x02

/* epFail constant */
#define RST_FAIL         0x0001
#define TRACE_CLR_FAIL   0x0002
#define TRACE_COUNT_FAIL 0x0004
#define TRACE_LOAD_FAIL  0x0010
#define EVRAM_A_FAIL     0x0020
#define EVRAM_D_FAIL     0x0040
#define MAPRAM_FAIL      0x0080
#define SPRAM_FAIL       0x0100
#define EMRAM_FAIL       0x0200

/* for SPoon & can program mode definition */
#define CAN_GETREG      0x0001
#define CAN_GETMEM      0x0002
#define CAN_NONE        0x0003

extern bit fw_verify ;         /* =1 -> verify on */
extern bit reset_flg ;         /* =1 -> target reset enable */
extern bit getRegFlg ;         /* =0 -> not get reg, =1 -> get reg */
extern bit epRunFlag ;         /* =1 -> ep running */
extern bit goRunFlag ;         /* =1 -> ep gorunning */
extern bit getTraceCnt ;       /* =0 -> not get trace, = 1 -> already get trace */

#ifdef _ICEHWLIB_C

extern data U8 SysTst;  /* system test result */
                        /* (see function 1. sysini() */
U16     epFail ;

U8  tLevel1[1+2] ;  /* set flag, trace, timer, event condition */
U8  tLevel2[1+2] ;
U8  tLogic[4] ;     /* set flag, run flag, level[0], level[1] */
U32 traceDlyCnt ;

U8  save_bflg ; /* EP bit flag, bit 0 -> .EA, bit 1 -> .TR0, bit 2 -> .TR1
                                bit 3 -> .TR2 */
U16 traceStart ;  /* trace physical start frame */
U16 traceEnd ;    /* trace physical end frame */
U16 traceCnt ;    /* total trace in frame */
TRACE_DATA  traceBuf[SAVE_TRACE] ;
TRACE_DATA  cycleBuf[SAVE_TRACE] ;
U8          cycleFlag ; /* =0, no vaild data in cycleBuf, otherwise is vaild */
U8          trigStatus ; /* = 1, enable trigger, = 0, disable trigger */

U8  podModel ;
U8  targetEA ;
U16 epModel ; /* emulation processor model */
U16 epMode  ; /* current emulation processor mode */
U32 traceSize ; /* trace memory size(8K, 32K..) on trace logic */
/* bit 0 -> Guard access, bit 1 -> Writed protected, bit 2 -> execute break point */
U8  brkStatus ;
U8  tracePort ; /* for trace use */
REGDATA regBuf ;  /* register buffer of ep */
U8  cycleNo ;
U8  ev3Buf ;
U8  CEBUERR[31] ; /* only used for Systst=UNERR (see function 1. sysini())
                   *** Note: SysTst & CEBUFFER are declared in HWLIB  */


#else

extern data U8   SysTst;     /* system test result */
                             /* (see function 1. sysini() */
extern U16     epFail ;

extern U8  tLevel1[1+2] ;  /* set flag, trace, timer, event condition */
extern U8  tLevel2[1+2] ;
extern U8  tLogic[3] ;     /* set flag, level[0], level[1] */
extern U32 traceDlyCnt ;
extern U16 traceStart ;  /* trace physical start frame */
extern U16 traceEnd ;    /* trace physical end frame */
extern U16 traceCnt ;    /* total trace in frame */
extern TRACE_DATA  traceBuf[SAVE_TRACE] ;
extern TRACE_DATA  cycleBuf[SAVE_TRACE] ;
extern U8          cycleFlag ;
extern U8          trigStatus ; /* = 1, enable trigger, = 0, disable trigger */

extern U8  CEBUERR[31] ;  /* RAM FAIL SYSTEM TEST MESSAGE */

extern U8  save_bflg ; /* EP bit flag, bit 0 -> .EA, bit 1 -> .TR0,
                                       bit 2 -> .TR1,bit 3 -> .TR2 */

extern REGDATA     regBuf ;  /* register buffer of ep */
extern U8  podModel ;
extern U16 epModel ; /* cpu model setting */
extern U32 traceSize ; /* trace memory size(8K, 32K..) on trace logic */
/* bit 0 -> Guard access, bit 1 -> Writed protected, bit 2 -> execute break point */
extern U8  brkStatus ;
extern U8  tracePort ; /* for trace use */
extern U8  cycleNo ;
extern U8  ev3Buf ;

#endif


#endif
