#include "dtype.h"
#include "cmddef.h"
#include "epdef.h"
/******************************************************************************
/* Some string table can include control code                                 *
*  String decode/encode control code definition:                              *
*  12nn    The following nn fixed characters can be leave out in assembler,   *
*          but should be decoded by disassembler                              *
*          example:                                                           *
*             "A\x12\2CC"   "A","ACC" accepts in assembler,but disassembler   *
*                           Will decode as "ACC"                              *
*  13nn    The following nn fixed characters can be absent in assembler       *
*          and should not be decoded by disassembler                          *
*             "A\x13\2CC"   "A","ACC" accepts in assembler,but disassembler   *
*                           Will decode as "A"                                *
******************************************************************************/
/* Special Function Register Table: must sort by Dir-Adr */
code SFRNAME SFRbyte[]={
        /* SFR-Name    Dir-Adr     CPUmode */
        {"P0",         0x80,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
        {"SP",         0x81,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
        {"DPL",        0x82,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
        {"DPH",        0x83,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
//      {"GMOD",       0x84,       CM152A|CM152B },
        {"ADAT",       0x84,       CM752 },
//      {"TFIFO",      0x85,       CM152A|CM152B },
        {"PCON",       0x87,       CM31|CM32|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
        {"TCON",       0x88,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
        {"TMOD",       0x89,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        {"TL",         0x8A,       CM752|CM750|CM751 },
        {"TL0",        0x8A,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        {"TL1",        0x8B,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        {"RTL",        0x8B,       CM752|CM750|CM751 },
        {"TH0",        0x8C,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        {"TH",         0x8C,       CM752|CM750|CM751 },
        {"RTH",        0x8D,       CM752|CM750|CM751 },
        {"TH1",        0x8D,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },

//?     {"AUXR",       0x8E,       CM51FA },


        {"PWCM",       0x8E,       CM752 },
        {"PWMP",       0x8F,       CM752 },
        {"P1",         0x90,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
//      {"P5",         0x91,       CM152B },
//      {"DCON0",      0x92,       CM152A|CM152B },
//      {"DCON1",      0x93,       CM152A|CM152B },
//      {"BAUD",       0x94,       CM152A|CM152B },
//      {"ADR0",       0x95,       CM152A|CM152B },
        {"SCON",       0x98,       CM31|CM32|CM154|CM152A|CM152B|CM51FA|CM562 },
        {"S0CON",      0x98,       CM652 },
        {"I2CON",      0x98,       CM752|CM751 },
        {"SBUF",       0x99,       CM31|CM32|CM154|CM152A|CM152B|CM51FA|CM562 },
        {"S0BUF",      0x99,       CM652 },
        {"I2DAT",      0x99,       CM752|CM751 },
        {"P2",         0xA0,       CM31|CM32|CM154|CM44|CM152A|CM152B|CM652|CM51FA|CM562 },
        {"ADCON",      0xA0,       CM752 },
//      {"P6",         0xA1,       CM152B },
//      {"SARL0",      0xA2,       CM152A|CM152B },
//      {"SARH0",      0xA3,       CM152A|CM152B },
//      {"IFS",        0xA4,       CM152A|CM152B },
//      {"ADR1",       0xA5,       CM152A|CM152B },
//      {"IEN0",       0xA8,       CM552|CM562 },
        {"IE",         0xA8,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751 },
        {"SADDR",      0xA9,       CM51FA },
//      {"CML0",       0xA9,       CM552|CM562 },
//      {"CML1",       0xAA,       CM552|CM562 },
//      {"CML2",       0xAB,       CM552|CM562 },
//      {"CTL0",       0xAC,       CM552|CM562 },
//      {"CTL1",       0xAD,       CM552|CM562 },
//      {"CTL2",       0xAE,       CM552|CM562 },
//      {"CTL3",       0xAF,       CM552|CM562 },
        {"P3",         0xB0,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
//      {"SARL1",      0xB2,       CM152A|CM152B },
//      {"SARH1",      0xB3,       CM152A|CM152B },
//      {"SLOTTM",     0xB4,       CM152A|CM152B },
//      {"ADR2",       0xB5,       CM152A|CM152B },
//      {"IP0",        0xB8,       CM552|CM562 },
        {"IP",         0xB8,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA },
        {"SADEN",      0xB9,       CM51FA },
//      {"P4",         0xC0,       CM152A|CM152B|CM552|CM562 },
//      {"DARL0",      0xC2,       CM152A|CM152B },
//      {"DARH0",      0xC3,       CM152A|CM152B },
//      {"BKOFF",      0xC4,       CM152A|CM152B },
//      {"P5",         0xC4,       CM552|CM562 },
//      {"ADR3",       0xC5,       CM152A|CM152B },
//      {"ADCON",      0xC5,       CM552|CM562 },
//      {"ADCH",       0xC6,       CM552|CM562 },
//      {"IEN1",       0xC8,       CM152A|CM152B },
        {"T2CON",      0xC8,       CM32|CM154|CM51FA },
        {"STS",        0xC8,       CM44 },
//      {"TM2IR",      0xC8,       CM552|CM562 },
        {"SMD",        0xC9,       CM44 },
        {"T2MOD",      0xC9,       CM51FA },
//      {"CMH0",       0xC9,       CM552|CM562 },
        {"RCAP2L",     0xCA,       CM32|CM154 },
        {"RCB",        0xCA,       CM44 },
        {"RACAP2L",    0xCA,       CM51FA },
//      {"CMH1",       0xCA,       CM552|CM562 },
        {"RCAP2H",     0xCB,       CM32|CM154 },
        {"RBL",        0xCB,       CM44 },
        {"RACAP2H",    0xCB,       CM51FA },
//      {"CMH2",       0xCB,       CM552|CM562 },
        {"TL2",        0xCC,       CM32|CM154|CM51FA },
        {"RBS",        0xCC,       CM44 },
//      {"CTH0",       0xCC,       CM552|CM562 },
        {"TH2",        0xCD,       CM32|CM154|CM51FA },
        {"RFL",        0xCD,       CM44 },
//      {"CTH1",       0xCD,       CM552|CM562 },
        {"STAD",       0xCE,       CM44 },
//      {"CTH2",       0xCE,       CM552|CM562 },
        {"DMACNT",     0xCF,       CM44 },
//      {"CTH3",       0xCF,       CM552|CM562 },
        {"PSW",        0xD0,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
//      {"DARL1",      0xD2,       CM152A|CM152B },
//      {"DARH1",      0xD3,       CM152A|CM152B },
//      {"TCDCNT",     0xD4,       CM152A|CM152B },
//      {"AMSK0",      0xD5,       CM152A|CM152B },
//      {"TSTAT",      0xD8,       CM152A|CM152B },
        {"NSNR",       0xD8,       CM44 },
        {"S1CON",      0xD8,       CM652 },
        {"CCON",       0xD8,       CM51FA },
        {"I2CFG",      0xD8,       CM752|CM751 },
        {"SIUST",      0xD9,       CM44 },
        {"S1STA",      0xD9,       CM652 },
        {"CMOD",       0xD9,       CM51FA },
        {"TCB",        0xDA,       CM44 },
        {"S1DAT",      0xDA,       CM652 },
        {"CCAPM0",     0xDA,       CM51FA },
        {"TBL",        0xDB,       CM44 },
        {"S1ADR",      0xDB,       CM652 },
        {"CCAPM1",     0xDB,       CM51FA },
        {"TBS",        0xDC,       CM44 },
        {"CCAPM2",     0xDC,       CM51FA },
        {"FIFO0",      0xDD,       CM44 },
        {"CCAPM3",     0xDD,       CM51FA },
        {"FIFO1",      0xDE,       CM44 },
        {"CCAPM4",     0xDE,       CM51FA },
        {"FIFO2",      0xDF,       CM44 },
        {"A\x12\2CC",  0xE0,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM751|CM562 },
//      {"BCRL0",      0xE2,       CM152A|CM152B },
//      {"BCRH0",      0xE3,       CM152A|CM152B },
//      {"PRBS",       0xE4,       CM152A|CM152B },
//      {"AMSK1",      0xE5,       CM152A|CM152B },
//      {"RSTAT",      0xE8,       CM152A|CM152B },
//      {"IEN1",       0xE8,       CM552|CM562 },
        {"CL",         0xE9,       CM51FA },
        {"CCAP0L",     0xEA,       CM51FA },
//      {"TM2CON",     0xEA,       CM552|CM562 },
        {"CCAP1L",     0xEB,       CM51FA },
//      {"CTCON",      0xEB,       CM552|CM562 },
        {"CCAP2L",     0xEC,       CM51FA },
//      {"TML2",       0xEC,       CM552|CM562 },
        {"CCAP3L",     0xED,       CM51FA },
//      {"TMH2",       0xED,       CM552|CM562 },
        {"CCAP4L",     0xEE,       CM51FA },
//      {"STE",        0xEE,       CM552|CM562 },
//      {"RTE",        0xEF,       CM552|CM562 },
        {"B",          0xF0,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
//      {"BCRL1",      0xF2,       CM152A|CM152B },
//      {"BCRH1",      0xF3,       CM152A|CM152B },
//      {"RFIFO",      0xF4,       CM152A|CM152B },
//      {"MYSLOT",     0xF5,       CM152A|CM152B },
//      {"IPN1",       0xF8,       CM152A|CM152B },
        {"IOCON",      0xF8,       CM154 },
        {"I2STA",      0xF8,       CM752|CM751 },
//      {"IP1",        0xF8,       CM552|CM562 },
        {"CH",         0xF9,       CM51FA },
        {"CCAP0H",     0xFA,       CM51FA },
        {"CCAP1H",     0xFB,       CM51FA },
        {"CCAP2H",     0xFC,       CM51FA },
//      {"PWM0",       0xFC,       CM552|CM562 },
        {"CCAP3H",     0xFD,       CM51FA },
//      {"PWM1",       0xFD,       CM552|CM562 },
        {"CCAP4H",     0xFE,       CM51FA },
        {"PWENA",      0xFE,       CM752 },
//      {"PWMP",       0xFE,       CM552|CM562 },
        {"T3",         0xFF,       CM562 },
        {"",           0x00,       0x00 }}; /* End of the table */

/* SFR Bit Table: must sort by Addr-Base */
code SFRNAME SFRbit[]={
        /* Bit-Name    Addr-Base   CPUmode */
        { "IT0",       0x88,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        { "IT1",       0x88,       CM752|CM750|CM751 },
        { "IE0",       0x89,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        { "IE1",       0x89,       CM752|CM750|CM751 },
        { "IT1",       0x8A,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        { "IT0",       0x8A,       CM752|CM750|CM751 },
        { "IE1",       0x8B,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        { "IE0",       0x8B,       CM752|CM750|CM751 },
        { "TR0",       0x8C,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        { "TR",        0x8C,       CM752|CM750|CM751 },
        { "TF0",       0x8D,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        { "TF",        0x8D,       CM752|CM750|CM751 },
        { "TR1",       0x8E,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        { "C/T",       0x8E,       CM752|CM750|CM751 },
        { "TF1",       0x8F,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        { "GATE",      0x8F,       CM752|CM750|CM751 },
/*      { "GRXD",      0x90,       CM152A|CM152B },
        { "GTXD",      0x91,       CM152A|CM152B },
        { "DEN",       0x92,       CM152A|CM152B },
        { "TXC",       0x93,       CM152A|CM152B },
        { "RXC",       0x94,       CM152A|CM152B },
        { "HLD",       0x95,       CM152A|CM152B },
        { "HLDA",      0x96,       CM152A|CM152B },*/
        { "RI",        0x98,       CM31|CM32|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        { "TI",        0x99,       CM31|CM32|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        { "MASTER",    0x99,       CM752|CM751 },
        { "RB8",       0x9A,       CM31|CM32|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        { "STP",       0x9A,       CM752|CM751 },
        { "TB8",       0x9B,       CM31|CM32|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        { "STR",       0x9B,       CM752|CM751 },
        { "REN",       0x9C,       CM31|CM32|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        { "ARL",       0x9C,       CM752|CM751 },
        { "SM2",       0x9D,       CM31|CM32|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        { "DRDY",      0x9D,       CM752|CM751 },
        { "SM1",       0x9E,       CM31|CM32|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        { "ATN",       0x9E,       CM752|CM751 },
        { "SM0",       0x9F,       CM31|CM32|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        { "RDAT",      0x9F,       CM752|CM751 },
        { "EX0",       0xA8,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
        { "ET0",       0xA9,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
        { "EX1",       0xAA,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
        { "ET1",       0xAB,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM562 },
        { "EPWM",      0xAB,       CM752 },
        { "ES",        0xAC,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM51FA|CM752|CM562 },
        { "ES0",       0xAC,       CM652 },
        { "EI2",       0xAC,       CM751 },
        { "ET2",       0xAD,       CM32|CM154|CM51FA },
        { "ES1",       0xAD,       CM652 },
        { "ETI",       0xAD,       CM752|CM751 },
        { "EC",        0xAE,       CM51FA },
        { "EAD",       0xAE,       CM752|CM562 },
        { "EA",        0xAF,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
        { "PX0",       0xB8,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM152A|CM152B|CM652|CM562|CM51FA },
        { "PT0",       0xB9,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM562|CM51FA },
        { "PX1",       0xBA,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM562|CM51FA },
        { "PT1",       0xBB,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM562|CM51FA },
        { "PS",        0xBC,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM562|CM51FA },
        { "PS0",       0xBC,       CM652 },
        { "PT2",       0xBD,       CM32|CM154|CM51FA },
        { "PS1",       0xBD,       CM652 },
//      { "PAD",       0xBE,       CM552|CM562 },
        { "PPC",       0xBE,       CM51FA },
        { "PCT",       0xBF,       CM154 },
        { "CP/RL2",    0xC8,       CM32|CM154|CM51FA },
        { "RBP",       0xC8,       CM44 },
//      { "EGSRV",     0xC8,       CM152A|CM152B },
//      { "CTI0",      0xC8,       CM552|CM562 },
        { "C/T2",      0xC9,       CM32|CM154|CM51FA },
        { "AM",        0xC9,       CM44 },
//      { "EGSRE",     0xC9,       CM152A|CM152B },
//      { "CTI1",      0xC9,       CM552|CM562 },
        { "TR2",       0xCA,       CM32|CM154|CM51FA },
//      { "EDMA0",     0xCA,       CM152A|CM152B },
        { "CPB",       0xCA,       CM44 },
//      { "CTI2",      0xCA,       CM552|CM562 },
        { "EXEN2",     0xCB,       CM32|CM154|CM51FA },
        { "BV",        0xCB,       CM44 },
//      { "EGSTV",     0xCB,       CM152A|CM152B },
//      { "CTI3",      0xCB,       CM552|CM562 },
        { "TCLK",      0xCC,       CM32|CM154|CM51FA },
        { "SI",        0xCC,       CM44 },
//      { "EDMA1",     0xCC,       CM152A|CM152B },
//      { "CMI0",      0xCC,       CM552|CM562 },
        { "RCLK",      0xCD,       CM32|CM154|CM51FA },
        { "RTS",       0xCD,       CM44 },
//      { "EGSTE",     0xCD,       CM152A|CM152B },
//      { "CMI1",      0xCD,       CM552|CM562 },
        { "EXF2",      0xCE,       CM32|CM154|CM51FA },
        { "RE",        0xCE,       CM44 },
//      { "CMI2",      0xCE,       CM552|CM562 },
        { "TF2",       0xCF,       CM32|CM154|CM51FA },
        { "TBF",       0xCF,       CM44 },
//      { "T2OV",      0xCF,       CM552|CM562 },
        { "P",         0xD0,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
        { "F1",        0xD1,       CM154|CM652|CM562 },
/*      { "F1",        0xD1,       CM32 }, */
        { "OV",        0xD2,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
        { "RS0",       0xD3,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
        { "RS1",       0xD4,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
        { "F0",        0xD5,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
        { "AC",        0xD6,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
        { "C\x12\1Y",  0xD7,       CM31|CM32|CM44|CM154|CM152A|CM152B|CM652|CM51FA|CM752|CM750|CM751|CM562 },
        { "SER",       0xD8,       CM44 },
//      { "DMA",       0xD8,       CM152A|CM152B },
        { "CR0",       0xD8,       CM652|CM562 },
        { "CCF0",      0xD8,       CM51FA },
        { "CT0",       0xD8,       CM752|CM751 },
        { "NR0",       0xD9,       CM44 },
//      { "TEN",       0xD9,       CM152A|CM152B },
        { "CR1",       0xD9,       CM652|CM562 },
        { "CCF1",      0xD9,       CM51FA },
        { "CT1",       0xD9,       CM752|CM751 },
        { "NR1",       0xDA,       CM44 },
//      { "TFNF",      0xDA,       CM152A|CM152B },
        { "AA",        0xDA,       CM652|CM562 },
        { "CCF2",      0xDA,       CM51FA },
        { "NR2",       0xDB,       CM44 },
//      { "TDN",       0xDB,       CM152A|CM152B },
        { "SI",        0xDB,       CM652|CM562 },
        { "CCF3",      0xDB,       CM51FA },
        { "SES",       0xDC,       CM44 },
//      { "TCDT",      0xDC,       CM152A|CM152B },
        { "STO",       0xDC,       CM652|CM562 },
        { "CCF4",      0xDC,       CM51FA },
        { "TIRUN",     0xDC,       CM752|CM751 },
        { "NS0",       0xDD,       CM44 },
//      { "UR",        0xDD,       CM152A|CM152B },
        { "STA",       0xDD,       CM652|CM562 },
        { "NS1",       0xDE,       CM44 },
//      { "NOACK",     0xDE,       CM152A|CM152B },
        { "ENS1",      0xDE,       CM652|CM562 },
        { "CR",        0xDE,       CM51FA },
        { "MASTRQ",    0xDE,       CM752|CM751 },
        { "NS2",       0xDF,       CM44 },
//      { "LNI",       0xDF,       CM152A|CM152B },
        { "CR2",       0xDF,       CM652|CM562 },
        { "CF",        0xDF,       CM51FA },
        { "SLAVEN",    0xDF,       CM752|CM751 },
//      { "HABEN",     0xE8,       CM152A|CM152B },
//      { "ECT0",      0xE8,       CM552|CM562 },
//      { "GREN",      0xE9,       CM152A|CM152B },
//      { "ECT1",      0xE9,       CM552|CM562 },
//      { "RFNE",      0xEA,       CM152A|CM152B },
//      { "ECT2",      0xEA,       CM552|CM562 },
//      { "RDN",       0xEB,       CM152A|CM152B },
//      { "ECT3",      0xEB,       CM552|CM562 },
//      { "CRCE",      0xEC,       CM152A|CM152B },
//      { "ECM0",      0xEC,       CM552|CM562 },
//      { "AE",        0xED,       CM152A|CM152B },
//      { "ECM1",      0xED,       CM552|CM562 },
//      { "RCABT",     0xEE,       CM152A|CM152B },
//      { "ECM2",      0xEE,       CM552|CM562 },
//      { "OVR",       0xEF,       CM152A|CM152B },
//      { "ET2",       0xEF,       CM552|CM562 },
//      { "PGSRV",     0xF8,       CM152A|CM152B },
        { "XSTP",      0xF8,       CM752|CM751 },
//      { "PCT0",      0xF8,       CM552|CM562 },
        { "ALF",       0xF8,       CM154 },
//      { "PGSRE",     0xF9,       CM152A|CM152B },
        { "XSTR",      0xF9,       CM752|CM751 },
//      { "PCT1",      0xF9,       CM552|CM562 },
        { "P1HZ",      0xFA,       CM154 },
//      { "PDMA0",     0xFA,       CM152A|CM152B },
        { "MAKSTP",    0xFA,       CM752|CM751 },
//      { "PCT2",      0xFA,       CM552|CM562 },
        { "P2HZ",      0xFA,       CM154 },
//      { "PGSTV",     0xFB,       CM152A|CM152B },
        { "MAKSTR",    0xFB,       CM752|CM751 },
//      { "PCT3",      0xFB,       CM552|CM562 },
        { "P3HZ",      0xFB,       CM154 },
//      { "PDMA1",     0xFC,       CM152A|CM152B },
        { "XACTV",     0xFC,       CM752|CM751 },
//      { "PCM0",      0xFC,       CM552|CM562 },
        { "IZC",       0xFC,       CM154 },
//      { "PGSTE",     0xFD,       CM152A|CM152B },
        { "XDATA",     0xFD,       CM752|CM751 },
//      { "PCM1",      0xFD,       CM552|CM562 },
        { "SERR",      0xFD,       CM154 },
        { "IDLE",      0xFE,       CM752|CM751 },
//      { "PCM2",      0xFE,       CM552|CM562 },
        { "T32",       0xFE,       CM154 },
//      { "PT2",       0xFF,       CM552|CM562 },
        { "WDT",       0xFF,       CM154 },
        { "",          0x00,       0x0000}};    /* End of the table */

