/* Limit defintion */
#define CELLLEN     128 /* definition Must same as fwasm.a51 (254>CELLLEN>127) */
#define MAXCELL     160 /* definition Must same as fwasm.a51 (>= 20) */

typedef struct wordpack{
BYTE Low;
BYTE Hi;
}PACKWORD;

typedef struct dwordpack{
PACKWORD Low;
PACKWORD Hi;
}PACKDWORD;


typedef struct tracefield{
    PACKWORD type;
    PACKWORD TitleLoc;
    }TRACEFIELD, *PTRACEFIELD;

typedef struct bfr{
	PACKWORD LineWidth; /* line with per text line */
	PACKWORD LineCnt;   /* the number of text line */
	BYTE String[1];     /* with terminater character per text line */
	}LINETXT, *PLINETXT;

typedef struct traceform{
    PACKWORD FrameLen;
    BYTE QlfyType[12];
    PACKWORD  FieldCnt;
    TRACEFIELD Field[4];
    BYTE Title[1];
    }TRACEFORM, *PTRACEFORM;

typedef struct iceset{
    WORD LineWidth;
    WORD LineCnt;
    BYTE String[1];
}ICESET, *PICESET;

/* Data Type */
#define UBYTE		0x08
#define UWORD		0x10
#define UDWORD		0x20
#define SBYTE		0x88
#define SWORD		0x90
#define SDWORD		0xA0

/* About final code */
#define     LASTMSG     0x00
#define     MOREMSG     0x01
#define     ENRESI      0x02
#define     TRACEON     0x04
#define     TRIGGER     0x08
#define     EPSTATUS    0x70
#define     EPSTOP      0x40
#define     EPSTOPBREAK     0x00
#define     EPSTOPUSER      0x10
#define     EPSTOPWRITE     0x20
#define     EPSTOPGUARD     0x30
#define     EPRUNNING       0x40
#define     EPWAIT          0x50
#define     EPHALT          0x60
#define     MVERIFY         0x80
/* Final code definition */
#define SYSERR      0x10
#define CMDERR      0x20
#define PROCERR     0x30
#define EPRUNGERR   0x40
#define RESIFULL    0x50
#define TRACERUNERR 0x60
#define VERIFYERR   0x70
#define WARNINGMSG  0x80

/* Command Head definition */
#define CMD_NO   0x00        /* Command code                                 */
#define CMD_ID   0x02        /* Command ID                                   */
#define CMD_PARM 0x04        /* Command parameter start                      */

/* Message Head definition */
#define MSG_ID       0x00   /* Message code                                 */
#define MSG_CMDNO    0x02   /* Command which the message echos              */
#define MSG_CMDID    0x04   /* Command ID which the message echos           */
#define MSG_RECNO    0x06   /* Record No.                                   */
#define MSG_FINAL    0x08   /* Final code                                   */ 
#define MSG_PARM     0x0A   /* Dependent message start here                 */

/* 0508 Show BP */
#define CMD_SHOWBP_ADRTYPE  0x04
#define CMD_SHOWBP_ADR      0x06
#define CMD_SHOWBP_ADRLEN   0x0E
#define CMD_SHOWBP_MAXLST   0x16

/* 0511 Read a string */
#define CMD_READSTR_MAXLEN        0x0E  /* maxmun length(include NULL) of read*/
#define CMD_READSTR_DIRECT        0x10  /* word flag 0 indirect */

/* Bp status definition */
#define ORGBP       0
#define LSTEPBP     1
#define NLSTEPBP    2

typedef struct bfrlnk{
BYTE BlkLen;                /* Length of data in this block                 */
                            /* (not include BlkLen & ParmLnk)               */
BYTE *ParmLnk;     /* Next bffer cell  Index                       */
                            /* If pParmLnk =  ENDOFBLK indicates no more    */
BYTE Data[CELLLEN+1]; /* reserve one byte for data length */
}BFRLNK, *PBFRLNK;

typedef struct cmdqueue{
BYTE Current;
BYTE Last;
BYTE Len;
PBFRLNK pCell[MAXCELL];
}BFRQUEUE, *PBFRQUEUE;

typedef struct memradr{
    PACKWORD AdrType;
    BYTE Adr[8];
}MEMADR, *PMEMADR;

#define MAXINIMSG   50
typedef struct inistatus{
    WORD Status;
    PACKWORD AdrType;
    BYTE Adr[8];
}INISTATUS, PINISTATUS;
#define MAXINIMSG   50
typedef struct statusq{
BYTE Current;
BYTE Last;
BYTE Len;
INISTATUS IniStatus[MAXINIMSG];
}STATUSQ, PSTATUSQ;

typedef struct finalmsg{
    PACKWORD FinalCode;
    BYTE *pDetail;
}FINALMSG, *PFINALMSG;

typedef struct memoprange{
    PACKWORD AdrType;
    BYTE StartAdr[8];
    BYTE AdrLen[8];
    PACKWORD OpSize;
}MEMOPRANGE, *PMEMOPRANGE;

typedef struct memrange{
    PACKWORD AdrType;
    BYTE StartAdr[8];
    BYTE AdrLen[8];
}MEMRANGE, *PMEMRANGE;

typedef struct memvar{
    PACKWORD VarType;
    PACKWORD AdrType;
    BYTE VarAdr[8];
    BYTE Data[32];
}MEMVAR, *PMEMVAR;

typedef struct ioport{
PACKDWORD Msk;
PACKDWORD Port;
}IOPORT, *PIOPORT;

typedef struct outparm{
PACKDWORD Msk;
PACKDWORD Port;
BYTE Data[4];
}OUTPARM, *POUTPARM;

typedef struct regdata{
PACKWORD RegOdn;
BYTE Data[4];
}REGDATA, *PREGDATA;

typedef struct bpqueue{
BYTE Status;
BYTE LastCell;
BYTE Index;
WORD StartID;
WORD EndID;
MEMADR sAdr;
MEMADR eAdr;
PBFRLNK pCell[MAXCELL];
}BPQUEUE, *PBPQUEUE;

typedef struct mdfymem{
MEMRANGE Range;
PACKWORD Reserved;
PACKWORD DataLen;
BYTE Data[256];
}MDFYMEM, *PMDFYMEM;


typedef struct rngstep{
WORD Len;
WORD Over;    /* 0 step into */
              /* 1 step over */
}RNGSTEP, *PRNGSTEP;

typedef struct stackdata{
    PACKWORD AdrType;
    BYTE StkAdr[8];
    BYTE Data[4];
}STACKDATA, *PSTACKDATA;

typedef struct runparm{
BYTE RunFlg;    /* 0    without RUN             */
                /* 1    with RUN                */
BYTE FlyFlg;    /* 0    without on-the-fly      */
                /* 1    with on-the-fly         */
MEMADR TillAdr; /* address type=0	free run    */
                /* ~=0	go untill "TillAdr"     */
}RUNPARM, *PRUNPARM;
#define WITHOUTRUN  0
#define WTHRUN      1
#define WITHOUTFLY  0
#define WITHFLY     1

void release_cell(PBFRLNK);
void free_lnkcell(PBFRLNK);
BYTE * take_addr(PBFRLNK, WORD);
BYTE take_byte(PBFRLNK, WORD);
WORD take_word(PBFRLNK, WORD);
DWORD take_dword(PBFRLNK, WORD);
BYTE take_cmdbyte(WORD);
WORD take_cmdword(WORD);
DWORD take_cmddword(unsigned  short);

/* H/W library */
PFINALMSG init_EP();
PFINALMSG start_EP(PRUNPARM);
PFINALMSG stop_EP();
PFINALMSG get_reg(BYTE **);
PFINALMSG modify_reg(PREGDATA);
PFINALMSG get_a_reg(WORD, BYTE *);
PFINALMSG read_var(PMEMVAR , BYTE *);
PFINALMSG read_trace(WORD, WORD, PQUALIFY, BYTE *);
PFINALMSG inst_step();
PFINALMSG call_step();
PFINALMSG range_step(PRNGSTEP);
PFINALMSG cycle_step(PLINETXT *);
PFINALMSG cycle_wait(PLINETXT *);
PFINALMSG read_EMM(PMEMOPRANGE, DWORD, BYTE *);
PFINALMSG read_mem(PMEMOPRANGE, BYTE *);
PFINALMSG cmp_mem(PCMPMEM, PMEMADR);
PFINALMSG input(PIOPORT, BYTE *);
PFINALMSG read_var(PMEMVAR, BYTE *);
PFINALMSG fill_mem(PMDFYMEM);
PFINALMSG srch_mem(PSRCHMEM, PMEMADR);
PFINALMSG log_blt(PLOGBLT);
PFINALMSG tst_mem(PMEMOPRANGE, PMEMADR);
PFINALMSG set_verify(BYTE);
PFINALMSG output(POUTPARM);
PFINALMSG set_event(PEVENTQULIFY, PSETEVRESULT);
PFINALMSG clr_event(WORD);
PFINALMSG clr_exbp(PMEMADR);
PFINALMSG set_trig_logic(BYTE *);
PFINALMSG set_trig_level(BYTE *);
PFINALMSG set_trig_status(BYTE);
PFINALMSG set_exbp(PMEMADR);
PFINALMSG cle_exbp(PMEMADR);
PFINALMSG dsm_ent(PMEMOPRANGE);
PFINALMSG asm_ent(PMEMADR, BYTE *);
PFINALMSG get_PC(PMEMADR);
PFINALMSG query_exebp(PMEMADR, PMEMADR);
PFINALMSG transparent_cmd(WORD, WORD);
PFINALMSG read_a_stack(short, PSTACKDATA);
PFINALMSG set_map(BYTE *);
PFINALMSG show_setting(PICESET *);
PFINALMSG set_lineBP(BYTE *, PMEMADR, PMEMADR);
PFINALMSG clr_lineBP(BYTE *, PMEMADR, PMEMADR);
PFINALMSG ini_timer(BYTE);
PFINALMSG ini_trace(BYTE);
PFINALMSG show_map(WORD,PLINETXT *);
PFINALMSG checksum(PMEMOPRANGE, PACKDWORD *);
BYTE is_trace_qualified();
void read_stack(short, WORD);
void set_groupbp(BYTE);
void clr_groupbp();
void save_exebp();
void reset_exebp();
void free_cell(PBFRLNK);

/* cmdproc.c51 function */
void cmd_proc();
void send_msg(BYTE);
void alloc_msg();
void putmsg_word(WORD, WORD);
void putmsg_dword(WORD, DWORD);
void putmsg_blk(WORD, BYTE *, WORD);
void cmd_error();
void set_errmsg(BYTE, BYTE *);
void putmsg_str(WORD,BYTE *);
void putmsg_byte(WORD,BYTE);
void copy_data(BYTE *, BYTE *, BYTE);
void copy_str(BYTE *, BYTE *, WORD);
void ini_ent();
short adjust_stack(short);
WORD get_stktype();
BYTE advance_adr(PMEMADR, DWORD);
BYTE is_last_adr(PMEMADR, PMEMADR);
void show_exebp(PBFRLNK);
void nxt_msg();
void send_inimsg();
BYTE in_range(PMEMADR, PMEMADR, PMEMADR);
void pre_msg_form();
void free_cell(PBFRLNK);
void readstr_cmd();
void copy_cmdtobfr(WORD, BYTE *, WORD);
void copy_cmdtomsg(WORD, WORD, WORD);
void copy_mem(BYTE *, BYTE *, WORD);
void put_assume_msg();
void alloc_bfr(PBFRLNK *);


