#include "dtype.h"
#include "cmddef.h"
#include "AD52.h"
#include "reg51.h"
#include "def52.h"
#include "epdef.h"


#define TRACEBUFLEN 0x1000

/* BP save/restore buffer */
#define MAXBPCELL   20
#define MAXINDEX     (CELLLEN-sizeof(MEMADR)-2)

/* franklin C51 address type definition */
#define HD51_IDATA  1
#define HD51_XDATA  2
#define HD51_PDATA  3
#define HD51_DATA   4
#define HD51_CODE   5

extern BFRQUEUE BfrQueue, MsgQueue, CmdQueue, InitMsgQueue;
extern PFINALMSG pFinal;
extern BYTE MsgPos;
extern code FINALMSG DefaultFinal;
extern WORD CPUmode;
extern BPQUEUE OrgBp;
extern PBFRLNK pCurCmd, pCurMsg;

PFINALMSG read_var(pMemVar, pVarBfr)
PMEMVAR pMemVar;
BYTE * pVarBfr;
{
BYTE DataSz;
MEMOPRANGE MemOpRange;
BYTE TmpData[4];

   DataSz= ((pMemVar->VarType.Low & 0x7F)-1)/8+1;
   MemOpRange.AdrType.Low= pMemVar->AdrType.Low;
   MemOpRange.AdrType.Hi= pMemVar->AdrType.Hi;
   MemOpRange.StartAdr[0]= pMemVar->VarAdr[0];
   MemOpRange.StartAdr[1]= pMemVar->VarAdr[1];
   MemOpRange.AdrLen[0]= DataSz;
   MemOpRange.AdrLen[1]= 0;
   MemOpRange.OpSize.Low= UBYTE;
   MemOpRange.OpSize.Hi= 0;
   read_mem(&MemOpRange,TmpData);
   for (;DataSz; DataSz--) {
      *pVarBfr= TmpData[DataSz-1];
      pVarBfr++;
   }
   return &DefaultFinal;
}

PFINALMSG write_var(pMemVar)
PMEMVAR pMemVar;
{
BYTE DataSz, i;
MDFYMEM MdfyMem;

   DataSz= ((pMemVar->VarType.Low & 0x7F)-1)/8+1;
   MdfyMem.Range.AdrType.Low= pMemVar->AdrType.Low;
   MdfyMem.Range.AdrType.Hi= pMemVar->AdrType.Hi;
   MdfyMem.Range.StartAdr[0]= pMemVar->VarAdr[0];
   MdfyMem.Range.StartAdr[1]= pMemVar->VarAdr[1];
   MdfyMem.Range.AdrLen[0]= DataSz;
   MdfyMem.Range.AdrLen[1]= 0;
   MdfyMem.DataLen.Low= DataSz;
   MdfyMem.DataLen.Hi= 0;
   for (i=0; i<DataSz; i++)
      MdfyMem.Data[i]= pMemVar->Data[(DataSz-1)-i];
   return fill_mem(&MdfyMem);
}

BYTE in_range(pAdr, pStartAdr, pEndAdr)
PMEMADR pAdr, pStartAdr, pEndAdr;
{
WORD Adr, StartAdr, EndAdr;


   if (pAdr->AdrType.Hi == HIBYTE(MICE51_CODE)) {
      if (pAdr->AdrType.Low != pStartAdr->AdrType.Low)
         return FALSE;
   Adr= ((WORD)pAdr->Adr[1]<<8)+pAdr->Adr[0];
   StartAdr= ((WORD)pStartAdr->Adr[1]<<8)+pStartAdr->Adr[0];
   if (Adr < StartAdr)
      return FALSE;
   EndAdr= ((WORD)pEndAdr->Adr[1]<<8)+pEndAdr->Adr[0];
   if (Adr > EndAdr)
      return FALSE;
   }
   else {
      if (pAdr->Adr[0] < pStartAdr->Adr[0] || pAdr->Adr[0] > pEndAdr->Adr[0])
         return FALSE;
   }
   return TRUE;
}

BYTE is_last_adr(pSetAdr, pEndAdr)
PMEMADR pSetAdr, pEndAdr;
{

   if (pSetAdr->AdrType.Hi == HIBYTE(MICE51_CODE)) {
      if (pSetAdr->Adr[1] < pEndAdr->Adr[1]) return FALSE;
      if (pSetAdr->Adr[1] == pEndAdr->Adr[1])
         if (pSetAdr->Adr[0] <= pEndAdr->Adr[0]) return FALSE;
   }
   else {
      if (pSetAdr->Adr[0] <= pEndAdr->Adr[0]) return FALSE;
   }
   return TRUE;
}

BYTE advance_adr(pFinalAdr, Ofst)
PMEMADR pFinalAdr;
DWORD Ofst;
{
WORD FinalAdr, OrgAdr;

   if (pFinalAdr->AdrType.Hi == HIBYTE(MICE51_CODE)) {
      OrgAdr=  ((WORD)pFinalAdr->Adr[1]<<8) + pFinalAdr->Adr[0];
   FinalAdr=  OrgAdr + (WORD)Ofst;
   pFinalAdr->Adr[0]= LOBYTE(FinalAdr);
   pFinalAdr->Adr[1]= HIBYTE(FinalAdr);
      if (FinalAdr >= OrgAdr)
         return TRUE;
   }
   else {
      OrgAdr=  pFinalAdr->Adr[0];
      pFinalAdr->Adr[0]=  OrgAdr + (WORD)Ofst;
      if (pFinalAdr->Adr[0] >= OrgAdr)
         return TRUE;
   }
   return FALSE;
}

short adjust_stack(StkPtr)
short StkPtr;
{
BYTE Sp;
WORD AdjStkPtr;

   get_a_reg(REG_SP, &Sp);
   if (StkPtr >= 0) {
      if (StkPtr > Sp)
         StkPtr= Sp;
   }
   else {
      AdjStkPtr = (WORD)Sp+(WORD)(-StkPtr);
      if (AdjStkPtr > 0xFF)
         StkPtr= Sp-(short)255;
   }
   return StkPtr;
}

WORD get_stktype()
{
   return UBYTE; /* Stack data type is word */
}

PFINALMSG read_a_stack(Stk, pStackData)
short Stk;
PSTACKDATA pStackData;
{
BYTE Sp;
MEMOPRANGE MemOpRange;

   get_a_reg(REG_SP, &Sp);
   Sp = (short)Sp + (-Stk);
   pStackData->AdrType.Low= LOBYTE(MICE51_IDATA);     /* Internal data type */
   pStackData->AdrType.Hi= HIBYTE(MICE51_IDATA);
   pStackData->StkAdr[0]= Sp;

   MemOpRange.AdrType.Low= LOBYTE(MICE51_IDATA);
   MemOpRange.AdrType.Hi= HIBYTE(MICE51_IDATA);
   MemOpRange.StartAdr[0]= Sp;
   MemOpRange.AdrLen[0]= 1;
   MemOpRange.AdrLen[1]= 0;
   MemOpRange.OpSize.Low= UBYTE;
   MemOpRange.OpSize.Hi= 0;
   return read_mem(&MemOpRange,&pStackData->Data[0]);
}

extern MEMADR LastEndDsmAdr, LastStartDsmAdr;
void show_exebp(pBpRange)
PBFRLNK pBpRange;
{
PMEMADR pStartAdr;
MEMADR SetAdr,EndAdr;
DWORD AdrLen, MaxLst, LstCnt;
WORD i;
BYTE CellIndex, BpIndex, MaxIndex;

   pStartAdr= (PMEMADR)take_addr(pBpRange, CMD_SHOWBP_ADRTYPE);
   SetAdr.AdrType.Low= pStartAdr->AdrType.Low;
   SetAdr.AdrType.Hi= pStartAdr->AdrType.Hi;
   MaxLst= take_dword(pBpRange, CMD_SHOWBP_MAXLST);
   if ((SetAdr.AdrType.Low|SetAdr.AdrType.Hi)== 0) {
      if (take_word(pBpRange, CMD_SHOWBP_ADR)) {
         /* show bp in last disassembler range */
         SetAdr.AdrType.Low= LastStartDsmAdr.AdrType.Low; /* set program type */
         SetAdr.AdrType.Hi= LastStartDsmAdr.AdrType.Hi;
         EndAdr.AdrType.Low= LastStartDsmAdr.AdrType.Low;
         EndAdr.AdrType.Hi= LastStartDsmAdr.AdrType.Hi;
         SetAdr.Adr[0]= LastStartDsmAdr.Adr[0];
         SetAdr.Adr[1]= LastStartDsmAdr.Adr[1];
         EndAdr.Adr[0]= LastEndDsmAdr.Adr[0];
         EndAdr.Adr[1]= LastEndDsmAdr.Adr[1];
      }
      else {
         SetAdr.AdrType.Low= LOBYTE(MICE51_CODE); /* set program type */
         SetAdr.AdrType.Hi= HIBYTE(MICE51_CODE);
         EndAdr.AdrType.Low= LOBYTE(MICE51_CODE);
         EndAdr.AdrType.Hi= HIBYTE(MICE51_CODE);
         for (i=0; i<2; i++ ) {
            SetAdr.Adr[i]= 0x00;
            EndAdr.Adr[i]= 0xFF;
         }
      }
   }
   else {
      AdrLen= take_dword(pBpRange, CMD_SHOWBP_ADRLEN);
      EndAdr.AdrType.Low= pStartAdr->AdrType.Low;
      EndAdr.AdrType.Hi= pStartAdr->AdrType.Hi;
      for (i=0; i<2; i++) {
         SetAdr.Adr[i]= pStartAdr->Adr[i];
         EndAdr.Adr[i]= pStartAdr->Adr[i];
      }
      if (AdrLen) {
         if (!advance_adr(&EndAdr, AdrLen-1)) {
            EndAdr.Adr[0]= 0xFF;
            EndAdr.Adr[1]= 0xFF;
         }
      }
      else goto end_showbp;
   }


   LstCnt= 0;
   if (OrgBp.Status != ORGBP) {
      for(CellIndex=0, MaxIndex=MAXINDEX ; CellIndex <= OrgBp.LastCell;
        CellIndex++) {
         if (CellIndex == OrgBp.LastCell) MaxIndex= OrgBp.Index;
         for (BpIndex=MSG_PARM; BpIndex < MaxIndex; BpIndex+=sizeof(MEMADR)) {
            if (is_last_adr((PMEMADR)&(OrgBp.pCell[CellIndex]->Data[BpIndex]),
                &EndAdr)== TRUE) goto end_showbp;
            if (in_range((PMEMADR)&(OrgBp.pCell[CellIndex]->Data[BpIndex]),
                &SetAdr, &EndAdr)) {
               if (++LstCnt > MaxLst) goto end_showbp;
               if ( (CELLLEN-MsgPos) < sizeof(MEMADR))
                    nxt_msg();
               putmsg_blk(MsgPos, &(OrgBp.pCell[CellIndex]->Data[BpIndex]),
                    sizeof(MEMADR));
            }
         }
      }
   }
   else {
      while (is_last_adr(&SetAdr, &EndAdr) == FALSE) {
         pFinal= query_exebp(&SetAdr, &EndAdr);

         if (pFinal->FinalCode.Hi) goto end_showbp;
         if (++LstCnt > MaxLst) goto end_showbp;
         if (pFinal->FinalCode.Low) {
            if ( (CELLLEN-MsgPos) < sizeof(MEMADR))
                nxt_msg();
            putmsg_blk(MsgPos, (BYTE *)&SetAdr, sizeof(MEMADR));
            if (advance_adr(&SetAdr, 1L)==FALSE) goto end_showbp;
         }
         else break;
      }
   }
end_showbp:
   putmsg_word(MsgPos,0);
   send_msg(LASTMSG);
}

void readstr_cmd(void) {
WORD AdrOffset;
MEMOPRANGE MemOpRange;
WORD AdrLen;
WORD unfinished;
BYTE i;
BYTE *pStr;
BYTE IndrAdr[3];

   copy_cmdtobfr(CMD_PARM, (BYTE *)&MemOpRange, sizeof(MEMADR));
   for (i=1; i<8; i++)
      MemOpRange.AdrLen[i]=0;
   if (!take_cmdbyte(CMD_READSTR_DIRECT)) {
      MemOpRange.AdrLen[0]= 3;
      pFinal= read_mem(&MemOpRange,IndrAdr);
      switch (IndrAdr[0]) {
         case HD51_IDATA:
         case HD51_DATA:
            MemOpRange.AdrType.Low= LOBYTE(MICE51_IDATA);
            MemOpRange.AdrType.Hi= HIBYTE(MICE51_IDATA);
            MemOpRange.StartAdr[0]= IndrAdr[2];
            MemOpRange.StartAdr[1]= IndrAdr[1];
            break;
         case HD51_CODE:
            MemOpRange.AdrType.Low= LOBYTE(MICE51_CODE);
            MemOpRange.AdrType.Hi= HIBYTE(MICE51_CODE);
            break;
         case HD51_PDATA:
         case HD51_XDATA:
         default:
            MemOpRange.AdrType.Low= LOBYTE(MICE51_XDATA);
            MemOpRange.AdrType.Hi= HIBYTE(MICE51_XDATA);
            break;
      }
      MemOpRange.StartAdr[0]= IndrAdr[2];
      MemOpRange.StartAdr[1]= IndrAdr[1];
      for (i=2; i<8; i++)
         MemOpRange.StartAdr[i]=0;
      for (i=0; i<sizeof(MEMADR); i++)
         putmsg_blk(MSG_PARM, (BYTE *)&MemOpRange, sizeof(MEMADR));
   }
   else
      copy_cmdtomsg(CMD_PARM, MSG_PARM, sizeof(MEMADR));

   AdrLen= take_cmddword(CMD_READSTR_MAXLEN);
   AdrOffset= 0;
   while (AdrOffset < AdrLen) {
      i = CELLLEN-MsgPos-1;
      unfinished= AdrLen-AdrOffset;
      if ( (DWORD)i > unfinished)
         i= (BYTE)unfinished;
      MemOpRange.AdrLen[0]= i;
      pStr= take_addr(pCurMsg,MsgPos);
      pFinal= read_mem(&MemOpRange,pStr);
      advance_adr((PMEMADR)&MemOpRange, (DWORD)i);
      MsgPos+= i;
      AdrOffset += i;
      for (; i>0; i--,pStr++) {
         if (*pStr=='\0') {
            AdrLen= AdrOffset;
            break;
         }
      }
      if (AdrOffset < AdrLen) {
         send_msg(MOREMSG);
         if (pFinal->FinalCode.Hi)
            return;
         alloc_msg();
         put_assume_msg();
      }
   }
   putmsg_byte(MsgPos,'\0');
   send_msg(LASTMSG);
}

extern code BYTE MemRead, MemDsm, MemAsm, MemMap;
extern code BYTE DeviceID, RegForm, EventForm;
extern code TRACEFORM TraceForm;
extern code BYTE MemAvail, SysCapacity;
extern code WORD LenMemRead, LenMemDsm, LenMemAsm, LenMemMap;

//;extern code WORD LenDeviceID, LenRegForm, LenTraceForm, LenEventForm;
extern code WORD LenDeviceID, LenTraceForm, LenEventForm;// 7/4/94

// Sep/28/1994 Deng
extern code WORD LenRegForm752;

extern code WORD LenRegForm750;
extern code WORD LenRegForm751;
// Dec/27/1994 deng add for 750/751



#if 0
extern code WORD LenRegForm0,LenRegForm31,LenRegForm32,LenRegForm44;
extern code WORD LenRegForm652,LenRegForm51FA,LenRegForm154;
extern code WORD LenRegForm528 ;
#endif


extern code WORD LenSysCapacity;
extern code WORD LenMemAvail;
extern code WORD LenTransList;
extern code BYTE TransList;
BYTE *pMemRead, *pMemDsm, *pMemAsm, *pMemMap;
BYTE *pDeviceID, *pRegForm, *pEventForm;
TRACEFORM *pTraceForm;
BYTE *pMemAvail, *pSysCapacity;
WORD *pLenMemRead, *pLenMemDsm, *pLenMemAsm, *pLenMemMap;
WORD *pLenDeviceID, *pLenRegForm, *pLenTraceForm, *pLenEventForm;
WORD *pLenSysCapacity;
WORD *pLenMemAvail;
WORD *pLenTransList;
BYTE *pTransList;
//WORD LenRegData;

//+
WORD lenDeviceID ;
extern BYTE deviceEpID[] ;
extern code BYTE deviceIdHeader ;
typedef struct cpumlst{
   BYTE *name;
   WORD modelBit;
   BYTE subVer ;
} CPULST, *PCPULST;
extern  code CPULST cpuModelList[] ;
extern       WORD epMode ;


// Sep/28/1994 Deng
extern   code BYTE regForm752,REGS752,REGE752;
// Dec/27/1994 deng modify for 750/751
extern   code BYTE regForm750,REGS750,REGE750;
extern   code BYTE regForm751,REGS751,REGE751;

   static code WORD ep2CPU[] = {
   CM31,    CM32,   CM154,  CM44,  CM152A,
   CM152B,  CM152A, CM152B, CM51FA, CM751,
   CM562,   CM752,  CM652, CM750, CM31,
   CM31, CM31, CM31, CM31} ;  //575, 592, CL31, C451

void pre_msg_form(void) {
BYTE index ;
BYTE *cPtr ; //cPtr is a pointer direct to string of cpu name on easyview
//BYTE *cPtr1;

   pMemRead= &MemRead;
   pMemDsm= &MemDsm;
   pMemAsm= &MemAsm;
   pMemMap= &MemMap;

   pLenDeviceID = &lenDeviceID ;
   pDeviceID= deviceEpID;

   //ICEDEV and VERSION
   cPtr = &deviceIdHeader ;
   for (lenDeviceID = 0; lenDeviceID < 4; lenDeviceID++)
      deviceEpID[lenDeviceID] = *(cPtr++) ;
   index = 0 ;
   while ((cpuModelList[index].modelBit != epMode) &&
          (cpuModelList[index].name[0]  != 0))
      index++ ;
   cPtr = &cpuModelList[index].name[0] ;
   do {
      deviceEpID[lenDeviceID++] = *cPtr ;
   } while (*(cPtr++) != 0) ;
   deviceEpID[lenDeviceID++] = cpuModelList[index].subVer ; // Disigned version
   deviceEpID[lenDeviceID++] = 0 ; // NULL

// Sep/28/1994 Deng
//   pLenRegForm = &LenRegForm752;  /Dec/27/1994 Deng
//   pRegForm = &regForm752;

switch(epMode) {
      case EP80C752:
      case EP83C752:
           pLenRegForm = &LenRegForm752; // Dec/27/1994 Deng
           pRegForm = &regForm752;
         break ;
      case EP80C751:
      case EP83C751:
           pLenRegForm = &LenRegForm751; // Dec/27/1994 Deng
           pRegForm = &regForm751;
         break ;
      case EP80C750:
      case EP83C750:
           pLenRegForm = &LenRegForm750; // Dec/27/1994 Deng
           pRegForm = &regForm750;
         break ;
      default :
           pLenRegForm = &LenRegForm752;  // Dec/27/1994 Deng
           pRegForm = &regForm752;
         break ;
               }

#if 0
   switch(epMode) {
      case EP8032:
      case EP8052:
         break ;
      case EP8044:
      case EP8344:
         break ;
      case EP8051FA:
      case EP8351FA:
         break ;
      case EP80154:
      case EP83154:
         break ;
      case EP80C752:
      case EP83C752:
         break ;
      case EP80C552:
      case EP83C552:
         break ;
      case EP80C550:
      case EP83C550:
         break ;
      case EP80C652:
      case EP83C652:
         break ;
      case EP80C528: // 7/27/94
      case EP83C528:
         break ;
      default:
         break;
   }
#endif

   pEventForm = &EventForm;
   pTraceForm = &TraceForm;
   pMemAvail = &MemAvail;
   pSysCapacity = &SysCapacity;
   pLenMemRead = &LenMemRead;
   pLenMemDsm = &LenMemDsm;
   pLenMemAsm = &LenMemAsm;
   pLenMemMap = &LenMemMap;
   pLenTraceForm = &LenTraceForm;
   pLenEventForm = &LenEventForm;
   pLenSysCapacity = &LenSysCapacity;
   pLenMemAvail = &LenMemAvail;
   pLenTransList = &LenTransList;
   pTransList = &TransList;
// convert CPUmode to CMXXX

   CPUmode = ep2CPU[(epMode >> 1)] ;

// CPUmode = CM752;

}

void save_exebp(void) {
MEMADR SetAdr,EndAdr;
PBFRLNK pCell;
WORD MaxLst;
WORD i;

   SetAdr.AdrType.Low= 0x01; /* set program type */
   SetAdr.AdrType.Hi= 0x22;
   EndAdr.AdrType.Low= 0x01;
   EndAdr.AdrType.Hi= 0x22;
   for (i=0; i<2; i++ ) {
     SetAdr.Adr[i]= 0x00;
     EndAdr.Adr[i]= 0xFF;
   }

   OrgBp.LastCell= 0;
   alloc_bfr(&pCell);
   OrgBp.Index= MSG_PARM;

   while (1){
      pFinal= query_exebp(&SetAdr, &EndAdr);

      if (pFinal->FinalCode.Low) {
         clr_exbp(&SetAdr);
         for (i=0; i<sizeof(MEMADR); i++)
            pCell->Data[OrgBp.Index+i]=((BYTE *)&SetAdr)[i];
         OrgBp.Index += sizeof(MEMADR);
         if (OrgBp.Index > MAXINDEX) {
            if (OrgBp.LastCell >= MAXBPCELL)
               break;
            OrgBp.pCell[OrgBp.LastCell++]= pCell;
            alloc_bfr(&pCell);
            OrgBp.Index= MSG_PARM;
         }
         if (advance_adr(&SetAdr, 1L)==FALSE) break;
      }
      else break;
   }
   if (OrgBp.Index > MSG_PARM) {
      OrgBp.pCell[OrgBp.LastCell]= pCell;
   }
   else
      free_cell(pCell);
}

void reset_exebp()
{
BYTE CellIndex, BpIndex;
if (OrgBp.Status != ORGBP)
    {
    clr_groupbp();
    for(CellIndex=0; CellIndex != OrgBp.LastCell; CellIndex++)
        {
        for (BpIndex=MSG_PARM; BpIndex < MAXINDEX; BpIndex+=sizeof(MEMADR))
            set_exbp((PMEMADR)&(OrgBp.pCell[CellIndex]->Data[BpIndex]));
        free_cell(OrgBp.pCell[CellIndex]);
        }
//  if (OrgBp.Index >= MSG_PARM)
    if (OrgBp.Index > MSG_PARM)
        {
        for (BpIndex=MSG_PARM; BpIndex < OrgBp.Index; BpIndex+=sizeof(MEMADR))
            set_exbp((PMEMADR)&(OrgBp.pCell[CellIndex]->Data[BpIndex]));
        free_cell(OrgBp.pCell[CellIndex]);
        }
    OrgBp.Status= ORGBP;
    }
}
