#
#  Name: makefile.mak
#
#  Description: Make definitions for EZ8052 firmware
#               for FrankLin C make.exe
#
#  $Log$
#
#  $Header$
#
#  COPYRIGHT (C) 1993 MICROTEK INTERNATIONAL, INC.
#


#
# files
#
SRC = .
BIN = bin
FCDIR = c:\TOOL\c51.v24
#FCDIR = D:\c51.v32
INC = $(FCDIR)\inc
CCDIR = $(FCDIR)
#CCDIR = $(FCDIR)\BIN
ASMDIR = $(FCDIR)
#ASMDIR = $(FCDIR)\BIN
#LNKDIR = $(FCDIR)
LNKDIR = $(FCDIR)\BIN
USDDIR = c:\USD
LIBDIR = $(FCDIR)\LIB
#DEEMAX = c:\deemax
TMPDIR = c:
# Verison number
VER = 22

.SUFFIXES:      .HEX .ABS .OBJ .C .A51 .H .A${VER}

#		*Translator Definitions*
#  Macros definition
#
ASM = $(ASMDIR)\A51
ASMFLAG = DEBUG
#LINK = $(LNKDIR)\xlink86
#LINK = $(LNKDIR)\xlink86e
LOC = $(ASMDIR)\L51
OH51 = $(ASMDIR)\oh51
CONV = $(USDDIR)\CONVERT
CONVEZ = CONVEZ
#OMFCONV = $(DEEMAX)\omfconv
CODEGEN = conv52
CHKSUM = omfcksum
CC = $(CCDIR)\c51
CFLAG = large debug oe OT(0) CODE


#		*Implicit Rules*
.C.obj:
 SET C51INC=${INC}
 SET C51TEMP=${TMPDIR}
 ${CC} ${SRC}\$*.c ${CFLAG} PR(${TMPDIR}\ERR.LST) OJ(${BIN}\$*.obj)

.A${VER}.obj:
 ${ASM} ${SRC}\$*.A${VER} ${ASMFLAG} NOPR EP(${TMPDIR}\err.lst) OJ(${BIN}\$*.obj)

.A51.obj:
 $(ASM) ${SRC}\$*.A51 ${ASMFLAG} NOPR EP(${TMPDIR}\err.lst) OJ(${BIN}\$*.obj)

# define all objs

LNK_depends = ${BIN}\hwtst52.obj ${BIN}\hwSUB52.obj ${BIN}\LLFW52.OBJ  \
              ${BIN}\icehwlib.obj ${BIN}\xfwsub.obj ${BIN}\INITDATA.OBJ  \
              ${BIN}\XFWMAIN.obj ${BIN}\XFWcomm.obj ${BIN}\XFWasm.obj ${BIN}\insram_e.obj


#
${BIN}\FW52.ABS : ${LNK_depends}
 SET C51LIB=$(LIBDIR)
 echo ${BIN}\xfwmain.obj,      &  > ${TMPDIR}\tmp.lnk
 echo ${BIN}\xfwcomm.obj,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\xfwasm.obj,       & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\insram_e.obj,     & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\icehwlib.obj,     & >> ${TMPDIR}\tmp.lnk
 echo C:\TOOL\C51.v24\lib\C51L.lib, & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\LLfw52.obj,       & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\hwsub52.obj,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\xfwsub.obj,      & >> ${TMPDIR}\tmp.lnk
 echo C:\TOOL\C51.v24\lib\C51L.lib, & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\hwtst52.obj,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\initdata.obj      & >> ${TMPDIR}\tmp.lnk
#to ${BIN}\fw52.abs IXREF MAP SYMBOLS NOOVERLAY
 echo to ${BIN}\fw52.abs      &  >> ${TMPDIR}\tmp.lnk
#BIT(BVAR(60h))          &
 echo IXREF MAP SYMBOLS NOOVERLAY      &  >> ${TMPDIR}\tmp.lnk
 ${LOC}  @${TMPDIR}\tmp.lnk
 del ${TMPDIR}\tmp.lnk
#$(CONV) ${BIN}\fw52.abs
 ${CHKSUM} ${BIN}\fw52.abs 0ffff
#$(OMFCONV) ${BIN}\fw52.abs
 if exist ${TMPDIR}\ERR.LST del ${TMPDIR}\TMP.LST
 if exist ${SRC}\fw52.HDF del ${SRC}\fw52.HDF
 if exist ${BIN}\fw52.hex del ${BIN}\fw52.hex
 copy ${BIN}\fw52.abs .
 set TMP=C:
#${CONVEZ} fw52.abs

#FW52.HEX : FW52.ABS
# $(PROM) ${BIN}\main186.abs to ${BIN}\main186.hex hex ad(0d0000h, 0fffffh)\
#         INITDATA EA

#		*Explicit Rules*
#FWMAIN.OBJ: ${SRC}\FWMAIN.c
${BIN}\xFWMAIN.OBJ: ${SRC}\xFWMAIN.c
${BIN}\xfwcomm.obj: ${SRC}\xfwcomm.c ${SRC}\xfwcmd.h
${BIN}\xfwsub.obj: ${SRC}\xfwsub.c
${BIN}\LLFW52.OBJ : ${SRC}\LLFW52.A$(VER) ${SRC}\IO.equ

${SRC}\can_ez52.dw : ${SRC}\can_ez52.A$(VER)
 $(ASM) ${SRC}\$*.A$(VER) NOOJ
 $(CODEGEN) ${SRC}\$*.LST ${SRC}\$*.DW ${SRC}\$*.EQU ${SRC}\$*.TBL

${SRC}\can_ez52.tbl : ${SRC}\can_ez52.A$(VER)
 $(ASM) ${SRC}\$*.A$(VER) NOOJ
 $(CODEGEN) ${SRC}\$*.LST ${SRC}\$*.DW ${SRC}\$*.EQU ${SRC}\$*.TBL

${SRC}\can_ez52.EQU : ${SRC}\can_ez52.A$(VER)
 $(ASM) ${SRC}\$*.A$(VER) NOOJ
 $(CODEGEN) ${SRC}\$*.LST ${SRC}\$*.DW ${SRC}\$*.EQU ${SRC}\$*.TBL

${BIN}\hwsub52.obj : ${SRC}\hwsub52.A$(VER) ${SRC}\can_ez52.dw ${SRC}\CAN_EZ52.EQU ${SRC}\IO.equ
${BIN}\icehwlib.obj: ${SRC}\icehwlib.c ${SRC}\icehwlib.h ${SRC}\io.h ${SRC}\can_ez52.tbl ${SRC}\basetype.h

${BIN}\INSRAM_E.obj : ${SRC}\INSRAM_E.A$(VER)
${BIN}\hwtst52.OBJ : ${SRC}\hWtst52.A$(VER) ${SRC}\IO.equ
${BIN}\initdata.obj : ${SRC}\INITDATA.A$(VER)
${BIN}\xfwasm.obj : ${SRC}\xfwasm.A$(VER)
