
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/FW/VER22/LOG/ICEHWLIB.C__   1.4   24 Sep 1996 13:51:28   ZJRD  $
**
**    $Log:   D:/EPSLDV1/FW/VER22/LOG/ICEHWLIB.C__  $
** 
**    Rev 1.4   24 Sep 1996 13:51:28   ZJRD
** No change.
** 
**    Rev 1.3   08 Jul 1996 10:33:24   ZJRD
** EasyPack/SLD FW Version 22.20
** 
**    Rev 1.2   15 Feb 1996 09:18:56   ZJRD
** EasyPack/SLD FW Version 22.12
** 
**    Rev 1.1   06 Feb 1996 16:18:56   ZJRD
** No change.
** 
**    Rev 1.0   29 Jan 1996 11:36:16   ZJRD
** Initial revision.
** 
****************************************************************************/
/****************************************************************************
**
**  Name:          icehwlib.c
**
**  Description:
**
**  Status:
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#define _ICEHWLIB_C

#include <reg51.h>
#include <string.h>
#include <stdio.h>

#include "basetype.h"
#include "icehwlib.h"
#include "fwmain.h"
#include "can_ez52.tbl"

#include "io.h"
#include "epdef.h"

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

static FINALMSG   fwMsg ;
U8         traceQualifyOn ; /* bit 0 -> current trace qualify setting */
                            /* bit 1 -> before stop trace qualify setting */
U8         cmdBuf[20] ;
code FINALMSG INVAILD_LEVEL = {
0, CMD_SYNTAX_ERR,
"Invaild level no!" };

//static code U8 RESET_ENABLE[] = "RESET ENABLED         " ;
//static code U8 DISABLE_MSG[] = "DISABLED" ;

extern code FINALMSG ErrStackOv ;  /* Out of the stack range!  */
extern code FINALMSG ErrEpRun  ;   /* Command ignored because EP running! */
extern code FINALMSG ErrEpWait ;   /* Command ignored because EP wait! */
extern code FINALMSG ErrEpHalt ;   /* Command ignored because EP halt! */
extern code FINALMSG ErrTraceRun ; /* Command ignored because Trace running! */


U8  LdFail ;
/* EP bit flag, bit 0 -> .EA, bit 1 -> .TR0, bit 2 -> .TR1,bit 3 -> .TR2 */
/*                            TR2 , TR1 , TR0 , EA  */
//static code U8 MASK_FLG[4] = {0x08, 0x04, 0x02, 0x01} ;
// static code U8 SFR_ADR[4]  = {0xCA, 0x8E, 0x8C, 0xAF} ;
#define  SETB  0xD2
#define  CLR   0xC2

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

//extern U8  timerHigh ; - koo
//extern U32 timerLow  ;
extern U8  initTrigger ; /* bit 0-> timer, bit 1 -> trace */
extern U8  fwMsgString[100] ;
extern U8  tmpBuf[] ; /* for PLINETXT type use */
extern U8  tmpRnBuf[8] ;
extern U32 ev1Count ;
//MAR/ERIC/1995
//extern U16  CPUmode ; /* CPU Mode bit definition */
  extern bit  coldStart ;         /* =1 -> cold start */

/* llfw52.a00 */
void OutHex16(U8 *bPtr) ; /* out bAddrH, bAddrL as hex string to bPtr */
void WVFail(U8 *) ;
U8   CheckBR_OVER(PFINALMSG) ;
/* hwtst52.a00 */
U8   RomChksum(void) ;
U8   SramTest(void) ;
U16  EpTest(void) ;
void InitHW(void) ;
U32  ChkTraSize(void) ;
/* sub52.a00 */
void Out_Trig(U8) ;
U8   CanRW(void) ;
U8   CanRdPara(void) ;
U8   CanWr(void) ;
U8   CanWrPara(void) ;
void WrEV_D(void) ;
U8   RdEV_D(void) ;
void WrEV_A(void) ;
U8   RdEV_A(void) ;
void WrMap(void) ;
U8   RdMap(void) ;
//void ReadElTimer(void) ;
//U16  Read_CTC(U8 channel) ;
//void Write_CTC(U8 channel, U16 cData) ;
void ClrEvent(U8 evNo) ;
void ClrEvARam(U8 fillData) ;
U8   CanRun(U8 mode) ;
void SpRamRd(U8 *sBuf, U16 sLen) ;
void SpRamWr(U8 *sBuf, U16 sLen) ;
void PrepareGo(void) ;
U8   LoadDecode(void) ;
U8   SaveTrace(TRACE_DATA tBuf[], U8 saveCnt) ;
void ClrTraceCnt(void) ;
void CountTraceCnt(void) ;
U8   RstEp(void) ;
void init_EP_1(void) ;
U8   CheckClockRate(void) ;
U8   GetRegAll(U8 *) ;
void WrCanRam(void) ;
void RdCanRam(void) ;
void WrEmRam(void) ;
void RdEmRam(void) ;
U16  CheckEpType(void) ;
//void RdSpToTbuf(void) ;
U8   MemFill(U8 *) ;
U8   MemDump(U8 *cmdBuf, U8 *bPtr) ;
U8   MemTest(U8 *) ;
U16  MemCkSum(U8 *) ;
U8   GoSpoon(void) ;
void EnableAdrBuf(void) ;
void EnableMapRam(void) ;
void EnEvLogic(void) ;
void DisableAdrBuf(void) ;
void DisableMapRam(void) ;
void DisEvLogic(void) ;
void LdStopSp(void) ; /* load stop spoon into spoon ram(SDATA = 0, counter from 0 to 80h) */
U8   StopEP(void) ;
U8   CycleStep(void) ;
U8   LoadTrigIni(U8 control) ;
//U8   ScanExBp(void) ;
U8   SetTracePort(void) ;
U8   GetFrame(U16 , U8 *) ;
U8   GetRN(U8 *) ; /* get register R0-7, will destory A, DPH, DPL in EP */
U16  GetOpRange(PMEMOPRANGE mPtr, U8 *cmdBuf) ;
U8   GetData(U8 *) ;
U8   DispCycle(void) ;
//
void ini_msg(void) ;
void InitElTimer(void) ;
void SetTriggerHW(U8 event, U8 action) ;
void SetRunFromAdr(RUNPARA *pRunParm) ;
void UpdateTraceCnt(void) ; /* read back traceCnt */
void ControlEA(U8) ; /* 0 disable EA, 1 enable EA */
void ControlRst(U8) ; /* 0 disable Rst, 1 enable Rst */
void ControlEBEN(U8) ; /* 0 disable EBEN, 1 enable EBEN */

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

void GetRegister(void) ;
void SaveRegister(void) ;

//void InitFwMsg(void) ;   Eric Deng marked June.22.1995
//void RecallRn(void) ;

unsigned char EpSupport( unsigned char * );

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

U16 lenRegData ;
/******************************************************************************
**  called when power on & handshake(cold/warm start)
**  output:
**     SysTst=0     SYSOK      test OK
**           =1     SYSRAMERR  system RAM test error
**           =2     EPERR      EP test falure
**           =4     UNERR      component Un test error
**     CEBUFFER                detal infomation about SysTst=UNERR
*****************************************************************************/
void sysini(void) {
//U16  resetFlag ;
//static ADRSTRUCT tPc ;


   EA  = 0 ;  /* disable interrupt during system init */
   EX0 = 0 ;  /* EP status changed */
// EX1 = 0 ;  /* PCE interface */
   IT0 = 0 ;
   IT1 = 0 ;
/* clear timer 0, 1 interrupt */
   ET0 = 0 ;
   ET1 = 0 ;
   TR0 = 0 ;
   TR1 = 0 ;
   TF0 = 0 ;
   TF1 = 0 ;

   bCtrl0 = bCtrl0 & ~TRACE_EN; /* enable tclk1 to TCLK  + koo 5/14/1996 */
   LDCTRL0 = bCtrl0 ;
   lenRegData = sizeof(REGDATA) ;

   TMOD = 0x11 ; /* program timer 0, 1 as 16 bits timer */

   P1 = 0xff ;

// SysTst = 0 ;
   InitHW() ;  /* disable H/W */  // MAR/ERIC/ok


   if ((coldStart == 1) || (SysTst != 0)) { /* Do selftest if cold start */

      epFail = 0 ;
      SysTst = 0 ;
      /* do rom checksum, ram test, ep test */
      if (RomChksum() != OK)
         SysTst = 1 ;
      if (SramTest() != OK) /* ram test will destory buffer */
         SysTst = SysTst | 2 ;
      InitHW() ; /* recall port data in sram */
      /* finish selftest, set coldstart finish flag */
   }
   traceSize = ChkTraSize() ;    // MAR/ERIC need marked status operation
   RstEp() ;                     // MAR/ERIC OK

   /* trace condition init */
   ev3Buf = 0 ;
   ev1Count = 1 ;
   traceDlyCnt = 0l ;
// July/5/1995 ERIC + to store trigWay;
   trigWay = 0;      // default is delay
   EvQfStatus = 0;
   levCount = 1;


   tLogic[0] = 1 ;     /* set flag */
   tLogic[1] = 0 ;     /* run flag */
   tLogic[2] = 1 ;     /* level[0] */
   tLogic[3] = 0xff ;  /* level[1] */
   tLevel1[0] = 1 ;    /* set flag */
   tLevel1[1] = 0xff ; /* trace, timer */
   tLevel1[2] = 0xfe ; /* event condition : ev1|ev2|ev3 */
   tLevel2[0] = 0 ;
   /* clear event */
   traceQualifyOn = 0 ;
   getTraceCnt = 1 ;
   /* clear ev address compare ram, LoadDecode() will clear data ram */
   ClrEvARam(0xCf) ; /* default qualify all match */
   tracePort = 1 ; /* default trace in is port 1 */

   /* Load decode, map data, can program */
   LdFail = LoadDecode() ;
   CanRW() ;
   CanRdPara() ; /* load init data into canBuf */
   LdStopSp() ; /* load stop spoon into spoon ram */

   /* clear trace counter */
   traceCnt = 0 ;
   trigStatus = 1 ; /* default trigger is on */
   cycleFlag = 0 ;
   initTrigger = 3 ; /* default trace and timer is on */
   fw_verify = 1 ; /* default f/w verify is on */

// podModel = STATUS1B & 0x0f ;
   ControlRst(0) ; // disable target reset
   ControlEA(1) ; // eanble target EA before check EA
   targetEA = STATUS0B & CHKEA ;
   ControlEBEN(1) ; // enable target EBEN before check EBEN.
   targetEAT = STATUS0B & CHKEAT ;
   targetEBEN = STATUS0B & CHKEBEN ;// john: 94/12/22: add for EBEN

   if (STATUS0B & TVCC) // if no target VCC, disable reset
      reset_flg = 1 ;
   else
      reset_flg = 0 ;
   ControlEA(0) ;
   ControlEBEN(1);
   /* reset ep */
// init_EP(&tPc) ;
   RstEp() ;   // RstEP will read back pod id and store to podModel

   SysTst = SysTst & ~0x18 ; // clear bit 3, 4
   switch (podModel) {

      case 0xff:
         SysTst = SysTst | 8 ; // no probe connect
         return;
/*
      case 0: // EPH/EPL-52F
         epModel = CheckEpType() ;
// Oct.26.1995 Eric
         if ( epModel == EP8351FA ) epModel = EP8051FA;
         if ( epModel == EP8044 ) epModel = EP8344;
         if ( epModel == EP85154 ) epModel = EP80154;
         if ( targetEA ) epModel = epModel | 1;


         break ;

      case 1: // EPH/EPL-87C552

         if (targetEA)
            epModel = EP83C552 ;
         else
            epModel = EP80C552 ;
         break ;
      case 2: // EPH/EPL-83C752
         epModel = EP83C752 ; // default ep mode is 83C752
         break ;
      case 4: // EPH/EPL-87C152A
         if (targetEAT)
            epModel = EP83152A;
         else {
            if (targetEBEN)
               epModel = EP80152B;
            else
               epModel = EP80152A;
            }

         epModeTMP = epModel;

         ControlEA(targetEAT) ;
         ControlEBEN(targetEBEN);
         break ;
*/

      case 5:     // EP85CL782
         epModel = CheckEpType();
/*       if (epModel = EP80CL580)   {
            if (targetEA)
               epModel = EP83CL580 ;
            else
               epModel = EP80CL580 ;
            ControlEA(targetEA);
            }
         else  {
*/
            if ((epModel != EP83CL782)    // && (epModel != EP83CL781)
               && (epModel != EP80CL410)
               && (epModel != EP80CL31 )
               && (epModel != EP8051FA))
            SysTst = SysTst | 0x10 ; // not supply in this firmware
//             epModel = EP83CL782;
//          }
         break;

      case 6: // EPH/EPL-80C550
         if (targetEA)
            epModel = EP83C550 ;
         else
            epModel = EP80C550 ;
         ControlEA(targetEA) ;      //+koo 1/21/95
         break ;

      case 3:     // CL580
         if (targetEA)
            epModel = EP83CL580 ;
         else
            epModel = EP80CL580 ;
         ControlEA(targetEA);
	 break;

      default:
         SysTst = SysTst | 0x10 ; // not supply in this firmware
         return;
//       epModel = EP8031 ; /* no pod connected!!! */
//       break ;
   }
   ControlEA(targetEA) ;
//Oct.13.1995 ERIC modify
// if ( epModel >= EP80152A && epModel <= EP83152D ) epMode = EP80152A;
// else    epMode = epModel ;
  epMode = epModel ;
//Oct25 Eric FOR 152
  epModeTMP = epModel;

// canBuf[EP_TYPE] = (U8)epModel ;

   /* after check EP, must reset ep again*/
   init_EP_1() ;  /* like init_EP but no Status and Occurrence update */

// MAR/ERIC/1995
     Status = 0x88 ; /* verify on, trigger on */

   EA = 1 ; /* enable interrupt */
}
/****************************************************************************
**
**  start_EP
**
**  struct{
**          BYTE RunFlg;             0    without RUN
**                                   1    with RUN
**          BYTE Reserved ;
**          ADRSTRUCT fromAdr;       address type =0      no from address
**                                               ~=0      go from "FromAdr"
**          ADRSTRUCT tillAdr;       address type =0      free run
**                                               ~=0      go untill "TillAdr"
**          }
*****************************************************************************/

//PFINALMSG start_EP(RUNPARA *pRunParm) { /* force EP started */
unsigned char start_EP(RUNPARA *pRunParm) { /* force EP started */

U16 i, j ;
U8  k ;
// Apr/4/19/1995 ERIC #define EpRunning   0x10

// MAR/ERIC/1995
     if (epRunFlag == 1)
//      return &ErrEpRun ;   /* aleardy going */ Eric -
        return 0x10      ;   /* aleardy going  Eric + */

/*     InitFwMsg() ; Eric - */
     Occurrence = Occurrence | 0x0002 ;
     Status = (Status & 0xfe8b) | 0x040 ;  /* EP running */

   EX0 = 0 ;

   GetRegister() ;
   if (BR_OVER == 0)
      SaveRegister() ;


//   CheckBR_OVER(&fwMsg) ;      Eric -
//   if (BR_OVER != 0)
//      return &fwMsg ;

      if (BR_OVER != 0)       // Apr/18/1995 ERIC +
      {
         BR_OVER = 0;
         return   1;          // return target canot step
      };

   /* clear timer, 8254 */
// timerHigh = 0 ;
// TH0 = 0 ;
// TL0 = 0 ;
// Write_CTC(TIMER_CH, 0) ;
// ET0 = 1 ; /* enable timer 0 interrupt */
   InitElTimer() ;
   SetRunFromAdr(pRunParm) ;        // Apr/4/19/1995 ERIc must modify.

   /* clear trace counter */
// traceStart = 0 ;
// traceEnd = 0 ;
   traceCnt = 0 ;
// ClrTraceCnt() ;
// if ((RDTCNTL | RDTCNTH) != 0) { /* trace counter logic fail! */
//    return &fwMsg ;
// }

   /* set trigger, trace control */
   if ((traceQualifyOn & 1) != 0)
      traceQualifyOn = traceQualifyOn | 2 ;
   else
      traceQualifyOn = traceQualifyOn & 0xfd ;

   /* enable trace, compare ram and buffer */
// bCtrl3 = bCtrl3 & (~DISEP) & (~NTDIN) ;
// LDCTRL3 = bCtrl3 ;

   /* set address,.EA, .TR0, .TR1, .TR2,  go ep */
   epRunFlag = 1 ;
   getTraceCnt = 0 ;
// getRegFlg = 0 ;
// bCtrl2 = bCtrl2 & (~SDATA) ;
// LDCTRL2 = bCtrl2 ;

   PrepareGo() ; /* put run spoon data into spoon ram */

   /* set default timer and trace */
   SetTracePort() ;
   initTrigger = initTrigger | 3; /* force trace and timer is on + koo 5/2/96*/
   LoadTrigIni(initTrigger) ; /* set ev1 cnt will destory trigger init value */

   bBufen = (~NENTDBUF) & (~NENTABUF) ;
// bCtrl0 = bCtrl0 & ~GORUN ; /* turn off GORUN */
   bCtrl0 = bCtrl0 & ~TRACE_EN; /* enable tclk1 to TCLK  + koo 5/14/1996 */
   bCtrl0 = bCtrl0 | ENTRACE ; /* enable trace */

   /* if trace on, enable trace ram cs */
   bRamen = 0 ;

   /* Set trigger */
   if (goRunFlag == 0) {
      if ((tLogic[0] == 1) && (trigStatus != 0)) { /* trigger set and enable */
         for (k = 2; k <= 3; k++) {
            bDataL = tLogic[k] ;
            switch (bDataL) {
               case 1:
                  if ((k == 3) || (tLogic[3] == 0xff))
                     /* last level */
                     SetTriggerHW(tLevel1[2], tLevel1[1] & 0xef) ;
                  else
                     SetTriggerHW(tLevel1[2], tLevel1[1]) ;
                  break ;

               case 2:
                  if ((k == 3) || (tLogic[3] == 0xff))
                     /* last level */
                     SetTriggerHW(tLevel2[2], tLevel2[1] & 0xef) ;
                  else
                     SetTriggerHW(tLevel2[2], tLevel2[1]) ;
                  break ;

               case 0xff:  /* only one level */
                  if (k == 3)
                     SetTriggerHW(0, 0xef) ;
                  break ;
            } /* end switch */
         } /* end for loop */

         if (tLogic[1] != 0)
            /* with go run */
            bCtrl0 = bCtrl0 | GORUN ; /* turn on GORUN */
         else
            bCtrl0 = bCtrl0 & ~GORUN ; /* turn off GORUN */
      }
      else  { /* trigger off */
         SetTriggerHW(0, 0xff) ;
         SetTriggerHW(0, 0xff) ;
      }
   }
   else { /* Gorun, disable trigger */
      SetTriggerHW(0, 0xff) ;
      SetTriggerHW(0, 0xff) ;
      bRamen = bRamen | NACEN ;  /* disable address compare ram to disable ev, exebp */
   }

// MAR/ERIC/1995
//   ini_msg() ; /* update status call back */

   LDCTRL0 = bCtrl0 ;
   LDBUFEN = bBufen ;
   LDRAMEN = bRamen ;

   IT0 = 0 ; /* level of external interrup */
// EX0 = 1 ; /* enable status change */


   GoSpoon() ; /* if go run then disable ENMAPBP */

   ET1 = 1 ;
   TR1 = 1 ; /* enable status changed polling */
   EX0 = 1 ; /* enable status change */

//   return &fwMsg ;    Apr/4/19/1995 ERIC -
      return 0x0  ;  // Apr/4/19/1995 ERIC + CommandExeOk

}

extern xdata U8 clockMsg[] ;
U8 ConvTimerToMhz(U16 timerValue) {
U8 timer ;
U16 timer0, timer1 ;


   if (timerValue < 5721)
      timer0 = 60128 ; /* >= 21Mhz */
   else
      timer0 = 60080 ; /* < 21Mhz */
// V1.3 update for 40MHZ
   if (timerValue < 3010)
      timer0 = 60160 ;  // 40Mhz

   timer = timer0 / timerValue ;     /* 120160(120256) / timerValue */

   clockMsg[0] = '0' + (timer / 5) ;
   timer = timer * 2 ;
   clockMsg[1] = '0' + (timer % 10) ;


   timer1 = timer0 % timerValue ;
   timer1 = timer1 * 20 ;
   timer = timer1 / timerValue ;
   clockMsg[3] = '0' + timer ;

   timer1 = timer1 % timerValue ;
   timer1 = timer1 * 10 ;
   timer = timer1 / timerValue ;
   clockMsg[4] = '0' + timer ;

   return(0) ;
}

unsigned char EpSupport( unsigned char * pTemp )
{
   unsigned char retTmp;

   if( SysTst & 0x10 ) return 0;

   switch ( epModel ) {
      case EP83C550:
            *pTemp = (unsigned char) EP83C550;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80C550;
            pTemp ++;
            *pTemp = 0;
            retTmp = 2;
         break;
      case EP83CL782:
            *pTemp = (unsigned char) EP83CL782;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP83CL781;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80CL51;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80CL31;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80CL410;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP83CL410;
            pTemp ++;
            *pTemp = 0;
            retTmp = 6;
         break;
      case EP83CL580:
            *pTemp = (unsigned char) EP83CL580;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80CL580;
            pTemp ++;
            *pTemp = 0;
            retTmp = 2;
         break;
      case EP80CL31:
      case EP8031:
      case EP80CL410:
      case EP80C550:
      case EP80CL580:
      case EP8051FA:
            *pTemp = (unsigned char) epModel;
            pTemp ++;
            *pTemp = 0;
            retTmp = 1;
         break;

   default:

            retTmp = 0;
         break;
      }
   return retTmp;
}
//;$$$ NO.8
void set_cpu_model(void) {
//MAR/ERIC/1995
//   epMode = CPUmode ;
   switch (epModel) {

      case EP83C550 :          // 7/4/1994
         if (epMode == EP80C550) {
            ControlEA(0) ;
            init_EP_1() ;
         }
         else
            epMode = EP83C550 ;
         break ;
      case EP83CL580 :          // 7/4/1994
         if (epMode == EP80CL580) {
            ControlEA(0) ;
            init_EP_1() ;
         }
         else
            epMode = EP83CL580 ;
         break ;

      case EP83CL782:
      case EP83CL781:
         if ((epMode == EP80CL31) || (epMode == EP80CL410)) {
            ControlEA(0) ;
            init_EP_1() ;
         }
         else
         {
            if ((epMode == EP80CL51) || (epMode == EP83CL410)) {
               ControlEA(1) ;
               init_EP_1() ;
            }
            else
               if ((epMode != EP83CL781)) {
                  epMode = EP83CL782 ;
               }
            }
         break ;
      case EP80CL51:
      case EP80CL31:
      case EP83CL410:
      case EP80CL410:
      case EP80CL580:
      case EP8051FA:
      case EP80C550:
         epMode = epModel ;
            ControlEA(0) ;
            init_EP_1() ;
         break ;

//    case EP8031:            /* if epModel is 8031, just 8031 could select */
      default:
         epMode = epModel ;
         break ;
   }
// canBuf[EP_TYPE] = (U8)epMode ;
// OCT25 ERIC for 152
   if ( epMode != EP80152A ) epModeTMP = epMode;

   return ;
}
