
/**************************************************************************
**
**    $Header:   D:/EPSLDV1/FW/VER22/LOG/XFWCOMM.C__   1.4   24 Sep 1996 13:51:18   ZJRD  $
**
**    $Log:   D:/EPSLDV1/FW/VER22/LOG/XFWCOMM.C__  $
** 
**    Rev 1.4   24 Sep 1996 13:51:18   ZJRD
** EasyPack/SLD FW Version 22.21
** 
**    Rev 1.3   08 Jul 1996 10:33:00   ZJRD
** EasyPack/SLD FW Version 22.20
** 
**    Rev 1.2   15 Feb 1996 09:19:50   ZJRD
** No change.
** 
**    Rev 1.1   06 Feb 1996 16:19:08   ZJRD
** EasyPack/SLD FW Version 22.11
** 
**    Rev 1.0   29 Jan 1996 11:36:14   ZJRD
** Initial revision.
** 
***************************************************************************/
/****************************************************************************
**
**  Name:         xfwcomm.c
**
**  Description:
**
**  Status:
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <reg51.h>
#include "xfwcmd.h"

/******************** It's new start ************/
extern xdata unsigned char bCtrl0;
unsigned char temp1,temp2;
extern unsigned char Analyse_Coverage(void);
extern unsigned char Cover_Go(void);
extern unsigned char Cover_Get(void);
extern unsigned char go_trace(void);
extern unsigned char Trace_Init(void);
//spa
extern data unsigned char SysTst;
extern bit Coverage_Flg;
extern bit getTraceCnt;
extern bit epRunFlag;
extern bit EpTest_bit;
unsigned char Coverage_Range_No;
unsigned char Code_Access_No;
unsigned int Coverage_Range_SAd1;
unsigned int Coverage_Range_DAd1;
unsigned int Coverage_Range_SAd2;
unsigned int Coverage_Range_DAd2;
unsigned int Coverage_Range_SAd3;
unsigned int Coverage_Range_DAd3;
unsigned int Coverage_Range_SAd4;
unsigned int Coverage_Range_DAd4;
unsigned int Code_Access_Range_SAd[33];
unsigned int Code_Access_Range_DAd[33];
unsigned int Frame_No[60];
unsigned int Frame_adr[60];
extern void sysini(void);
extern unsigned char CycleStep(void);
/* SPA and Code Coverage Routing */
extern unsigned char ClrTraceCnt(void);
extern unsigned char EnableMapBp(void);
extern unsigned char Clr_Ev_ExBp_all(void);
extern unsigned char SetExBp( unsigned char * );
extern unsigned char GetCTraceBuf( unsigned char,  unsigned char );
extern xdata unsigned char LDCTRL0    ;
extern xdata unsigned char LDCTRL3    ;
extern unsigned char StopEp_1( void );
#define TRACE_EN        0x80
#define ENTRACE         0x10
#define NTDIN           0x04
#define DISEP           0x01
extern xdata unsigned char bStatus1A;
extern unsigned char Copy_Mem ( unsigned char * );
extern unsigned char Diag_Tst ( void );
/******************** It's new end ************/
extern bit TimerOut;
extern bit ChkTimerOut;
extern xdata unsigned char TimCount;

//(timer message when ep stop running)
//extern xdata U8 elTimerMsg[] ;
extern xdata unsigned char timerHigh;
extern xdata unsigned char timerLow;
extern xdata unsigned char timerLow_1;
extern xdata unsigned char timerLow_2;
extern xdata unsigned char timerLow_3;
extern bit ReadElTimer_Flg;

//Event_Get ( Qualify )
xdata unsigned char EvQfStatus; // bit0: Qualify status. 0:dis. 1:en
                                // bit1: Ev1 status
                                // bit2: Ev2 status
xdata unsigned char Ev1Buffer[0x80];
xdata unsigned char Ev2Buffer[0x80];
xdata unsigned char QlfBuffer[0x80];
extern xdata unsigned char Ev3Buf; // 0: low  1: high

//Trig_Get
extern xdata unsigned char trigStatus,trigWay,levCount;    // default 1 is on.
extern xdata unsigned char tLevel1[1+2] ;  /* set flag, trace, timer, event condition */
extern xdata unsigned char tLevel2[1+2] ;
extern xdata unsigned char tLogic[4] ;/* set flag, run flag, level[0], level[1] */
extern xdata unsigned long int traceDlyCnt ;
//
// NOV.1.1995 Eric
extern xdata unsigned char initTrigger ; /* bit 0-> timer, bit 1 -> trace */


extern data unsigned char bAddrH,bAddrL;
extern xdata unsigned char regbuf;
extern xdata unsigned int traceCnt;
extern xdata unsigned int STATUS;   // bit 4~6 = 4 EP running (BIT 6 = 1)
extern xdata unsigned int epModeTMP;
extern xdata unsigned int epMode;
extern xdata unsigned char clockMsg[];

extern void *memcpy(void *,void *,int );

// #define  LEAD_CODE   ':'
// #define  REC_OK      0x55
// #define  REC_FAIL    0xAA
// #define  ACK         0x5A
// #define  NACK        0xA5

#define  CommandExeOk       0x00
#define  TargetCanotStep    0x01
#define  MemWrFail          0x02
#define  MapStatusInC       0x03
#define  MapInAddrNoBnd     0x04
#define  BpNotFound         0x05
#define  BpFound            0x06
#define ParaError           0x08
#define CommunicationErr    0x07
#define  RangeStepHalt      0x09
#define  EpRunning          0x10
#define  TraceRunning       0x11
#define  TraceRDOver        0x12
#define  CmdInvalid         0x13

#define  FlashSWErr         0x40
#define  FlashECErr         0x41
#define  FlashPRGErr        0x42
#define  FlashRECErr        0x43


//    0x3A  reserved
//    0x55  reserved
//    0xAA  reserved
//    0x5A  reserved
//    0xA5  reserved

extern code unsigned char Fw_Support_Numb;
extern code unsigned char FW_VER_MAJOR,FW_VER_MINOR;
extern unsigned char CMD_RET;
unsigned char chksum;

unsigned int TStreamLen;

unsigned int commandStreamLen;
unsigned char commandStream[512];

unsigned char receiveBuf[512];
unsigned char TransmitBuf[2048];

void ReceiveStream(void);
void TransmitStream(void);
void ProcessCommand(void);

// for flash prom of Easypack. June/24/1995
extern unsigned char Flash_Here(void);

extern unsigned char ReceiveByte(void);
extern void TransmitByte(unsigned char);

extern unsigned char Init_Ep( unsigned char *);
extern unsigned char start_EP( unsigned char *);
extern unsigned char stop_EP( void );
extern unsigned char Output( unsigned char *);
extern unsigned char Input( unsigned char *, unsigned char *);
                          /* port ID         data save */
extern unsigned char Set_Verify( unsigned char );
extern unsigned char Set_Trig_Status( unsigned char );
extern unsigned char Set_Trig_Level( unsigned char * );
extern unsigned char Set_Trig_Logic( unsigned char * );

/* Event Routine */
extern unsigned char Set_Event(unsigned int, unsigned char *);
extern unsigned char Clr_Event(unsigned int, unsigned int);
extern unsigned char Ini_Timer(unsigned char); /* 0 OFF 1 ON */


/* Memory operation Routine */
extern unsigned char Fill_Mem( unsigned char *MdfyMemPtr );
extern unsigned char Read_Mem( unsigned char *, unsigned char * );
extern unsigned char Tst_Mem( unsigned char *);
extern unsigned int CheckSum( unsigned char *); // checksum value saved in
                                                // TransmitBuf+1 directly
extern unsigned char Modify_Reg( unsigned char *);
extern unsigned char Set_Map( unsigned char *);
extern unsigned char Get_Map( unsigned char *,unsigned char *);
extern unsigned char Set_ExBp( unsigned char * );
extern unsigned char Clr_ExBp( unsigned char * );
extern unsigned char Query_ExeBp( unsigned char *,unsigned char *,unsigned char *);
//                                  start addr     End addr        result addr
extern unsigned char Inst_Step(void);
extern unsigned char Call_Step(void);
extern unsigned char Cycle_Step( void );

extern unsigned char Get_A_Reg( unsigned short,void *);
extern unsigned char Cmp_Mem( unsigned char *,unsigned char *);
                           // input.          // output: PADRSTRUCT.
extern unsigned char Srch_Mem( unsigned char *,unsigned char *);
                           // input.         // output: PADRSTRUCT.
extern unsigned char Read_Trace( unsigned int,unsigned int,unsigned char *,unsigned char *);
                           //    RdDirect    ,StartFrame    ,PQUALIFY      ,*PBUF
extern unsigned char GetTraceBuf( unsigned int,  unsigned int,  unsigned int,  unsigned char *, unsigned char *);
                           // RdDirect,   StartFrame,    EndFrame,      *PQUALIFY,       TraceSaveBuf
extern unsigned char CheckTraceRun(unsigned char *); // 0. Trace is not RUNNING.
                          // 11. Trace is RUNNING.  char * to qualify.
extern unsigned char Transparent_Cmd( unsigned char,unsigned char);
                                    // ID          , VALUE
                                    // 0:EA,1:RESET, 0:OFF,1:ON
extern unsigned char Get_Control( unsigned char ); // Control ID
extern unsigned int EpTest(unsigned char);
extern void set_cpu_model(void);
extern unsigned char Select_Port( unsigned int );

extern unsigned char EpSupport( unsigned char * );


/***************************************************************************
** Functions for Flash prom.
****************************************************************************/
extern unsigned char Flash_Here(void);
extern unsigned char Flash_EC(void);
extern unsigned char FlashPrgRec( unsigned char * );

/****************************************************************************
**
**  ReceiveStream
**
**  Description: Receive data from communication and check the length and
**               checksum, the data format is :       XXXXxxx....xxxX
**                                                  length   data   checksum
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
void ReceiveStream(void)
{
register unsigned int lp;
unsigned char aa[4];
unsigned int  RStreamLen;
// aa[0] store LEAD_CODE
// aa[1] store Data Length High
// aa[2] store Data Length Low
// aa[3] store chksum
// aa[0] + aa[1] + aa[2] + aa[3] == 0

   RStreamLen = 0;
   chksum = 0;

   while(1) {
      // receive leading code and data length and checksum.

      aa[0] = 0;
      aa[1] = 0;
      aa[2] = 0;
      aa[3] = 0;
      lp = 0;
      TimerOut = 0;
      ChkTimerOut = 0;
      TimCount = 0;

      while( lp < 4 )
      {
         aa[lp] = ReceiveByte();
         TimCount = 0;
         lp ++;
         if( aa[0] != LEAD_CODE ) lp = 0;
// June/10/1996
//       else ChkTimerOut = 1;
//         if (TimerOut) break;
      }

// June/10/1996
//      if (TimerOut) continue;   // To restart ReceiveStream

      for (lp = 1; lp < 4; lp++) chksum += aa[lp];
      if ((aa[0] == LEAD_CODE) && (chksum == 0)) // command length.
      {
         RStreamLen =(unsigned int)aa[2] * 256 + aa[1];
         TransmitByte(REC_OK);
      }
      else
      {
         TransmitByte(REC_FAIL);
         continue;                          // To restart ReceiveString.
      }


      chksum = 0;

      for (lp = 0; lp < RStreamLen; lp++) {
// June/10/1996
//       TimCount = 0;

         receiveBuf[lp] = ReceiveByte();
// June/10/1996
//       if ( TimerOut ) break;

         chksum += receiveBuf[lp];
      }
// June/10/1996
//    if ( TimerOut) continue;

      if (chksum == 0) {    // The End of ReceiveBuf char is Data checksum
         memcpy(commandStream,&receiveBuf[0],RStreamLen);
         commandStreamLen = RStreamLen;
         TransmitByte(ACK);
// June/10/1996
//       ChkTimerOut = 0;
         return;
      }
      else TransmitByte(NACK);
   }
}



/****************************************************************************
**
**  ReceiveByte
**
**  Description: Receive one byte from communication.
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/

/****************************************************************************
**
**  TransmitByte
**
**  Description: Transmit one byte from communication.
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/




/****************************************************************************
**
**  TransmitStream
**
**  Description: Transmit data(length + data + checksum) to
**               communication port.
**               the data format is :  XXXXxxx....xxxX
**                                   length   data   checksum
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
/*
   Transmit data(length + data + checksum) to communication port.
   the data format is : LENGTH(2 bytes)DATA(number of length)CHECKSUM(1 byte)
*/
void TransmitStream(void) {

register unsigned int lp;
unsigned char highLen,lowLen,aa;

   chksum = 0;
   for (lp = 0; lp < TStreamLen; lp++)
      chksum += TransmitBuf[lp];
   TransmitBuf[TStreamLen] = ( unsigned char )(~chksum+1);
   TStreamLen++;

   highLen = (unsigned char)(TStreamLen/256);
   lowLen =  (unsigned char) TStreamLen;
   chksum = (unsigned char) (~(lowLen+highLen) ) + 1;

   while (1) {
      TransmitByte(LEAD_CODE);
      TransmitByte(lowLen);
      TransmitByte(highLen);
      TransmitByte(chksum);
      aa = ReceiveByte();
//    if ( aa != REC_OK ) return;
      if ( aa != REC_OK ) continue;
      for (lp = 0; lp < TStreamLen; lp++)
         TransmitByte(TransmitBuf[lp]);

      aa = ReceiveByte();
      if (aa == ACK) {

         return ;
      }
      else {                   //(aa == NACK)
         continue;
      }
   }

}


/***************************************************************************
**
**  ProcessCommand
**
**  Description: Idnetidy then command ID and call FW function.
**
**  Parameters:
**     input:
**        commandStream : Global varible commandStream.
**        commandStreamLen : Global varible length of commandStream.
**     output:
**        1. errNo(char) : The command execute result. Function return value.
**        2. outputStream :
**
****************************************************************************/
void ProcessCommand(void) {
unsigned int NumBer;
unsigned char retvalue;
unsigned int  retvalue16;
unsigned short arg16;
unsigned int Int1,Int2,Int0;
unsigned int Int4,Int5,Int3;


   TStreamLen = 1;
   Coverage_Flg = 0;

   switch ( commandStream[0] )
   {
      case FW_SUPPORT_GET :
// TB[0] : STATUS
// TB[1],TB[2] : FW support CPU number.
// TB[3],TB[4] : FW support CPU ID.
// TB[..],TB[..] : FW support CPU ID.

         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = ( unsigned char) (Fw_Support_Numb);
         TransmitBuf[2] = 0;
         memcpy ( (&TransmitBuf[3]),(&Fw_Support_Numb)+1,TransmitBuf[1] );

         TStreamLen = 3 + TransmitBuf[1] ;
         TransmitBuf[1] = TransmitBuf[1]/2;

         break;

      case EP_SUPPORT_GET :
         TransmitBuf[0] = CommandExeOk;
         retvalue = EpSupport( &TransmitBuf[3] );
         TransmitBuf[1] = retvalue;
         TransmitBuf[2] = 0;
         TStreamLen = 1 + 2 + retvalue*2;


         break;

      case HAND_SHAKE :
         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = 'E';
         TransmitBuf[2] = 'A';
         TransmitBuf[3] = 'S';
         TransmitBuf[4] = 'Y';
         TransmitBuf[5] = 'P';
         TransmitBuf[6] = 'A';
         TransmitBuf[7] = 'C';
         TransmitBuf[8] = 'K';
         TStreamLen = 9;
         break;

      case MHZ_GET:
         TransmitBuf[0] = CommandExeOk;
         for(retvalue=0;retvalue<10;retvalue++)
         TransmitBuf[1+retvalue] = clockMsg[retvalue];
         TStreamLen = 11;
         break;

      case FWID_GET:
         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = FW_VER_MAJOR;
         TransmitBuf[2] = FW_VER_MINOR;
         TStreamLen = 3;
         break;

      case ECB_ID_GET:
         retvalue = 0;                 // It's old ECB
         if(bStatus1A == 0x01)
         {
            retvalue = 1;              // It's ECB2
         }
         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = retvalue;
         TStreamLen = 2;
         break;


      case FLASH_SWITCH :
         retvalue = Flash_Here();
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
         break;

      case FLASH_ERASE :
         retvalue = Flash_EC();
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
         break;

      case FLASH_PROG :
//           record length            record type 0 data
         if( commandStream[1] != 0 )
         {
         retvalue = FlashPrgRec( & commandStream[1] );
         }
         else
         retvalue = FlashRECErr;
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
         break;

      case CPU_SELECT :
 epMode = (unsigned int)commandStream[1] + (unsigned int)(commandStream[2]*256);
         set_cpu_model();

      case CPU_GET :
         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = (unsigned char) ( epModeTMP & 0xff );
         TransmitBuf[2] = (unsigned char) ( epModeTMP / 256 );
         TStreamLen = 3;
         break;

      case DIAGNOSTIC :
         if(commandStream[1] > 7 || commandStream[1] < 1 )
         {
            TransmitBuf[0] = CmdInvalid;
         }
         else
         {
            retvalue = EpTest(commandStream[1]);
            TransmitBuf[0] = CommandExeOk;      //Special for trace:
            TransmitBuf[1] = retvalue;          //bit 0~6 is Trace Cnt l,h,
            TStreamLen = 2;                     //addr h,l,data,port,st&sp.
            if (EpTest_bit ==1)
            {
               TransmitBuf[1] = TransmitBuf[1] + 0x80; //err address flag,bit 7
               TransmitBuf[2] = commandStream[1];  //error address low
               TransmitBuf[3] = commandStream[2];  //error address high
               TStreamLen = 4;
            }
         }
         break;

      case DIAG_TEST :
//    case 0x70 :
         retvalue = Diag_Tst();
         TransmitBuf[0] = retvalue;
         if (EpTest_bit == 1)
         {
            TransmitBuf[1] = 1;
            TStreamLen = 2 ;
         }
         break;

      case EP_START :
         if(commandStream[1] == 1)
         {
            epRunFlag = 1;
            CycleStep();
            epRunFlag = 0;
         }
         retvalue = start_EP( &commandStream[1] );
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
         break;

      case EP_RESET :
            if(commandStream[1] == 0x10)
            {
               sysini();
               commandStream[1] = 0;
            }
         retvalue = Init_Ep( &commandStream[1] );
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
         break;

      case EP_HALT :
         retvalue = stop_EP();
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;

         break;

      case TIMER_GET:      // 0x27 +Koo 1/30/96
         if (ReadElTimer_Flg) {
            TransmitBuf[0] = 0;
            TransmitBuf[1] = 1;
            TransmitBuf[2] = timerLow_3;
            TransmitBuf[3] = timerLow_2;
            TransmitBuf[4] = timerLow_1;
            TransmitBuf[5] = timerLow;
            TransmitBuf[6] = timerHigh;
//          ClrElTimerMsg();
            TStreamLen = 7;
         }
         else  {
            TransmitBuf[0] = 0;
            TransmitBuf[1] = 0;
            TStreamLen = 2;
         }
         break;

      case STATUS_GET :
         for( arg16 = 0; arg16 < 0x2000; arg16++ );
            TransmitBuf[0] = CommandExeOk;
            TransmitBuf[1] = ( unsigned char ) (STATUS & 0xff);
            TransmitBuf[2] = ( unsigned char ) (STATUS / 256 );
            if ( initTrigger & 0x2 ) TransmitBuf[1] = TransmitBuf[1] | 0x4;
            else TransmitBuf[1] = TransmitBuf[1] & 0xfb;
            if ( initTrigger & 0x1 ) TransmitBuf[2] = TransmitBuf[2] | 0x1;
            else TransmitBuf[2] = TransmitBuf[2] & 0xfe;
            TStreamLen = 3;
         break;

      case CONTROL_SET :
            if( STATUS & 0x40 ) retvalue = EpRunning;
            else
         retvalue = Transparent_Cmd( commandStream[1], commandStream[2] );
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
         break;

      case CONTROL_GET :
            retvalue = Get_Control( commandStream[1] );
            TransmitBuf[0] = CommandExeOk;
            TransmitBuf[1] = retvalue;
            TStreamLen = 2;
         break;


      case LASTFRAME_GET :
         if( getTraceCnt == 1)
         {
            TransmitBuf[0] = CommandExeOk;
            TransmitBuf[1] = (unsigned char)( traceCnt & 0xff );
            TransmitBuf[2] = (unsigned char)( traceCnt /256 );
         }
         else
         {
            retvalue = (bCtrl0 & 0x10);
            if( retvalue != CommandExeOk )
            {
               go_trace();
            }
            if(getTraceCnt == 0)
            {
               bCtrl0 = bCtrl0 | ENTRACE ; // disable trace writing
               LDCTRL0 = bCtrl0 ;
               getTraceCnt = 0;
               TransmitBuf[0] = CommandExeOk;
               TransmitBuf[1] = 0;
               TransmitBuf[2] = 0;
            }
            else
            {
               TransmitBuf[0] = CommandExeOk;
               TransmitBuf[1] = (unsigned char)( traceCnt & 0xff );
               TransmitBuf[2] = (unsigned char)( traceCnt /256 );
            }
         }
         TStreamLen = 3;
         break;

      case EVENT_SET :
         retvalue16 = (unsigned int)(commandStream[1]) + (unsigned int)(commandStream[2])*256;
         retvalue = Set_Event( retvalue16, &commandStream[3] );
            TransmitBuf[0] = retvalue;
            if( retvalue == CommandExeOk )
            {
               if(commandStream[3]==0)
               {
                  memcpy(QlfBuffer,&commandStream[1],0x80);
                  EvQfStatus = EvQfStatus | 0x1;
               };
               if(commandStream[3]==1)
               {
                  memcpy(Ev1Buffer,&commandStream[1],0x80);
                  EvQfStatus = EvQfStatus | 0x2;
               };
               if(commandStream[3]==2)
               {
                  memcpy(Ev2Buffer,&commandStream[1],0x80);
                  EvQfStatus = EvQfStatus | 0x4;
               };

            }

            TStreamLen = 1;

         break;
      case EVENT_CLR :

         retvalue = Clr_Event( (unsigned int)(commandStream[1]+commandStream[2]*256),
                               (unsigned int)(commandStream[3]+commandStream[4]*256) );
            TransmitBuf[0] = retvalue;
            if ( retvalue == 0 && ( commandStream[3] >= commandStream[1] ) )
            {
               switch( commandStream[1] ) {
                  case 0 : EvQfStatus = EvQfStatus & 0xfe;
                           if( commandStream[3] == 1 )
                           EvQfStatus = EvQfStatus & 0xfd;
                           if( commandStream[3] == 2 || commandStream[3] == 3)
                           EvQfStatus = EvQfStatus & 0xfd &0xfb;
                           break;
                  case 1 : EvQfStatus = EvQfStatus & 0xfd;
                           if( commandStream[3] == 2 || commandStream[3] == 3)
                           EvQfStatus = EvQfStatus & 0xfb;
                           break;
                  case 2 : EvQfStatus = EvQfStatus & 0xfb;
                           break;
                  default:
                           break;
               }


            }


            TStreamLen = 1;
         break;
      case EVENT_GET :
         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = EvQfStatus;  // bit0: Qualify. bit1: Ev1. bit2: Ev2.
         TransmitBuf[2] = Ev3Buf;
         memcpy(&TransmitBuf[0x3],QlfBuffer,0x80);     // qualify
         memcpy(&TransmitBuf[0x3+0x80],Ev1Buffer,0x80);  // event1
         memcpy(&TransmitBuf[0x3+0x80+0x80],Ev2Buffer,0x80); // event2

         TStreamLen =  3 + 0x80 + 0x80 + 0x80 ;

         break;
      case PORT_SET :      // ABI --> FW port is 2 bytes. here skip high byte
         retvalue16 = commandStream[1] + (unsigned int) commandStream[2] * 256;
         retvalue = Select_Port( retvalue16 );
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
   // retcode : CommandExeOk,TargetCanotStep,ParaError

         break;

      case PORT_OUT :
         retvalue = Output( &commandStream[1] );
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;

         break;

      case PORT_IN :
         retvalue = Input( &commandStream[1], &TransmitBuf[1] );
            TransmitBuf[0] = retvalue;
            TransmitBuf[2] = 0;
            TStreamLen = 3;

         break;
      case VERIFY_SET :
// 0 OFF,   1 ON
         retvalue = Set_Verify( commandStream[1] );
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
         break;
      case TRIG_STATUS_SET :
// 0 disable 1 enable
         retvalue = Set_Trig_Status( commandStream[1] );
            TransmitBuf[0] = retvalue;
            TStreamLen =1 ;
         break;
      case TRIG_LEVEL_SET :
         retvalue = Set_Trig_Level( &commandStream[1] );
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
         break;
      case TRIG_LOGIC_SET :
         retvalue = Set_Trig_Logic( &commandStream[1] );
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
         break;
      case TRACE_INI :
         Trace_Init();
         break;

      case TIMER_INI :
         retvalue = Ini_Timer( commandStream[1] );
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
         break;


      case TRACE_C_READ :
         retvalue = (bCtrl0 & 0x10);
         if( retvalue == CommandExeOk )
         {
            Code_Access_Range_SAd[0] = commandStream[4] + commandStream[5] * 256;
            Code_Access_Range_DAd[0] = commandStream[6] + commandStream[7] * 256;
            Code_Access_Range_SAd[1] = commandStream[8] + commandStream[9] * 256;
            Code_Access_Range_DAd[1] = commandStream[10] + commandStream[11] * 256;
            Code_Access_Range_SAd[2] = commandStream[12] + commandStream[13] * 256;
            Code_Access_Range_DAd[2] = commandStream[14] + commandStream[15] * 256;
            Code_Access_Range_SAd[3]= commandStream[16] + commandStream[17] * 256;
            Code_Access_Range_DAd[3] = commandStream[18] + commandStream[19] * 256;
            Code_Access_Range_SAd[4] = commandStream[20] + commandStream[21] * 256;
            Code_Access_Range_DAd[4] = commandStream[22] + commandStream[23] * 256;
            TransmitBuf[0] = GetCTraceBuf( commandStream[3], commandStream[24]);
            TransmitBuf[1] = temp2;
            for (temp1=0;temp1<temp2;temp1++)
            {
               TransmitBuf[temp1 * 4 + 2] = Frame_No[temp1] & 0x00ff;
               TransmitBuf[temp1 * 4 + 3] = Frame_No[temp1] / 256;
               TransmitBuf[temp1 * 4 + 4] = Frame_adr[temp1] & 0x00ff;
               TransmitBuf[temp1 * 4 + 5] = Frame_adr[temp1] / 256;
            }
            TStreamLen = 1 + 1 + (temp1 * 4);
         }
         else TransmitBuf[0] = retvalue;
         break;


      case TRACE_READ :
         if( getTraceCnt == 0 )
         {
            go_trace();
         }
         if(getTraceCnt == 0)
         {
            bCtrl0 = bCtrl0 | ENTRACE ; // disable trace writing
            LDCTRL0 = bCtrl0 ;
            getTraceCnt = 0;
            TransmitBuf[0] = TraceRunning;
         }
         else
         {
            retvalue = CheckTraceRun( &commandStream[9]); //July.18 Pointer to QlfyType
            if( retvalue == CommandExeOk)
            {
               Int0 = commandStream[1] + (unsigned int)( commandStream[2] * 256 );
               Int1 = commandStream[3] + (unsigned int)( commandStream[4] * 256 );
               Int2 = commandStream[5] + (unsigned int)( commandStream[6] * 256 );

TransmitBuf[0] = GetTraceBuf( Int0,Int1,Int2,&commandStream[7+2],&TransmitBuf[3] );
               TStreamLen = 1 + 1 + 1 + (unsigned int) (TransmitBuf[1] * 7);
            }
            else TransmitBuf[0] = retvalue;
         }
         break;

      case MEM_CHECKSUM :
         retvalue = CheckSum( &commandStream[1] );

            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
            if ( retvalue == CommandExeOk )
            TStreamLen = 3;


         break;
      case MEM_COMPARE :
            Int1 = commandStream[2] + commandStream[3]*256;   // startadr
            Int2 = commandStream[5] + commandStream[6]*256;   // endadr
// July.10.1995  ERIC + 1
            Int1 = Int2-Int1+1;
            commandStream[6] = (unsigned char) (Int1 / 256);
            commandStream[5] = (unsigned char) (Int1 & 0x00ff);

            retvalue = Cmp_Mem( &commandStream[1],&TransmitBuf[1] );
            TransmitBuf[0] = retvalue;
            TStreamLen = 1 + 3;

         break;
      case MEM_COPY :
            retvalue = Copy_Mem( &commandStream[1] );
            TransmitBuf[0] = retvalue;
            TStreamLen = 1 + 3;
         break;

      case MEM_DOWNLOAD:
         break;

      case MEM_FILL :
// commandStream contents :
//    0 : CommandID
//    1 : start address MemoryType
//  2,3 : start address (lo,hi)
//    4 : end address MemoryType
//  5,6 : end address (lo,hi)
//    7 : fill data length 2
//  8,9 : fill contents
         retvalue = Fill_Mem( &commandStream[1] );

         switch( retvalue ) {
            case TargetCanotStep :
               TransmitBuf[0] = TargetCanotStep;
               break;
// TranmitBuf contents :
//   0 : execute result
//   1 : fill failure address type (lo,hi)
// 2,3 : fill failure address (lo,hi)
            case MemWrFail :
               TransmitBuf[0] = MemWrFail;
               TransmitBuf[1] = 0;        // Fill memory type skip in fw
               TransmitBuf[2] = bAddrL;
               TransmitBuf[3] = bAddrH;  // Fill memory failure address
               TStreamLen = 4;
               break;
            case CommandExeOk :
               TransmitBuf[0] = CommandExeOk;
               break;
            default :
               TransmitBuf[0] = CommandExeOk;
               break;
               }

            break;
      case MEM_READ :
            retvalue = Read_Mem ( &commandStream[1] , &TransmitBuf[3] ) ;

               TransmitBuf[0] = retvalue;

            if (TransmitBuf[0] == CommandExeOk)
            {
            NumBer =(unsigned int)commandStream[5] + (unsigned int)commandStream[6] *256
                   -(unsigned int) commandStream[2] - (unsigned int)commandStream[3] *256
                   + 1;
            TStreamLen = NumBer + 3 ;
            TransmitBuf[1] =(unsigned char)( NumBer & 0x00ff) ;
            TransmitBuf[2] =(unsigned char)( NumBer /256 );
            }
            else
            TStreamLen = 1;

         break;
      case MEM_SEARCH :
            commandStream[5] = commandStream[5] + 1;
            if( commandStream[5] == 0 ) commandStream[6] = commandStream[6] + 1;

            retvalue = Srch_Mem( &commandStream[1],&TransmitBuf[1] );
            TransmitBuf[0] = retvalue;
            TStreamLen = 4;

         break;
      case MEM_TEST :
           retvalue = Tst_Mem( &commandStream[1] );
           TransmitBuf[0] = retvalue;
           if( retvalue == MemWrFail )
            TStreamLen = 4;
            else
            TStreamLen = 1;

         break;
      case MEM_UPLOAD :
         break;

      case REG_GETLEN :
         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = 80;
         TransmitBuf[2] = 0;
         TStreamLen = 80 + 2;
         break;

      case REG_GETALL :
         memcpy ( &TransmitBuf[1], &regbuf,80 );
         TransmitBuf[0] = CommandExeOk;
         TStreamLen = 81;

         break;

      case REG_GETONE :
         if( STATUS & 0x40 ) {
            retvalue = EpRunning;
            TransmitBuf[0] = retvalue ;
            TStreamLen = 1 ;
         }
         else
         {
         arg16 =(unsigned short) commandStream[1] ;
         retvalue = Get_A_Reg( arg16, &TransmitBuf[1] );
         TransmitBuf[0] = retvalue ;
         TStreamLen = 1 + 2 ;
         }
         break;

      case REG_MODIFY :
         retvalue = Modify_Reg( &commandStream[1] );

               TransmitBuf[0] = retvalue;
               TStreamLen = 1;

         break;
      case  MAP_GET :
         retvalue = Get_Map( &commandStream[1],&TransmitBuf[1] );
         TransmitBuf[0] = retvalue;
         if( retvalue )
         TStreamLen = 1;
         else TStreamLen = 1 + 7; //sizeof(cmdID) + sizeof(MAP_INFO)

         break;

      case  MAP_SET :
         retvalue = Set_Map( &commandStream[1] );
         TransmitBuf[0] = retvalue;
         TStreamLen = 1;
         break;

      case BP_SET :
         retvalue = Set_ExBp( &commandStream[1] );
         TransmitBuf[0] = retvalue;
         TStreamLen = 1;
         break;
      case BP_CLR :
         retvalue = Clr_ExBp( &commandStream[1] );
         TransmitBuf[0] = retvalue;
         TStreamLen = 1;
         break;
      case BP_QUERY :
         retvalue = Query_ExeBp( &commandStream[1],&commandStream[4],&TransmitBuf[1] );
         TransmitBuf[0] = retvalue;
         switch (retvalue) {
            case TargetCanotStep :
            case BpNotFound :
                  TStreamLen = 1;
                  break;
            case BpFound :
                  TStreamLen = 4;
                  break;
            default :
                  break;
                        };
         break;

      case STEP_ONE :
            retvalue = Inst_Step();
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
            break;
      case STEP_OVER :
            retvalue = Call_Step();
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
// Eric Nov.21.1995 +
            retvalue16 = 0;
            while( (STATUS & 0x40) && retvalue16 < 0xffff ) retvalue16 ++;


            break;
      case STEP_CYCLE:
            bCtrl0 = bCtrl0 & ~TRACE_EN ;
            LDCTRL0 = bCtrl0 ;
            retvalue = Cycle_Step();
            TransmitBuf[0] = retvalue;
            TStreamLen = 1 + 1 + 40*4;
            break;
      case STEP_RANGE :
            retvalue = CommandExeOk;
            retvalue16 = 0;
            Int3  = 0; //+ koo
            Int0 = commandStream[2] + commandStream[3] * 256; // Start addr
            Int1 = commandStream[5] + commandStream[6] * 256; // End addr
            Get_A_Reg( 0, &Int4 ); // Int4 store current PC
            Int4  = (Int4 / 256) + (Int4 & 0xff) * 256;
            Int2 =  Int4;
// Nov.16.1995 ERIC modify
            while ( !(Int2 > Int1) && !(Int2 < Int0)
//                && (retvalue==CommandExeOk) && ( retvalue16 < 64 ) )
                                              && ( retvalue16 < 0xffff ) )
            {
               retvalue16 = 0;
               Int5  = Inst_Step();

            while( (STATUS & 0x40) && retvalue16 != 0x1ff ) retvalue16 ++;

//               if ( retvalue != CommandExeOk ) retvalue16 ++;
//               else retvalue16 = 0;

            Get_A_Reg( 0, &Int4 );
            Int4  = (Int4 / 256) + (Int4 & 0xff) * 256;
            Int2 =  Int4 ;
            Int3 ++;
            if (Int3 > 30)
               {
//                  retvalue = RangeStepHalt;
                  Int2 = Int1 + 1;
               };
            };

            if ( !(Int4 > Int1) && !(Int4 < Int0) )
            {
               retvalue = RangeStepHalt;
            }
            else
            {
               retvalue = Int5;
            }

            TransmitBuf[0] = retvalue;

            TStreamLen = 1;



            break;

      case STEPOVER_RANGE :
            retvalue = CommandExeOk;
            retvalue16 = 0;
            Int3  = 0; //+ koo
            Int0 = commandStream[2] + commandStream[3] * 256; // Start addr
            Int1 = commandStream[5] + commandStream[6] * 256; // End addr
            Get_A_Reg( 0, &Int4 ); // Int4 store current PC
            Int4  = (Int4 / 256) + (Int4 & 0xff) * 256;
            Int2 =  Int4;
            while ( !(Int2 > Int1) && !(Int2 < Int0)
// Eric -         && (retvalue==CommandExeOk) && (retvalue16 < 64 ) )
                                            && (retvalue16 < 0xffff ) )
            {
               retvalue16 = 0;
               Int5  = Call_Step();
//             if ( retvalue != CommandExeOk ) retvalue16 ++;
//             else retvalue16 = 0;

            while( (STATUS & 0x40) && retvalue16 < 0xffff ) retvalue16 ++;

            Get_A_Reg( 0, &Int4 );
            Int4  = (Int4 / 256) + (Int4 & 0xff) * 256;
            Int2 =  Int4 ;
            Int3 ++;
            if (Int3 > 20)
               {
                  Int2 = Int1 + 1;
               };
            };

            if ( !(Int4 > Int1) && !(Int4 < Int0) )
            {
               retvalue = RangeStepHalt;
            }
            else
            {
               retvalue = Int5;
            }

            TransmitBuf[0] = retvalue;
            TStreamLen = 1;


            break;

      case TRIG_GET:
            TransmitBuf[0] = CommandExeOk;
            TransmitBuf[1] = trigStatus; // default is 1 (on)

            // TRIGGER LEVEL1
            TransmitBuf[2] = tLevel1[0]; // Level set flag. 0:not set. 1.set
            TransmitBuf[3] = 1; // levelID PACKWORD
            TransmitBuf[4] = 0;          //
            TransmitBuf[5] = (~tLevel1[1]) & 0x3; // TraceFlag
            TransmitBuf[6] = (~(tLevel1[1] >> 2)) & 0x3; // Timer flag
            TransmitBuf[7] = tLevel1[2];  // PACKDWORD Condition. EV
            TransmitBuf[8] = tLevel1[2];
            TransmitBuf[9] = tLevel1[2];
            TransmitBuf[10] = tLevel1[2];

            // TRIGGER LEVEL2
            TransmitBuf[11] = tLevel2[0]; // Level set flag. 0:not set. 1:set
            TransmitBuf[12] = 2; // levelID PACKWORD
            TransmitBuf[13] = 0;          //
            TransmitBuf[14] = (~tLevel2[1]) & 0x3; // TraceFlag
            TransmitBuf[15] = (~(tLevel2[1] >> 2)) & 0x3; // Timer flag
            TransmitBuf[16] = tLevel2[2];  // PACKDWORD Condition. EV
            TransmitBuf[17] = tLevel2[2];
            TransmitBuf[18] = tLevel2[2];
            TransmitBuf[19] = tLevel2[2];

           // TRIGGER LOGIC
            TransmitBuf[20] = trigWay; // TrigFlg 0 delay 1 forward 2 backward 3 centre
            TransmitBuf[21] = tLogic[1]; // run flag
            TransmitBuf[22] = (unsigned char)(traceDlyCnt & 0xff);
            TransmitBuf[23] = (unsigned char)( ( traceDlyCnt >> 8 ) & 0xff );
            TransmitBuf[24] = 0;
            TransmitBuf[25] = 0;
            TransmitBuf[26] = levCount;   // PACKWORD
            TransmitBuf[27] = 0;
            TransmitBuf[28] = tLogic[2];  // PACKWORD LevelID[0]
            TransmitBuf[29] = 0;
            TransmitBuf[30] = tLogic[3];  // PACKWORD LevelID[1]
            TransmitBuf[31] = 0;
            TransmitBuf[32] = 0;          // PACKWORD LevelID[2]
            TransmitBuf[33] = 0;
            TransmitBuf[34] = 0;          // PACKWORD LevelID[3]
            TransmitBuf[35] = 0;

            TStreamLen = 36;

         break;

      case SPA_BP_SET:
         Clr_Ev_ExBp_all();
         for (temp1 = 1; temp1 <= commandStream[9]; temp1 ++) {
            SetExBp(&commandStream[8 + temp1 * 2]);
         }
         retvalue = start_EP( &commandStream[1] );
         TransmitBuf[0] = retvalue;
         TStreamLen = 1;
         break;

      case COVERAGE_GO:
         Cover_Go();
         break;

      case COVERAGE_GET:
         Cover_Get();
         break;

      default :
            TransmitBuf[0] = CmdInvalid ;
            TStreamLen = 1;
            break;

//       break;
   }
}

