
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/FW/VER22/LOG/XFWSUB.C__   1.1   24 Sep 1996 13:51:28   ZJRD  $
**
**    $Log:   D:/EPSLDV1/FW/VER22/LOG/XFWSUB.C__  $
** 
**    Rev 1.1   24 Sep 1996 13:51:28   ZJRD
** EasyPack/SLD FW Version 22.21
** 
**    Rev 1.0   08 Jul 1996 10:33:00   ZJRD
** Initial revision.
** 
****************************************************************************/
/****************************************************************************
**
**  Name:         xfwsub.c
**
**  Description:
**
**  Status:
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <reg51.h>

extern bit User1Flag;
extern bit Coverage_Flg;
extern bit epRunFlag;
extern bit getTraceCnt;

extern unsigned char commandStream[512];
extern unsigned char start_EP( unsigned char *);
extern unsigned char Fill_Mem( unsigned char *MdfyMemPtr );
extern unsigned char Read_Mem( unsigned char *, unsigned char * );
extern unsigned char Clr_Ev_ExBp_all(void);
extern unsigned char TransmitBuf[2048];
extern xdata unsigned int traceCnt;
extern unsigned int Read_Trace_Ini(void);
extern unsigned char LdTraceCnt(unsigned int);
extern unsigned int TStreamLen;
extern unsigned int traceStart;
extern unsigned char Code_Access_No;
extern unsigned int Coverage_Range_SAd1;
extern unsigned int Coverage_Range_DAd1;
extern unsigned int Coverage_Range_SAd2;
extern unsigned int Coverage_Range_DAd2;
extern unsigned int Coverage_Range_SAd3;
extern unsigned int Coverage_Range_DAd3;
extern unsigned int Coverage_Range_SAd4;
extern unsigned int Coverage_Range_DAd4;
extern unsigned int Code_Access_Range_SAd[33];
extern unsigned int Code_Access_Range_DAd[33];
extern unsigned int Frame_No[60];
extern unsigned int Frame_adr[60];
extern unsigned int Read_Trace_Content(void);
extern unsigned char temp2;
extern unsigned char GetFrame( unsigned int,unsigned char *);
                           // frame number, frame buffer
                           // return : 0 getframe ok. 1 out of frame
extern unsigned char ChkTrace( unsigned char * ); // pointer to trace data.
extern unsigned char SaveTraceEnd( void );
extern xdata unsigned char bCtrl0;
extern xdata unsigned char bLdst;
extern data unsigned char bRamen;
extern data unsigned char bBufen;
extern xdata unsigned char LDBUFEN    ;
extern xdata unsigned char LDRAMEN    ;
extern xdata unsigned char LDCTRL0    ;
extern xdata unsigned char LDST       ;
extern unsigned char ReadElTimer(void); // ConvElTimer()
extern unsigned char UpdateTraceCnt(void);
extern unsigned char Ini_Trace(unsigned char); /* 0 OFF 1 ON */
extern unsigned char Coverage_Range_No;

data unsigned int Code_Access_Tmp;
unsigned char Copy_Mem ( unsigned char * );
unsigned char GetTraceBuf( unsigned int,  unsigned int,  unsigned int,  unsigned char *, unsigned char *);
                           // RdDirect,   StartFrame,    EndFrame,      *PQUALIFY,       TraceSaveBuf
unsigned char GetCTraceBuf( unsigned char,  unsigned char );
unsigned char Analyse_Coverage(void);
unsigned char Cover_Go(void);
unsigned char Cover_Get(void);
unsigned char go_trace(void);
unsigned char Trace_Init(void);
unsigned char FwDumpCmd[6];
unsigned char CopyTmpBuf[270];

#define  CommandExeOk       0x00
#define  TraceRunning       0x11
#define  CmdInvalid         0x13
#define TRACE_EN        0x80
#define ENTRACE         0x10
#define NENTDBUF        0x08   /* trace data buffer enable */
#define NENTABUF        0x10   /* trace address buffers enable */

unsigned char Copy_Mem( unsigned char *PCmd )
{
   unsigned char retvalueCopy;
   unsigned char SourAdr1_hi,SourAdr1_lo;
   unsigned char DestAdr1_hi,DestAdr1_lo;
   unsigned long int  copyLength;
   register  unsigned int  copyCycle;
   register  unsigned int jk;


   FwDumpCmd[0] = PCmd[0];
   FwDumpCmd[3] = PCmd[0];
   CopyTmpBuf[0] = PCmd[6];
   CopyTmpBuf[3] = PCmd[6];
   CopyTmpBuf[6] = 0xff;

   SourAdr1_lo = PCmd[1] ;
   SourAdr1_hi = PCmd[2] ;
   DestAdr1_lo = PCmd[7] ;
   DestAdr1_hi = PCmd[8] ;

   copyLength = PCmd[4] + (unsigned long int)PCmd[5]*256
               - PCmd[1] - (unsigned long int) PCmd[2]*256 + 1;
   copyCycle = copyLength / 255;


   for( jk = 0; jk < copyCycle; jk ++ )
   {
      FwDumpCmd[1] = SourAdr1_lo;
      FwDumpCmd[2] = SourAdr1_hi;
      if(FwDumpCmd[1] > 1)
         SourAdr1_hi  ++ ;
      FwDumpCmd[4] = SourAdr1_lo + 254;
      FwDumpCmd[5] = SourAdr1_hi;

      SourAdr1_lo = FwDumpCmd[4] + 1;
      if(SourAdr1_lo == 0) SourAdr1_hi ++ ;

      retvalueCopy = Read_Mem ( FwDumpCmd, &CopyTmpBuf[7] );
      if( retvalueCopy != 0 ) return retvalueCopy;

      CopyTmpBuf[1] = DestAdr1_lo;
      CopyTmpBuf[2] = DestAdr1_hi;
      if(CopyTmpBuf[1] > 1)
         DestAdr1_hi ++ ;
      CopyTmpBuf[4] = DestAdr1_lo + 254;
      CopyTmpBuf[5] = DestAdr1_hi;

      DestAdr1_lo = CopyTmpBuf[4] + 1;
      if(DestAdr1_lo == 0)   DestAdr1_hi ++ ;
// OCT.26.1995 ERIC for copy.
      commandStream[1] = CopyTmpBuf[0];
      commandStream[2] = CopyTmpBuf[1];
      commandStream[3] = CopyTmpBuf[2];
      commandStream[4] = CopyTmpBuf[3];
      commandStream[5] = CopyTmpBuf[4];
      commandStream[6] = CopyTmpBuf[5];
      commandStream[7] = CopyTmpBuf[6];
      for ( retvalueCopy = 0; retvalueCopy < commandStream[7];retvalueCopy ++ )
      commandStream[8+retvalueCopy] = CopyTmpBuf[7+retvalueCopy];
//

      retvalueCopy = Fill_Mem ( &CopyTmpBuf[0] );
      if( retvalueCopy != 0) return retvalueCopy;

   }

   copyCycle = copyLength % 255 ;
   if( copyCycle != 0 )
   {
      FwDumpCmd[1] = SourAdr1_lo;
      FwDumpCmd[2] = SourAdr1_hi;
      CopyTmpBuf[6] = copyCycle;

      copyLength = (unsigned long int)SourAdr1_lo
                  + (unsigned long int)copyCycle - 1;
      if( copyLength > 255 ) SourAdr1_hi ++;
      FwDumpCmd[4] = SourAdr1_lo + copyCycle - 1;
      FwDumpCmd[5] = SourAdr1_hi;

      retvalueCopy = Read_Mem ( &FwDumpCmd[0], &CopyTmpBuf[7] );
      if( retvalueCopy != 0 ) return retvalueCopy;

      CopyTmpBuf[1] = DestAdr1_lo;
      CopyTmpBuf[2] = DestAdr1_hi;

      copyLength = (unsigned long int)DestAdr1_lo
                  + (unsigned long int)copyCycle - 1;
      if( copyLength > 255) DestAdr1_hi ++ ;
      CopyTmpBuf[4] = DestAdr1_lo + copyCycle - 1;
      CopyTmpBuf[5] = DestAdr1_hi;
// OCT.26.1995 ERIC for copy.
      commandStream[1] = CopyTmpBuf[0];
      commandStream[2] = CopyTmpBuf[1];
      commandStream[3] = CopyTmpBuf[2];
      commandStream[4] = CopyTmpBuf[3];
      commandStream[5] = CopyTmpBuf[4];
      commandStream[6] = CopyTmpBuf[5];
      commandStream[7] = CopyTmpBuf[6];
      for ( retvalueCopy = 0; retvalueCopy < commandStream[7];retvalueCopy ++ )
      commandStream[8+retvalueCopy] = CopyTmpBuf[7+retvalueCopy];
//


      retvalueCopy = Fill_Mem ( CopyTmpBuf );
      if( retvalueCopy != 0) return retvalueCopy;

   };

   return   0;

}

unsigned char GetTraceBuf( unsigned int RdDirect,unsigned int StartFrame,
            unsigned int EndFrame,unsigned char *P2Qualify,unsigned char *P2TBuf)
{
   unsigned char RetRDTrace;
   unsigned char *pChar;


   TransmitBuf[1] = 0;     // Trace read Frame Number = 0
   TransmitBuf[2] = 1;     // Trace not over

   do
   {
   *(P2TBuf) = (unsigned char) (StartFrame & 0x00ff);
   *(P2TBuf+1) = (unsigned char) (StartFrame / 256);
   RetRDTrace = GetFrame( StartFrame,P2TBuf + 2);
   if ( RetRDTrace == 0 )
      {
       StartFrame ++;
       if ( User1Flag == 1 )
       {
         if( ChkTrace( P2TBuf ) == 0 ) // match
         {
         TransmitBuf[1] = TransmitBuf[1] + 1;
         P2TBuf = P2TBuf + 7;
         };
      }
      else
      {
         TransmitBuf[1] = TransmitBuf[1] + 1;
         P2TBuf = P2TBuf + 7;
      }

      }
   else TransmitBuf[2] = 0;


   }
   while ( StartFrame <= EndFrame && TransmitBuf[1] <= 254 && TransmitBuf[2] != 0  );


         return CommandExeOk;

}

unsigned char GetCTraceBuf( unsigned char count, unsigned char rangeCount)

{
   unsigned char x, retcount = 0;
   unsigned int StartFrame;
   StartFrame = commandStream[1] + commandStream[2] * 256;
   if (count > 60)
   {
      return CmdInvalid;
   }
   if(StartFrame < traceCnt)
   {
      Read_Trace_Ini();
// Code_Access_No = 0;
      LdTraceCnt(traceStart+StartFrame);
      if (rangeCount == 0)
      {
         for (x=0;x<count;x++)
         {
            Frame_adr[x] = Read_Trace_Content();
            Frame_No[x] = StartFrame;
            if (Coverage_Flg != 1)
            {
               x--;
            }
            StartFrame ++;
            if(StartFrame >= traceCnt)
            {
               break;
            }
         }
         retcount = x;
      }
      else
      {
         if (rangeCount < 0xf5 && rangeCount > 0xf0)
         {
            rangeCount = rangeCount - 0xf0;
            for(Coverage_Range_SAd1 = StartFrame;
               Coverage_Range_SAd1 <  traceCnt; Coverage_Range_SAd1++ )
            {
               Code_Access_Tmp = Read_Trace_Content();
               if (Coverage_Flg == 1)
               {
                  if((Code_Access_Tmp >= Code_Access_Range_SAd[4])
                     && (Code_Access_Tmp <= Code_Access_Range_DAd[4]))
                  {
                     StartFrame = Coverage_Range_SAd1;
                     Frame_No[retcount] = StartFrame;
                     Frame_adr[retcount] = Code_Access_Tmp;
                     retcount++;
                     StartFrame++;
                     break;
                  }
               }
            }
            goto NORM;
         }
         if (rangeCount > 5 || rangeCount == 0)
         {
            return CmdInvalid;
         }
         StartFrame++;
         Code_Access_Tmp = Read_Trace_Content();
         for(;StartFrame <  traceCnt; StartFrame++)
         {
            Code_Access_Tmp = Read_Trace_Content();
            if (Coverage_Flg == 1)
            {
               if((Code_Access_Tmp <= Code_Access_Range_SAd[0])
                  || (Code_Access_Tmp > Code_Access_Range_DAd[0]))
               {
                  Frame_No[retcount] = StartFrame;
                  Frame_adr[retcount] = Code_Access_Tmp;
                  retcount++;
                  StartFrame++;
                  break;
               }
            }
            if(retcount >= count )
            {
               temp2 = retcount;
               return CommandExeOk;
            }
         }
         NORM:
         do
         {
            for(x=0;x<rangeCount;x++)
            {
               if((Code_Access_Tmp >= Code_Access_Range_SAd[x])
                   &&(Code_Access_Tmp <= Code_Access_Range_DAd[x]))
               {
                  break;
               }
            }
            if(x==rangeCount)
            {
               temp2 = retcount;
               return CommandExeOk;
            }
            for(;StartFrame <  traceCnt; StartFrame++)
            {
               Code_Access_Tmp = Read_Trace_Content();
               if (Coverage_Flg == 1)
               {
                  if((Code_Access_Tmp <= Code_Access_Range_SAd[x])
                     || (Code_Access_Tmp > Code_Access_Range_DAd[x]))
                  {
                     Frame_No[retcount] = StartFrame;
                     Frame_adr[retcount] = Code_Access_Tmp;
                     retcount++;
                     StartFrame++;
                     break;
                  }
               }
            }
            if(StartFrame >= traceCnt)
            {
               temp2 = retcount;
               return CommandExeOk;
            }
         }while(retcount<count);
      }
   }
   temp2 = retcount;
   return CommandExeOk;
}

unsigned char Analyse_Coverage() {
   data unsigned char i,k,l,m,n;
   unsigned int j;

   Read_Trace_Ini();
   Code_Access_No = 0;
/* ClrTraceCnt();    // call ClrTraceCnt */
   LdTraceCnt(traceStart);
   switch ( Coverage_Range_No ) {
      case 1:
               i = 1;
               k = 0;
               for (j = 1; j <= traceCnt; j++ ) {
                  Code_Access_Tmp = Read_Trace_Content();
                  if ((Coverage_Range_SAd1 <= Code_Access_Tmp) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd1)) {
                     if (k == i-1) {
                        if (Coverage_Flg == 1)
                 // Add for avoid set the not 's' status as the start
                 // access address (Coverage_Flg = 1 is 's').
                        {
                           Code_Access_Range_SAd[i] = Code_Access_Tmp;
                           Code_Access_Range_DAd[i] = Code_Access_Tmp;
                           Frame_adr[i] = Code_Access_Tmp;
                           k = i;
                        }
                     }
		     else {
                        for (l = i; l >= 1; l-- ) {
                           if ((Code_Access_Tmp == Code_Access_Range_DAd[l]) ||
                               (Code_Access_Tmp == Code_Access_Range_DAd[l] + 1))
                           {
                              Code_Access_Range_DAd[l] = Code_Access_Tmp;
                              if (Coverage_Flg == 1)
                              {
                                 Frame_adr[l] = Code_Access_Tmp;
                              }
                              m = 1;
                              l = 1;
                           }
                           else {
                              if (( Code_Access_Range_SAd[l] <= Code_Access_Tmp) &&
                                  (Code_Access_Tmp < Code_Access_Range_DAd[l] ))
                              {
                                 m = 1;
                                 l = 1;
                              }
                              else { m = 0; }

                           }
			}
                        if ((m != 1) && (Coverage_Flg == 1))
                 // Add for avoid set the not 's' status as the start
                 // access address (Coverage_Flg = 1 is 's').
                        {
                              i++;
                              Code_Access_Range_SAd[i] = Code_Access_Tmp;
                              Code_Access_Range_DAd[i] = Code_Access_Tmp;
                              Frame_adr[i] = Code_Access_Tmp;
                              k = i;
                        }
                        if (Code_Access_Range_SAd[i] != Code_Access_Range_DAd[i])
                        {
                           for (l = 1; l < i; l++) {
                              if (Code_Access_Range_DAd[i] == Code_Access_Range_SAd[l])
                              {
                                 Code_Access_Range_SAd[l] = Code_Access_Range_SAd[i];
                                 i--;
                                 k--;
                              }
                           }
                        }
                        if ( i > 32 ) {
                           j = traceCnt ;
                        }
                     }
		  }
               }
               break;

      case 2:
               i = 1;
               k = 0;
               for (j = 1; j <= traceCnt; j++ ) {
                  Code_Access_Tmp = Read_Trace_Content();
                  if ( ((Coverage_Range_SAd1 <= Code_Access_Tmp) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd1)) ||
                       ((Coverage_Range_SAd2 <= Code_Access_Tmp) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd2)) ) {
                     if (k == i-1) {
                        if (Coverage_Flg == 1)
                 // Add for avoid set the not 's' status as the start
                 // access address (Coverage_Flg = 1 is 's').
                        {
                           Code_Access_Range_SAd[i] = Code_Access_Tmp;
                           Code_Access_Range_DAd[i] = Code_Access_Tmp;
                           Frame_adr[i] = Code_Access_Tmp;
                           k = i;
                        }
                     }
		     else {
                        for (l = i; l >= 1; l-- ) {
                           if ((Code_Access_Tmp == Code_Access_Range_DAd[l]) ||
                               (Code_Access_Tmp == Code_Access_Range_DAd[l] + 1))
                           {
                              Code_Access_Range_DAd[l] = Code_Access_Tmp;
                              if (Coverage_Flg == 1)
                              {
                                 Frame_adr[l] = Code_Access_Tmp;
                              }
                              m = 1;
                              l = 1;
                           }
                           else {
                              if (( Code_Access_Range_SAd[l] <= Code_Access_Tmp) &&
                                  (Code_Access_Tmp < Code_Access_Range_DAd[l] ))
                              {
                                 m = 1;
                                 l = 1;
                              }
                              else { m = 0; }

                           }
			}
                        if ((m != 1) && (Coverage_Flg == 1))
                 // Add for avoid set the not 's' status as the start
                 // access address (Coverage_Flg = 1 is 's').
                        {
                              i++;
                              Code_Access_Range_SAd[i] = Code_Access_Tmp;
                              Code_Access_Range_DAd[i] = Code_Access_Tmp;
                              Frame_adr[i] = Code_Access_Tmp;
                              k = i;
                        }
                        if (Code_Access_Range_SAd[i] != Code_Access_Range_DAd[i])
                        {
                           for (l = 1; l < i; l++) {
                              if (Code_Access_Range_DAd[i] == Code_Access_Range_SAd[l])
                              {
                                 Code_Access_Range_SAd[l] = Code_Access_Range_SAd[i];
                                 i--;
                                 k--;
                              }
                           }
                        }
                        if ( i > 32 ) {
                           j = traceCnt ;
                        }
                     }
		  }
               }
               break;

      case 3:
               i = 1;
               k = 0;
               for (j = 1; j <= traceCnt; j++ ) {
                  Code_Access_Tmp = Read_Trace_Content();
                  if ( ((Coverage_Range_SAd1 <= Code_Access_Tmp) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd1)) ||
                       ((Coverage_Range_SAd2 <= Code_Access_Tmp) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd2)) ||
                       ((Coverage_Range_SAd3 <= Code_Access_Tmp) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd3)) ) {
                     if (k == i-1) {
                        if (Coverage_Flg == 1)
                 // Add for avoid set the not 's' status as the start
                 // access address (Coverage_Flg = 1 is 's').
                        {
                           Code_Access_Range_SAd[i] = Code_Access_Tmp;
                           Code_Access_Range_DAd[i] = Code_Access_Tmp;
                           Frame_adr[i] = Code_Access_Tmp;
                           k = i;
                        }
                     }
		     else {
                        for (l = i; l >= 1; l-- ) {
                           if ((Code_Access_Tmp == Code_Access_Range_DAd[l]) ||
                               (Code_Access_Tmp == Code_Access_Range_DAd[l] + 1))
                           {
                              Code_Access_Range_DAd[l] = Code_Access_Tmp;
                              if (Coverage_Flg == 1)
                              {
                                 Frame_adr[l] = Code_Access_Tmp;
                              }
                              m = 1;
                              l = 1;
                           }
                           else {
                              if (( Code_Access_Range_SAd[l] <= Code_Access_Tmp) &&
                                  (Code_Access_Tmp < Code_Access_Range_DAd[l] ))
                              {
                                 m = 1;
                                 l = 1;
                              }
                              else { m = 0; }

                           }
			}
                        if ((m != 1) && (Coverage_Flg == 1))
                 // Add for avoid set the not 's' status as the start
                 // access address (Coverage_Flg = 1 is 's').
                        {
                              i++;
			      Code_Access_Range_SAd[i] = Code_Access_Tmp;
			      Code_Access_Range_DAd[i] = Code_Access_Tmp;
                              Frame_adr[i] = Code_Access_Tmp;
			      k = i;
                        }
                        if (Code_Access_Range_SAd[i] != Code_Access_Range_DAd[i])
                        {
                           for (l = 1; l < i; l++) {
                              if (Code_Access_Range_DAd[i] == Code_Access_Range_SAd[l])
                              {
                                 Code_Access_Range_SAd[l] = Code_Access_Range_SAd[i];
                                 i--;
                                 k--;
                              }
                           }
                        }
                        if ( i > 32 ) {
                           j = traceCnt ;
                        }
                     }
		  }
               }
               break;

      case 4:
               i = 1;
               k = 0;
               for (j = 1; j <= traceCnt; j++ ) {
                  Code_Access_Tmp = Read_Trace_Content();
                  if ( ((Coverage_Range_SAd1 <= Code_Access_Tmp) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd1)) ||
                       ((Coverage_Range_SAd2 <= Code_Access_Tmp) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd2)) ||
                       ((Coverage_Range_SAd3 <= Code_Access_Tmp) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd3)) ||
                       ((Coverage_Range_SAd4 <= Code_Access_Tmp) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd4)) ) {
                     if (k == i-1) {
                        if (Coverage_Flg == 1)
                 // Add for avoid set the not 's' status as the start
                 // access address (Coverage_Flg = 1 is 's').
                        {
                           Code_Access_Range_SAd[i] = Code_Access_Tmp;
                           Code_Access_Range_DAd[i] = Code_Access_Tmp;
                           Frame_adr[i] = Code_Access_Tmp;
                           k = i;
                        }
                     }
		     else {
                        for (l = i; l >= 1; l-- ) {
                           if ((Code_Access_Tmp == Code_Access_Range_DAd[l]) ||
                               (Code_Access_Tmp == Code_Access_Range_DAd[l] + 1))
                           {
                              Code_Access_Range_DAd[l] = Code_Access_Tmp;
                              if (Coverage_Flg == 1)
                              {
                                 Frame_adr[l] = Code_Access_Tmp;
                              }
                              m = 1;
                              l = 1;
                           }
                           else {
                              if (( Code_Access_Range_SAd[l] <= Code_Access_Tmp) &&
                                  (Code_Access_Tmp < Code_Access_Range_DAd[l] ))
                              {
                                 m = 1;
                                 l = 1;
                              }
                              else { m = 0; }

                           }
			}
                        if ((m != 1) && (Coverage_Flg == 1))
                 // Add for avoid set the not 's' status as the start
                 // access address (Coverage_Flg = 1 is 's').
                        {
                              i++;
                              Code_Access_Range_SAd[i] = Code_Access_Tmp;
			      Code_Access_Range_DAd[i] = Code_Access_Tmp;
                              Frame_adr[i] = Code_Access_Tmp;
                              k = i;
                        }
                        if (Code_Access_Range_SAd[i] != Code_Access_Range_DAd[i])
                        {
                           for (l = 1; l < i; l++) {
                              if (Code_Access_Range_DAd[i] == Code_Access_Range_SAd[l])
                              {
                                 Code_Access_Range_SAd[l] = Code_Access_Range_SAd[i];
                                 i--;
                                 k--;
                              }
                           }
                        }
                        if ( i > 32 ) {
// -koo 8/16/1996          i = 16;
                           j = traceCnt ;
                        }
                     }
		  }
               }
               break;

      default:
               break;
   }
   Code_Access_No = k;
   SaveTraceEnd();
}

unsigned char go_trace( void )
{
   unsigned int l,m;
   bCtrl0 = bCtrl0 | TRACE_EN ;
   bCtrl0 = bCtrl0 & ~ENTRACE ; /* disable trace writing */
   LDCTRL0 = bCtrl0 ;
   ReadElTimer();
   Read_Trace_Content();
   UpdateTraceCnt();
/* Read_Trace_Ini();
   LdTraceCnt(traceEnd +1 );
   l = Read_Trace_Content();
   m = Read_Trace_Content();
   if( l == m && Coverage_Flg == 1)
   {
      traceStart = traceStart - 1;
      traceEnd = traceEnd - 1;
   }
*/
}

unsigned char Trace_Init( void )
{
   unsigned char retval;
   if( epRunFlag == 1)
   {
      if( (commandStream[1] & 0x1) == 0 )  //trace off
      {
         if( getTraceCnt == 0 )
         {
            go_trace();
         }
         if(getTraceCnt == 0)
         {
            bCtrl0 = bCtrl0 | ENTRACE ; // enalbe trace writing
            LDCTRL0 = bCtrl0 ;
            getTraceCnt = 0;
            retval = TraceRunning;
         }
         else
         {
            retval = Ini_Trace( commandStream[1] );
         }
         TransmitBuf[0] = retval;
      }
      else
      {
         retval = Ini_Trace( commandStream[1] );
         LDST = bLdst;
         bCtrl0 = bCtrl0 & ~TRACE_EN ;
         bCtrl0 = bCtrl0 | ENTRACE ; /* enable trace writing */
         bRamen = 0;
         bBufen = bBufen & (~NENTDBUF) & (~NENTABUF) ;
         LDCTRL0 = bCtrl0 ;
         LDBUFEN = bBufen ;
         LDRAMEN = bRamen;
         getTraceCnt = 0 ;
         traceCnt = 0 ;
         TransmitBuf[0] = retval;
      }
   }
   else
   {
      retval = Ini_Trace( commandStream[1] );
      TransmitBuf[0] = retval;
   }
}

unsigned char Cover_Get(void)
{
         Coverage_Flg = 0;
         Analyse_Coverage();
         TransmitBuf[0] = 0;
         TransmitBuf[1] = Code_Access_No;
         temp2 = 1;
         while ( (temp2 <= Code_Access_No) && (temp2 < 33) ) {
            TransmitBuf[temp2 * 4 - 2] = Code_Access_Range_SAd[temp2] & 0x00ff;
            TransmitBuf[temp2 * 4 - 1] = Code_Access_Range_SAd[temp2]/256;
            TransmitBuf[temp2 * 4]     = Frame_adr[temp2] & 0x00ff;
            TransmitBuf[temp2 * 4 + 1] = Frame_adr[temp2]/256;
//          TransmitBuf[retvalue * 4]     = Code_Access_Range_DAd[retvalue] & 0x00ff;
//          TransmitBuf[retvalue * 4 + 1] = Code_Access_Range_DAd[retvalue]/256;
            temp2 ++;
         }
         TStreamLen = (temp2 - 1) * 4 + 2;
}

unsigned char Cover_Go(void)
{
         Clr_Ev_ExBp_all();
         Coverage_Range_No = commandStream[1];
         Coverage_Range_SAd1 = commandStream[2] + commandStream[3] * 256;
         Coverage_Range_DAd1 = commandStream[4] + commandStream[5] * 256;
         Coverage_Range_SAd2 = commandStream[6] + commandStream[7] * 256;
         Coverage_Range_DAd2 = commandStream[8] + commandStream[9] * 256;
         Coverage_Range_SAd3 = commandStream[10] + commandStream[11] * 256;
         Coverage_Range_DAd3 = commandStream[12] + commandStream[13] * 256;
         Coverage_Range_SAd4 = commandStream[14] + commandStream[15] * 256;
         Coverage_Range_DAd4 = commandStream[16] + commandStream[17] * 256;
         Coverage_Flg = 1;
         temp2 = start_EP( &commandStream[18] );
//       while (Coverage_Flg == 1) {TransmitBuf[0] = 0x55;}
         TransmitBuf[0] = temp2;
}
