#
#  Name: makefile.mak
#
#  Description: Make definitions for EZ8052 firmware
#               for FrankLin C make.exe
#
#  $Log$
#
#  $Header$
#
#  COPYRIGHT (C) 1993 MICROTEK INTERNATIONAL, INC.
#


#
# files
#
SRC = .
BIN = bin
FCDIR = c:\TOOL\c51.v24
#FCDIR = D:\c51.v32
INC = $(FCDIR)\inc
CCDIR = $(FCDIR)
#CCDIR = $(FCDIR)\BIN
ASMDIR = $(FCDIR)
#ASMDIR = $(FCDIR)\BIN
#LNKDIR = $(FCDIR)
LNKDIR = $(FCDIR)\BIN
USDDIR = c:\USD
LIBDIR = $(FCDIR)\LIB
#DEEMAX = c:\deemax
TMPDIR = D:
# Verison number
VER = 13

.SUFFIXES:      .HEX .ABS .OBJ .C .A51 .H .A${VER}

#		*Translator Definitions*
#  Macros definition
#
ASM = $(ASMDIR)\A51
ASMFLAG = DEBUG
#LINK = $(LNKDIR)\xlink86
#LINK = $(LNKDIR)\xlink86e
LOC = $(ASMDIR)\L51
OH51 = $(ASMDIR)\oh51
CONV = $(USDDIR)\CONVERT
CONVEZ = CONVEZ
#OMFCONV = $(DEEMAX)\omfconv
CODEGEN = conv52
CHKSUM = omfcksum
CC = $(CCDIR)\c51
CFLAG = large debug oe OT(0) CODE


#		*Implicit Rules*
.C.obj:
 SET C51INC=${INC}
 SET C51TEMP=${TMPDIR}
 ${CC} ${SRC}\$*.c ${CFLAG} PR(${TMPDIR}\ERR.LST) OJ(${BIN}\$*.obj)

.A${VER}.obj:
 ${ASM} ${SRC}\$*.A${VER} ${ASMFLAG} NOPR EP(${TMPDIR}\err.lst) OJ(${BIN}\$*.obj)

.A51.obj:
 $(ASM) ${SRC}\$*.A51 ${ASMFLAG} NOPR EP(${TMPDIR}\err.lst) OJ(${BIN}\$*.obj)

# define all objs

LNK_depends = ${BIN}\hwtst52.obj ${BIN}\hwSUB52.obj ${BIN}\LLFW52.OBJ ${BIN}\rs232.OBJ  \
              ${BIN}\icehwlib.obj ${BIN}\xfwsub.obj ${BIN}\INITDATA.OBJ ${BIN}\FWVAR52.OBJ \
              ${BIN}\fwmem52.obj ${BIN}\fwevent.obj ${BIN}\regmap.OBJ ${BIN}\FWVAR52.OBJ \
              ${BIN}\fwrun52.obj ${BIN}\fwtrace.obj ${BIN}\process.obj ${BIN}\HWSUB1.OBJ\
              ${BIN}\XFWMAIN.obj ${BIN}\XFWcomm.obj ${BIN}\XFWasm.obj ${BIN}\insram_e.obj\
              ${BIN}\xfwcom1.OBJ ${BIN}\epstatus.OBJ ${BIN}\BANKSUB.OBJ \
              ${BIN}\testhw1.obj ${BIN}\testhw2.obj ${BIN}\testhw3.OBJ ${bin}\ispprog.obj

#
${BIN}\FW52.ABS : ${LNK_depends}
 SET C51LIB=$(LIBDIR)
 echo ${BIN}\xfwmain.obj,      &  > ${TMPDIR}\tmp.lnk
 echo ${BIN}\xfwcomm.obj,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\rs232.obj,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\xfwasm.obj,       & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\insram_e.obj,     & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\initdata.obj,     & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\HWSUB1.obj,      & >> ${TMPDIR}\tmp.lnk
 echo C:\TOOL\C51.v24\lib\C51L.lib, & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\FWtrace.obj,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\xfwsub.obj,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\icehwlib.obj,     & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\LLfw52.obj,       & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\FWVAR52.obj,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\FWrun52.obj,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\FWmem52.obj,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\FWevent.obj,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\regmap.obj,       & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\hwsub52.obj,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\process.obj,      & >> ${TMPDIR}\tmp.lnk
 echo C:\TOOL\C51.v24\lib\C51L.lib,  & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\HWTST52.obj,     & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\xfwcom1.obj,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\epstatus.obj,     & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\BANKSUB.obj,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\testhw1.obj,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\testhw2.obj,      & >> ${TMPDIR}\tmp.lnk
 echo ${BIN}\testhw3.obj,      & >> ${TMPDIR}\tmp.lnk

 echo ${BIN}\ispprog.obj       & >> ${TMPDIR}\tmp.lnk
#to ${BIN}\fw52.abs IXREF MAP SYMBOLS NOOVERLAY
 echo to ${BIN}\fw52.abs      &  >> ${TMPDIR}\tmp.lnk
 echo IXREF MAP SYMBOLS NOOVERLAY      &  >> ${TMPDIR}\tmp.lnk
 ${LOC}  @${TMPDIR}\tmp.lnk
 del ${TMPDIR}\tmp.lnk
 if exist ${TMPDIR}\CAN*.TBL del ${TMPDIR}\CAN*.TBL
 if exist ${TMPDIR}\CAN*.EQU del ${TMPDIR}\CAN*.EQU
 ${CHKSUM} ${BIN}\fw52.abs 0ffff
 copy ${BIN}\fw52.abs .
 set TMP=C:
 $(ASMDIR)\OHS51 FW52.ABS

#		*Explicit Rules*
${BIN}\xFWMAIN.OBJ: ${SRC}\xFWMAIN.c
${BIN}\xfwcomm.obj: ${SRC}\xfwcomm.c ${SRC}\xfwcmd.h ${SRC}\basetype.h
${BIN}\rs232.obj: ${SRC}\rs232.c
${BIN}\xfwsub.obj: ${SRC}\xfwsub.c ${SRC}\xfwsub.h
${BIN}\process.obj: ${SRC}\process.c ${SRC}\xfwcmd.h ${SRC}\basetype.h
${BIN}\LLFW52.OBJ : ${SRC}\LLFW52.A$(VER) ${SRC}\IO.equ
#${BIN}\TESTHW.OBJ : ${SRC}\TESTHW.A$(VER) ${SRC}\IO.equ


#${SRC}\can_22.dw : ${SRC}\can_22.A$(VER)
# $(ASM) ${SRC}\$*.A$(VER) NOOJ
# $(CODEGEN) ${SRC}\$*.LST ${SRC}\$*.DW ${TMPDIR}\$*.EQU ${TMPDIR}\$*.TBL

${SRC}\can_752.dw : ${SRC}\can_752.A$(VER)
 $(ASM) ${SRC}\$*.A$(VER) NOOJ
 $(CODEGEN) ${SRC}\$*.LST ${SRC}\$*.DW ${SRC}\$*.EQU ${TMPDIR}\$*.TBL

#${SRC}\can_320.dw : ${SRC}\can_320.A$(VER)
# $(ASM) ${SRC}\$*.A$(VER) NOOJ
# $(CODEGEN) ${SRC}\$*.LST ${SRC}\$*.DW ${SRC}\$*.EQU ${TMPDIR}\$*.TBL

${SRC}\can_ez52.dw : ${SRC}\can_ez52.A$(VER)
 $(ASM) ${SRC}\$*.A$(VER) NOOJ
 $(CODEGEN) ${SRC}\$*.LST ${SRC}\$*.DW ${SRC}\$*.EQU ${SRC}\$*.TBL

${SRC}\can_ez52.tbl : ${SRC}\can_ez52.A$(VER)
 $(ASM) ${SRC}\$*.A$(VER) NOOJ
 $(CODEGEN) ${SRC}\$*.LST ${SRC}\$*.DW ${SRC}\$*.EQU ${SRC}\$*.TBL

${SRC}\can_ez52.EQU : ${SRC}\can_ez52.A$(VER)
 $(ASM) ${SRC}\$*.A$(VER) NOOJ
 $(CODEGEN) ${SRC}\$*.LST ${SRC}\$*.DW ${SRC}\$*.EQU ${SRC}\$*.TBL

${BIN}\hwsub52.obj : ${SRC}\hwsub52.A$(VER) ${SRC}\can_752.dw ${SRC}\can_ez52.dw ${SRC}\CAN_EZ52.EQU ${SRC}\CAN_752.EQU ${SRC}\IO.equ
${BIN}\icehwlib.obj: ${SRC}\icehwlib.c ${SRC}\icehwlib.h ${SRC}\io.h ${SRC}\can_ez52.tbl ${SRC}\basetype.h

${BIN}\INSRAM_E.obj : ${SRC}\INSRAM_E.A$(VER)
${BIN}\hwsub1.obj : ${SRC}\hwsub1.A$(VER) ${SRC}\IO.EQU
${BIN}\hwtst52.OBJ : ${SRC}\hWtst52.A$(VER) ${SRC}\IO.equ
${BIN}\FWVAR52.obj : ${SRC}\FWVAR52.A$(VER) ${SRC}\CAN_EZ52.EQU ${SRC}\IO.equ
${BIN}\FWmem52.obj : ${SRC}\FWmem52.A$(VER) ${SRC}\CAN_EZ52.EQU ${SRC}\CAN_752.EQU ${SRC}\IO.equ
${BIN}\FWevent.obj : ${SRC}\fwevent.A$(VER) ${SRC}\IO.equ
${BIN}\FWtrace.obj : ${SRC}\FWtrace.A$(VER) ${SRC}\IO.equ
${BIN}\FWrun52.obj : ${SRC}\FWrun52.A$(VER) ${SRC}\IO.equ
${BIN}\regmap.obj : ${SRC}\regmap.A$(VER)   ${SRC}\CAN_EZ52.EQU ${SRC}\CAN_752.EQU ${SRC}\IO.equ
${BIN}\initdata.obj : ${SRC}\INITDATA.A$(VER)
${BIN}\xfwasm.obj : ${SRC}\xfwasm.A$(VER) ${SRC}\io.equ

${BIN}\xfwcom1.obj: ${SRC}\xfwcom1.c ${SRC}\xfwcmd.h ${SRC}\basetype.h
${BIN}\epstatus.obj: ${SRC}\epstatus.A$(VER) ${SRC}\io.equ
${BIN}\BANKSUB.OBJ : ${SRC}\BANKSUB.A$(VER) ${SRC}\XDATA.equ ${SRC}\io.equ
#${BIN}\TESTHW1.OBJ : ${SRC}\TESTHW1.A$(VER) ${SRC}\IO.equ
${BIN}\testhw1.OBJ: ${SRC}\testhw1.a$(ver) ${src}\io.equ $(src)\xdata.equ
${BIN}\testhw2.obj: ${SRC}\testhw2.a$(ver) ${src}\io.equ $(src)\xdata.equ
${BIN}\testhw3.obj: ${SRC}\testhw3.a$(ver) ${src}\io.equ $(src)\xdata.equ

${BIN}\ispprog.obj:  ${SRC}\ispprog.a13
