
/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/
/****************************************************************************
**
**  Name:          icehwlib.c
**
**  Description:
**
**  Status:
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#define _ICEHWLIB_C

#include <reg51.h>
#include <string.h>
#include <stdio.h>

#include "basetype.h"
#include "icehwlib.h"
#include "fwmain.h"

#include "io.h"

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

U8         traceQualifyOn ; /* bit 0 -> current trace qualify setting */
                            /* bit 1 -> before stop trace qualify setting */
U8         cmdBuf[20] ;


                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

extern U8 bBank;
extern U8 goTillExbp;
extern U8  timerHigh ;
extern U32 timerLow  ;
extern U8  initTrigger ; /* bit 0-> timer, bit 1 -> trace */
extern U8 TransmitBuf[0];

extern bit TrigRun;
void PrepareGo(void) ;
void init_EP_1(void) ;
U8   GoSpoon(void) ;

U8   LoadTrigIni(U8 control) ;

U8   SetTracePort(void) ;
//
extern unsigned char nBank_Set( U8 i ) ;
extern void Set_TPort(void);
extern void RestorePort(void);
//extern void ControlEA(U8) ; /* 0 disable EA, 1 enable EA */
//extern void ControlEBEN(U8) ; /* 0 disable EBEN, 1 enable EBEN */
void InitElTimer(void) ;
void SetTriggerHW(U8 event, U8 action) ;
void SetRunFromAdr(RUNPARA *pRunParm) ;

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

void GetRegister(void) ;
void SaveRegister(void) ;

unsigned char EpSupport( unsigned char * );

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/****************************************************************************
**
**  start_EP
**
**  struct{
**          BYTE RunFlg;             0    without RUN
**                                   1    with RUN
**          BYTE Reserved ;
**          ADRSTRUCT fromAdr;       address type =0      no from address
**                                               ~=0      go from "FromAdr"
**          ADRSTRUCT tillAdr;       address type =0      free run
**                                               ~=0      go untill "TillAdr"
**          }
*****************************************************************************/

//PFINALMSG start_EP(RUNPARA *pRunParm) { /* force EP started */
unsigned char start_EP(RUNPARA *pRunParm) { /* force EP started */

U16 i, j ;
U8  k ;
U8 chTmp[8];


   memcpy(&chTmp[0],pRunParm,8);
// Apr/4/19/1995 ERIC #define EpRunning   0x10

// MAR/ERIC/1995
     if (epRunFlag == 1)
//      return &ErrEpRun ;   /* aleardy going */ Eric -
        return 0x10      ;   /* aleardy going  Eric + */

/*     InitFwMsg() ; Eric - */
     Occurrence = Occurrence | 0x0002 ;
     Status = (Status & 0xfe8b) | 0x040 ;  /* EP running */

   EX0 = 0 ;

   GetRegister() ;
   if (BR_OVER == 0)
      SaveRegister() ;


//   CheckBR_OVER(&fwMsg) ;      Eric -
//   if (BR_OVER != 0)
//      return &fwMsg ;

      if (BR_OVER != 0)       // Apr/18/1995 ERIC +
      {
         BR_OVER = 0;
         return   1;          // return target canot step
      };

   /* clear timer, 8254 */
// timerHigh = 0 ;
// TH0 = 0 ;
// TL0 = 0 ;
// Write_CTC(TIMER_CH, 0) ;
// ET0 = 1 ; /* enable timer 0 interrupt */
   InitElTimer() ;
   if ((bBank == 1) && (chTmp[5] > 5)) {
      Set_TPort();
      nBank_Set(chTmp[5] - 5);
   }
   SetRunFromAdr(pRunParm) ;        // Apr/4/19/1995 ERIc must modify.
   goTillExbp = chTmp[5];           // if 0/1 then no change, 6~9 change bank.
   if ((bBank == 1) && (chTmp[2] > 5)) {
      Set_TPort();
      nBank_Set(chTmp[2] - 5);
   } else {
      RestorePort();
      Set_TPort();
   }

// GetRegister() ;
   if (BR_OVER == 0)
      SaveRegister() ;

   /* clear trace counter */
// traceStart = 0 ;
// traceEnd = 0 ;
   traceCnt = 0 ;
// ClrTraceCnt() ;
// if ((RDTCNTL | RDTCNTH) != 0) { /* trace counter logic fail! */
//    return &fwMsg ;
// }

   /* set trigger, trace control */
   if ((traceQualifyOn & 1) != 0)
      traceQualifyOn = traceQualifyOn | 2 ;
   else
      traceQualifyOn = traceQualifyOn & 0xfd ;

   /* enable trace, compare ram and buffer */
// bCtrl3 = bCtrl3 & (~DISEP) & (~NTDIN) ;
// LDCTRL3 = bCtrl3 ;

   /* set address,.EA, .TR0, .TR1, .TR2,  go ep */
   epRunFlag = 1 ;
   getTraceCnt = 0 ;
// getRegFlg = 0 ;
// bCtrl2 = bCtrl2 & (~SDATA) ;
// LDCTRL2 = bCtrl2 ;

   PrepareGo() ; /* put run spoon data into spoon ram */

   /* set default timer and trace */
   SetTracePort() ;
   initTrigger = initTrigger | 3; /* force trace and timer is on + koo 5/2/96*/
   LoadTrigIni(initTrigger) ; /* set ev1 cnt will destory trigger init value */

   bBufen = (~NENTDBUF) & (~NENTABUF) ;
// bCtrl0 = bCtrl0 & ~GORUN ; /* turn off GORUN */
// bCtrl0 = bCtrl0 & ~TRACE_EN; /* enable tclk1 to TCLK  + koo 5/14/1996 */
   bCtrl0 = bCtrl0 | ENTRACE ; /* enable trace */

   /* if trace on, enable trace ram cs */
   bRamen = 0 ;

   /* Set trigger */
   if (goRunFlag == 0) {
      if ((tLogic[0] == 1) && (trigStatus != 0)) { /* trigger set and enable */
         for (k = 2; k <= 3; k++) {
            bDataL = tLogic[k] ;
            switch (bDataL) {
               case 1:
                  if ((k == 3) || (tLogic[3] == 0xff))
                     /* last level */
                     SetTriggerHW(tLevel1[2], tLevel1[1] & 0xef) ;
                  else
                     SetTriggerHW(tLevel1[2], tLevel1[1]) ;
                  break ;

               case 2:
                  if ((k == 3) || (tLogic[3] == 0xff))
                     /* last level */
                     SetTriggerHW(tLevel2[2], tLevel2[1] & 0xef) ;
                  else
                     SetTriggerHW(tLevel2[2], tLevel2[1]) ;
                  break ;

               case 0xff:  /* only one level */
                  if (k == 3)
                     SetTriggerHW(0, 0xef) ;
                  break ;
            } /* end switch */
         } /* end for loop */

         if (tLogic[1] != 0)
         {
            /* with go run */
            TrigRun = 1;
            bCtrl0 = bCtrl0 | GORUN ; /* turn on GORUN */
         }
         else
         {
            TrigRun = 0;
            bCtrl0 = bCtrl0 & ~GORUN ; /* turn off GORUN */
         }
      }
      else  { /* trigger off */
         SetTriggerHW(0, 0xff) ;
         SetTriggerHW(0, 0xff) ;
      }
   }
   else { /* Gorun, disable trigger */
      SetTriggerHW(0, 0xff) ;
      SetTriggerHW(0, 0xff) ;
      bRamen = bRamen | NACEN ;  /* disable address compare ram to disable ev, exebp */
   }

// MAR/ERIC/1995
//   ini_msg() ; /* update status call back */

   LDCTRL0 = bCtrl0 ;
   LDBUFEN = bBufen ;
   LDRAMEN = bRamen ;

   IT0 = 0 ; /* level of external interrup */
// EX0 = 1 ; /* enable status change */


   GoSpoon() ; /* if go run then disable ENMAPBP */

   ET1 = 1 ;
   TR1 = 1 ; /* enable status changed polling */
   EX0 = 1 ; /* enable status change */

//   return &fwMsg ;    Apr/4/19/1995 ERIC -
      return 0x0  ;  // Apr/4/19/1995 ERIC + CommandExeOk

}

#if 0
unsigned char EpSupport( unsigned char * pTemp )
{
   unsigned char retTmp;

   if( SysTst & 0x18 ) {
      TransmitBuf[0] = 0x01;
      return 0x0; // target cannot ste
   }
   switch ( epModel ) {
      case EP8051 :
            *pTemp = (unsigned char) EP8031;
            pTemp ++;
            *pTemp = 0;
            retTmp = 1;
         break;
      case EP8032 :
            *pTemp = (unsigned char) EP8032;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP8031;
            pTemp ++;
            *pTemp = 0;
            retTmp = 2;
         break;
      case EP8052 :
            *pTemp = (unsigned char) EP8052;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP8032;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP8031;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP8051;
            pTemp ++;
            *pTemp = 0;
            retTmp = 4;
         break;
      case EP83C652 :
            *pTemp = (unsigned char) EP83C652;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80C652;
            pTemp ++;
            *pTemp = 0;
            retTmp = 2;
         break;
      case EP83C528 :
            *pTemp = (unsigned char) EP83C528;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80C528;
            pTemp ++;
            *pTemp = 0;
            retTmp = 2;
         break;
      case EP8351FA :
            *pTemp = (unsigned char) EP8351FA;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP8051FA;
            pTemp ++;
            *pTemp = 0;
            retTmp = 2;
         break;
      case EP83C552 :
            *pTemp = (unsigned char) EP83C552;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80C552;
            pTemp ++;
            *pTemp = 0;
            retTmp = 2;
         break;
      case EP83152A:
            *pTemp = (unsigned char) EP83152A;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80152A;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP83152C;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80152C;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80152B;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80152D;
            pTemp ++;
            *pTemp = 0;

            retTmp = 6;
         break;
      case EP80152A:
            *pTemp = (unsigned char) EP80152A;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80152C;
            pTemp ++;
            *pTemp = 0;

            retTmp = 2;
         break;
      case EP80152B:
            *pTemp = (unsigned char) EP80152B;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80152A;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80152C;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80152D;
            pTemp ++;
            *pTemp = 0;
            retTmp = 4;
         break;
      case EP83C550:
            *pTemp = (unsigned char) EP83C550;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80C550;
            pTemp ++;
            *pTemp = 0;
            retTmp = 2;
         break;
      case EP83CL782:
            *pTemp = (unsigned char) EP83CL782;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP83CL781;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80CL51;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80CL31;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80CL410;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP83CL410;
            pTemp ++;
            *pTemp = 0;
            retTmp = 6;
         break;
      case EP83CL580:
            *pTemp = (unsigned char) EP83CL580;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP80CL580;
            pTemp ++;
            *pTemp = 0;
            retTmp = 2;
         break;
      case EP80C752 :
      case EP83C752 :
            *pTemp = (unsigned char) EP83C752;
            pTemp ++;
            *pTemp = 0;
            retTmp = 1;
         break;
      case EP80C750 :
      case EP83C750 :
            *pTemp = (unsigned char) EP83C750;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP83C751;
            pTemp ++;
            *pTemp = 0;
            retTmp = 2;
         break;
      case EP80C751:
      case EP83C751:
            *pTemp = (unsigned char) EP83C751;
            pTemp ++;
            *pTemp = 0;
            pTemp ++;
            *pTemp = (unsigned char) EP83C750;
            pTemp ++;
            *pTemp = 0;
            retTmp = 2;
         break;
      case EP80CL31:
      case EP80CL410:
      case EP80C550:
      case EP80CL580:
      case EP80154:
      case EP8051FA:
      case EP80C552:
      case EP8031:
      case EP80C652:
      case EP8344:   
      case EP80C528:
      case EP80C320:
            *pTemp = (unsigned char) epModel;
            pTemp ++;
            *pTemp = 0;
            retTmp = 1;
         break;
   default:
            TransmitBuf[0] = 0x01;
            retTmp = 0x0; // target cannot step
         break;
      }
   return retTmp;
}
//#endif
//;$$$ NO.8
void set_cpu_model(void) {
//MAR/ERIC/1995
//   epMode = CPUmode ;
   switch (epModel) {
      case EP8051:          // 7/4/1994
            epMode = EP8031;
            ControlEA(0) ;
            init_EP_1() ;
            epMode = EP8031;
         break ;

      case EP8032:

           if (epMode != EP8031) epMode = EP8032;
           else
           {
            ControlEA(0);
            init_EP_1();
           }
                                  /* if epModel is 8031, just 8031 could select */
         break ;

      case EP8052:

         if ((epMode == EP8031) || (epMode == EP8032)) {
            /* disable EA */
            ControlEA(0) ;
            init_EP_1() ;
         };
         if ( (epMode != EP8051) && (epMode != EP8031) && (epMode != EP8032) )
         epMode = EP8052;

         break ;
      case EP83C652 :          // 7/4/1994
         if (epMode == EP80C652) {
            ControlEA(0) ;
            init_EP_1() ;
         }
         else
            epMode = EP83C652 ;
         break ;
      case EP83C552 :
         if (epMode == EP80C552) {
            ControlEA(0) ;
            init_EP_1() ;
         }
         else
            epMode = EP83C552 ;
         break ;
      case EP83C528 :          // 7/4/1994
         if (epMode == EP80C528) {
            ControlEA(0) ;
            init_EP_1() ;
         }
         else
            epMode = EP83C528 ;
         break ;
      case EP83152A:
         if ((epMode == EP80152A) || (epMode == EP80152C)) {
// OCT25 ERIC for 152
            epModeTMP = epMode;
            epMode = EP80152A;

            ControlEA(0) ;
            ControlEBEN(0) ;
            init_EP_1() ;
         }
         else  {
            if ((epMode == EP80152B) || (epMode == EP80152D)) {
// OCT25 ERIC for 152
            epModeTMP = epMode;
            epMode = EP80152A;


               ControlEBEN(1) ;
               init_EP_1() ;
            }
            else  {
               if ((epMode != EP83152C) && (epMode != EP83152A))
                  epMode = EP83152A;
// OCT25 ERIC for 152
            epModeTMP = epMode;
            epMode = EP80152A;

            }
         }
         break ;

      case EP80152A:
         if ((epMode != EP80152A) && (epMode != EP80152C))
            epMode = EP83152A;
// OCT25 ERIC for 152
            epModeTMP = epMode;
            epMode = EP80152A;

         break ;

      case EP80152B:
         if ((epMode != EP80152D) && (epMode != EP80152A) && (epMode != EP80152C))
            epMode = EP80152B;
// OCT25 ERIC for 152
            epModeTMP = epMode;
            epMode = EP80152A;
         break ;
      case EP8351FA :          // 2/1/1996 +Koo
         if (epMode == EP8051FA) {
            ControlEA(0) ;
            init_EP_1() ;
         }
         else
            epMode = EP8351FA ;
         break ;

      case EP83C550 :          // 7/4/1994
         if (epMode == EP80C550) {
            ControlEA(0) ;
            init_EP_1() ;
         }
         else
            epMode = EP83C550 ;
         break ;
      case EP83CL580 :          // 7/4/1994
         if (epMode == EP80CL580) {
            ControlEA(0) ;
            init_EP_1() ;
         }
         else
            epMode = EP83CL580 ;
         break ;

      case EP83CL782:
      case EP83CL781:
         if ((epMode == EP80CL31) || (epMode == EP80CL410)) {
            ControlEA(0) ;
            init_EP_1() ;
         }
         else
         {
            if ((epMode == EP80CL51) || (epMode == EP83CL410)) {
               ControlEA(1) ;
               init_EP_1() ;
            }
            else
               if ((epMode != EP83CL781)) {
                  epMode = EP83CL782 ;
               }
            }
         break ;

      case EP80C752:
      case EP83C752:
         epMode = EP83C752;
      break;
      case EP80C750:
      case EP83C750:
         if( (epMode != EP80C751) && (epMode != EP83C751) )
         epMode = EP83C750;
         else
         init_EP_1();
      break;
      case EP80C751:
      case EP83C751:
         if( (epMode != EP80C750) && (epMode != EP83C750) )
         epMode = EP83C751;
         else
         init_EP_1();
      break;

      case EP80C320:
      case EP80154:
      case EP8051FA:
      case EP80C552:
      case EP8031:            /* if epModel is 8031, just 8031 could select */
      case EP80C652:          /* if epModel is 80C652, just 80C652 could select */
      case EP80C528:          /* if epModel is 80C528, just 80C528 could select */
      case EP8344:            /* if epModel is 8044, just 8044 could select */
      case EP80CL51:
      case EP80CL31:
      case EP83CL410:
      case EP80CL410:
      case EP80CL580:
      case EP80C550:

         epMode = epModel ;
         break ;

      default:
         TransmitBuf[0] = 0x01;  // target cannot step
         break ;
   }
// canBuf[EP_TYPE] = (U8)epMode ;
// OCT25 ERIC for 152
   if ( epMode != EP80152A ) epModeTMP = epMode;

   return ;
}
//#if 0
// this function is moved to S/W.
static code U8 TIMER_OFFSET[14] = {
// 100000000L us =  1 Hr 11 min 34.967296
   0, 0, 0, 1, 1, 1, 3, 4, 9, 6, 7, 2, 9, 6} ;
extern xdata U8 elTimerMsg[] ;
U8 ConvElTimer(void) {
U8 i ;
U16 tmpVal1 ;
U32 tmpVal ;
/* total 40 bits timer, unit is 1 us
   'Elapsed: 00 day,00 hr'
	     01     23
   '00 min,00.000.000 sec'
    45     67 89A BCD
*/

   i = 14 ;
   tmpVal = timerLow ;
   do {
      i-- ;
      switch(i) {
	 case 3: // Hour
	    elTimerMsg[i] = (tmpVal % 24L) ;
	    tmpVal = tmpVal / 24L ;
	    if (timerHigh > 0) {
	       tmpVal1 = elTimerMsg[i] + (TIMER_OFFSET[i] * timerHigh) ;
	       tmpVal += (tmpVal1 / 24) ;
	       tmpVal1 = tmpVal1 % 24 ;
	       elTimerMsg[3] = '0' + (tmpVal1 % 10) ;
	       elTimerMsg[2] = tmpVal1 / 10 ;
	    }
	    i--;
            break ;

         case 4:
         case 6:
            elTimerMsg[i] = (tmpVal % 6L) ;
            tmpVal = tmpVal / 6L ;
	    if (timerHigh > 0) {
	       tmpVal1 = elTimerMsg[i] + (TIMER_OFFSET[i] * timerHigh) ;
	       elTimerMsg[i] = tmpVal1 % 6 ;
	       tmpVal += (tmpVal1 / 6) ;
	    }
            break ;

         default:
            elTimerMsg[i] = (tmpVal % 10L) ;
            tmpVal = tmpVal / 10L ;
	    if (timerHigh > 0) {
	       tmpVal1 = elTimerMsg[i] + (TIMER_OFFSET[i] * timerHigh) ;
	       elTimerMsg[i] = tmpVal1 % 10 ;
	       tmpVal += (tmpVal1 / 10) ;
	    }
            break ;
      }
      elTimerMsg[i] += '0' ;
// } while ((i > 3) && (tmpVal != 0)) ;
   } while ((i != 0) && ((tmpVal != 0) || (timerHigh != 0))) ;

   return(0) ;
}
#endif
