
/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/
/****************************************************************************
**
**  Name:         process.c
**
**  Description:
**
**  Status:
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
*****************************************************************************/

#include "basetype.h"
#include "xfwcmd.h"

extern xdata U8 bStatus1A   ;
extern U16 TStreamLen;
extern U8 commandStream[512];
extern U8 TransmitBuf[2048];
extern bit Coverage_Flg,user1Flag;
extern xdata unsigned char bBankType;
extern U8 bBank;
extern U8 bSelBank;
extern U8 chBankNo;
extern U8 temp2;
extern U8 bBankPort;
extern data U8 bAddrH,bAddrL;
extern data U8 bpodModel;

extern U8 Coverage_Range_No;
extern U16 Coverage_Range_SAd1;
extern U16 Coverage_Range_DAd1;
extern U16 Coverage_Range_SAd2;
extern U16 Coverage_Range_DAd2;
extern U16 Coverage_Range_SAd3;
extern U16 Coverage_Range_DAd3;
extern U16 Coverage_Range_SAd4;
extern U16 Coverage_Range_DAd4;
extern xdata U8 tracePort ; /* for traceport and bankswitch use */

extern void *memcpy(void *,void *,int );

extern void  Can_RW(void);
extern void  Can_RdPara(void);
extern void  Ld_StopSp(void);

extern U8 SetTracePort7(void) ;
extern U8 start_EP( U8 *);
extern U8 Read_Mem( U8 *, U8 * );
extern U8 Fill_Mem( U8 *MdfyMemPtr );
extern U16 CheckSum( U8 *); // checksum value saved in
extern U8 Srch_Mem( U8 *,U8 *);
                           // input.         // output: PADRSTRUCT.
extern U8 Tst_Mem( U8 *);
extern U8 Clr_Ev_ExBp_all(void);

extern U8 Set_EventA(U16,U8 *);
extern void ClrEv0A(void);
extern void ClrQlf(void);
extern xdata Event_No;
extern unsigned char Set_Bank1(void);
extern unsigned char Set_Bank2(void);
extern unsigned char Set_Bank3(void);
extern unsigned char Set_Bank4(void);
extern U8 checkPort(void);
extern void RestorePort(void);

U8  Coverage_Bank[5];

void Cover_Go(void);
U8 chkBankType( U8,U8 );
unsigned char CheckBank(void);

void Set_TPort( void ) {
   if (bBank == 1) {
      tracePort = bBankPort ;
      SetTracePort7();
   }
}

unsigned char CheckBank(void)
{
   if (checkPort()) return 1;    // check the podModel if port support
                                // > 3
   switch (bBankType & 3)
   {
      // bStatus1A.2 = BANKEN128, bSttatus1A.3 = BANKEN256
      case 0:     //bank64
         chBankNo = 1;
         if ((bStatus1A & 0x0f) == 0x02) {
            bBank = 0;
            return 0;
         }
         else return 1;

      case 1:     //bank128
         chBankNo = 2;
         if ((bStatus1A & 0x0f) == 0x06) {
            return 0;
         }
         else return 1;

      case 2:     //bank256
         chBankNo = 4;
         if ((bStatus1A & 0x0f) == 0x0A) {
         return 0;
         }
         else return 1;

      default:
         return 1;
   }
}

unsigned char nBank_Set( U8 i ) {
unsigned char j ;
   if ((bBank == 0) || ( i > chBankNo)) return 1;
   switch ( i )
   {
      case 1:
         j = Set_Bank1();
         break;

      case 2:
         j = Set_Bank2();
         break;

      case 3:
         j = Set_Bank3();
         break;

      case 4:
         j = Set_Bank4();
         break;
   }
   return j ;
}

void Comp_MemB(void) {
   unsigned int i,nStAdr,nEndAdr,nDesStAdr;
   unsigned char j, chCmpB_dif;

   chCmpB_dif = 0;
   nStAdr = commandStream[2] + commandStream[3]*256;   // startadr
   nEndAdr = commandStream[5] + commandStream[6]*256;   // endadr
   nDesStAdr = commandStream[8] + commandStream[9]*256;   // dest startadr
   memcpy (&TransmitBuf[1],&commandStream[1],9);
   j = 0xff;
   while (chCmpB_dif == 0) {
      TransmitBuf[2] = nStAdr & 0x00ff;
      TransmitBuf[3] = nStAdr / 256;
      if ((nStAdr >= nEndAdr - 0xfe) || (nEndAdr <= 0xfe)) {
         j = nEndAdr - nStAdr + 1;
         chCmpB_dif = 0x10;
      }
      nStAdr = nStAdr + j - 1 ;
      TransmitBuf[5] = nStAdr & 0x00ff;
      TransmitBuf[6] = nStAdr / 256;
      nStAdr ++ ;

      TransmitBuf[1] = chkBankType(commandStream[1],TransmitBuf[1]) ;

      Read_Mem ( &TransmitBuf[1] , &TransmitBuf[20] ) ;

      TransmitBuf[8] = nDesStAdr & 0x00ff;
      TransmitBuf[9] = nDesStAdr / 256;
      if (nDesStAdr > 0xffff - j) {
         chCmpB_dif = 0x20;
         j = 0xffff - nDesStAdr + 1;
      }
      nDesStAdr = nDesStAdr + j - 1;
      TransmitBuf[11] = nDesStAdr & 0x00ff;
      TransmitBuf[12] = nDesStAdr / 256;
      nDesStAdr ++ ;
      if ((nStAdr == 0) || (nDesStAdr == 0)) chCmpB_dif = 0x30;

      TransmitBuf[7] = chkBankType(commandStream[7],TransmitBuf[7]) ;

      Read_Mem(&TransmitBuf[7], &TransmitBuf[20+256] ) ;

      for (i = 0; i < j; i++) {
         if (TransmitBuf[i+20] != TransmitBuf[i+20+256]) {
            chCmpB_dif = 3;
            TransmitBuf[1] = commandStream[1] ;
            TransmitBuf[2] = (nStAdr - j + i) & 0x00ff;
            TransmitBuf[3] = (nStAdr - j + i) / 256;
            break;
         }
      }
   }
   if ((chCmpB_dif & 0x0f) == 0) {
      TransmitBuf[1] = 0;
   }

}

void Cover_Go(void)
{
   U8 i;
   Set_TPort();
   for ( i = 1; i <= chBankNo; i++ ) {
      nBank_Set(i);
      Clr_Ev_ExBp_all();
   }
   RestorePort();
   Coverage_Range_No = commandStream[1];
   Coverage_Range_SAd1 = commandStream[2] + commandStream[3] * 256;
   Coverage_Range_DAd1 = commandStream[4] + commandStream[5] * 256;
   Coverage_Range_SAd2 = commandStream[6] + commandStream[7] * 256;
   Coverage_Range_DAd2 = commandStream[8] + commandStream[9] * 256;
   Coverage_Range_SAd3 = commandStream[10] + commandStream[11] * 256;
   Coverage_Range_DAd3 = commandStream[12] + commandStream[13] * 256;
   Coverage_Range_SAd4 = commandStream[14] + commandStream[15] * 256;
   Coverage_Range_DAd4 = commandStream[16] + commandStream[17] * 256;
   if (bBank == 1) {
      Coverage_Bank[1] = commandStream[26] - 6;   // because bCurBank is 0~3.
      Coverage_Bank[2] = commandStream[28] - 6;
      Coverage_Bank[3] = commandStream[30] - 6;
      Coverage_Bank[4] = commandStream[32] - 6;
   }
   Coverage_Flg = 1;
   temp2 = start_EP( &commandStream[18] );
   TransmitBuf[0] = temp2;
}

U8 chkBankType (U8 i, U8 j) {
   if (bBank == 1) {
      if ((i > 5) && (i < 10)) {
         nBank_Set(i - 5);
         j = 1;
      } else {
         if (i == 1) {
            nBank_Set(bSelBank);
         }
      }
   }
   if (j > 5) j = 1;
   return j;
}

unsigned char Set_EvAB(U16 nTmp) {
   U8 chret;
   U8 i,j,k;
   memcpy(&TransmitBuf[3],&commandStream[3],128);
   switch (commandStream[7]) {
      case 0:   // wildcard addr
      case 2:   // bit wildcard addr
         for ( i = 1; i <= chBankNo; i++ ) {
            nBank_Set(i);
            chret = Set_EventA(nTmp, &TransmitBuf[3] );
         }
         break;

      case 1:  // single and group addr
      case 0x40:
         for ( k = 6; k <= chBankNo + 5; k++) {
            j = 0;
            for (i=0; i<commandStream[45]; i++) {     //[45] is addr_count
               if (commandStream[49+i*8] == k) {     //[49]+i*8 is bank type
                  memcpy(&TransmitBuf[47+j*8],&commandStream[47+i*8],3);
                  j++;
               }
            }
            TransmitBuf[45] = j;
            if (j != 0) {
               nBank_Set(k-5);
               chret = Set_EventA(nTmp, &TransmitBuf[3] );
               if (chret != CommandExeOk) break;
            } else
            {
               nBank_Set(k-5);
               if(TransmitBuf[3] == 0) // qualify
               {
                  user1Flag = 0;
                  Event_No = 2;        // qualify
                  ClrQlf();
               } else
               {
                  user1Flag = 0;
                  Event_No = TransmitBuf[3]-1;
                  ClrEv0A();
               }
            }
         }
         break;

      case 0x10:  // range
      case 0x20:  // exclusive range
         for (i = 6; i <= chBankNo + 5; i++)
         {
            if ((i < commandStream[49]) || (i > commandStream[57]))
            {
               nBank_Set(i-5);
               if(TransmitBuf[3] == 0) // qualify
               {
                  user1Flag = 0;
                  Event_No = 2;
                  ClrQlf();
               } else
               {
                  user1Flag = 0;
                  Event_No = TransmitBuf[3]-1;
                  ClrEv0A();
               }
            }
         }

         if (commandStream[49] == commandStream[57]) {
            nBank_Set(commandStream[49]-5);
            chret = Set_EventA(nTmp, &TransmitBuf[3] );
            if (chret != 0) break;
         } else {
            if (commandStream[49] < commandStream[57]) {
               nBank_Set(commandStream[49]-5);
               TransmitBuf[55] = 0xff;
               TransmitBuf[56] = 0xff;
               chret = Set_EventA(nTmp, &TransmitBuf[3] );
               if (chret != 0) break;
               TransmitBuf[47] = 0;
               TransmitBuf[48] = 0;
               for (i=commandStream[49]+1; i<commandStream[57]; i++) {
                  nBank_Set(i-5);
                  chret = Set_EventA(nTmp, &TransmitBuf[3] );
                  if (chret != 0) break;
               }
               nBank_Set(commandStream[57]-5);
               TransmitBuf[55] = commandStream[55];
               TransmitBuf[56] = commandStream[56];
               chret = Set_EventA(nTmp, &TransmitBuf[3] );
               if (chret != 0) break;
            }
         }
         break;

      default:
         chret = 8;
         break;
   }
   return chret;
}


U8 Mem_Operate(void) {
   U8 i,j,k,chRet,chLen;
   U32 nChkSum;

   if((bpodModel == 2) && (commandStream[1] == 2)) {
      return ParaError;
   }
   Set_TPort();
   nChkSum = 0;
// memcpy(&TransmitBuf[10], &commandStream[1],0x106);
   if ((bBank != 1) && (commandStream[4] != commandStream[1]))
   {
      commandStream[4] = commandStream[1] ;
   }
   memcpy(&TransmitBuf[10], &commandStream[1],6);
   for (i = commandStream[1] ; i <= commandStream[4] ; i++) {
   memcpy(&TransmitBuf[16], &commandStream[7],0x100);
      if (bBank == 1) {
         if (i < commandStream[4]) {
            commandStream[5] = 0xff;
            commandStream[6] = 0xff;
         }
         if (i > commandStream[1]) {
            commandStream[2] = 0;
            commandStream[3] = 0;
         }
         if (i == commandStream[4]) {
            commandStream[5] = TransmitBuf[14];
            commandStream[6] = TransmitBuf[15];
         }
         commandStream[1] = i;
      } else {
         i = commandStream[4];
      }
      Set_TPort();         // new koo 4/46/97 for fill over bank and jump
                           // register error
      commandStream[1] = chkBankType(commandStream[1],commandStream[1]);
      switch (commandStream[0]) {
      case MEM_CHECKSUM :
         chRet = CheckSum( &commandStream[1] );
         if (chRet != 0) {
            TStreamLen = 1;
            return chRet;
         }
         nChkSum = TransmitBuf[1] + TransmitBuf[2] * 256 + nChkSum;
         TransmitBuf[1] = nChkSum & 0x00ff;
         TransmitBuf[2] = nChkSum / 256;
         TStreamLen = 3;
         break;

      case MEM_FILL :
         chLen = commandStream[7];
         // 3/17/97  for "fill p0:ffff p1:3 1 2 3 4 5" error.
         nChkSum = (U32) (commandStream[5]) + (U32) (commandStream[6]) * 256 + 1
                 - (U32) (commandStream[2]) - (U32) (commandStream[3]) * 256 ;
         if (nChkSum < (U32) commandStream[7])  // 3/17/97
         {
            commandStream[7] = (U8) nChkSum;
         }
         chRet = Fill_Mem( &commandStream[1] );
         if (chRet != 0)
         {
            TransmitBuf[1] = i;
            if (chRet == MemWrFail)
            {
               TransmitBuf[0] = MemWrFail;
               TransmitBuf[2] = bAddrL;
               TransmitBuf[3] = bAddrH;  // Fill memory failure address
               TStreamLen = 4;
            }
            return chRet;
         }
         commandStream[7] = chLen;  // 3/17/97
         if (i < commandStream[4]) {
            j = nChkSum % commandStream[7] ;
            k = commandStream[7] - j;
            if (j != 0) {
               memcpy(&commandStream[8], &TransmitBuf[17+j], k);
               memcpy(&commandStream[8+k], &TransmitBuf[17], j);
            }
         }
         break;

      case MEM_TEST :
         chRet = Tst_Mem( &commandStream[1] );
         if (chRet != 0)
         {
            TransmitBuf[1] = i;
            return chRet;
         }
         break;

      case MEM_SEARCH :
//       if (i == commandStream[4]) {
            commandStream[5] = commandStream[5] + 1;
            if( commandStream[5] == 0 ) commandStream[6] = commandStream[6] + 1;
//       }
         TStreamLen = 4;
         chRet = Srch_Mem( &commandStream[1],&TransmitBuf[1] );
         if ((chRet == 0) && (TransmitBuf[1] == 1))
         {
            TransmitBuf[1] = i;
            return chRet;
         }
         break;

      }
      RestorePort();       // new koo 4/46/97 for fill over bank and jump
                           // register error
   }
   return 0;
}

