
/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/
/****************************************************************************
**
**  Name:         RS232.C
**
**  Description:
**
**  Status:
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <reg51.h>

#define  LEAD_CODE   ':'
#define  REC_OK      0x55
#define  REC_FAIL    0xAA
#define  ACK         0x5A
#define  NACK        0xA5

extern bit TimerOut;

extern unsigned char transmit_Data ;
extern unsigned char serialBaudrate;
extern unsigned char diagnostic_flag ;
extern unsigned char spa_flag;
extern unsigned int delay ;

extern void SerialSelectBaudrate(void);
extern unsigned char SerialReceiveByte(void);
extern void SerialTransmitByte(void);
extern void Ini_rs232_buf(void);
extern unsigned char Rs232_check_buf(void);
extern void *memcpy(void *,void *,int );

extern unsigned char chksum;


extern unsigned int TStreamLen;
extern unsigned int RStreamLen;
extern unsigned int commandStreamLen;
extern unsigned char commandStream[512];
extern unsigned char receiveBuf[512];
extern unsigned char TransmitBuf[2048];

unsigned int SerialTimCount;
void SerialReceiveStream(void);
void SerialTransmitStream(void);
void  SerialHandShake( void);
void rec_fail_service(void);

/****************************************************************************
**
**  ReceiveStream
**
**  Description: Receive data from communication and check the length and
**               checksum, the data format is :       XXXXxxx....xxxX
**                                                  length   data   checksum
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
void SerialReceiveStream(void)
{
register unsigned int lp;
unsigned char aa[4];
RStreamLen = 0;
chksum = 0;
while(1){
          aa[0] = 0;
          aa[1] = 0;
          aa[2] = 0;
          aa[3] = 0;
          TimerOut = 0;

          SerialTimCount = 0;
//-----------------------------------------------------------------------
//             receive '?'  from    ABI
//             if a '?' has been received then transmit a '!' to ABI
//             and continue to receive '?' until a ':' has been received
//             if timerout then clear time counter and continue receive '?'
//------------------------------------------------------------------------
           while (1)
           {
            if(Rs232_check_buf() == 1)
              {
               aa[0] =  SerialReceiveByte();
               if (aa[0] == '?')
                       {
                        Ini_rs232_buf( );
                        transmit_Data = '!' ;
                        SerialTransmitByte();
                        continue;
                        }
               if( aa[0] == LEAD_CODE ) break;
              }
          }
//--------------------------------------------------------------------------
//                 end of receive '?'
//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
//         receive head  from  ABI
//         aa[0] store LEAD_CODE
//         aa[1] store Data Length High
//         aa[2] store Data Length Low
//         aa[3] store chksum
//         aa[0] + aa[1] + aa[2] + aa[3] == 0
//-------------------------------------------------------------------------
           lp = 1;
           while( lp < 4 )
                {
                 if(Rs232_check_buf() == 1) {
                       aa[lp] = SerialReceiveByte();
                       SerialTimCount = 0;
                       lp++;
                       }
                  else {
                       SerialTimCount += 1;
                       if (SerialTimCount >= 0x2800) TimerOut = 1;
                       }
                 if ( TimerOut )
                      {
                       transmit_Data = '$' ;
                       SerialTransmitByte();
                       break;
                       }
                 }//receive four
           if (TimerOut) continue;
           for (lp = 1; lp < 4; lp++) chksum += aa[lp];
           if ((aa[0] == LEAD_CODE) && (chksum == 0)) // command length.
              {
               RStreamLen =(unsigned int)aa[2] * 256 + aa[1];
              transmit_Data =REC_OK ;
              SerialTransmitByte();
               }
           else
               {
               transmit_Data =REC_FAIL ;
               SerialTransmitByte();
               rec_fail_service();
               }
          if (TimerOut) continue;

//-----------------------------------------------------------------------------
//             receive  recoder
//----------------------------------------------------------------------------
         while(1)
              {

//-----------------------------------------------------------------------------
//             receive ':' before a recoder
//----------------------------------------------------------------------------
               while(1){
                     if(Rs232_check_buf() == 1) {
                            aa[0] = SerialReceiveByte();
                            SerialTimCount = 0;
                            if (aa[0] == LEAD_CODE) break;
                            }  
                  else {
                       SerialTimCount += 1;
                       if (SerialTimCount >= 0x2800) TimerOut = 1;
                       }
                     if ( TimerOut ) break;
                     }
               if ( TimerOut )  break;
//----------------------------------------------------------------------------
//              end of receive ':' before a recoder
//----------------------------------------------------------------------------
//
//----------------------------------------------------------------------------
//             receive recoder
//----------------------------------------------------------------------------
               chksum = 0;               
               SerialTimCount = 0;
               for (lp = 0; lp < RStreamLen; lp++) {
                     while(1){
                          if(Rs232_check_buf() == 1) {
                                  receiveBuf[lp] = SerialReceiveByte();
                                  SerialTimCount = 0;
                                  break;
                                  }

                           else {
                                SerialTimCount += 1;
                                if (SerialTimCount >= 0x2800) TimerOut = 1;
                                }
                          if ( TimerOut )
                                  {
                                   transmit_Data ='$';
                                   SerialTransmitByte();
                                   break;
                                   }
                          }
                     if ( TimerOut ) break;
                    }//for
              if ( TimerOut ) break;
              SerialTimCount = 0;//by john
//----------------------------------------------------------------------------
//             receive all of the recoder and chksum the recoder
//----------------------------------------------------------------------------
              for (lp = 0; lp < RStreamLen; lp++) {
                   chksum += receiveBuf[lp];
                   }
              if (chksum == 0) {    // The End of ReceiveBuf char is Data checksum
                   memcpy(commandStream,&receiveBuf[0],RStreamLen);
                   commandStreamLen = RStreamLen;
                   transmit_Data =ACK;
                   SerialTransmitByte();

                   return;
                   }
              else {
                   transmit_Data =NACK;
                   SerialTransmitByte();
                   continue;
                   }    
//----------------------------------------------------------------------------
//             end of receive recoder
//----------------------------------------------------------------------------
            } //   end of receive recoder
            
      }    //   end of receive stream biggest while
      
}      //  end of routine


//----------------------------------------------------------------------
//      rec_fail_service(void)
//----------------------------------------------------------------------
void rec_fail_service(void)
{
   unsigned char lp;
   unsigned char aa[4];
   transmit_Data =REC_FAIL;
   SerialTransmitByte();
   TimerOut = 0;
   SerialTimCount = 0;
   while(1)
         {
              while(1)
                   {
                    if(Rs232_check_buf() == 1)
                          {
                           SerialTimCount = 0;
                           aa[0] =  SerialReceiveByte();
                           if (aa[0] != LEAD_CODE ) continue;
                           TimerOut = 0;
                           break;
                           }

                    else {
                          SerialTimCount += 1;
                          if (SerialTimCount >= 0x2800) TimerOut = 1;
                         }
                     if(TimerOut) return;
                     }

              lp = 1;
              TimerOut = 0;
              while( lp < 4 )
                   {
                    if(Rs232_check_buf() == 1) {
                            SerialTimCount = 0;
                            aa[lp] = SerialReceiveByte();
                            TimerOut = 0;
                            lp++;
                            }
                    else {
                          SerialTimCount += 1;
                          if (SerialTimCount >= 0xfff0) TimerOut = 1;
                         }
                    if ( TimerOut ) return;
                    }//receive four
              chksum = 0;
              for (lp = 1; lp < 4; lp++) chksum += aa[lp];
                   if ((aa[0] == LEAD_CODE) && (chksum == 0)) // command length.
                      {
                       RStreamLen =(unsigned int)aa[2] * 256 + aa[1];
                       transmit_Data =REC_OK;
                       SerialTransmitByte();
                       TimerOut = 0;
                       return;
                       }
              transmit_Data =REC_FAIL;
              SerialTransmitByte();
              TimerOut = 0;
       }

 }

//---------------------------------------------------------------------------
//    end of  head_fail routine
//---------------------------------------------------------------------------
       
/****************************************************************************
**
**  SerialHandShake
**
**  Description: RS232 Communication hand shake
**               Receive 'EPSLD' from ABI
**               and then transmit 'EPSLD' to ABI.
**
*****************************************************************************/

void SerialHandShake (void)
{
  unsigned char aa,i;
//code unsigned char bb[]="PICPack";
  code unsigned char bb[]="EPSLD";


   for (i=0;i<5;i++) {
        SerialTimCount =0;

	while (1) {
              SerialTimCount ++ ;
	      if(Rs232_check_buf() == 1)  {
                    aa =  SerialReceiveByte();
                    SerialTimCount = 0;
                    if (aa=bb[i]) break; // break while(1).
                    else i = 0xff;
		    }
              if (SerialTimCount >= 0x2800)  {
//               SerialCpIni();
                 if (serialBaudrate>1) serialBaudrate=1;
                 SerialSelectBaudrate();
                 i=0xff;
		 break; // break while(1).
		 }
	      } // end while(1)
	} // end for

   for (i=0;i<5;i++) {
        transmit_Data = bb[i];
        SerialTransmitByte();
	}
   return;
} // end SerialHandShake.

//================================================================
//    The End of SerialHandShake.
//================================================================




/****************************************************************************
**
**  SerialTransmitStream
**
**  Description: Transmit data(length + data + checksum) to
**               communication port.
**               the data format is :  XXXXxxx....xxxX
**                                   length   data   checksum
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
/*
   Transmit data(length + data + checksum) to communication port.
   the data format is : LENGTH(2 bytes)DATA(number of length)CHECKSUM(1 byte)
*/
void SerialTransmitStream(void) {

register unsigned int lp;
unsigned char highLen,lowLen,aa;

   chksum = 0;
   for (lp = 0; lp < TStreamLen; lp++)
   {
      chksum += TransmitBuf[lp];
   }
   TransmitBuf[TStreamLen] = ( unsigned char )(~chksum+1);
   TStreamLen++;

   highLen = (unsigned char)(TStreamLen/256);
   lowLen =  (unsigned char) TStreamLen;
   chksum = (unsigned char) (~(lowLen+highLen) ) + 1;
//--------------------------------------------------------------------------
//        begin to transmit a stream
//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
//        transmit '?' to ABI
//        and receive 100 times if  a '!' have receive then break
//-------------------------------------------------------------------------

     TimerOut = 0;

     SerialTimCount = 0;
     while(1)
          {
           transmit_Data ='?';
           SerialTransmitByte();
           aa=0;
           for(lp=0;lp<100;lp++){
                  if(Rs232_check_buf() == 1) {
                      aa =  SerialReceiveByte();
                      SerialTimCount = 0;
                      if (aa == '!')  break;
                      }
              else {
                    SerialTimCount += 1;
                    if (SerialTimCount >= 0x2800) TimerOut = 1;
                   }
                  if (TimerOut) return;
                  }
           if (aa == '!') break;
           }
//-------------------------------------------------------------------------
//        a '!' has been received end transmit '?' to ABI
//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
//        begin to transmit head
//        LEAD_CODE   ':'
//        Data Length High
//        Data Length Low
//        chksum
//------------------------------------------------------------------------

     TimerOut = 0;

     SerialTimCount = 0;
     while(1)
          {

           transmit_Data =LEAD_CODE;
           SerialTransmitByte();
           transmit_Data =lowLen;
           SerialTransmitByte();
           transmit_Data =highLen;
           SerialTransmitByte();
           transmit_Data =chksum;
           SerialTransmitByte();
           while(1){
                 if(Rs232_check_buf() == 1) {
                        aa =  SerialReceiveByte();
                        SerialTimCount = 0;
                        if (aa == '?')  continue;
                        if (aa == REC_OK) break;
                        if (aa == REC_FAIL) break;
                        if (aa == '$') return;
                        }
              else {
                    SerialTimCount += 1;
                    if (SerialTimCount >= 0x2800) TimerOut = 1;
                   }

                  if (TimerOut)  return;
                 }
          if (aa == REC_FAIL) continue;
          if (aa == REC_OK) break;
          }
//--------------------------------------------------------------------------
//        end of transmit  head
//--------------------------------------------------------------------------

     TimerOut = 0;

     SerialTimCount = 0;
     while(1)
          {
           transmit_Data =LEAD_CODE;
           SerialTransmitByte();
           for (lp = 0; lp < TStreamLen; lp++)
              {
                transmit_Data =TransmitBuf[lp];
                SerialTransmitByte();
              }
           while(1){
                if(Rs232_check_buf() == 1) {
                       aa =  SerialReceiveByte();
                       SerialTimCount = 0;
                       if (aa == '?')  continue;
                       if (aa == ACK) return;
                       if (aa == '$') return;
                       if (aa == NACK) break;
                       }
              else {
                    SerialTimCount += 1;
                    if (SerialTimCount >= 0x2800) TimerOut = 1;
                   }
                if (TimerOut)  return;
                }
           if (aa == NACK) continue;
         }
}

