
/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/
/****************************************************************************
**
**  Name:       xfwcmd.h
**
**  Description:
**
**  Status:
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
*****************************************************************************/
/* Reset Command*/
#define EP_RESET        0x00
#define EP_START        0x01
#define EP_HALT         0x02
#define DIAGNOSTIC      0x03
#define CPU_SELECT      0x04
#define CONTROL_GET     0x05
#define CONTROL_SET     0x06
#define TIMER_INI       0x07
#define PORT_SET        0x08
#define PORT_OUT        0x09
#define PORT_IN         0x0a
#define VERIFY_SET      0x0b
#define TRIG_STATUS_SET 0x0c
#define TRIG_LEVEL_SET  0x0d
#define TRIG_LOGIC_SET  0x0e
#define CPU_GET         0x0f
/* Memory Commands */

#define MEM_CHECKSUM    0x10
#define MEM_COMPARE     0x11
#define MEM_COPY        0x12
#define MEM_DOWNLOAD    0x13
#define MEM_FILL        0x14
#define MEM_READ        0x15
#define MEM_SEARCH      0x16
#define MEM_TEST        0x17
#define MEM_WRITE       0x18
#define MEM_UPLOAD      0x19
#define TRIG_GET        0x1a
#define BANK_INI        0x1b
#define BANK_GET        0x1c
#define SEL_BANK        0x1d
#define SEL_PCBANK      0x1e

#define REG_GETLEN      0x1f
#define REG_GETALL      0x20
#define REG_GETONE      0x21
#define REG_MODIFY      0x22
#define FWID_GET        0x23
#define MHZ_GET         0x24
#define EPROM_INI       0x25
#define EPROM_FUNC      0x26
#define TIMER_GET       0x27

#define MAP_GET         0x31
#define MAP_SET         0x32
#define BP_SET          0x33
#define BP_CLR          0x34
#define BP_QUERY        0x35

#define COVERAGE_GO     0x38
#define COVERAGE_GET    0x39
// reserved             0x3a
#define SPA_BP_SET      0x3b
#define ENTRY_GET       0x3c
#define SPA_TIME_GET    0x3d

#define STEP_ONE        0x40
#define STEP_OVER       0x41
#define STEP_CYCLE      0x42
#define STATUS_GET      0x43
#define STEP_RANGE      0x44
#define STEPOVER_RANGE  0x45
#define HAND_SHAKE      0x46

#define EP_SUPPORT_GET  0x47
#define FW_SUPPORT_GET  0x48

#define ECB_ID_GET      0x49

#define EVENT_SET       0x50
#define EVENT_CLR       0x51
#define EVENT_GET       0x52

// reserved             0x55
// reserved             0x5a

#define TRACE_INI       0x58
#define TRACE_READ      0x59
#define LASTFRAME_GET   0x5a
#define TRACE_C_READ    0x5B

#define FLASH_SWITCH    0x60
#define FLASH_ERASE     0x61
#define FLASH_PROG      0x62

#define DIAG_TEST       0x70
#define FW_TESTINC      0x71
#define FW_TESTdia      0x72
// serial communication
#define SELECT_BAUDRATE 0x74
// in system programming command:
#define FW_HIDDEN_COM   0x80
#define ISP_RECIEVE_DATA 0x90
#define ISPLSIXXXX_CMD  0x91
#define Get_ispLSI_UES  0x92


//for EA to detail set the HW and the check it
// reserved             0xa5
// reserved             0xaa


typedef struct {
        ADRSTRUCT startaddr;
        ADRSTRUCT endaddr;
        } MEMRANGE,*PMEMRANGE;

typedef struct  {
        MEMRANGE MemRange;
        U8 DataLen;
        U8 NewData[128]; //Maxmun data length is 128 bytes
        } *MdfyMemPtr;

typedef struct {
        PACKWORD adrType;
        U8 startAdr[8];
        U8 bytesLen[8];
        PACKWORD opSize;
} MEMOPRANGE, *PMEMOPRANGE;

typedef struct {
        U8 numb;
        U16 cpuname1[10];
        U16 cpuname2[10];
        U16 cpuname3[10];
        U16 cpuname4[10];
} FWSUPPORT;


/*
typedef enum
        {
        CommandExeOk,
        CommandExeFail,
        TargetCanotStep,
        NotFound,
        BPFound,
        EPRunning,
        MemWrFail,
        MapStatusInC,
        MapInAddrNotBnd
        }RETCODE;
*/

#define  LEAD_CODE   ':'
#define  REC_OK      0x55
#define  REC_FAIL    0xAA
#define  ACK         0x5A
#define  NACK        0xA5

#define  CommandExeOk       0x00
#define  TargetCanotStep    0x01
#define  MemWrFail          0x02
#define  MapStatusInC       0x03
#define  MapInAddrNoBnd     0x04
#define  BpNotFound         0x05
#define  BpFound            0x06
#define ParaError           0x08
#define CommunicationErr    0x07
#define  RangeStepHalt      0x09
#define  EpRunning          0x10
#define  TraceRunning       0x11
#define  TraceRDOver        0x12
#define  CmdInvalid         0x13

#define  BankIniErr         0x20
#define  BankSelErr         0x21
#define  BankGetErr         0x22

#define  FlashSWErr         0x40
#define  FlashECErr         0x41
#define  FlashPRGErr        0x42
#define  FlashRECErr        0x43

