
/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/
/****************************************************************************
**
**  Name:         xfwcom1.c
**
**  Description:
**
**  Status:
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
*****************************************************************************/

#include "basetype.h"
#include "xfwcmd.h"

extern xdata U8 bCtrl0;
extern xdata U8 LDCTRL0    ;
extern xdata U8 bStatus1A   ;
extern xdata U8 timerLow_3;
extern xdata U8 EvQfStatus; // bit0: Qualify status. 0:dis. 1:en
                                // bit1: Ev1 status
                                // bit2: Ev2 status
extern xdata U8 Ev1Buffer[0x80];
extern xdata U8 Ev2Buffer[0x80];
extern xdata U8 QlfBuffer[0x80];
extern unsigned char podModel;
extern unsigned char regBuf;
extern U8 commandStream[512];
extern U8 TransmitBuf[2048];
extern U16 TStreamLen;
extern xdata U16 traceCnt;
extern xdata U16 STATUS;   // bit 4~6 = 4 EP running (BIT 6 = 1)
extern xdata U16 epMode;
extern xdata U16 epModeTMP;
extern data U8 bpodModel;
extern data U8 bAddrH,bAddrL;
extern data unsigned char SysTst;
extern data unsigned char BR_OVER;
extern bit fw_verify;
extern bit Bank_Reg_flg;
extern bit Coverage_Flg;
extern bit getTraceCnt;
extern bit epRunFlag;
extern bit goRunFlag;
extern bit ontheflyflg;
extern U8 bBank;
extern U8 bBankType;
extern U8 bBankPort;
extern U8 bADRBIT16;
extern U8 bADRBIT17;
extern U8 bCurBank;
extern U8 chCurPort;
extern U8 bSelBank;
extern U8 chPortTmp;
extern U8 bBankTmp;
extern U8 chBankNo;
extern U8 Coverage_Bank[5];
extern U8 onTheFlyBuf;
/**************************************************/
//extern void OnTheFlyStart(void);
//extern void ChkOnTheFly(void);
extern void GetRegister(void) ;
extern unsigned char nBank_Set( U8 i ) ;
extern void RestorePort(void);
extern U8 Set_EventA(U16,U8 *);
extern void Get_CurBank(void);
extern U8 Mem_Operate(void);
extern void GetPort(void);
extern U8 CheckBank(void);
extern U8 Analyse_Coverage(void);
extern U8 EpSupport(void);
extern void *memcpy(void *,void *,int );
extern void set_cpu_model(void);
extern void CycleStep(void);
extern U8 start_EP( U8 *);
extern void sysini(void);
extern U8 Init_Ep( U8 *);
extern U8 Transparent_Cmd( U8,U8);
                                    // ID          , VALUE
                                    // 0:EA,1:RESET, 0:OFF,1:ON
extern void go_trace(void);
extern U8 Set_EventB(U16, U8 *);
extern U8 Clr_Event(U16, U16);
extern U8 Select_Port( U16 );
extern U8 Output( U8 *);
extern U8 Input( U8 *, U8 *);
                          /* port ID         data save */
extern U8 Set_Verify( U8 );
extern U8 Set_Trig_Status( U8 );
extern U8 Set_Trig_Level( U8 * );
extern U8 Set_Trig_Logic( U8 * );

/* Event Routine */
extern U8 Ini_Timer(U8); /* 0 OFF 1 ON */

extern U8 GetCTraceBuf( U8,  U8 );
extern U8 CheckTraceRun(U8 *); // 0. Trace is not RUNNING.
                          // 11. Trace is RUNNING.  char * to qualify.
extern U8 GetTraceBuf( U16,  U16,  U16,  U8 *, U8 *);
                           // RdDirect,   StartFrame,    EndFrame,      *PQUALIFY,       TraceSaveBuf
/* Memory operation Routine */
extern U16 CheckSum( U8 *); // checksum value saved in
                                                // TransmitBuf+1 directly
extern U8 Cmp_Mem( U8 *,U8 *);
                           // input.          // output: PADRSTRUCT.
extern void Comp_MemB( void);

extern U8 Copy_Mem ( U8 * );
extern U8 Copy_MemB(void);
extern U8 Fill_Mem( U8 *MdfyMemPtr );
extern U8 Read_Mem( U8 *, U8 * );
extern U8 Srch_Mem( U8 *,U8 *);
                           // input.         // output: PADRSTRUCT.
extern U8 Tst_Mem( U8 *);
extern U8 Get_A_Reg( unsigned short,void *);
extern U8 Modify_Reg( U8 *);
extern U8 Get_Map( U8 *,U8 *);
extern U8 Set_Map( U8 *);
extern U8 Set_ExBp( U8 * );
extern U8 Clr_ExBp( U8 * );
extern U8 Query_ExeBp( U8 *,U8 *,U8 *);
//                                  start addr     End addr        result addr
extern U8 Clr_Ev_ExBp_all(void);
extern U8 SetExBp( U8 * );
extern U8 Inst_Step(void);
extern U8 Call_Step(void);
extern U8 Get_Control( U8 ); // Control ID
extern unsigned char ChkBr_Over( void );
extern unsigned char RstEp( void );
extern unsigned char T_CANEND( void );
extern unsigned char T_ENDSP( void );
extern unsigned char T_CPURUN( void );
extern unsigned char T_TADDRH( void );
extern unsigned char T_CANRUN( void );
extern unsigned char T_GETREG( void );
unsigned char T_TSTMEM( void );
extern unsigned char T_BREAKPNT( void );
extern unsigned char T_TRACE( void );
extern unsigned char T_QUALIFY( void );
extern unsigned char T_EV_CHK( void );
extern unsigned char T_AK( void );

extern unsigned char Stop_Ep( void );
extern unsigned char ClrTraceCnt(void);
extern unsigned char ClrElTimerMsg( void );
extern U8 chkBankType (U8,U8);
extern unsigned char Set_EvAB(U16);
extern void Set_TPort(void);

#define ENTRACE         0x10
U8 temp1,temp2;
U8 Coverage_Range_No;
U8 Code_Access_No;
U16 Coverage_Range_SAd1;
U16 Coverage_Range_DAd1;
U16 Coverage_Range_SAd2;
U16 Coverage_Range_DAd2;
U16 Coverage_Range_SAd3;
U16 Coverage_Range_DAd3;
U16 Coverage_Range_SAd4;
U16 Coverage_Range_DAd4;
U16 Code_Access_Range_SAd[17];
U16 Code_Access_Range_DAd[17];
U16 Frame_No[60];
U16 Frame_adr[60];
U8  Frame_port[60];
void ProcessCommand1(void);

void ChkCopyType(void)
{
   if (commandStream[1] > 5)
   {
      if (commandStream[7] > 5)
      {
         if (commandStream[7] == commandStream[1])
         {
            commandStream[7] = 1;
            commandStream[1] = chkBankType(commandStream[1],commandStream[1]);
         }
      }
      else
      {
         commandStream[1] = chkBankType(commandStream[1],commandStream[1]);
      }
   }
   else
   {
      if (commandStream[7] > 5)
      {
         commandStream[7] = chkBankType(commandStream[7],commandStream[7]);
      }
   }
}

void ChkOnFly(void)
{
  if ((bBank == 1) && (epRunFlag == 1) && (goRunFlag == 1)) {
     ontheflyflg = 1;
//     ChkOnTheFly();
     Stop_Ep();
  }
}
void OnFlyStart(void)
{
   if (ontheflyflg == 1) {
//      OnTheFlyStart();
      commandStream[20] = 1;
      commandStream[22] = 0;
      commandStream[25] = 0;
      start_EP(&commandStream[20]);
      ontheflyflg = 0;
   }
}

void ProcessCommand1(void) {
   U8 retvalue, i;
   U16  retvalue16;
   U16 NumBer;
   unsigned short arg16;
   U16 Int1,Int2,Int0;
   U16 Int4,Int5,Int3;

   switch ( commandStream[0] ) {
      case EP_SUPPORT_GET :
         retvalue = EpSupport();
         TransmitBuf[1] = retvalue;
         TransmitBuf[2] = 0;
         TStreamLen = 1 + 2 + retvalue*2;

         break;

      case CPU_SELECT :
 epMode = (U16)commandStream[1] + (U16)(commandStream[2]*256);
         set_cpu_model();

      case CPU_GET :
//       TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = (U8) ( epModeTMP & 0xff );
         TransmitBuf[2] = (U8) ( epModeTMP / 256 );
         TStreamLen = 3;
         break;

      case EP_START :
         if(commandStream[1] == 1) {
            epRunFlag = 1;
            CycleStep();
            epRunFlag = 0;
         }
         TransmitBuf[0] = start_EP( &commandStream[1] );
         break;

      case EP_RESET :
         if(commandStream[1] == 0x10) {
            sysini();
            commandStream[1] = 0;
         }
         TransmitBuf[0] = Init_Ep( &commandStream[1] );
         if ((bBank == 1) && (commandStream[1] != 0)) {
            Bank_Reg_flg = 1 ; // to change bank and register P?.
            commandStream[1] = chkBankType(commandStream[1],commandStream[1]);
            Get_CurBank();
            GetRegister();
            Bank_Reg_flg = 0 ;
         }
         Get_CurBank();
         break;

      case CONTROL_SET :
            if( STATUS & 0x40 ) retvalue = EpRunning;
            else
         retvalue = Transparent_Cmd( commandStream[1], commandStream[2] );
            TransmitBuf[0] = retvalue;
         break;

      case CONTROL_GET :
            retvalue = Get_Control( commandStream[1] );
            TransmitBuf[0] = CommandExeOk;
            TransmitBuf[1] = retvalue;
            TStreamLen = 2;
         break;

      case LASTFRAME_GET :
         if( getTraceCnt == 1)
         {
            TransmitBuf[0] = CommandExeOk;
            TransmitBuf[1] = (U8)( traceCnt & 0xff );
            TransmitBuf[2] = (U8)( traceCnt /256 );
         } else {
            retvalue = (bCtrl0 & 0x10);
            if( retvalue != CommandExeOk )
            {
               go_trace();
            }
            if(getTraceCnt == 0)
            {
               bCtrl0 = bCtrl0 | ENTRACE ; // disable trace writing
               LDCTRL0 = bCtrl0 ;
               getTraceCnt = 0;
               TransmitBuf[0] = TraceRunning;
//               TransmitBuf[0] = CommandExeOk;
               TransmitBuf[1] = 0;
               TransmitBuf[2] = 0;
            } else {
               TransmitBuf[0] = CommandExeOk;
               TransmitBuf[1] = (U8)( traceCnt & 0xff );
               TransmitBuf[2] = (U8)( traceCnt /256 );
            }
         }
         TStreamLen = 3;
         break;

      case EVENT_SET :
         retvalue16 = (U16)(commandStream[1]) + (U16)(commandStream[2])*256;
         retvalue = Set_EventB( retvalue16, &commandStream[3] ); // others
         if (retvalue == CommandExeOk) {
            if (bBank == 0) {
               retvalue = Set_EventA(retvalue16, &commandStream[3] ); // address
            } else {
               Set_TPort();  // koo temp
               retvalue = Set_EvAB(retvalue16);
               RestorePort();
            }
         }
         TransmitBuf[0] = retvalue;
         if( retvalue == CommandExeOk )
         {
            if(commandStream[3]==0)
            {
               memcpy(QlfBuffer,&commandStream[1],0x80);
               EvQfStatus = EvQfStatus | 0x1;
            };
            if(commandStream[3]==1)
            {
               memcpy(Ev1Buffer,&commandStream[1],0x80);
               EvQfStatus = EvQfStatus | 0x2;
            };
            if(commandStream[3]==2)
            {
               memcpy(Ev2Buffer,&commandStream[1],0x80);
               EvQfStatus = EvQfStatus | 0x4;
            };

         }

         break;

      case EVENT_CLR :
         if (bBank == 1) {
            Set_TPort();  // koo temp
            for (i = 1; i <= chBankNo; i++ ) {
               nBank_Set(i) ;
               retvalue = Clr_Event( (U16)(commandStream[1]+commandStream[2]*256),
                               (U16)(commandStream[3]+commandStream[4]*256) );
            }
            RestorePort();
         } else {
            retvalue = Clr_Event( (U16)(commandStream[1]+commandStream[2]*256),
                               (U16)(commandStream[3]+commandStream[4]*256) );
         }
            TransmitBuf[0] = retvalue;
            if ( retvalue == 0 && ( commandStream[3] >= commandStream[1] ) )
            {
               switch( commandStream[1] ) {
                  case 0 : EvQfStatus = EvQfStatus & 0xfe;
                           if( commandStream[3] == 1 )
                           EvQfStatus = EvQfStatus & 0xfd;
                           if( commandStream[3] == 2 || commandStream[3] == 3)
                           EvQfStatus = EvQfStatus & 0xfd &0xfb;
                           break;
                  case 1 : EvQfStatus = EvQfStatus & 0xfd;
                           if( commandStream[3] == 2 || commandStream[3] == 3)
                           EvQfStatus = EvQfStatus & 0xfb;
                           break;
                  case 2 : EvQfStatus = EvQfStatus & 0xfb;
                           break;
                  default:
                           break;
               }


            }
         break;

      case PORT_SET :      // ABI --> FW port is 2 bytes. here skip high byte
         retvalue16 = commandStream[1] + (U16) commandStream[2] * 256;
         retvalue = Select_Port( retvalue16 );
            TransmitBuf[0] = retvalue;
   // retcode : CommandExeOk,TargetCanotStep,ParaError

         break;

      case PORT_OUT :
         retvalue = Output( &commandStream[1] );
            TransmitBuf[0] = retvalue;

         break;

      case PORT_IN :
         retvalue = Input( &commandStream[1], &TransmitBuf[1] );
            TransmitBuf[0] = retvalue;
            TransmitBuf[2] = 0;
            TStreamLen = 3;

         break;
      case VERIFY_SET :
// 0 OFF,   1 ON
         retvalue = Set_Verify( commandStream[1] );
            TransmitBuf[0] = retvalue;
         break;
      case TRIG_STATUS_SET :
// 0 disable 1 enable
         retvalue = Set_Trig_Status( commandStream[1] );
            TransmitBuf[0] = retvalue;
         break;
      case TRIG_LEVEL_SET :
         retvalue = Set_Trig_Level( &commandStream[1] );
            TransmitBuf[0] = retvalue;
         break;
      case TRIG_LOGIC_SET :
         retvalue = Set_Trig_Logic( &commandStream[1] );
            TransmitBuf[0] = retvalue;
         break;
      case TIMER_INI :
         retvalue = Ini_Timer( commandStream[1] );
            TransmitBuf[0] = retvalue;
         break;


      case TRACE_C_READ :
         retvalue = (bCtrl0 & 0x10);
         if( retvalue == CommandExeOk )
         {
            Code_Access_Range_SAd[0] = commandStream[4] + commandStream[5] * 256;
            Coverage_Bank[0] = commandStream[6];
            Code_Access_Range_DAd[0] = commandStream[8] + commandStream[9] * 256;
            Code_Access_Range_SAd[1] = commandStream[12] + commandStream[13] * 256;
            Coverage_Bank[1] = commandStream[14];
            Code_Access_Range_DAd[1] = commandStream[16] + commandStream[17] * 256;
            Code_Access_Range_SAd[2] = commandStream[20] + commandStream[21] * 256;
            Coverage_Bank[2] = commandStream[22];
            Code_Access_Range_DAd[2] = commandStream[24] + commandStream[25] * 256;
            Code_Access_Range_SAd[3]= commandStream[28] + commandStream[29] * 256;
            Coverage_Bank[3] = commandStream[30];
            Code_Access_Range_DAd[3] = commandStream[32] + commandStream[33] * 256;
            Code_Access_Range_SAd[4] = commandStream[36] + commandStream[37] * 256;
            Coverage_Bank[4] = commandStream[38];
            Code_Access_Range_DAd[4] = commandStream[40] + commandStream[41] * 256;

            bBankTmp = bCurBank;
            chPortTmp = chCurPort;

            TransmitBuf[0] = GetCTraceBuf( commandStream[3], commandStream[44]);

            chCurPort = chPortTmp;
            bCurBank = bBankTmp;

            TransmitBuf[1] = temp2;
            for (temp1=0;temp1<temp2;temp1++)
            {
               TransmitBuf[temp1 * 8 + 2] = Frame_No[temp1] & 0x00ff;
               TransmitBuf[temp1 * 8 + 3] = Frame_No[temp1] / 256;
               TransmitBuf[temp1 * 8 + 4] = Frame_adr[temp1] & 0x00ff;
               TransmitBuf[temp1 * 8 + 5] = Frame_adr[temp1] / 256;
               TransmitBuf[temp1 * 8 + 6] = Frame_port[temp1] ;
               TransmitBuf[temp1 * 8 + 7] = 0 ;
               TransmitBuf[temp1 * 8 + 8] = 0 ;
               TransmitBuf[temp1 * 8 + 9] = 0 ;
            }
            TStreamLen = 1 + 1 + (temp1 * 8);
         }
         else TransmitBuf[0] = retvalue;
         break;


      case TRACE_READ :
         if( getTraceCnt == 0 )
         {
            go_trace();
         }
         if(getTraceCnt == 0)
         {
            bCtrl0 = bCtrl0 | ENTRACE ; // disable trace writing
            LDCTRL0 = bCtrl0 ;
            getTraceCnt = 0;
            TransmitBuf[0] = TraceRunning;
         } else {
            retvalue = CheckTraceRun( &commandStream[9]); //July.18 Pointer to QlfyType
            if( retvalue == CommandExeOk)
            {
               Int0 = commandStream[1] + (U16)( commandStream[2] * 256 );
               Int1 = commandStream[3] + (U16)( commandStream[4] * 256 );
               Int2 = commandStream[5] + (U16)( commandStream[6] * 256 );

TransmitBuf[0] = GetTraceBuf( Int0,Int1,Int2,&commandStream[7+2],&TransmitBuf[3] );
               TStreamLen = 1 + 1 + 1 + (U16) (TransmitBuf[1] * 7);
            }
            else TransmitBuf[0] = retvalue;
         }
         break;

      case MEM_COMPARE :
         if((bpodModel == 2) && ((commandStream[1] == 2)
                  || (commandStream[7] == 2)))
         {
            TransmitBuf[0] = ParaError;
         } else {
            ChkOnFly();
            Set_TPort();  // koo temp
            memcpy(&TransmitBuf[11],&commandStream[1],6);
            ChkCopyType();
            if ((commandStream[1] > 5) && (commandStream[7] > 5))
            {
               Comp_MemB();
            }
            else
            {
               Int1 = commandStream[2] + commandStream[3]*256;   // startadr
               Int2 = commandStream[5] + commandStream[6]*256;   // endadr
   // July.10.1995  ERIC + 1
               Int1 = Int2-Int1+1;
               commandStream[6] = (U8) (Int1 / 256);
               commandStream[5] = (U8) (Int1 & 0x00ff);

               retvalue = Cmp_Mem( &commandStream[1],&TransmitBuf[1] );
               TransmitBuf[0] = retvalue;
               if ((TransmitBuf[1] == 1) && (TransmitBuf[11] > 5))
               {
                  TransmitBuf[1] = TransmitBuf[11];
               }
            }
            TStreamLen = 1 + 3;  // [1] is Src Mem type, [2],[3] is dif addr.
            RestorePort();
            OnFlyStart();
         }
         break;
      case MEM_COPY :
         ChkOnFly();
         Set_TPort();  // koo temp
         ChkCopyType();
         if((bpodModel == 2) && ((commandStream[1] == 2)
                  || (commandStream[7] == 2)))
         {
            TransmitBuf[0] = ParaError;
         } else {
            retvalue = Copy_Mem(&commandStream[1]);
         }

         if (retvalue == MemWrFail) {
            TransmitBuf[0] = MemWrFail;
            TransmitBuf[1] = 0;        // Fill memory type skip in fw
            TransmitBuf[2] = bAddrL;
            TransmitBuf[3] = bAddrH;  // Fill memory failure address
            TStreamLen = 4;
         }
         RestorePort();
         OnFlyStart();
         break;

      case MEM_DOWNLOAD:
         break;

      case MEM_READ :
         if((bpodModel == 2) && (commandStream[1] == 2))
         {
            TransmitBuf[0] = ParaError;
         } else {
            ChkOnFly();
            Set_TPort();  // koo temp
            if ((commandStream[1] > 5) && (commandStream[1] < 9)
            && (commandStream[4] == commandStream[1] + 1))
            {
               memcpy(&TransmitBuf[1],&commandStream[1],6);
               Int1 =0xffff -(U16) commandStream[2] - (U16)commandStream[3] *256
                    + 1;
               TransmitBuf[1] = chkBankType(commandStream[1],commandStream[1]);
               TransmitBuf[5] = 0xff;
               TransmitBuf[6] = 0xff;
               retvalue = Read_Mem ( &TransmitBuf[1] , &TransmitBuf[300] ) ;
               memcpy(&TransmitBuf[1],&commandStream[1],6);
               TransmitBuf[2] = 0;
               TransmitBuf[3] = 0;
//             Int2 = commandStream[5] + commandStream[6] *256 + 1;
               Int2 = commandStream[5] + 1; // there com[6] must be 0,
                                            // for Read_Mem len <= 0xff.
               TransmitBuf[1] = chkBankType(commandStream[4],commandStream[4]);
               retvalue = Read_Mem ( &TransmitBuf[1] , &TransmitBuf[600] ) ;
               memcpy(&TransmitBuf[3],&TransmitBuf[300],Int1);
               memcpy(&TransmitBuf[3+Int1],&TransmitBuf[600],Int2);
               NumBer = Int1 + Int2;
               if (TransmitBuf[0] == CommandExeOk)
               {
                  TStreamLen = NumBer + 3 ;
               }
            }
            else
            {
               commandStream[1] = chkBankType(commandStream[1],commandStream[1]);
               retvalue = Read_Mem ( &commandStream[1] , &TransmitBuf[3] ) ;

               TransmitBuf[0] = retvalue;

               if (TransmitBuf[0] == CommandExeOk)
               {
            NumBer =(U16)commandStream[5] + (U16)commandStream[6] *256
                   -(U16) commandStream[2] - (U16)commandStream[3] *256
                   + 1;
                  TStreamLen = NumBer + 3 ;
               }
            }
            TransmitBuf[1] =(U8)( NumBer & 0x00ff) ;
            TransmitBuf[2] =(U8)( NumBer /256 );

            RestorePort();
            OnFlyStart();
         }
         break;

//#if 0
      case MEM_CHECKSUM :
      case MEM_SEARCH :
      case MEM_TEST :
      case MEM_FILL :
// commandStream contents :
//    0 : CommandID
//    1 : start address MemoryType
//  2,3 : start address (lo,hi)
//    4 : end address MemoryType
//  5,6 : end address (lo,hi)
//    7 : fill data length 2
//  8,9 : fill contents
         if ((epRunFlag == 1) && (goRunFlag == 0)) {
            TransmitBuf[0] = EpRunning;
         } else {
            ChkOnFly();
            TransmitBuf[0] = Mem_Operate();
            RestorePort();
            OnFlyStart();
         }
         if (TransmitBuf[0] == MemWrFail) TStreamLen = 4;
         break;
//#endif
#if 0
      case MEM_SEARCH :
         if((bpodModel == 2) && (commandStream[1] == 2))
         {
            TransmitBuf[0] = ParaError;
         } else {
            Set_TPort();  // koo temp
            commandStream[1] = chkBankType(commandStream[1],commandStream[1]);
            commandStream[5] = commandStream[5] + 1;
            if( commandStream[5] == 0 ) commandStream[6] = commandStream[6] + 1;

            retvalue = Srch_Mem( &commandStream[1],&TransmitBuf[1] );
            TransmitBuf[0] = retvalue;
            TStreamLen = 4;
            RestorePort();
         }
         break;

      case MEM_TEST :
         if((bpodModel == 2) && (commandStream[1] == 2))
         {
            TransmitBuf[0] = ParaError;
         } else {
            Set_TPort();  // koo temp
            commandStream[1] = chkBankType(commandStream[1],commandStream[1]);
           retvalue = Tst_Mem( &commandStream[1] );
           TransmitBuf[0] = retvalue;
           if( retvalue == MemWrFail ) {
               TStreamLen = 4;
            }
//          else {
//             TStreamLen = 1;
//          }
            RestorePort();
         }
         break;

      case MEM_CHECKSUM :
            if((bpodModel == 2) && (commandStream[1] == 2)) {
               TransmitBuf[0] = ParaError;
            } else {
               Set_TPort() ; // koo temp
               commandStream[1] = chkBankType(commandStream[1],commandStream[1]);
               retvalue = CheckSum( &commandStream[1] );
               TransmitBuf[0] = retvalue;
               if ( retvalue == CommandExeOk )
               TStreamLen = 3;
               RestorePort();
            }
            break;

      case MEM_FILL :
// commandStream contents :
//    0 : CommandID
//    1 : start address MemoryType
//  2,3 : start address (lo,hi)
//    4 : end address MemoryType
//  5,6 : end address (lo,hi)
//    7 : fill data length 2
//  8,9 : fill contents
         if((bpodModel == 2) && (commandStream[1] == 2))
         {
            TransmitBuf[0] = ParaError;
         } else {
            Set_TPort();  // koo temp
            for (i = 1; i <= chBankNo; i++)
            {
               nBank_Set(i) ;
               if (commandStream[1] > 5) commandStream[1] = 1;
               retvalue = Fill_Mem( &commandStream[1] );

         switch( retvalue ) {
            case TargetCanotStep :
               TransmitBuf[0] = TargetCanotStep;
               break;
// TranmitBuf contents :
//   0 : execute result
//   1 : fill failure address type (lo,hi)
// 2,3 : fill failure address (lo,hi)
            case MemWrFail :
               TransmitBuf[0] = MemWrFail;
               TransmitBuf[1] = 0;        // Fill memory type skip in fw
               TransmitBuf[2] = bAddrL;
               TransmitBuf[3] = bAddrH;  // Fill memory failure address
               TStreamLen = 4;
               break;
            case CommandExeOk :
               TransmitBuf[0] = CommandExeOk;
               break;
            default :
               TransmitBuf[0] = CommandExeOk;
               break;
               }
            }
            RestorePort();
         }

         break;
#endif
      case MEM_UPLOAD :
         break;

      case REG_GETONE :
         if( STATUS & 0x40 ) {
            retvalue = EpRunning;
            TransmitBuf[0] = retvalue ;
//          TStreamLen = 1 ;
         } else {
         arg16 =(unsigned short) commandStream[1] ;
         retvalue = Get_A_Reg( arg16, &TransmitBuf[1] );
         TransmitBuf[0] = retvalue ;
         TStreamLen = 1 + 2 ;
         }
         break;

      case REG_MODIFY :
         ChkOnFly();
         retvalue = Modify_Reg( &commandStream[1] );
               TransmitBuf[0] = retvalue;
         OnFlyStart();
         break;

      case  MAP_GET :
         ChkOnFly();
         Set_TPort();  // koo tem
         temp1 = chBankNo*2+3;
         if (commandStream[1] > temp1)
         {
            retvalue = ParaError;
         } else
         {
            commandStream[1] = chkBankType(commandStream[1],commandStream[1]);
            retvalue = Get_Map( &commandStream[1],&TransmitBuf[1] );
            RestorePort();
            OnFlyStart();
         }
         TransmitBuf[0] = retvalue;
         if( retvalue )
         TStreamLen = 1;
         else TStreamLen = 1 + 7; //sizeof(cmdID) + sizeof(MAP_INFO)

         break;

      case  MAP_SET :
         if((bpodModel == 2) && (commandStream[1] == 2))
         {
            TransmitBuf[0] = ParaError;
         } else {
            ChkOnFly();
            if ((commandStream[1] == 2) && (bBank == 1)) {
               for (i=6;i<=chBankNo+5;i++) {
                  commandStream[1] = i;
                  Set_TPort();  // koo temp
                  commandStream[1] = chkBankType(commandStream[1],commandStream[1]);
                  commandStream[1] = 2;
                  retvalue = Set_Map( &commandStream[1] );
                  if (retvalue != 0) break;
                  RestorePort();
               }
            } else {

               Set_TPort();  // koo temp
               memcpy(&TransmitBuf[1],&commandStream[1],6);
               if ((TransmitBuf[1] < TransmitBuf[4]) && (TransmitBuf[1] > 5)
                  && (TransmitBuf[4] < 10))
               {
                  commandStream[1] = 1;
                  for (i = TransmitBuf[1];i <= TransmitBuf[4];i++)
                  {
                     nBank_Set(i-5);
                     retvalue = Set_Map( &commandStream[1] );
                  }
               } else
               {
                  commandStream[1] = chkBankType(commandStream[1],commandStream[1]);
                  retvalue = Set_Map( &commandStream[1] );
               }
               RestorePort();
            }
            OnFlyStart();
            TransmitBuf[0] = retvalue;
         }
         break;

      case BP_SET :
         ChkOnFly();
         Set_TPort();  // koo temp
         commandStream[1] = chkBankType(commandStream[1],commandStream[1]);
         retvalue = Set_ExBp( &commandStream[1] );
         RestorePort();
         OnFlyStart();
         TransmitBuf[0] = retvalue;
//       TStreamLen = 1;
         break;
      case BP_CLR :
         ChkOnFly();
         if (bBank == 1) {
            Set_TPort();  // koo temp
            if (commandStream[1] == 0) {
               for ( i = 1; i <= chBankNo; i++ ) {
                  nBank_Set(i);
                  retvalue = Clr_ExBp( &commandStream[1] );
               }
            } else {
               commandStream[1] = chkBankType(commandStream[1],commandStream[1]);
               retvalue = Clr_ExBp( &commandStream[1] );
            }
            RestorePort();
            OnFlyStart();
         } else {
            retvalue = Clr_ExBp( &commandStream[1] );
         }
         TransmitBuf[0] = retvalue;
         break;

      case BP_QUERY :   // no use (S/W called self)
         retvalue = Query_ExeBp( &commandStream[1],&commandStream[4],&TransmitBuf[1] );

         TransmitBuf[0] = retvalue;
         switch (retvalue) {
            case BpFound :
                  TStreamLen = 4;
                  break;

            case TargetCanotStep :
            case BpNotFound :
            default :
                  break;
            };
         break;
#if 0
// It's no used in EPSLD 2.09, so marked, maybe it'll be used in future.
// - koo 5/March/1997
      case STEP_RANGE :
            retvalue = CommandExeOk;
            retvalue16 = 0;
            Int3  = 0; //+ koo
            Int0 = commandStream[2] + commandStream[3] * 256; // Start addr
            Int1 = commandStream[5] + commandStream[6] * 256; // End addr
            Get_A_Reg( 0, &Int4 ); // Int4 store current PC
            Int4  = (Int4 / 256) + (Int4 & 0xff) * 256;
            Int2 =  Int4;
// Nov.16.1995 ERIC modify
            while ( !(Int2 > Int1) && !(Int2 < Int0)
//                && (retvalue==CommandExeOk) && ( retvalue16 < 64 ) )
                                              && ( retvalue16 < 0xffff ) )
            {
               retvalue16 = 0;
               Int5  = Inst_Step();

            while( (STATUS & 0x40) && retvalue16 < 0xffff ) retvalue16 ++;

//               if ( retvalue != CommandExeOk ) retvalue16 ++;
//               else retvalue16 = 0;

            Get_A_Reg( 0, &Int4 );
            Int4  = (Int4 / 256) + (Int4 & 0xff) * 256;
            Int2 =  Int4 ;
            Int3 ++;
            if (Int3 > 30)
               {
//                  retvalue = RangeStepHalt;
                  Int2 = Int1 + 1;
               };
            };

            if ( !(Int4 > Int1) && !(Int4 < Int0) )
            {
               retvalue = RangeStepHalt;
            } else {
               retvalue = Int5;
            }

            TransmitBuf[0] = retvalue;

            break;

      case STEPOVER_RANGE :
            retvalue = CommandExeOk;
            retvalue16 = 0;
            Int3  = 0; //+ koo
            Int0 = commandStream[2] + commandStream[3] * 256; // Start addr
            Int1 = commandStream[5] + commandStream[6] * 256; // End addr
            Get_A_Reg( 0, &Int4 ); // Int4 store current PC
            Int4  = (Int4 / 256) + (Int4 & 0xff) * 256;
            Int2 =  Int4;
            while ( !(Int2 > Int1) && !(Int2 < Int0)
// Eric -         && (retvalue==CommandExeOk) && (retvalue16 < 64 ) )
                                            && (retvalue16 < 0xffff ) )
            {
               retvalue16 = 0;
               Int5  = Call_Step();
//             if ( retvalue != CommandExeOk ) retvalue16 ++;
//             else retvalue16 = 0;

               while( (STATUS & 0x40) && retvalue16 < 0xffff ) retvalue16 ++;

               Get_A_Reg( 0, &Int4 );
               Int4  = (Int4 / 256) + (Int4 & 0xff) * 256;
               Int2 =  Int4 ;
               Int3 ++;
               if (Int3 > 20) {
                  Int2 = Int1 + 1;
               }
            };

            if ( !(Int4 > Int1) && !(Int4 < Int0) )
            {
               retvalue = RangeStepHalt;
            } else {
               retvalue = Int5;
            }

            TransmitBuf[0] = retvalue;
            break;
#endif
      case SPA_BP_SET:
         Set_TPort();
         for ( i = 1; i <= chBankNo; i++ ) {
            nBank_Set(i);
            Clr_Ev_ExBp_all();
         }
         for (temp1 = 1; temp1 <= commandStream[9]; temp1 ++) {
            i = commandStream[temp1 + 29];   // 8 + 1 + 20(go,number,bp addr)
            chkBankType(i,i);
            SetExBp(&commandStream[8 + temp1 * 2]);
         }
         retvalue = start_EP( &commandStream[1] );
         TransmitBuf[0] = retvalue;
         break;

      case BANK_INI :      //0x1b
         bBank = 1 ;
         bBankType = commandStream[1] ;   //bit7 is h/l valid sel. 0~1 Banktype
         bBankPort = commandStream[2] ;
//       bBankPort = 1                ;   // koo temp

         bADRBIT16 = commandStream[3] ;   // value = [1,2,4,8,10,20,40,80]
         bADRBIT17 = commandStream[4] ;   // to point out P1.0/p1.1/~/p1.7
         GetPort();                // save P1/P3 value
         if (CheckBank() == 0)  {
            TransmitBuf[0] = CommandExeOk ;
         } else {
            bBank = 0 ;
            TransmitBuf[0] = BankIniErr ; // HW switch set not equal to SW set.
         }
         RestorePort();            // restore P1/P3
         TStreamLen = 2;
            break;

      case BANK_GET :      // 0x1c
         if (bBank == 0) {
            TransmitBuf[0] = BankGetErr ;
         } else {
            if ((epRunFlag == 1) && (goRunFlag == 0))
            {
               TransmitBuf[0] = EpRunning;
            } else {
               ChkOnFly();
               Get_CurBank();
               TransmitBuf[2] = bCurBank+1 ;
               TransmitBuf[1] = bSelBank ;
               TStreamLen = 3;
               OnFlyStart();
            }
         }
         break;

      case SEL_BANK :      // 0x1d
         if ((bBank == 0) || (commandStream[1] > 4)) {
            TransmitBuf[0] = BankSelErr ;
         } else {
            if (epRunFlag == 1)
            {
               TransmitBuf[0] = EpRunning;
            } else {
               Get_CurBank();
               bSelBank = commandStream[1] ;
            }
         }
         break;

      case SEL_PCBANK :      // 0x1e
         if ((bBank == 0) || (commandStream[1] > 4)) {
            TransmitBuf[0] = BankSelErr ;
         } else {
            if (epRunFlag == 1)
            {
               TransmitBuf[0] = EpRunning;
            } else {
               Bank_Reg_flg = 1 ; // to change bank and register P?.
               nBank_Set(commandStream[1]) ;
               Get_CurBank();
               GetRegister();
               Bank_Reg_flg = 0 ;
            }
         }
         break;

      default :
            TransmitBuf[0] = CmdInvalid ;
            break;

//       break;
   }
}
