
/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/
/****************************************************************************
**
**  Name:         xfwcomm.c
**
**  Description:
**
**  Status:
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <reg51.h>
#include "basetype.h"
#include "xfwcmd.h"
#include "io.h"

/******************** It's new start ************/
extern xdata U8 bCtrl0;
extern data U8 bncs2;
extern data U8 bpodModel;
extern U8 Cover_Go_l(void);
extern U8 Cover_Get_l(void);
extern U8 Trace_Initial(void);
//spa
extern bit Coverage_Flg;
extern bit EpTest_bit;
extern bit pod320_flg;
extern bit ontheflyflg;

extern xdata U8 LDCTRL0    ;
extern xdata U8 LDCTRL1    ;
extern xdata U8 bCTRL1    ;
extern xdata U8 bBank    ;
extern U8 bCurBank;
extern U8 bSelBank;
extern U8 bBankType;
extern U8 chBankNo;
extern U8 bBankPort;
extern U8 bADRBIT16;
extern U8 bADRBIT17;

extern xdata U8 bStatus1A;
extern U8 Diag_Tst ( void );
extern void Set_TPort(void);
extern unsigned char nBank_Set( U8 i ) ;

extern bit serial_Flag;

/******************** It's new end ************/
extern bit TimerOut;

//(timer message when ep stop running)
//extern xdata U8 elTimerMsg[] ;
extern xdata U8 timerHigh;
extern xdata U8 timerLow;
extern xdata U8 timerLow_1;
extern xdata U8 timerLow_2;
extern xdata U8 timerLow_3;
extern bit ReadElTimer_Flg;

//Event_Get ( Qualify )
xdata U8 EvQfStatus; // bit0: Qualify status. 0:dis. 1:en
                                // bit1: Ev1 status
                                // bit2: Ev2 status
xdata U8 Ev1Buffer[0x80];
xdata U8 Ev2Buffer[0x80];
xdata U8 QlfBuffer[0x80];
extern xdata U8 Ev3Buf; // 0: low  1: high

//Trig_Get
extern xdata U8 trigStatus,trigWay,levCount;    // default 1 is on.
extern xdata U8 tLevel1[1+2] ;  /* set flag, trace, timer, event condition */
extern xdata U8 tLevel2[1+2] ;
extern xdata U8 tLogic[4] ;/* set flag, run flag, level[0], level[1] */
extern xdata unsigned long int traceDlyCnt ;
//
// NOV.1.1995 Eric
extern xdata U8 initTrigger ; /* bit 0-> timer, bit 1 -> trace */


extern xdata U8 regbuf;
extern xdata U16 STATUS;   // bit 4~6 = 4 EP running (BIT 6 = 1)
extern xdata U16 epModeTMP;
extern xdata U8 clockMsg[];

extern void *memcpy(void *,void *,int );

// #define  LEAD_CODE   ':'
// #define  REC_OK      0x55
// #define  REC_FAIL    0xAA
// #define  ACK         0x5A
// #define  NACK        0xA5



//    0x3A  reserved
//    0x55  reserved
//    0xAA  reserved
//    0x5A  reserved
//    0xA5  reserved

U8  tracePort ; /* for trace use */
extern U8 Status ;
extern U16 epMode  ; /* current emulation processor mode */
extern U16 epModel ; /* emulation processor model */
U8  podModel ;
extern bit reset_flg ;         /* =1 -> target reset enable */
extern  xdata U8 STATUS0B   ;
U8  targetEA ;
U8  targetEAT ; // for 152
U8  targetEBEN; // for 152
extern bit fw_verify ;         /* =1 -> verify on */
U8          cycleFlag ; /* =0, no vaild data in cycleBuf, otherwise is vaild */
extern U16 traceCnt ;    /* total trace in frame */
extern U8   SetTracePort(void) ;
extern bit getTraceCnt ;       /* =0 -> not get trace, = 1 -> already get trace */
extern U8 traceQualifyOn ;
extern U32 ev1Count ;
U8  ev3Buf ;
U16 traceSize ; /* trace memory size(8K, 32K..) on trace logic */
extern data U8 SysTst;  /* system test result */
U8     epFail ;
  extern bit  coldStart ;         /* =1 -> cold start */
U16 lenRegData ;
extern code FWSUPPORT Fw_Support;
extern code U8 FW_VER_MAJOR,FW_VER_MINOR;
U8 chksum;

U16 TStreamLen;
U16 RStreamLen;

U16 commandStreamLen;
U8 commandStream[512];

U8 receiveBuf[512];
U8 TransmitBuf[2048];

bit ReceiveStream(void);
void TransmitStream(void);
void ProcessCommand(void);

void Init_HW(void) ;
U8   Rom_Chksum(void) ;
U8   SramTest(void) ;
U8   Can_RW(void) ;
U8   Can_RdPara(void) ;
void ClrEvARam(U8 fillData) ;
U8   CanRun(U8 mode) ;
U8   Load_Decode(void) ;
U8   InitMap(void) ;
U8   RstEp(void) ;
void init_EP1(void) ;
U16  Check_EpType(void) ;
void Ld_StopSp(void) ; /* load stop spoon into spoon ram(SDATA = 0, counter from 0 to 80h) */
void ControlEA(U8) ; /* 0 disable EA, 1 enable EA */
void ControlRst(U8) ; /* 0 disable Rst, 1 enable Rst */
void ControlEBEN(U8) ; /* 0 disable EBEN, 1 enable EBEN */

/* EP bit flag, bit 0 -> .EA, bit 1 -> .TR0, bit 2 -> .TR1,bit 3 -> .TR2 */
/*                            TR2 , TR1 , TR0 , EA  */
extern void Process_Command(void);

// for flash prom of Easypack. June/24/1995
extern U8 Flash_Here(void);

extern U8 ReceiveByte(void);
extern void TransmitByte(U8);

extern U8 stop_E_P( void );

extern U8 Inst_Step_l(void);
extern U8 Call_Step_l(void);
extern U8 Cycle_Step_l( void );

extern U16 EpTest(U8);
extern U8 TEST_ALL_ECBIIS(void);

extern void Get_CurBank(void);
extern void isp_save_data(void);
extern U8 IspLSIprg(U8 );
extern U8 isp_get_ues_data(void);

/***************************************************************************
** Functions for Flash prom.
****************************************************************************/
extern U8 Flash_Here(void);
extern U8 Flash_EC(void);
extern U8 FlashPrgRec( U8 * );

/****************************************************************************
**
**  ReceiveStream
**
**  Description: Receive data from communication and check the length and
**               checksum, the data format is :       XXXXxxx....xxxX
**                                                  length   data   checksum
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
bit ReceiveStream(void)
{
register U16 lp;
U8 aa[4];
// aa[0] store LEAD_CODE
// aa[1] store Data Length High
// aa[2] store Data Length Low
// aa[3] store chksum
// aa[0] + aa[1] + aa[2] + aa[3] == 0

   RStreamLen = 0;
   chksum = 0;

   while(1) {
      // receive leading code and data length and checksum.

      aa[0] = 0;
      aa[1] = 0;
      aa[2] = 0;
      aa[3] = 0;
      lp = 0;
      TimerOut = 0;

      while( lp < 4 )
      {
         aa[lp] = ReceiveByte();
	 if ( serial_Flag==1 ) return serial_Flag; // for serial communication.1996.10.17

         lp ++;
         if( aa[0] != LEAD_CODE ) lp = 0;
// June/10/1996
//       else ChkTimerOut = 1;
//         if (TimerOut) break;
      }

// June/10/1996
//      if (TimerOut) continue;   // To restart ReceiveStream

      for (lp = 1; lp < 4; lp++) chksum += aa[lp];
      if ((aa[0] == LEAD_CODE) && (chksum == 0)) // command length.
      {
         RStreamLen =(U16)aa[2] * 256 + aa[1];
         TransmitByte(REC_OK);
      } else {
         TransmitByte(REC_FAIL);
         continue;                          // To restart ReceiveString.
      }


      chksum = 0;

      for (lp = 0; lp < RStreamLen; lp++) {
// June/10/1996
//       TimCount = 0;

         receiveBuf[lp] = ReceiveByte();
// June/10/1996
//       if ( TimerOut ) break;

         chksum += receiveBuf[lp];
      }
// June/10/1996
//    if ( TimerOut) continue;

      if (chksum == 0) {    // The End of ReceiveBuf char is Data checksum
         memcpy(commandStream,&receiveBuf[0],RStreamLen);
         commandStreamLen = RStreamLen;
         TransmitByte(ACK);
// June/10/1996
//       ChkTimerOut = 0;
	 return serial_Flag;
      }
      else TransmitByte(NACK);
   }
}



/****************************************************************************
**
**  ReceiveByte
**
**  Description: Receive one byte from communication.
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/

/****************************************************************************
**
**  TransmitByte
**
**  Description: Transmit one byte from communication.
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/




/****************************************************************************
**
**  TransmitStream
**
**  Description: Transmit data(length + data + checksum) to
**               communication port.
**               the data format is :  XXXXxxx....xxxX
**                                   length   data   checksum
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
/*
   Transmit data(length + data + checksum) to communication port.
   the data format is : LENGTH(2 bytes)DATA(number of length)CHECKSUM(1 byte)
*/
void TransmitStream(void) {

register U16 lp;
U8 highLen,lowLen,aa;

   chksum = 0;
   for (lp = 0; lp < TStreamLen; lp++)
      chksum += TransmitBuf[lp];
   TransmitBuf[TStreamLen] = ( U8 )(~chksum+1);
   TStreamLen++;

   highLen = (U8)(TStreamLen/256);
   lowLen =  (U8) TStreamLen;
   chksum = (U8) (~(lowLen+highLen) ) + 1;

   while (1) {
      TransmitByte(LEAD_CODE);
      TransmitByte(lowLen);
      TransmitByte(highLen);
      TransmitByte(chksum);
      aa = ReceiveByte();
//    if ( aa != REC_OK ) return;
      if ( aa != REC_OK ) continue;
      for (lp = 0; lp < TStreamLen; lp++)
         TransmitByte(TransmitBuf[lp]);

      aa = ReceiveByte();
      if (aa == ACK) {

         return ;
      } else {                   //(aa == NACK)
         continue;
      }
   }

}

/***************************************************************************
**
**  ProcessCommand
**
**  Description: Idnetidy then command ID and call FW function.
**
**  Parameters:
**     input:
**        commandStream : Global varible commandStream.
**        commandStreamLen : Global varible length of commandStream.
**     output:
**        1. errNo(char) : The command execute result. Function return value.
**        2. outputStream :
**
****************************************************************************/
void ProcessCommand(void) {
U16 NumBer;
U8 retvalue;
U16  retvalue16;
unsigned short arg16;
U16 Int1,Int2,Int0;
U16 Int4,Int5,Int3;

   if (serial_Flag == 1) ES = 0;
   TStreamLen = 1;
   Coverage_Flg = 0;
   TransmitBuf[0] = CommandExeOk;
   if (epFail & 0x80) {
      TransmitBuf[0] = TargetCanotStep ;
   }
   switch ( commandStream[0] )
   {
      case FW_SUPPORT_GET :
// TB[0] : STATUS
// TB[1],TB[2] : FW support CPU number.
// TB[3],TB[4] : FW support CPU ID.
// TB[..],TB[..] : FW support CPU ID.

         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[2] = 0;
         memcpy ( (&TransmitBuf[3]),Fw_Support.cpuname1,Fw_Support.numb);

         TStreamLen = 3 + Fw_Support.numb ;
         TransmitBuf[1] = Fw_Support.numb/2;

         break;

      case HAND_SHAKE :
         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = 'E';
         TransmitBuf[2] = 'A';
         TransmitBuf[3] = 'S';
         TransmitBuf[4] = 'Y';
         TransmitBuf[5] = 'P';
         TransmitBuf[6] = 'A';
         TransmitBuf[7] = 'C';
         TransmitBuf[8] = 'K';
         TStreamLen = 9;
         break;

      case MHZ_GET:
         TransmitBuf[0] = CommandExeOk;
         for(retvalue=0;retvalue<10;retvalue++)
         TransmitBuf[1+retvalue] = clockMsg[retvalue];
         TStreamLen = 11;
         break;

      case FWID_GET:
         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = FW_VER_MAJOR;
         TransmitBuf[2] = FW_VER_MINOR;
         TStreamLen = 3;
         break;

      case ECB_ID_GET:
         retvalue = bStatus1A & 3;     // ECB2 is 1, ECB2S is 2;
         if((bStatus1A != 0x01) && (retvalue != 2))
         {
            retvalue = 0 ;             // old ECB.
         }
         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = retvalue;
         TStreamLen = 2;
         break;


      case FLASH_SWITCH :
         retvalue = Flash_Here();
            TransmitBuf[0] = retvalue;
         break;

      case FLASH_ERASE :
         retvalue = Flash_EC();
            TransmitBuf[0] = retvalue;
         break;

      case FLASH_PROG :
//           record length            record type 0 data
         if( commandStream[1] != 0 ) {
         retvalue = FlashPrgRec( & commandStream[1] );
         } else {
            retvalue = FlashRECErr;
         }
         TransmitBuf[0] = retvalue;
         break;

//    case Serial_Err :    //0x4a
//       TransmitBuf[0] = 0;
//       break;

      case DIAGNOSTIC :
         if(commandStream[1] > 7 || commandStream[1] < 1 )
         {
            TransmitBuf[0] = CmdInvalid;
         } else {
            retvalue = EpTest(commandStream[1]);
            TransmitBuf[0] = CommandExeOk;      //Special for trace:
            TransmitBuf[1] = retvalue;          //bit 0~6 is Trace Cnt l,h,
            TStreamLen = 2;                     //addr h,l,data,port,st&sp.
            if (EpTest_bit ==1)
            {
               TransmitBuf[1] = TransmitBuf[1] + 0x80; //err address flag,bit 7
               TransmitBuf[2] = commandStream[1];  //error address low
               TransmitBuf[3] = commandStream[2];  //error address high
               TStreamLen = 4;
            }
         }
         break;

      case DIAG_TEST :
//    case 0x70 :
         retvalue = Diag_Tst();
         TransmitBuf[0] = retvalue;
         if(EpTest_bit == 1)        // LdTcntFail
         {
            TransmitBuf[1] = 1;
            TStreamLen = 2 ;
         }
         break;

      case EP_HALT :
         retvalue = stop_E_P();
            TransmitBuf[0] = retvalue;

         break;

      case TIMER_GET:      // 0x27 +Koo 1/30/96
         if (ReadElTimer_Flg) {
            TransmitBuf[0] = 0;
            TransmitBuf[1] = 1;
            TransmitBuf[2] = timerLow_3;
            TransmitBuf[3] = timerLow_2;
            TransmitBuf[4] = timerLow_1;
            TransmitBuf[5] = timerLow;
            TransmitBuf[6] = timerHigh;
//          ClrElTimerMsg();
            TStreamLen = 7;
         } else {
            TransmitBuf[0] = 0;
            TransmitBuf[1] = 0;
            TStreamLen = 2;
         }
         break;

      case STATUS_GET :
         for( arg16 = 0; arg16 < 0x2000; arg16++ );
            TransmitBuf[0] = CommandExeOk;
            TransmitBuf[1] = ( U8 ) (STATUS & 0xff);
            TransmitBuf[2] = ( U8 ) (STATUS / 256 );
            if ( initTrigger & 0x2 ) TransmitBuf[1] = TransmitBuf[1] | 0x4;
            else TransmitBuf[1] = TransmitBuf[1] & 0xfb;
            if ( initTrigger & 0x1 ) TransmitBuf[2] = TransmitBuf[2] | 0x1;
            else TransmitBuf[2] = TransmitBuf[2] & 0xfe;
            TStreamLen = 3;
         break;

      case EVENT_GET :
         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = EvQfStatus;  // bit0: Qualify. bit1: Ev1. bit2: Ev2.
         TransmitBuf[2] = Ev3Buf;
         memcpy(&TransmitBuf[0x3],QlfBuffer,0x80);     // qualify
         memcpy(&TransmitBuf[0x3+0x80],Ev1Buffer,0x80);  // event1
         memcpy(&TransmitBuf[0x3+0x80+0x80],Ev2Buffer,0x80); // event2

         TStreamLen =  3 + 0x80 + 0x80 + 0x80 ;

         break;

      case TRACE_INI :
         Trace_Initial();
         break;

      case REG_GETLEN :
         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = 80;
         TransmitBuf[2] = 0;
         TStreamLen = 80 + 2;
         break;

      case REG_GETALL :
         memcpy ( &TransmitBuf[1], &regbuf,80 );
         TransmitBuf[0] = CommandExeOk;
         TStreamLen = 81;

         break;

      case STEP_ONE :
            retvalue = Inst_Step_l();
            TransmitBuf[0] = retvalue;
            break;
      case STEP_OVER :
            Set_TPort();
            retvalue = Call_Step_l();
            TransmitBuf[0] = retvalue;
// Eric Nov.21.1995 +
            retvalue16 = 0;
            while( (STATUS & 0x40) && retvalue16 < 0xffff ) retvalue16 ++;
            bCTRL1 = bCTRL1 & ~PSEN & ~TFEN;
            LDCTRL1 = bCTRL1 ;

            break;
      case STEP_CYCLE:
            bCS2 = bCS2 & ~TFLYOFF ;
            NCS2 = bCS2 ;
            retvalue = Cycle_Step_l();
            TransmitBuf[0] = retvalue;
            TStreamLen = 1 + 1 + 40*4;
            break;

      case TRIG_GET:
            TransmitBuf[0] = CommandExeOk;
            TransmitBuf[1] = trigStatus; // default is 1 (on)

            // TRIGGER LEVEL1
            TransmitBuf[2] = tLevel1[0]; // Level set flag. 0:not set. 1.set
            TransmitBuf[3] = 1; // levelID PACKWORD
            TransmitBuf[4] = 0;          //
            TransmitBuf[5] = (~tLevel1[1]) & 0x3; // TraceFlag
            TransmitBuf[6] = (~(tLevel1[1] >> 2)) & 0x3; // Timer flag
            TransmitBuf[7] = tLevel1[2];  // PACKDWORD Condition. EV
            TransmitBuf[8] = tLevel1[2];
            TransmitBuf[9] = tLevel1[2];
            TransmitBuf[10] = tLevel1[2];

            // TRIGGER LEVEL2
            TransmitBuf[11] = tLevel2[0]; // Level set flag. 0:not set. 1:set
            TransmitBuf[12] = 2; // levelID PACKWORD
            TransmitBuf[13] = 0;          //
            TransmitBuf[14] = (~tLevel2[1]) & 0x3; // TraceFlag
            TransmitBuf[15] = (~(tLevel2[1] >> 2)) & 0x3; // Timer flag
            TransmitBuf[16] = tLevel2[2];  // PACKDWORD Condition. EV
            TransmitBuf[17] = tLevel2[2];
            TransmitBuf[18] = tLevel2[2];
            TransmitBuf[19] = tLevel2[2];

           // TRIGGER LOGIC
            TransmitBuf[20] = trigWay; // TrigFlg 0 delay 1 forward 2 backward 3 centre
            TransmitBuf[21] = tLogic[1]; // run flag
            TransmitBuf[22] = (U8)(traceDlyCnt & 0xff);
            TransmitBuf[23] = (U8)( ( traceDlyCnt >> 8 ) & 0xff );
            TransmitBuf[24] = 0;
            TransmitBuf[25] = 0;
            TransmitBuf[26] = levCount;   // PACKWORD
            TransmitBuf[27] = 0;
            TransmitBuf[28] = tLogic[2];  // PACKWORD LevelID[0]
            TransmitBuf[29] = 0;
            TransmitBuf[30] = tLogic[3];  // PACKWORD LevelID[1]
            TransmitBuf[31] = 0;
            TransmitBuf[32] = 0;          // PACKWORD LevelID[2]
            TransmitBuf[33] = 0;
            TransmitBuf[34] = 0;          // PACKWORD LevelID[3]
            TransmitBuf[35] = 0;

            TStreamLen = 36;

         break;

      case COVERAGE_GO:
         Cover_Go_l();
         break;

      case COVERAGE_GET:
         Cover_Get_l();
         break;

      case SELECT_BAUDRATE:
	 TransmitBuf[0] = CommandExeOk;
	 break;

      case ISP_RECIEVE_DATA:     // 0x90
         isp_save_data();
	 TransmitBuf[0] = CommandExeOk;
         TStreamLen = 1;
         break;

      case ISPLSIXXXX_CMD:    // 0x91
         TransmitBuf[0]=IspLSIprg(commandStream[1]);
//       bCS2 = bncs2;
         NCS2 = bCS2 ;
	 break;

      case Get_ispLSI_UES:     // 0x92
         TStreamLen = isp_get_ues_data();
         TransmitBuf[0]=0;
         break;


//    case ISPGAL22V10_CMD:
//       TransmitBuf[0] = Ispgal22v10();
//       break;

      case FW_TESTdia:
         retvalue = TEST_ALL_ECBIIS();
         TransmitBuf[0] = 0;
         TransmitBuf[1] = retvalue;
         TransmitBuf[2] = 0;
         TStreamLen = 3;

         break;

      default :
         Process_Command();
         break;

   }
   if (serial_Flag == 1) ES = 1;
}

/******************************************************************************
**  called when power on & handshake(cold/warm start)
**  output:
**     SysTst=0     SYSOK      test OK
**           =1     SYSRAMERR  system RAM test error
**           =2     EPERR      EP test falure
**           =4     UNERR      component Un test error
**     CEBUFFER                detal infomation about SysTst=UNERR
*****************************************************************************/
extern bit Bank_Reg_flg;

void sysini(void) {
//U16  resetFlag ;
//static ADRSTRUCT tPc ;
   U8 i ;

   EA  = 0 ;  /* disable interrupt during system init */
   EX0 = 0 ;  /* EP status changed */
// EX1 = 0 ;  /* PCE interface */
   IT0 = 0 ;
   IT1 = 0 ;
/* clear timer 0, 1 interrupt */
   ET0 = 0 ;
   ET1 = 0 ;
   TR0 = 0 ;
   TR1 = 0 ;
   TF0 = 0 ;
   TF1 = 0 ;

   epModel = 0;
   bCS2 = bCS2 & ~TFLYOFF; /* enable tclk1 to TCLK  + koo 5/14/1996 */
   NCS2 = bCS2 ;
   lenRegData = sizeof(REGDATA) ;

   TMOD = 0x11 ; /* program timer 0, 1 as 16 bits timer */

   P1 = 0xff ;

// SysTst = 0 ;
   Init_HW() ;  /* disable H/W */


   if ((coldStart == 1) || (SysTst != 0)) { /* Do selftest if cold start */

      epFail = 0 ;
      SysTst = 0 ;
      /* do rom checksum, ram test, ep test */
      if (Rom_Chksum() != OK)
         SysTst = 1 ;
      if (SramTest() != OK) /* ram test will destory buffer */
         SysTst = SysTst | 2 ;
      Init_HW() ; /* recall port data in sram */
      /* finish selftest, set coldstart finish flag */
   }
   traceSize = 0x7fff;
   RstEp() ;

   /* trace condition init */
   ev3Buf = 0 ;
   ev1Count = 1 ;
   traceDlyCnt = 0l ;

   trigWay = 0;      // default is delay
   EvQfStatus = 0;
   levCount = 1;


   tLogic[0] = 1 ;     /* set flag */
   tLogic[1] = 0 ;     /* run flag */
   tLogic[2] = 1 ;     /* level[0] */
   tLogic[3] = 0xff ;  /* level[1] */
   tLevel1[0] = 1 ;    /* set flag */
   tLevel1[1] = 0xff ; /* trace, timer */
   tLevel1[2] = 0xfe ; /* event condition : ev1|ev2|ev3 */
   tLevel2[0] = 0 ;
   /* clear event */
   traceQualifyOn = 0 ;
   getTraceCnt = 1 ;
   /* clear ev address compare ram, LoadDecode() will clear data ram */
   ClrEvARam(0xCf) ; /* default qualify all match */

   bBankPort = 1;
   tracePort = bBankPort ; /* default trace in is port 1 */

   /* Load decode, map data, can program */
   ControlRst(1) ; // to check if it is DS320 (change from EP-52f)
                   // X-RSTEN connect to INPS0 (J2 pin 21)
   commandStream[10] = STATUS0B & CHKEBEN ;
   ControlRst(0) ; // disable target reset
   commandStream[11] = STATUS0B & CHKEBEN ;
   if ((podModel == 0) && (commandStream[10] == commandStream[11] + 0x40)
      && (((bStatus1A & 3) == 0x01) || ((bStatus1A & 3) == 0x02))) {
      pod320_flg = 1;
   } else {
      pod320_flg = 0;
   }
   Load_Decode() ;
   Can_RW() ;
   Can_RdPara() ; /* load init data into canBuf */
   Ld_StopSp() ; /* load stop spoon into spoon ram */

   /* clear trace counter */
   traceCnt = 0 ;
   trigStatus = 1 ; /* default trigger is on */
   cycleFlag = 0 ;
   initTrigger = 3 ; /* default trace and timer is on */
   fw_verify = 1 ; /* default f/w verify is on */

// podModel = STATUS1B & 0x0f ;
   ControlRst(0) ; // disable target reset
   ControlEA(1) ; // eanble target EA before check EA
   targetEA = STATUS0B & CHKEA ;
   ControlEBEN(1) ; // enable target EBEN before check EBEN.
   targetEAT = STATUS0B & CHKEAT ;
   targetEBEN = STATUS0B & CHKEBEN ;// john: 94/12/22: add for EBEN

   if (STATUS0B & TVCC) // if no target VCC, disable reset
      reset_flg = 1 ;
   else
      reset_flg = 0 ;
   ControlEA(0) ;
   ControlEBEN(1);
   /* reset ep */
// init_EP(&tPc) ;
   RstEp() ;   // RstEP will read back pod id and store to podModel

   SysTst = SysTst & ~0x18 ; // clear bit 3, 4
   switch (podModel) {
      case 0: // EPH/EPL-52F
         epModel = Check_EpType() ;
         if (( epModel != EP80C320 ) && (pod320_flg == 1)) {
            pod320_flg = 0 ;
            Load_Decode() ;    // reload Norm init_data
            RstEp() ;
            epModel = Check_EpType() ; /* will destory ep register */
         }
         if ( targetEA ) epModel = epModel | 1;
         if (( epModel == EP8044 ) || (epModel == EP85154)
            || ( epModel == EP83C320 )) {
            epModel = epModel & 0xfe ;
            targetEA = 0;
         }
         if (targetEA == 0) {
            bCS2 = bCS2 | HSPEED ;
            NCS2 = bCS2 ;
         }
         break ;

      case 0xff:
         SysTst = SysTst | 8 ; // no probe connect
         EA = 1 ; /* enable interrupt */
         return;

      case 1: // EPH/EPL-87C552

         if (targetEA)
            epModel = EP83C552 ;
         else
            epModel = EP80C552 ;
         break ;

      case 2: // EPH/EPL-83C752    Hardware check if EPL-750 is on.
        if ( STATUS0B & 0x40 ) {
            epModel = EP83C752 ;
         } else {
            epModel = EP83C750 ;

         };
         break;

      case 3:     // CL580
         if (targetEA)
            epModel = EP83CL580 ;
         else
            epModel = EP80CL580 ;
         ControlEA(targetEA);
	 break;

      case 4: // EPH/EPL-87C152A
         if (targetEAT)
            epModel = EP83152A;
         else {
            if (targetEBEN)
               epModel = EP80152B;
            else
               epModel = EP80152A;
            }

         epModeTMP = epModel;

         ControlEA(targetEAT) ;
         ControlEBEN(targetEBEN);
         break ;

      case 5:     // EP85CL782
         epModel = Check_EpType();
            if (epModel != EP83CL782) {
               ControlEA(0);
            } else {
               ControlEA(targetEA);
            }
         break;

      case 6: // EPH/EPL-80C550
         if (targetEA)
            epModel = EP83C550 ;
         else
            epModel = EP80C550 ;
         ControlEA(targetEA) ;      //+koo 1/21/95
         break ;

      case 8: // DS80C320 cancel
         break ;

      default:
         SysTst = SysTst | 0x10 ; // not supply in this firmware
         EA = 1 ; /* enable interrupt */
         return;
   }
   ControlEA(targetEA) ;

   if ( epModel >= EP80152A && epModel <= EP83152D ) {
      epMode = EP80152A;
   } else {
      epMode = epModel ;
   }

  epModeTMP = epModel;

   if (podModel == 2)      // for 752
   {
      canBuf[EP_TYPE] = (U8)epModel ;
   }

   /* after check EP, must reset ep again*/
   init_EP1() ;  /* like init_EP but no Status and Occurrence update */

   Bank_Reg_flg = 0;
   bBank = 1 ;          // ADD for default map & event set
   bCurBank = 0 ;    // 0 is the default bank (first)
   bSelBank = 1 ;    // 1 is as bCurBank = 0 (bSelBank:1~4; bCurBank:0~3)

   switch (bStatus1A & 0x0c) {
      case 0:
         bBank = 0;
         break;

      case 4:
         bBankType = 0x81;
         chBankNo = 2;
         break;

      case 8:
         bBankType = 0x82;
         chBankNo = 4;
         break;
   }
   if (bBank == 1) {
      bADRBIT16 = 1;
      bADRBIT17 = 2;
      Get_CurBank();
      Set_TPort();
      for ( i=1 ; i<=chBankNo ; i++ ) {
         nBank_Set(i);
         ClrEvARam(0xCF);
         InitMap();
      }
      bCTRL1 = bCTRL1 & ~PSEN & ~TFEN;
      LDCTRL1 = bCTRL1 ;
//    recall init_EP;
      init_EP1() ;  /* like init_EP but no Status and Occurrence update */
   }

   bBank = 0 ;       // initial Bank Set.
   bCurBank = 0 ;    // 0 is the default bank (first)
   bSelBank = 1 ;    // 1 is as bCurBank = 0 (bSelBank:1~4; bCurBank:0~3)


   if ((SysTst & 0x18) || (epModeTMP > EP83C320 )) {
      epFail = epFail | 0x80;
   }
     Status = 0x88 ; /* verify on, trigger on */
   ontheflyflg = 0;
   EA = 1 ; /* enable interrupt */
}
