
/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/
/****************************************************************************
**
**  Name:         xfwmain.c
**
**  Description:
**
**
**  Status:
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
*****************************************************************************/


#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <reg51.h>

extern void cp_ini(void);
extern void sys_ini(void);
extern bit ReceiveStream(void);
extern unsigned char ProcessCommand(void);
extern void TransmitStream(void);

unsigned char  errNo;

extern bit ColdStart;

extern unsigned int TStreamLen;
extern unsigned char TransmitBuf[2048];
extern unsigned char commandStream[512];
extern unsigned char serialBaudrate;
extern void SerialSelectBaudrate(void);


// The following is for serial communication.
extern void SerialCpIni(void);
extern unsigned char FirstHandShake(void);
extern void SerialHandShake(void);
extern void SerialReceiveStream(void);
extern void SerialTransmitStream(void);
extern void Ini_rs232_buf(void);

extern bit serial_Flag;

/***************************************************************************
**
**  main()
**
**  Description: Michelle main routine, with its linear control process
**               sequence. We always think this fw process with one single
**               task.
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
****************************************************************************/

void main(void)
{
   cp_ini();
//   cp_ini();
   SerialCpIni();

   ColdStart = 1;



   sys_ini();


   serial_Flag = 0;


   while (1) {
      while( !serial_Flag ) {
         serial_Flag = ReceiveStream(); /* read the input commands stream. */
         if (serial_Flag) break;
         ProcessCommand(); /* case switching the command tasks */
         TransmitStream();
      }
      while (1) {
         SerialHandShake();

         while( serial_Flag ) {
            Ini_rs232_buf();
            SerialReceiveStream();
            ProcessCommand();
            Ini_rs232_buf();
            SerialTransmitStream();
            if ( commandStream[0] == 0x74 ){
               serialBaudrate = commandStream[1];
               SerialSelectBaudrate();
               break;      // end while (serial_Flag) to handshake.
            }
         }// end-while(serial_Flag)

      }// end-while(1)

   }// end-while(1)

}//end-main.



