
/***************************************************************************
**
**    $Header$
**
**    $Log$
** 
****************************************************************************/
/****************************************************************************
**
**  Name:         xfwsub.c
**
**  Description:
**
**  Status:
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
*****************************************************************************/

#include "basetype.h"
#include <reg51.h>

#include "xfwsub.h"

unsigned char Copy_Mem( unsigned char *PCmd )
{
   unsigned char retvalueCopy;
   unsigned char SourAdr1_hi,SourAdr1_lo;
   unsigned char DestAdr1_hi,DestAdr1_lo;
   unsigned long int  copyLength;
   register  unsigned int  copyCycle;
   register  unsigned int jk;
   unsigned char  Source_Type,Destin_Type,i,j;


   FwDumpCmd[0] = PCmd[0];
   FwDumpCmd[3] = PCmd[0];
   Source_Type  = PCmd[0];
   CopyTmpBuf[0] = PCmd[6];
   CopyTmpBuf[3] = PCmd[6];
   Destin_Type  = PCmd[6];
   CopyTmpBuf[6] = 0xff;

   SourAdr1_lo = PCmd[1] ;
   SourAdr1_hi = PCmd[2] ;
   DestAdr1_lo = PCmd[7] ;
   DestAdr1_hi = PCmd[8] ;

   copyLength = PCmd[4] + (unsigned long int)PCmd[5]*256
               - PCmd[1] - (unsigned long int) PCmd[2]*256 + 1;
   copyCycle = copyLength / 255;


   for( jk = 0; jk < copyCycle; jk ++ )
   {
      FwDumpCmd[1] = SourAdr1_lo;
      FwDumpCmd[2] = SourAdr1_hi;
      if(FwDumpCmd[1] > 1)
         SourAdr1_hi  ++ ;
      FwDumpCmd[4] = SourAdr1_lo + 254;
      FwDumpCmd[5] = SourAdr1_hi;

      SourAdr1_lo = FwDumpCmd[4] + 1;
      if(SourAdr1_lo == 0) SourAdr1_hi ++ ;
      if ((Source_Type > 5) && (Destin_Type > 5) && (Source_Type != Destin_Type))
      {
         Set_TPort();
         FwDumpCmd[0] = 1;
         FwDumpCmd[3] = 1;
         i = Source_Type - 5;
         nBank_Set(i) ;
      }
      retvalueCopy = Read_Mem ( FwDumpCmd, &CopyTmpBuf[7] );
      if( retvalueCopy != 0 ) return retvalueCopy;
      if ((Source_Type > 5) && (Destin_Type > 5) && (Source_Type != Destin_Type))
      {
         RestorePort();
      }

      CopyTmpBuf[1] = DestAdr1_lo;
      CopyTmpBuf[2] = DestAdr1_hi;
      if(CopyTmpBuf[1] > 1)
         DestAdr1_hi ++ ;
      CopyTmpBuf[4] = DestAdr1_lo + 254;
      CopyTmpBuf[5] = DestAdr1_hi;

      DestAdr1_lo = CopyTmpBuf[4] + 1;
      if(DestAdr1_lo == 0)   DestAdr1_hi ++ ;
      if ((Source_Type > 5) && (Destin_Type > 5) && (Source_Type != Destin_Type))
      {
         Set_TPort();
         CopyTmpBuf[0] = 1;
         CopyTmpBuf[3] = 1;
         i = Destin_Type - 5;
         nBank_Set(i) ;
      }
// OCT.26.1995 ERIC for copy.
      commandStream[1] = CopyTmpBuf[0];
      commandStream[2] = CopyTmpBuf[1];
      commandStream[3] = CopyTmpBuf[2];
      commandStream[4] = CopyTmpBuf[3];
      commandStream[5] = CopyTmpBuf[4];
      commandStream[6] = CopyTmpBuf[5];
      commandStream[7] = CopyTmpBuf[6];
      for ( retvalueCopy = 0; retvalueCopy < commandStream[7];retvalueCopy ++ )
      commandStream[8+retvalueCopy] = CopyTmpBuf[7+retvalueCopy];
//

      retvalueCopy = Fill_Mem ( &CopyTmpBuf[0] );
      if( retvalueCopy != 0) return retvalueCopy;
      if ((Source_Type > 5) && (Destin_Type > 5) && (Source_Type != Destin_Type))
      {
         RestorePort();
      }

   }

   copyCycle = copyLength % 255 ;
   if( copyCycle != 0 )
   {
      FwDumpCmd[1] = SourAdr1_lo;
      FwDumpCmd[2] = SourAdr1_hi;
      CopyTmpBuf[6] = copyCycle;

      copyLength = (unsigned long int)SourAdr1_lo
                  + (unsigned long int)copyCycle - 1;
      if( copyLength > 255 ) SourAdr1_hi ++;
      FwDumpCmd[4] = SourAdr1_lo + copyCycle - 1;
      FwDumpCmd[5] = SourAdr1_hi;
      if ((Source_Type > 5) && (Destin_Type > 5) && (Source_Type != Destin_Type))
      {
         Set_TPort();
         FwDumpCmd[0] = 1;
         FwDumpCmd[3] = 1;
         i = Source_Type - 5;
         nBank_Set(i) ;
      }
      retvalueCopy = Read_Mem ( &FwDumpCmd[0], &CopyTmpBuf[7] );
      if( retvalueCopy != 0 ) return retvalueCopy;
      if ((Source_Type > 5) && (Destin_Type > 5) && (Source_Type != Destin_Type))
      {
         RestorePort();
      }

      CopyTmpBuf[1] = DestAdr1_lo;
      CopyTmpBuf[2] = DestAdr1_hi;

      copyLength = (unsigned long int)DestAdr1_lo
                  + (unsigned long int)copyCycle - 1;
      if( copyLength > 255) DestAdr1_hi ++ ;
      CopyTmpBuf[4] = DestAdr1_lo + copyCycle - 1;
      CopyTmpBuf[5] = DestAdr1_hi;
      if ((Source_Type > 5) && (Destin_Type > 5) && (Source_Type != Destin_Type))
      {
         Set_TPort();
         CopyTmpBuf[0] = 1;
         CopyTmpBuf[3] = 1;
         i = Destin_Type - 5;
         nBank_Set(i) ;
      }
// OCT.26.1995 ERIC for copy.
      commandStream[1] = CopyTmpBuf[0];
      commandStream[2] = CopyTmpBuf[1];
      commandStream[3] = CopyTmpBuf[2];
      commandStream[4] = CopyTmpBuf[3];
      commandStream[5] = CopyTmpBuf[4];
      commandStream[6] = CopyTmpBuf[5];
      commandStream[7] = CopyTmpBuf[6];
      for ( retvalueCopy = 0; retvalueCopy < commandStream[7];retvalueCopy ++ )
      commandStream[8+retvalueCopy] = CopyTmpBuf[7+retvalueCopy];
//


      retvalueCopy = Fill_Mem ( CopyTmpBuf );
      if( retvalueCopy != 0) return retvalueCopy;

   };

   return   0;

}

unsigned char GetTraceBuf( unsigned int RdDirect,unsigned int StartFrame,
            unsigned int EndFrame,unsigned char *P2Qualify,unsigned char *P2TBuf)
{
   unsigned char RetRDTrace;
   unsigned char *pChar;


   TransmitBuf[1] = 0;     // Trace read Frame Number = 0
   TransmitBuf[2] = 1;     // Trace not over

   do
   {
   *(P2TBuf) = (unsigned char) (StartFrame & 0x00ff);
   *(P2TBuf+1) = (unsigned char) (StartFrame / 256);
   RetRDTrace = GetFrame( StartFrame,P2TBuf + 2);
   if ( RetRDTrace == 0 )
      {
       StartFrame ++;
       if ( User1Flag == 1 )
       {
         if( ChkTrace( P2TBuf ) == 0 ) // match
         {
         TransmitBuf[1] = TransmitBuf[1] + 1;
         P2TBuf = P2TBuf + 7;
         };
      }
      else
      {
         TransmitBuf[1] = TransmitBuf[1] + 1;
         P2TBuf = P2TBuf + 7;
      }

      }
   else TransmitBuf[2] = 0;


   }
   while ( StartFrame <= EndFrame && TransmitBuf[1] <= 254 && TransmitBuf[2] != 0  );


         return CommandExeOk;

}

unsigned char GetCTraceBuf( unsigned char count, unsigned char rangeCount)

{
   unsigned char x, retcount = 0;
   unsigned int StartFrame;

   StartFrame = commandStream[1] + commandStream[2] * 256;
   if (count > 60)
   {
      return CmdInvalid;
   }
   if(StartFrame < traceCnt)
   {
      Read_Trace_Ini();
// Code_Access_No = 0;
      LdTraceCnt(traceStart+StartFrame);
      if (rangeCount == 0)
      {
         for (x=0;x<count;x++)
         {
            chCurPort = Read_Trace_Port();
            Frame_adr[x] = Read_Trace_Content();
            Frame_No[x] = StartFrame;
               Get_CurPort();
            Frame_port[x] = bCurBank+1;
            if (Coverage_Flg != 1)
            {
               x --;
            }
            StartFrame ++;
            if(StartFrame >= traceCnt)
            {
               break;
            }
         }
         if (x == 0xff) x = 0;
         retcount = x;
      }
#if 0
// It's no used in EPSLD 2.09, so marked, maybe it'll be used in future.
// - koo 5/March/1997
      else
      {
         if (rangeCount < 0xf5 && rangeCount > 0xf0)
         {
            rangeCount = rangeCount - 0xf0;
            for(Coverage_Range_SAd1 = StartFrame;
               Coverage_Range_SAd1 <  traceCnt; Coverage_Range_SAd1++ )
            {
               chCurPort = Read_Trace_Port();
               Code_Access_Tmp = Read_Trace_Content();
               Get_CurPort();
               if (Coverage_Flg == 1)
               {
                  if((Code_Access_Tmp >= Code_Access_Range_SAd[4])
                     && (Code_Access_Tmp <= Code_Access_Range_DAd[4])
                     && (bCurBank == Coverage_Bank[4]))
                  {
                     StartFrame = Coverage_Range_SAd1;
                     Frame_No[retcount] = StartFrame;
                     Frame_adr[retcount] = Code_Access_Tmp;
                     Frame_port[retcount] = bCurBank + 1;
                     retcount++;
                     StartFrame++;
                     break;
                  }
               }
            }
            goto NORM;
         }
         if (rangeCount > 5 || rangeCount == 0)
         {
            return CmdInvalid;
         }
         StartFrame++;
         chCurPort = Read_Trace_Port();
         Code_Access_Tmp = Read_Trace_Content();
         Get_CurPort();
         for(;StartFrame <  traceCnt; StartFrame++)
         {
            chCurPort = Read_Trace_Port();
            Code_Access_Tmp = Read_Trace_Content();
            Get_CurPort();
            if (Coverage_Flg == 1)
            {
               if((Code_Access_Tmp <= Code_Access_Range_SAd[0])
                  || (Code_Access_Tmp > Code_Access_Range_DAd[0]))
               {
                  Frame_No[retcount] = StartFrame;
                  Frame_adr[retcount] = Code_Access_Tmp;
                  Frame_port[retcount] = bCurBank + 1;
                  retcount++;
                  StartFrame++;
                  break;
               }
            }
            if(retcount >= count )
            {
               temp2 = retcount;
               return CommandExeOk;
            }
         }
         NORM:
         do
         {
            for(x=0;x<rangeCount;x++)
            {
               if((Code_Access_Tmp >= Code_Access_Range_SAd[x])
                   && (Code_Access_Tmp <= Code_Access_Range_DAd[x])
                   && (bCurBank == Coverage_Bank[x]))
               {
                  break;
               }
            }
            if(x==rangeCount)
            {
               temp2 = retcount;
               return CommandExeOk;
            }
            for(;StartFrame <  traceCnt; StartFrame++)
            {
               chCurPort = Read_Trace_Port();
               Code_Access_Tmp = Read_Trace_Content();
               Get_CurPort();
               if (Coverage_Flg == 1)
               {
                  if((Code_Access_Tmp <= Code_Access_Range_SAd[x])
                     || (Code_Access_Tmp > Code_Access_Range_DAd[x]))
                  {
                     Frame_No[retcount] = StartFrame;
                     Frame_adr[retcount] = Code_Access_Tmp;
                     Frame_port[retcount] = bCurBank + 1;
                     retcount++;
                     StartFrame++;
                     break;
                  }
               }
            }
            if(StartFrame >= traceCnt)
            {
               temp2 = retcount;
               return CommandExeOk;
            }
         }while(retcount<count);
      }
#endif
   }
   temp2 = retcount;
   return CommandExeOk;
}

/************************************************************************
*  1. save Bank information (bCurBank) to bBankTmp;
*  2. read Trace (content and port), destory chCurPort. destory bCurBank.
*  3. analyse
*  4. if not complete, jmp 2.
*  5. complete, Restore chCurPort and bCurBank.
************************************************************************/

unsigned char Analyse_Coverage() {
   data unsigned char i,k,l,m,n;
   unsigned int j;

   Read_Trace_Ini();
   Code_Access_No = 0;
/* ClrTraceCnt();    // call ClrTraceCnt */
   LdTraceCnt(traceStart);
   bBankTmp = bCurBank;
   chPortTmp = chCurPort;
   switch ( Coverage_Range_No ) {
      case 1:
               i = 1;
               k = 0;
               for (j = 1; j <= traceCnt; j++ ) {
                  chCurPort = Read_Trace_Port();
                  Code_Access_Tmp = Read_Trace_Content();
                  GetCurPort();
                  if ((Coverage_Range_SAd1 <= Code_Access_Tmp) &&
                     (bCurBank == Coverage_Bank[1]) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd1)) {
                     if (k == i-1) {
                        if (Coverage_Flg == 1)
                 // Add for avoid set the not 's' status as the start
                 // access address (Coverage_Flg = 1 is 's').
                        {
                           Code_Access_Range_SAd[i] = Code_Access_Tmp;
                           Code_Access_Range_DAd[i] = Code_Access_Tmp;
                           if (bBank == 1)
                           {
                              chCode_Access_Ad_Type[i] = bCurBank ;
                           } else
                           {
                              chCode_Access_Ad_Type[i] = 1;
                           }
                           Frame_adr[i] = Code_Access_Tmp;
                           k = i;
                        }
                     }
		     else {
                        for (l = i; l >= 1; l-- ) {
                           if (((Code_Access_Tmp == Code_Access_Range_DAd[l]) ||
                                (Code_Access_Tmp == Code_Access_Range_DAd[l] + 1)) &&
                                (bCurBank == chCode_Access_Ad_Type[l]))
                           {
                              Code_Access_Range_DAd[l] = Code_Access_Tmp;

                              if (Coverage_Flg == 1)
                              {
                                 Frame_adr[l] = Code_Access_Tmp;
                              }
                              m = 1;
                              l = 1;
                           }
                           else {
                              if (( Code_Access_Range_SAd[l] <= Code_Access_Tmp) &&
                                  (bCurBank == chCode_Access_Ad_Type[l]) &&
                                  (Code_Access_Tmp < Code_Access_Range_DAd[l] ))
                              {
                                 m = 1;
                                 l = 1;
                              }
                              else { m = 0; }

                           }
			}
                        if ((m != 1) && (Coverage_Flg == 1))
                 // Add for avoid set the not 's' status as the start
                 // access address (Coverage_Flg = 1 is 's').
                        {
                              i++;
                              Code_Access_Range_SAd[i] = Code_Access_Tmp;
                              Code_Access_Range_DAd[i] = Code_Access_Tmp;
                              if (bBank == 1)
                              {
                                 chCode_Access_Ad_Type[i] = bCurBank ;
                              } else
                              {
                                 chCode_Access_Ad_Type[i] = 1;
                              }

                              Frame_adr[i] = Code_Access_Tmp;
                              k = i;
                        }
                        if (Code_Access_Range_SAd[i] != Code_Access_Range_DAd[i])
                        {
                           for (l = 1; l < i; l++) {
                              if (Code_Access_Range_DAd[i] == Code_Access_Range_SAd[l])
                              {
                                 Code_Access_Range_SAd[l] = Code_Access_Range_SAd[i];
                                 i--;
                                 k--;
                              }
                           }
                        }
                        if ( i > 16 ) {
                           j = traceCnt ;
                        }
                     }
		  }
               }
               break;

      case 2:
               i = 1;
               k = 0;
               for (j = 1; j <= traceCnt; j++ ) {
                  chCurPort = Read_Trace_Port();
                  Code_Access_Tmp = Read_Trace_Content();
                  GetCurPort();
                  if ( ((Coverage_Range_SAd1 <= Code_Access_Tmp) &&
                     (bCurBank == Coverage_Bank[1]) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd1)) ||
                       ((Coverage_Range_SAd2 <= Code_Access_Tmp) &&
                     (bCurBank == Coverage_Bank[2]) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd2)) ) {
                     if (k == i-1) {
                        if (Coverage_Flg == 1)
                 // Add for avoid set the not 's' status as the start
                 // access address (Coverage_Flg = 1 is 's').
                        {
                           Code_Access_Range_SAd[i] = Code_Access_Tmp;
                           Code_Access_Range_DAd[i] = Code_Access_Tmp;
                              if (bBank == 1)
                              {
                                 chCode_Access_Ad_Type[i] = bCurBank ;
                              } else
                              {
                                 chCode_Access_Ad_Type[i] = 1;
                              }

                           Frame_adr[i] = Code_Access_Tmp;
                           k = i;
                        }
                     }
		     else {
                        for (l = i; l >= 1; l-- ) {
                           if (((Code_Access_Tmp == Code_Access_Range_DAd[l]) ||
                                (Code_Access_Tmp == Code_Access_Range_DAd[l] + 1)) &&
                                (bCurBank == chCode_Access_Ad_Type[l]))
                           {
                              Code_Access_Range_DAd[l] = Code_Access_Tmp;

                              if (Coverage_Flg == 1)
                              {
                                 Frame_adr[l] = Code_Access_Tmp;
                              }
                              m = 1;
                              l = 1;
                           }
                           else {
                              if (( Code_Access_Range_SAd[l] <= Code_Access_Tmp) &&
                                  (bCurBank == chCode_Access_Ad_Type[l]) &&
                                  (Code_Access_Tmp < Code_Access_Range_DAd[l] ))
                              {
                                 m = 1;
                                 l = 1;
                              }
                              else { m = 0; }

                           }
			}
                        if ((m != 1) && (Coverage_Flg == 1))
                 // Add for avoid set the not 's' status as the start
                 // access address (Coverage_Flg = 1 is 's').
                        {
                              i++;
                              Code_Access_Range_SAd[i] = Code_Access_Tmp;
                              Code_Access_Range_DAd[i] = Code_Access_Tmp;
                              if (bBank == 1)
                              {
                                 chCode_Access_Ad_Type[i] = bCurBank ;
                              } else
                              {
                                 chCode_Access_Ad_Type[i] = 1;
                              }

                              Frame_adr[i] = Code_Access_Tmp;
                              k = i;
                        }
                        if (Code_Access_Range_SAd[i] != Code_Access_Range_DAd[i])
                        {
                           for (l = 1; l < i; l++) {
                              if ((Code_Access_Range_DAd[i] == Code_Access_Range_SAd[l])
                               && (chCode_Access_Ad_Type[i] == chCode_Access_Ad_Type[l]))
                              {
                                 Code_Access_Range_SAd[l] = Code_Access_Range_SAd[i];
                                 i--;
                                 k--;
                              }
                           }
                        }
                        if ( i > 16 ) {
                           j = traceCnt ;
                        }
                     }
		  }
               }
               break;

      case 3:
               i = 1;
               k = 0;
               for (j = 1; j <= traceCnt; j++ ) {
                  chCurPort = Read_Trace_Port();
                  Code_Access_Tmp = Read_Trace_Content();
                  GetCurPort();
                  if ( ((Coverage_Range_SAd1 <= Code_Access_Tmp) &&
                     (bCurBank == Coverage_Bank[1]) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd1)) ||
                       ((Coverage_Range_SAd2 <= Code_Access_Tmp) &&
                     (bCurBank == Coverage_Bank[2]) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd2)) ||
                       ((Coverage_Range_SAd3 <= Code_Access_Tmp) &&
                     (bCurBank == Coverage_Bank[3]) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd3)) ) {
                     if (k == i-1) {
                        if (Coverage_Flg == 1)
                 // Add for avoid set the not 's' status as the start
                 // access address (Coverage_Flg = 1 is 's').
                        {
                           Code_Access_Range_SAd[i] = Code_Access_Tmp;
                           Code_Access_Range_DAd[i] = Code_Access_Tmp;
                              if (bBank == 1)
                              {
                                 chCode_Access_Ad_Type[i] = bCurBank ;
                              } else
                              {
                                 chCode_Access_Ad_Type[i] = 1;
                              }

                           Frame_adr[i] = Code_Access_Tmp;
                           k = i;
                        }
                     }
		     else {
                        for (l = i; l >= 1; l-- ) {
                           if (((Code_Access_Tmp == Code_Access_Range_DAd[l]) ||
                                (Code_Access_Tmp == Code_Access_Range_DAd[l] + 1)) &&
                                (bCurBank == chCode_Access_Ad_Type[l]))
                           {
                              Code_Access_Range_DAd[l] = Code_Access_Tmp;
                              if (Coverage_Flg == 1)
                              {
                                 Frame_adr[l] = Code_Access_Tmp;
                              }
                              m = 1;
                              l = 1;
                           }
                           else {
                              if (( Code_Access_Range_SAd[l] <= Code_Access_Tmp) &&
                                  (bCurBank == chCode_Access_Ad_Type[l]) &&
                                  (Code_Access_Tmp < Code_Access_Range_DAd[l] ))
                              {
                                 m = 1;
                                 l = 1;
                              }
                              else { m = 0; }

                           }
			}
                        if ((m != 1) && (Coverage_Flg == 1))
                 // Add for avoid set the not 's' status as the start
                 // access address (Coverage_Flg = 1 is 's').
                        {
                              i++;
			      Code_Access_Range_SAd[i] = Code_Access_Tmp;
			      Code_Access_Range_DAd[i] = Code_Access_Tmp;
                              if (bBank == 1)
                              {
                                 chCode_Access_Ad_Type[i] = bCurBank ;
                              } else
                              {
                                 chCode_Access_Ad_Type[i] = 1;
                              }

                              Frame_adr[i] = Code_Access_Tmp;
			      k = i;
                        }
                        if (Code_Access_Range_SAd[i] != Code_Access_Range_DAd[i])
                        {
                           for (l = 1; l < i; l++) {
                              if ((Code_Access_Range_DAd[i] == Code_Access_Range_SAd[l])
                               && (chCode_Access_Ad_Type[i] == chCode_Access_Ad_Type[l]))
                              {
                                 Code_Access_Range_SAd[l] = Code_Access_Range_SAd[i];
                                 i--;
                                 k--;
                              }
                           }
                        }
                        if ( i > 16 ) {
                           j = traceCnt ;
                        }
                     }
		  }
               }
               break;

      case 4:
               i = 1;
               k = 0;
               for (j = 1; j <= traceCnt; j++ ) {
                  chCurPort = Read_Trace_Port();
                  Code_Access_Tmp = Read_Trace_Content();
                  GetCurPort();
                  if ( ((Coverage_Range_SAd1 <= Code_Access_Tmp) &&
                     (bCurBank == Coverage_Bank[1]) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd1)) ||
                       ((Coverage_Range_SAd2 <= Code_Access_Tmp) &&
                     (bCurBank == Coverage_Bank[2]) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd2)) ||
                       ((Coverage_Range_SAd3 <= Code_Access_Tmp) &&
                     (bCurBank == Coverage_Bank[3]) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd3)) ||
                       ((Coverage_Range_SAd4 <= Code_Access_Tmp) &&
                     (bCurBank == Coverage_Bank[4]) &&
                     (Code_Access_Tmp <= Coverage_Range_DAd4)) ) {
                     if (k == i-1) {
                        if (Coverage_Flg == 1)
                 // Add for avoid set the not 's' status as the start
                 // access address (Coverage_Flg = 1 is 's').
                        {
                           Code_Access_Range_SAd[i] = Code_Access_Tmp;
                           Code_Access_Range_DAd[i] = Code_Access_Tmp;
                              if (bBank == 1)
                              {
                                 chCode_Access_Ad_Type[i] = bCurBank ;
                              } else
                              {
                                 chCode_Access_Ad_Type[i] = 1;
                              }

                           Frame_adr[i] = Code_Access_Tmp;
                           k = i;
                        }
                     }
		     else {
                        for (l = i; l >= 1; l-- ) {
                           if (((Code_Access_Tmp == Code_Access_Range_DAd[l]) ||
                                (Code_Access_Tmp == Code_Access_Range_DAd[l] + 1)) &&
                                (bCurBank == chCode_Access_Ad_Type[l]))
                           {
                              Code_Access_Range_DAd[l] = Code_Access_Tmp;
                              if (Coverage_Flg == 1)
                              {
                                 Frame_adr[l] = Code_Access_Tmp;
                              }
                              m = 1;
                              l = 1;
                           }
                           else {
                              if (( Code_Access_Range_SAd[l] <= Code_Access_Tmp) &&
                                  (bCurBank == chCode_Access_Ad_Type[l]) &&
                                  (Code_Access_Tmp < Code_Access_Range_DAd[l] ))
                              {
                                 m = 1;
                                 l = 1;
                              }
                              else { m = 0; }

                           }
			}
                        if ((m != 1) && (Coverage_Flg == 1))
                 // Add for avoid set the not 's' status as the start
                 // access address (Coverage_Flg = 1 is 's').
                        {
                              i++;
                              Code_Access_Range_SAd[i] = Code_Access_Tmp;
			      Code_Access_Range_DAd[i] = Code_Access_Tmp;
                              if (bBank == 1)
                              {
                                 chCode_Access_Ad_Type[i] = bCurBank ;
                              } else
                              {
                                 chCode_Access_Ad_Type[i] = 1;
                              }

                              Frame_adr[i] = Code_Access_Tmp;
                              k = i;
                        }
                        if (Code_Access_Range_SAd[i] != Code_Access_Range_DAd[i])
                        {
                           for (l = 1; l < i; l++) {
                              if ((Code_Access_Range_DAd[i] == Code_Access_Range_SAd[l])
                               && (chCode_Access_Ad_Type[i] == chCode_Access_Ad_Type[l]))
                              {
                                 Code_Access_Range_SAd[l] = Code_Access_Range_SAd[i];
                                 i--;
                                 k--;
                              }
                           }
                        }
                        if ( i > 16 ) {
// -koo 8/16/1996          i = 16;
                           j = traceCnt ;
                        }
                     }
		  }
               }
               break;

      default:
               break;
   }
   if (bBank == 1)
   {
      for (i = 1; i<17; i++)
      {
         chCode_Access_Ad_Type[i] += 6;
      }
   }
   Code_Access_No = k;
   SaveTraceEnd();
   chCurPort = chPortTmp;
   bCurBank = bBankTmp;
}

void go_trace( void )
{
   unsigned int l,m;

   if ((bBank == 1) && (chBankNo > 1)) return ;

   bCS2 = bCS2 | TFLYOFF ;
   bCtrl0 = bCtrl0 & ~ENTRACE ; /* disable trace writing */
   NCS2 = bCS2 ;
   LDCTRL0 = bCtrl0 ;
   ReadElTimer();
// Read_Trace_Content();      // skip for TFLYOFF to TRACE_EN
   UpdateTraceCnt();
/* Read_Trace_Ini();
   LdTraceCnt(traceEnd +1 );
   l = Read_Trace_Content();
   m = Read_Trace_Content();
   if( l == m && Coverage_Flg == 1)
   {
      traceStart = traceStart - 1;
      traceEnd = traceEnd - 1;
   }
*/
}

unsigned char Trace_Init( void )
{
   unsigned char retval;
   if( epRunFlag == 1)
   {
      if( (commandStream[1] & 0x1) == 0 )  //trace off
      {
         if( getTraceCnt == 0 )
         {
            go_trace();
         }
         if(getTraceCnt == 0)
         {
            bCtrl0 = bCtrl0 | ENTRACE ; // enalbe trace writing
            LDCTRL0 = bCtrl0 ;
            getTraceCnt = 0;
            retval = TraceRunning;
         }
         else
         {
            retval = Ini_Trace( commandStream[1] );
         }
         TransmitBuf[0] = retval;
      }
      else
      {
         retval = Ini_Trace( commandStream[1] );
         LDST = bLdst;
         bCS2 = bCS2 & ~TFLYOFF ;
         bCtrl0 = bCtrl0 | ENTRACE ; /* enable trace writing */
         bRamen = 0;
         bBufen = bBufen & (~NENTDBUF) & (~NENTABUF) ;
         NCS2 = bCS2 ;
         LDCTRL0 = bCtrl0 ;
         LDBUFEN = bBufen ;
         LDRAMEN = bRamen;
         getTraceCnt = 0 ;
         traceCnt = 0 ;
         TransmitBuf[0] = retval;
      }
   }
   else
   {
      retval = Ini_Trace( commandStream[1] );
      TransmitBuf[0] = retval;
   }
}

unsigned char Cover_Get(void)
{
         Coverage_Flg = 0;
         Analyse_Coverage();
         TransmitBuf[0] = 0;
         TransmitBuf[1] = Code_Access_No;
         temp2 = 1;
         while ( (temp2 <= Code_Access_No) && (temp2 < 17) ) {
            TransmitBuf[temp2 * 4 - 2] = Code_Access_Range_SAd[temp2] & 0x00ff;
            TransmitBuf[temp2 * 4 - 1] = Code_Access_Range_SAd[temp2]/256;
            TransmitBuf[temp2 * 4 - 0] = Frame_adr[temp2] & 0x00ff;
            TransmitBuf[temp2 * 4 + 1] = Frame_adr[temp2]/256;
            TransmitBuf[temp2 * 2 + 64] = chCode_Access_Ad_Type[temp2];
            TransmitBuf[temp2 * 2 + 65] = chCode_Access_Ad_Type[temp2];
            temp2 ++;
         }
         TStreamLen = (temp2 + 1) * 2 + 64 ;
}


extern xdata unsigned char clockMsg[9] ;
unsigned char ConvTimerToMhz(unsigned int timerValue) {
#if 0
U8 timer ;
U16 timer0, timer1 ;

// main board using 16M clock

   if (timerValue < 5721)
      timer0 = 60128 ; // >= 21Mhz
   else
      timer0 = 60080 ; // < 21Mhz
// V1.3 update for 40MHZ
   if (timerValue < 3010)
      timer0 = 60160 ;  // 40Mhz

   timer = timer0 / timerValue ;     /* 120160(120256) / timerValue */

   clockMsg[0] = '0' + (timer / 5) ;
   timer = timer * 2 ;
   clockMsg[1] = '0' + (timer % 10) ;


   timer1 = timer0 % timerValue ;
   timer1 = timer1 * 20 ;
   timer = timer1 / timerValue ;
   clockMsg[3] = '0' + timer ;

   timer1 = timer1 % timerValue ;
   timer1 = timer1 * 10 ;
   timer = timer1 / timerValue ;
   clockMsg[4] = '0' + timer ;

   return(0) ;
#endif
//#if 0
// main board using 14.7456M Crystal
U8 timer[6];
U32 timer0,timer1;

//   timer0 = 7500 * 16 ; // There 16 meaning 16Mhz.
   timer0 = 7500 * 147456 ;
   timer1 = timer0 / 10000 / (timerValue - 8) / 10 ;
   timer[0] = (U8) (timer1 & 0xff);

   clockMsg[0] = '0' + timer[0] ;

   timer1 = timer0 / 10000 / (timerValue - 8) - timer[0] * 10 ;
   timer[1] = (U8) (timer1 & 0xff);
   clockMsg[1] = '0' + timer[1] ;

   clockMsg[2] = '.' ;

   timer1 = timer0 / 1000 / (timerValue - 8) - timer[0] * 100 - timer[1] * 10 ;
   timer[2] = (U8) (timer1 & 0xff);
   clockMsg[3] = '0' + timer[2] ;

   timer1 = timer0 / 100 / (timerValue - 8) - timer[0] * 1000 - timer[1] * 100
               - timer[2] * 10 ;
   timer[3] = (U8) (timer1 & 0xff);
   clockMsg[4] = '0' + timer[3] ;

   timer1 = timer0 / 10 / (timerValue - 8) - timer[0] * 10000 - timer[1] * 1000
               - timer[2] * 100 -timer[3] * 10 ;
   timer[4] = (U8) (timer1 & 0xff);
   clockMsg[5] = '0' + timer[4] ;

   timer1 = timer0 / (timerValue - 8) - timer[0] * 100000 - timer[1] * 10000
               - timer[2] * 1000 - timer[3] * 100 - timer[4] * 10 ;
   timer[5] = (U8) (timer1 & 0xff);
   clockMsg[6] = '0' + timer[5] ;

   return(0) ;
//#endif
}

