#
#  Name: makefile.mak
#
#  Description: Make definitions for TBird shared data server
#
#  COPYRIGHT (C) 1992 MICROTEK INTERNATIONAL, INC.
#

.AUTODEPEND
#.SWAP

#
# files
#
SRC = .
ASMSRC = asm
BIN = bin
CCDIR = S:\tools\C600\bin
INC = S:\tools\C600\include
LNKDIR = S:\tools\lnkloc\bin
TMPDIR = c:\temp

#
# paths
#
.PATH.lst = $(SRC)
.PATH.c   = $(SRC)
.PATH.db  = $(ASMSRC)
.PATH.tbl = $(ASMSRC)
.PATH.equ = $(ASMSRC)
.PATH.def = $(ASMSRC)
.PATH.asm = $(ASMSRC)
.PATH.a00 = $(ASMSRC)
.PATH.obj = $(BIN)
.PATH.lib = $(BIN)
.PATH.ssi = $(BIN)
.PATH.lnk = $(BIN)
.PATH.ABS = $(BIN)
.PATH.HEX = $(BIN)

#               *Translator Definitions*
LINK = $(LNKDIR)\xlink86
LOC = $(LNKDIR)\xloc86
PROM = $(LNKDIR)\prom86
OH86 = $(LNKDIR)\xoh86
CV2OMF = $(LNKDIR)\cv2omf
CONV = $(USDDIR)\CONVERT
CHKSUM = mice3chk
CC = $(CCDIR)\cl
MASM = $(CCDIR)\masm
CFLAG = /AM /G1 /Gs /Od /Oi /Zp /c /FPa /Zi /W3
CODEGEN = codegen

#               *Implicit Rules*
.C.obj:
#$(CC) $(CFLAG) /I. /I./asm /I$(INC) /Fa$(BIN)\$& /Fo$(SRC)\bin\$&.obj $(SRC)\$&.C
 $(CC) $(CFLAG) /I. /I./asm /I$(INC) /Fo$(SRC)\bin\$&.obj $(SRC)\$&.C

.A00.obj:
 $(MASM) /Mx /Zi /W2 /z /Zd /I$(ASMSRC) $(ASMSRC)\$&.A00,$(BIN)\$&,$(SRC)\ERR;

# define all objs
LNK_depends =  start.obj wrom.obj bios.obj boot.obj\
               wcomm.obj wmain.obj
#

BOOT603e.HEX : BOOT603e.BIN
 iunHEX 1C000 0 $(BIN)\BOOT603e

BOOT603e.BIN : ISP_CODE.DEF
 $(PROM)  $(BIN)\ISP603e.ABS TO $(BIN)\BOOT603e.BIN ADDRESSES(0E0000H, 0FFFFFH) CHECKSUM

ISP_CODE.DEF : ISP603e.BIN
 asmHEX 11264 4096 $(BIN)\ISP603e $(BIN)\ISP_CODE

ISP603e.BIN : ISP603e.OMF
 $(PROM)  $(BIN)\ISP603e.ABS TO $(BIN)\ISP603e.BIN ADDRESSES(400H, 3FFFH) CHECKSUM

ISP603e.OMF : ISP603e.ABS
 $(CV2OMF) $(BIN)\ISP603e.ABS TO $(BIN)\ISP603e.OMF

ISP603e.ABS : ISP603e.LNK
 $(LOC)  @&&!
            $(BIN)\ISP603e.LNK TO $(BIN)\$&.ABS &
            NOIC &               Do not generate new segment for register initialization
            ORDER(CLASSES(&
                 FAR_DATA_BEG,FAR_DATA,FAR_DATA_END,&
                 DATA_BEG,&
                 DATA,&
                 CONST,&
                 DATA_END,&
                 MSG,&
                 BSS, &
                 BSS_END,&
                 CODE,&
                 CODE_END&
            )) &
            RESERVE(00H TO 03FFH) &
            ADDRESSES(CLASSES( &
               DATA_BEG(  400H),&
               STACK(1400H),&
               CODE( 3000H),&
               CPBUF( 4000H),&
               FLASH(0E0000h),&
               BIOS(0FC000h),&
               BOOT(0FFF80h),&
               DEBSYM(040000H),DEBTYP(048000H)),&
               GROUPS(DGROUP(00400H)) &
            )&
            SEGSIZE(STACK(1C00H))&
            ST(BOOT_INIT)&
            BS
!


#               *Explicit Rules*

# .A00  condition definition start!
start.obj : start.a00 commdata.h cppcb.def cpinit.def macro.def\
            strings.def
wrom.obj : wrom.a00 cppcb.def macro.def
bios.obj : bios.a00 cppcb.def cpinit.def macro.def
boot.obj : boot.a00 cppcb.def cpinit.def

# .C condition definition
wcomm.obj: wcomm.c wtypes.h wcomm.h commdata.h flash.h strings.def
wmain.obj: wmain.c wtypes.h wcomm.h commdata.h flash.h strings.def

ISP603e.LNK : $(LNK_depends)
 $(LINK) @&&!
             $(BIN)\start.obj,$(BIN)\wrom.obj,&
             $(BIN)\wcomm.obj,$(BIN)\wmain.obj,&
             $(BIN)\bios.obj,$(BIN)\boot.obj,&
             $(BIN)\mLIBce.ssi &
             TO $(BIN)\ISP603e.LNK
!

