#include "wtypes.h"
#include "wcomm.h"
#include "commdata.h"
#include "flash.h"
#include "strings.def"

VOID SendStr(U16 str){
U16 wait=0xFF;
  if(wait &= write_str(str))
    ISP_SetWatchDog(wait);
  timeOut=0;
}

VOID SendStrWait(U16 str){
U16 wait=0xFF;
  if(wait &= write_str(str))
    ISP_SetWatchDog(wait);
  for(timeOut=0;!timeOut;);
}

U8 sum;

int hex2bin(U8 c){
  if(('0'<=c)&&(c<='9'))
    return c-'0';
  if(('A'<=c)&&(c<='F'))
    return c-'A'+10;
  if(('a'<=c)&&(c<='f'))
    return c-'a'+10;
  return -1;
}

int hex2byte(U8 *hex, U8 *bin){
  int low,high;
  if((high=hex2bin(hex[0])) < 0)
    return -1;
  if((low=hex2bin(hex[1])) < 0)
    return -1;
  sum += (*bin = (U8)(high*16+low));
  return 0;
}

int hex2word(U8 *hex, U16 *bin){
  int t0,t1,t2,t3;
  if((t3=hex2bin(hex[0])) < 0)
    return -1;
  if((t2=hex2bin(hex[1])) < 0)
    return -1;
  if((t1=hex2bin(hex[2])) < 0)
    return -1;
  if((t0=hex2bin(hex[3])) < 0)
    return -1;
  sum += ((U8*)bin)[1] = (U8)(t3*16+t2);
  sum += ((U8*)bin)[0] = (U8)(t1*16+t0);
  return 0;
}

int DownLoad(VOID){
  U32 sum_b;
  U16 sum_w;
  U16 i,addr,body;
  U8 tmp[36],c;
  U8 len;

  ClearBuffer();
  for(;;){
    ISP_SetDmaCount(1);
    if(c=ISP_ReceiveByte())
      ISP_TransmitByte(c);
    if(c!=':')
      continue;
    ISP_SetDmaCount(6);
    break;
  }
  for(;;){
    sum=0;
    for(i=0;i<6;i++){
      tmp[i]=ISP_ReceiveByte();
      if(timeOut)
        return 1;
      ISP_TransmitByte(tmp[i]);
    }
    if(hex2byte(tmp,&len))
      return 1;
    if(hex2word(tmp+2,&addr))
      return 1;
    if(len==0)
      break;
    if(len!=16)
      return 1;
    if(addr>=FLASH_MAX)
      return 1;
    ISP_SetDmaCount((body=len+1)*2+1);
    for(i=0;i<body;i++){
      tmp[i]=ISP_ReceiveByte();
      if(timeOut)
        return 1;
      ISP_TransmitByte(tmp[i]);
      tmp[i+1]=ISP_ReceiveByte();
      if(timeOut)
        return 1;
      ISP_TransmitByte(tmp[i+1]);
      if(hex2byte(tmp+i,tmp+i))
        return 1;
    }
    c=ISP_ReceiveByte();
    if(timeOut)
      return 1;
    ISP_TransmitByte(c);
    if(sum!=0)
      return 1;
    ISP_SetDmaCount(7);
    SetBuffer(addr,tmp);
    for(;;){
      if(c=ISP_ReceiveByte())
        ISP_TransmitByte(c);
      if(c==':')
        break;
      else if(c)
        return 1;
      ISP_SetDmaCount(7);
    }
  }
  BufferChkSum(&sum_w,&sum_b);
  if((sum_w+addr)||(U8)sum_b)
    return 1;
  tmp[0]='M';
  tmp[1]='I';
  tmp[2]='C';
  tmp[3]='R';
  tmp[4]='O';
  tmp[5]='T';
  tmp[6]='E';
  tmp[7]='K';
  ((U16*)tmp)[4] = 0xFFFF;
  ((U16*)tmp)[5] = sum_w;
  ((U32*)tmp)[3] = sum_b;
  SetBuffer(FLASH_MAX,tmp);
  SendStr(S_chk_sum);
  SendHex(((U8*)&sum_b)[3]);
  SendHex(((U8*)&sum_b)[2]);
  SendHex(((U8*)&sum_b)[1]);
  SendHex(((U8*)&sum_b)[0]);
  while(!timeOut);
  return 0;
}
