/*********************************************************/
/* Communication Subroutine in START.ASM                 */
/*********************************************************/
#define  SPiclk     0x8000
#define  Baud_1152  (SPiclk+16)   // (16MHz/(8*115200))-1
#define  Baud_576   (SPiclk+34)   // (16MHz/(8*57600))-1
#define  Baud_384   (SPiclk+51)   // (16MHz/(8*38400))-1
#define  Baud_192   (SPiclk+103)  // (16MHz/(8*19200))-1
#define  Baud_96    (SPiclk+207)  // (16MHz/(8*9600))-1

VOID ISP_BaudRate(U16 Scale);
// Set baud rate,
// both transmit and receive must be stop before changing baud rate

VOID ISP_SetBaudRateTimer(U16 T);
//  set baud rate timer equal to T*0.1sec

VOID ISP_SetWatchDog(U16 T);
//  set watchdog timer equal to T*10ms

VOID ISP_HltWatchDog(VOID);
//  halt WatchDog timer

VOID ISP_SetDmaCount(U16 dmaCnt);
//  start receive logic to transfer dmaCnt bytes
//  dmaCnt must be a non-zero value

U8   ISP_ReceiveByte(VOID);
//  get one byte from receive buffer

VOID ISP_CommRecover(VOID);
//  reset transmit logic, remaining data in transmit buffer will lost

U16  ISP_outSize(VOID);
//  remaining bytes in transmit buffer

VOID ISP_TransmitByte(U8 byteData);
//  put one byte to transmit buffer
//  if buffer is full, data will lost

U16 write_str(U16);

/*********************************************************/
/* Communication Subroutine in wcomm.c                   */
/*********************************************************/
VOID SendStr(U16 str);
VOID SendStrWait(U16 str);
VOID SendHex(U8 ch);

int DownLoad(VOID);
