/****************************************************************************
*
*  Name:  CONVPIC.c
*
*  Description:
*     This is the program to convert PIC's can program list file.
*     input file is the list file which generated from MPASM Assembler
*
*  Status:  PRELIMINARY
*
*  $Log$
*
*  $Header$
*
*  Copyright (C) 1996 S. Q. Xu  All rights reserved.
*
****************************************************************************/
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "stdio.h"
#include "stdlib.h"
#include "malloc.h"
#include "string.h"
#include "ctype.h"
#include "dos.h"
#include "time.h"
#ifdef _DOS16M_
#include "dos16.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

#define U8  unsigned char
#define U16 unsigned int
#define U32 unsigned long
#define RETCODE U16
#define ADDR U16
#define OK   0
#define GOOD 0
#define TRUE 1
#define YES  1
#define NO   0
#define FALSE 0

#define LF    0xA
#define CR    0xD

#define CODE_ADDR    0
#define CODE_START   5     /* for franklin 51 Assembler V4.4  */
#define LINE_NO     22
#define LABEL_START 26

U16     SYM_LEN  =  12 ;
#define SYM_TYPE    SYM_LEN+3
#define SYM_VALUE   SYM_TYPE+1
#define SYM_ATTRIB  SYM_VALUE+5
#define SYM_END     ' '
U8 CMP_STRING[] = "SYMBOL TABLE" ;

typedef U8 BOOLEAN ;

#define VerStr  "PIC Code Convert V(0.1) MICROTEK (c) 1996.3 Written by S. Q. Xu \n"
int     scr_X, scr_Y ;

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

void outAddr(U16 addr) ;
void gotoxy(int Hor, int Ver) ;
void scr_loc(int *lin,int *col) ;
void set_cur(U8 ,U8) ;

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

RETCODE main(argc, argv, envp)
int argc ;
char *argv[], *envp[];
{
       U16     i, j = 0, addr, pc ;
       FILE    *inFile, *outFile, *outTblFile, *outEquFile;
time_t  beginTime, endTime ;
static U8      inFileName[40],outFileName[40],  c, lineBuf[255] ;
static U8      tmp1Buf[32], tmp2Buf[255], tmpStr[255] ;
static U8      outTblFileName[40], outEquFileName[40], fileEnd, tblFlag, equFlag  ;
//static RETCODE ret, ret1 ;
       U16     totalSymbols = 0, totalCode = 0 ;
       U8      symFlag = 0 ;

   printf(VerStr) ;
   j = 0 ;

   for (i = 1; i < argc; i++) {
      if ((argv[i][0] == '/') || (argv[i][0] == '-')) { /* set parament */
//       if ((ret = SetParVal(argv[i])) != GOOD) { /* parament error! */
/*          Help() ;    */
//          return(2) ;
//       }
      }
      else {
         switch(j++) {
            case 0:
               strcpy(inFileName,argv[i]) ;
               break ;

            case 1:
               strcpy(outFileName,argv[i]) ;
               break ;

            case 2:
               strcpy(outEquFileName,argv[i]) ;
               equFlag = TRUE ;
               break ;

            case 3:
               strcpy(outTblFileName,argv[i]) ;
               tblFlag = TRUE ;
               break ;

            default:
               printf("Invaild paraments erro!, enter >CONVPIC infile.lst outFile.dw [outFile.equ][outFile.tbl]<CR>\n") ;
 /*            Help() ;  */
               return(3) ;
         }
      }
   }

   switch(j) {
      case 0:
         printf("input Filename : ") ;
         i = 0;
         while (((c=(U8)getchar()) != '\n') && (i < 40))
            inFileName[i++] = c ;
         inFileName[i] = 0 ; /* end of string */
      case 1:
         strcpy(outFileName, "CON") ;
      case 2:
         equFlag = FALSE ;
      case 3:
         tblFlag = FALSE ;
      case 4:
         if ((inFile = fopen(inFileName,"rt")) == NULL) {
            printf("Could not open file %s\n", inFileName) ;
            return(-1) ;
         }
         if ((outFile = fopen(outFileName,"wt")) == NULL) {
            printf("Could not open file %s\n", outFileName) ;
            return(-1) ;
         }
         if (equFlag == TRUE)
            if ((outEquFile = fopen(outEquFileName,"wt")) == NULL) {
               printf("Could not open file %s\n", outEquFileName) ;
               return(-1) ;
            }
         if (tblFlag == TRUE)
            if ((outTblFile = fopen(outTblFileName,"wt")) == NULL) {
               printf("Could not open file %s\n", outTblFileName) ;
               return(-1) ;
            }
         break ;

      default:
         printf("Invaild paraments erro!, enter >CONVPIC infile.ext [outFile.dw [outFile.tb]l]<CR>\n") ;
         exit(-1) ;
   }


   if (equFlag == TRUE)
      fprintf(outEquFile, ";*\n;*\n;*     %s;*\n;*\n", VerStr) ;
   if (tblFlag == TRUE)
      fprintf(outTblFile, "/* \n\n    %s\n*/\n", VerStr) ;
   if (strcmp(outFileName, "CON") != 0)
      fprintf(outFile, ";*\n;*\n;*     %s;*\n;*\n", VerStr) ;
   fileEnd = NO ;
   time(&beginTime) ; // start timer
   addr =  0 ;
   pc = 0xffff ;
   tmp1Buf[0] = '0' ;
   tmp1Buf[6] =  0 ;
   set_cur(15,0) ; /* turn off cur */
   printf("\n   Process address: ") ;
   scr_loc(&scr_Y, &scr_X) ;
   do {
      if (fgets(lineBuf, 255, inFile) == NULL) {
         /* end of file */
         time(&endTime) ;
         endTime -= beginTime ;
         printf("\n   Convert finishied!!! No failure found.\n") ;
         printf(  "   Total %5.5d code converted, %5.5d symbols created,",
                 totalCode, totalSymbols) ;
         printf(" %d seconds elapsed.\n", endTime) ;
         fileEnd = YES ;
      }
      else {
         if ((symFlag == 0) && (strlen(lineBuf) > LABEL_START) &&
             (lineBuf[LINE_NO+2] >= '0') && (lineBuf[LINE_NO+2] <= '9') &&
             (((lineBuf[CODE_ADDR] >= '0') && (lineBuf[CODE_ADDR] <= '9')) ||
              ((lineBuf[CODE_ADDR] >= 'A') && (lineBuf[CODE_ADDR] <= 'F')))) {
            memcpy(tmp1Buf+1, lineBuf, 4) ;
            j = LABEL_START ;
            while ((j < strlen(lineBuf)) && (lineBuf[j] != ':') &&
                   (lineBuf[j] != ' ') && (lineBuf[j] != ';')) {
               j++ ;
            }
            sscanf(tmp1Buf, "%x", &addr) ;
/*
            if (pc < (addr - 0x1))
               fprintf(outFile, "       DS  0%4.4XH\n", addr-pc) ;*/
            if (j > LABEL_START) {
               memcpy(tmp2Buf, lineBuf+LABEL_START, j - LABEL_START+1) ;
               tmp2Buf[j - LABEL_START] = 0 ;
               tmp1Buf[5] = 'H' ;
//             fprintf(outFile, "%s EQU %s\n", tmp2Buf, tmp1Buf) ;
               fprintf(outFile, ";%s = %s\n", tmp2Buf, tmp1Buf) ;
               tmp1Buf[5] = 0 ;
//             if (tblFlag == TRUE)
//                fprintf(outTblFile, "#define %s 0X%s\n", tmp2Buf, tmp1Buf) ;
            }
            i = CODE_START ;
            while (lineBuf[i] != ' ') {
               if (i == CODE_START) {
                  sprintf(tmpStr, "       DB  0%c%cH", lineBuf[i], lineBuf[i+1]) ;
               }
               else
                  sprintf(tmpStr+strlen(tmpStr), ", 0%c%cH", lineBuf[i], lineBuf[i+1]) ;
               i += 2;
               addr++;
               totalCode++ ;
            }
            if (i != CODE_START) {
               j = strlen(tmpStr) ;
               while (j < 30)
                  tmpStr[j++] = ' ' ;
               sprintf(tmpStr+j, " ;%s: %s", tmp1Buf+1, lineBuf+LABEL_START) ;
               fprintf(outFile, "%s", tmpStr) ;
            }
            outAddr(addr) ;
            pc = addr ;
         }
         if ((symFlag == 0) && (strlen(lineBuf) > strlen(CMP_STRING)-1) &&
             (memcmp(lineBuf, CMP_STRING, strlen(CMP_STRING)-1) == 0))
            symFlag = 1 ;
         else {
            if ((symFlag == 1) && ((i = strlen(lineBuf)) > 25))
               if (memcmp(lineBuf, "LABEL", 5) == 0) {
                  SYM_LEN = 5 ;
                  while ((lineBuf[SYM_LEN] == ' ') && (SYM_LEN < i))
                     SYM_LEN++ ;
                  if (lineBuf[SYM_LEN] == 'V') {
                     SYM_LEN -= 3 ;
                     symFlag = 2 ;
                  }
               }
            /* create symbols use cross-referce table */
            if ((symFlag == 2) && (strlen(lineBuf) > 25) &&
                (equFlag == TRUE) &&
                (((lineBuf[36] >= '0') && (lineBuf[36] <= '9')) ||
                ((lineBuf[36] >= 'A') && (lineBuf[36] <= 'F')))
                ) {
               for (i = 0; i <= SYM_LEN ; i++) {
                    if (lineBuf[i] != SYM_END)
                     tmp2Buf[i] = lineBuf[i] ;
                    else
                       tmp2Buf[i] = ' ' ;
               }
               tmp2Buf[SYM_LEN+1] = 0 ;
               memcpy(tmp1Buf, lineBuf+SYM_VALUE, 4) ;
               tmp1Buf[4] = 0 ;
               fprintf(outEquFile, "%s EQU 0%sH\n", tmp2Buf, tmp1Buf) ;
               if (tblFlag == TRUE)
                  fprintf(outTblFile, "#define %s 0x%s\n", tmp2Buf, tmp1Buf) ;
               totalSymbols++ ;
            }
         }
      }
   } while (fileEnd == NO) ;
   set_cur(11,12) ; /* turn on cur */
   fclose(inFile) ;
   fclose(outFile) ;
   fclose(outEquFile) ;
   fclose(outTblFile) ;
   exit  ;

}
void outAddr(U16 address) {


   gotoxy(scr_X, scr_Y) ;
   printf("%4.4X", address) ;
}

void scr_loc(lin,col)
int *lin, *col;
{
union REGS regs;

   regs.h.ah = 0x03;
   regs.h.bh = 0x0;
   int86(0x10,&regs,&regs);
   *lin = regs.h.dh;
   *col = regs.h.dl;
}

void gotoxy(Hor,Ver)
int Hor, Ver;
{
union REGS regs;

   regs.h.ah = 0x02;
   regs.h.bh = 0;
   regs.h.dh = (U8)Ver;
   regs.h.dl = (U8)Hor;
   int86(0x10,&regs,&regs);
}

void set_cur(start, end)
U8  start, end ;
{
union REGS regs;

   regs.h.ah = 0x01;
   regs.h.ch = start;
   regs.h.cl = end;
   int86(0x10,&regs,&regs);
}

