/**************************************************************************
**
** $Header:
**
** $Log:
** 
** 
** Initial revision. 1.0
** 
***************************************************************************/
/****************************************************************************
**
**  Name:         fwspa.c
**
**  Description:    SPA C source routines of EasyPack PIC16F firmware .
**
**
**  Status:  PRELIMINARY
**
**  
**  Modification:
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <reg51.h>
#include "io.h"
#define  CommandExeOk       0x00
#define  CmdInvalid         0x13

/******************************************************************************/
                  /**********************
                  *  extern data        *
                  **********************/
/////////////////////////////////////////////////////////////////////////////
// Global variables.
extern unsigned char exe_bp_addr0 ;
extern unsigned char exe_bp_addr1 ;
extern unsigned char  EPrunningFlag ;
extern unsigned char Select_break;
extern unsigned char break_type_in  ;
extern unsigned char trace_addrl ;
extern unsigned char trace_addrh ;
extern unsigned char pic_addrl ;
extern unsigned char pic_addrh ;
extern unsigned char commandStream[2048];
extern unsigned int TStreamLen;
extern unsigned char TransmitBuf[2048] ;
extern unsigned char exe_bp_addr0  ;
extern unsigned char exe_bp_addr1  ;
extern unsigned int trace1_start_frame;
extern unsigned int Coverage_Range_SAd1;
extern unsigned int Coverage_Range_DAd1;
extern unsigned int Coverage_Range_SAd2;
extern unsigned int Coverage_Range_DAd2;
extern unsigned int Coverage_Range_SAd3;
extern unsigned int Coverage_Range_DAd3;
extern unsigned int Coverage_Range_SAd4;
extern unsigned int Coverage_Range_DAd4;
extern unsigned char Coverage_Range_No;
extern unsigned char retvalue;
extern unsigned char Coverage_Flg;
/////////////////////////////////////////////////////////////////////////////

                  /**********************
                  *  extern code        *
                  **********************/


extern void set_cp_access_emu(void) ;
extern void sel_cp_trace(void) ;
extern sel_code_coverage(void);
extern clr_code_coverage(void);
extern void set_break_type(void) ;
extern void read_coverage_value(void);
extern clr_exe_bp_addr(void);
extern unsigned char fw_ep_start(void);
extern void set_exe_bp_addr(void) ;
extern void set_ep_access_emu(void) ;

/******************************************************************************/

unsigned int Code_Access_Range_SAd[17];
unsigned int Code_Access_Range_DAd[17];
unsigned char Code_Access_No;
unsigned char temp1,temp2;

void  Analyse_Coverage(void);
void  Fw_SpaCoverageGet(void);
void Read_Coverage_Content(unsigned int);
void Fw_SpaCoveragecheck(void);           // Jason 10/28/96

///////////////////////////////////////////////////////////////////////////////
//   Fw_SpaCoverageGet(void)
//
//         function :   the Analyse which codes had been coveraged
//
//         input :
//                Coverage_Range_No
//                Coverage_Range_SAd1
//                Coverage_Range_DAd1
//                Coverage_Range_SAd2
//                Coverage_Range_DAd2
//                Coverage_Range_SAd3
//                Coverage_Range_DAd3
//                Coverage_Range_SAd4
//                Coverage_Range_DAd4
//         output :
//                    the number of segment to ABI
//
//                    TransmitBuf[Number_segment * 4 - 2]   ;low byte of the segment
//                                                           start address
//                    TransmitBuf[Number_segment  * 4 - 1]  ;high byte of the segment
//                                                           start address
//                    TransmitBuf[Number_segment  * 4]      ;low byte of the segment
//                                                           end  address
//                    TransmitBuf[Number_segment  * 4 + 1]  ;high byte of the segment
//                                                           end  address
//
///////////////////////////////////////////////////////////////////////////////
//
//
void Fw_SpaCoverageGet(void)
    {
         Coverage_Flg = 0;       //  set the Coverage_Flg for identify the status
                                 //  is the SPA status or other status .

         Analyse_Coverage();    //   call the subroutine to analyse which codes
                                //   had been coveraged and return up to 17
                                //   couples of start and end addresses of
                                //   segment which had been coverage.

         TransmitBuf[0] = 0;    //  return the special code "CommandExeOk" to ABI.

         retvalue = 1;          //  initial the argument retvale

         Fw_SpaCoveragecheck(); //   call the subroutine to analyse the return
                                //   values of Analyse_Coverage().   if they
                                //   overlape each other , then reduce the
                                //   overlaping.

         TransmitBuf[1] = Code_Access_No;   // return the number of segment to ABI

         while ( (retvalue <= Code_Access_No) && (retvalue < 17) ) {
            TransmitBuf[retvalue * 4 - 2] = Code_Access_Range_SAd[retvalue] & 0x00ff;
            TransmitBuf[retvalue * 4 - 1] = Code_Access_Range_SAd[retvalue]/256;
            TransmitBuf[retvalue * 4]     = Code_Access_Range_DAd[retvalue] & 0x00ff;
            TransmitBuf[retvalue * 4 + 1] = Code_Access_Range_DAd[retvalue]/256;
            retvalue ++;
         }
         TStreamLen = (retvalue - 1) * 4 + 2;  // the len of next transmit stream.
   }

////////////////////////////////////////////////////////////////////////////////////
//         end of routine   Fw_SpaCoverageGet(void)
////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//   Analyse_Coverage()
//
//         function :  Analyse which code had coverage and puts their address
//                     to the array Code_Access_Range_SAd[i],Code_Access_Range_DAd[i]
//
//         input :
//                Coverage_Range_No
//                Coverage_Range_SAd1
//                Coverage_Range_DAd1
//                Coverage_Range_SAd2
//                Coverage_Range_DAd2
//                Coverage_Range_SAd3
//                Coverage_Range_DAd3
//                Coverage_Range_SAd4
//                Coverage_Range_DAd4
//         output :
//                the number of segment to ABI: Code_Access_No
//                Code_Access_Range_SAd[i] , Code_Access_Range_DAd[i]
//
///////////////////////////////////////////////////////////////////////////////
//
//                                              

void Analyse_Coverage()
{
 unsigned char i;
 unsigned int j;
 unsigned int t ;
 sel_cp_trace() ;
 for ( i = 0 ;i<17; i++)
     {    
      Code_Access_Range_SAd[i] = 0;        // the start address
      Code_Access_Range_DAd[i] = 0;        // the end address
     }

 switch ( Coverage_Range_No ) {

    case 1:
         i = 1;
         j = Coverage_Range_SAd1;
         while (i <17)
         {
          for ( ; j <=  Coverage_Range_DAd1; j++ ) {
               Read_Coverage_Content(j);
               if (Coverage_Flg == 1)
                  {
                   Code_Access_Range_SAd[i] = j;        // the start address
                   break;                               // of the segment
                   }
              }
          for ( ; j <=  Coverage_Range_DAd1; j++ ) {
               Read_Coverage_Content(j);
               Code_Access_Range_DAd[i] = j;        // the end address
               if (Coverage_Flg == 0)
                  {
               Code_Access_Range_DAd[i] = j-1;        // the end address
                   i ++;
                   break;                                 // of the segment
                   }
              }
          if ((j >=  Coverage_Range_DAd1)&&(Coverage_Flg == 1)) i++;
          if (j >=  Coverage_Range_DAd1) break;
         }
         break;
  //------------------------------------------------------------------------
  //                      end of case 1
  //------------------------------------------------------------------------
    case 2:
         i = 1;
         j = Coverage_Range_SAd1;
         while (i <17)
         {
          for ( ; j <=  Coverage_Range_DAd1; j++ ) {
               Read_Coverage_Content(j);
               if (Coverage_Flg == 1)
                  {
                   Code_Access_Range_SAd[i] = j;        // the start address
                   break;                               // of the segment
                   }
              }
          for ( ; j <=  Coverage_Range_DAd1; j++ ) {
               Read_Coverage_Content(j);
               Code_Access_Range_DAd[i] = j;        // the end address
               if (Coverage_Flg == 0)
                  {
                   Code_Access_Range_DAd[i] = j-1;        // the end address
                   i ++;
                   break;                                 // of the segment
                   }
              }
          if ((j >=  Coverage_Range_DAd1)&&(Coverage_Flg == 1)) i++;
          if (j >=  Coverage_Range_DAd1) break;
         }                                 
         j = Coverage_Range_SAd2;
         while (i <17)
         {
          for ( ; j <=  Coverage_Range_DAd2; j++ ) {
               Read_Coverage_Content(j);
               if (Coverage_Flg == 1)
                  {
                   Code_Access_Range_SAd[i] = j;        // the start address
                   break;                               // of the segment
                   }
              }
          for ( ; j <=  Coverage_Range_DAd2; j++ ) {
               Read_Coverage_Content(j);
               Code_Access_Range_DAd[i] = j;        // the end address
               if (Coverage_Flg == 0)
                  {
                   Code_Access_Range_DAd[i] = j-1;        // the end address
                   i ++;
                   break;                                 // of the segment
                   }
              }
          if ((j >=  Coverage_Range_DAd2)&&(Coverage_Flg == 1)) i++;
          if (j >=  Coverage_Range_DAd2) break;
         }
         break;
  //---------------------------------------------------------------------------
  //             end of case 2
  //---------------------------------------------------------------------------
    case 3:
         i = 1;
         j = Coverage_Range_SAd1;
         while (i <17)
         {
          for ( ; j <=  Coverage_Range_DAd1; j++ ) {
               Read_Coverage_Content(j);
               if (Coverage_Flg == 1)
                  {
                   Code_Access_Range_SAd[i] = j;        // the start address
                   break;                               // of the segment
                   }
              }
          for ( ; j <=  Coverage_Range_DAd1; j++ ) {
               Read_Coverage_Content(j);
               Code_Access_Range_DAd[i] = j;        // the end address
               if (Coverage_Flg == 0)
                  {
                   Code_Access_Range_DAd[i] = j-1;        // the end address
                   i ++;
                   break;                                 // of the segment
                   }
              }
          if ((j >=  Coverage_Range_DAd1)&&(Coverage_Flg == 1)) i++;
          if (j >=  Coverage_Range_DAd1) break;
         }                                 
         j = Coverage_Range_SAd2;
         while (i <17)
         {
          for ( ; j <=  Coverage_Range_DAd2; j++ ) {
               Read_Coverage_Content(j);
               if (Coverage_Flg == 1)
                  {
                   Code_Access_Range_SAd[i] = j;        // the start address
                   break;                               // of the segment
                   }
              }
          for ( ; j <=  Coverage_Range_DAd2; j++ ) {
               Read_Coverage_Content(j);
               Code_Access_Range_DAd[i] = j;        // the end address
               if (Coverage_Flg == 0)
                  {
                   Code_Access_Range_DAd[i] = j-1;        // the end address
                   i ++;
                   break;                                 // of the segment
                   }
              }
          if ((j >=  Coverage_Range_DAd2)&&(Coverage_Flg == 1)) i++;
          if (j >=  Coverage_Range_DAd2) break;
         }                    

         j = Coverage_Range_SAd3;
         while (i <17)
         {
          for ( ; j <=  Coverage_Range_DAd3; j++ ) {
               Read_Coverage_Content(j);
               if (Coverage_Flg == 1)
                  {
                   Code_Access_Range_SAd[i] = j;        // the start address
                   break;                               // of the segment
                   }
              }
          for ( ; j <=  Coverage_Range_DAd3; j++ ) {
               Read_Coverage_Content(j);
               Code_Access_Range_DAd[i] = j;        // the end address
               if (Coverage_Flg == 0)
                  {
                   Code_Access_Range_DAd[i] = j-1;        // the end address
                   i ++;
                   break;                                 // of the segment
                   }
              }
          if ((j >=  Coverage_Range_DAd3)&&(Coverage_Flg == 1)) i++;
          if (j >=  Coverage_Range_DAd3) break;
         }
         break;                
  //---------------------------------------------------------------------------
  //             end of case 3
  //---------------------------------------------------------------------------
    case 4:
         i = 1;
         t = Coverage_Range_SAd1;
         while (i <17)
         {
          for (j = t ; j <=  Coverage_Range_DAd1; j++ ) {
               Read_Coverage_Content(j);
               if (Coverage_Flg == 1)
                  {
                   Code_Access_Range_SAd[i] = j;        // the start address
                   break;                               // of the segment
                   }
               t = t+1 ;
              }
          for ( j= t; j <=  Coverage_Range_DAd1; j++ ) {
               Read_Coverage_Content(j);
               Code_Access_Range_DAd[i] = j;        // the end address
               if (Coverage_Flg == 0)
                  {
                   Code_Access_Range_DAd[i] = j-1;        // the end address
                   i ++;
                   break;                                 // of the segment
                   }
               t= t +1 ;
              }
          if ((j >=  Coverage_Range_DAd1)&&(Coverage_Flg == 1)) i++;
          if (j >=  Coverage_Range_DAd1) break;
         }                                 
         t = Coverage_Range_SAd2;
         while (i <17)
         {
          for (  j = t; j <=  Coverage_Range_DAd2; j++ ) {
               Read_Coverage_Content(j);
               if (Coverage_Flg == 1)
                  {
                   Code_Access_Range_SAd[i] = j;        // the start address
                   break;                               // of the segment
                   }
                t= t +1 ;
              }
          for (j = t ; j <=  Coverage_Range_DAd2; j++ ) {
               Read_Coverage_Content(j);
               Code_Access_Range_DAd[i] = j;        // the end address
               if (Coverage_Flg == 0)
                  {
                   Code_Access_Range_DAd[i] = j-1;        // the end address
                   i ++;
                   break;                                 // of the segment
                   }
                t= t +1 ;
              }
          if ((j >=  Coverage_Range_DAd2)&&(Coverage_Flg == 1)) i++;
          if (j >=  Coverage_Range_DAd2) break;
         }                    

         t = Coverage_Range_SAd3;
         while (i <17)
         {
          for (j = t ; j <=  Coverage_Range_DAd3; j++ ) {
               Read_Coverage_Content(j);
               if (Coverage_Flg == 1)
                  {
                   Code_Access_Range_SAd[i] = j;        // the start address
                   break;                               // of the segment
                   }
               t= t+1 ;
              }
          for ( j = t ; j <=  Coverage_Range_DAd3; j++ ) {
               Read_Coverage_Content(j);
               Code_Access_Range_DAd[i] = j;        // the end address
               if (Coverage_Flg == 0)
                  {
                   Code_Access_Range_DAd[i] = j-1;        // the end address
                   i ++;
                   break;                                 // of the segment
                   }
               t = t +1 ;
              }
          if ((j >=  Coverage_Range_DAd3)&&(Coverage_Flg == 1)) i++;
          if (j >=  Coverage_Range_DAd3) break;
         }


         t = Coverage_Range_SAd4;
         while (i <17)
         {
          for (j = t ; j <=  Coverage_Range_DAd4; j++ ) {
               Read_Coverage_Content(j);
               if (Coverage_Flg == 1)
                  {
                   Code_Access_Range_SAd[i] = j;        // the start address
                   break;                               // of the segment
                   }
               t= t+1 ;
              }
          for ( j = t; j <=  Coverage_Range_DAd4; j++ ) {
               Read_Coverage_Content(j);
               Code_Access_Range_DAd[i] = j;        // the end address
               if (Coverage_Flg == 0)
                  {
                   Code_Access_Range_DAd[i] = j-1;        // the end address
                   i ++;
                   break;                                 // of the segment
                   }
               t= t+1 ;
              }
          if ((j >=  Coverage_Range_DAd4)&&(Coverage_Flg == 1)) i++;
          if (j >=  Coverage_Range_DAd4) break;
         }
         break;                
  //---------------------------------------------------------------------------
  //             end of case 4
  //---------------------------------------------------------------------------
   default:
         break;
   }
   Code_Access_No = i-1;
}
//-----------------------------------------------------------------------
//  unsigned int Read_Coverage_Content(unsigned int Pic_Frame_Number)
//  input   :    unsigned int trace_frame_number
//  output  :    Coverage_Flg
//----------------------------------------------------------------------
void Read_Coverage_Content(unsigned int Pic_Frame_Number)
{
 unsigned int i;
 unsigned int PicTraceBufferAddress;
 unsigned char PicRamaddrh;
 unsigned char PicRamaddrl;
 i = Pic_Frame_Number;
// PicTraceBufferAddress = i + trace1_start_frame ;
 trace_addrh =  i/256;
 trace_addrl = i - 1;
 read_coverage_value();
 if ((pic_addrl & 0x01) == 0x01)  Coverage_Flg = 1;
 else  Coverage_Flg = 0;
 }



///////////////////////////////////////////////////////////////////////////////
//   Fw_SpaCoverageGet(void)
//
//        function :    Analyse the return  values of Analyse_Coverage().
//                      if they overlape each other , then reduce the
//                      overlaping.
//
//         input :
//                 Code_Access_No
//                 Code_Access_Range_SAd[Code_Access_No]
//                 Code_Access_Range_DAd[Code_Access_No]
//         output :
//
//                 Code_Access_No
//                 Code_Access_Range_SAd[Code_Access_No]
//                 Code_Access_Range_DAd[Code_Access_No]
//
///////////////////////////////////////////////////////////////////////////////
//
//
void Fw_SpaCoveragecheck(void)
  {
   unsigned char i;
   unsigned char j;
   unsigned char ii;
   unsigned char jj;
   unsigned char spacheckagain ;
   spacheckagain = 1;
   while ( spacheckagain == 1)
   {
      spacheckagain = 0;
      for (ii=1;ii<Code_Access_No;ii++)
          {
           for (jj=ii+1;jj<=Code_Access_No;jj++)
                     {
                      // *****************************************************
                      //
                      //     *******************************
                      //    SAd[ii]                     DAd[ii]
                      //                *******************************
                      //              SAd[jj]                        DAd[jj]
                      //
                      // *****************************************************
                      if (( Code_Access_Range_SAd[jj]  <= Code_Access_Range_DAd[ii]) &&
                          ( Code_Access_Range_SAd[jj]  >= Code_Access_Range_SAd[ii]) &&
                          ( Code_Access_Range_DAd[jj]  >= Code_Access_Range_DAd[ii]) )
                           {
                             Code_Access_Range_DAd[ii]  = Code_Access_Range_DAd[jj];
                             for (j=jj; j<Code_Access_No;j++)
                                 {
                                 Code_Access_Range_SAd[j] = Code_Access_Range_SAd[j+1];
                                 Code_Access_Range_DAd[j] = Code_Access_Range_DAd[j+1];
                                  }
                            Code_Access_No = Code_Access_No - 1;
                            spacheckagain = 1;
                            break;
                           }
                      // *****************************************************
                      //
                      //                *******************************
                      //                SAd[ii]                     DAd[ii]
                      //    *******************************
                      //   SAd[jj]                        DAd[jj]
                      //
                      // *****************************************************
                      if (( Code_Access_Range_SAd[ii]  <= Code_Access_Range_DAd[jj]) &&
                          ( Code_Access_Range_SAd[ii]  >= Code_Access_Range_SAd[jj]) &&
                          ( Code_Access_Range_DAd[ii]  >= Code_Access_Range_DAd[jj]) )
                           {
                             Code_Access_Range_SAd[ii]  = Code_Access_Range_SAd[jj];
                             for (j=jj; j<Code_Access_No;j++)
                                 {
                                 Code_Access_Range_SAd[j] = Code_Access_Range_SAd[j+1];
                                 Code_Access_Range_DAd[j] = Code_Access_Range_DAd[j+1];
                                  }
                            Code_Access_No = Code_Access_No - 1;
                            spacheckagain = 1;
                            break;
                           }                       
                      // *****************************************************
                      //
                      //    *******************************************
                      //    SAd[ii]                               DAd[ii]
                      //           *******************************
                      //           SAd[jj]                 DAd[jj]
                      //
                      // *****************************************************
                      if (( Code_Access_Range_SAd[ii]  <= Code_Access_Range_SAd[jj]) &&
                          ( Code_Access_Range_DAd[ii]  >= Code_Access_Range_DAd[jj]) )
                           {
                             for (j=jj; j<Code_Access_No;j++)
                                 {
                                 Code_Access_Range_SAd[j] = Code_Access_Range_SAd[j+1];
                                 Code_Access_Range_DAd[j] = Code_Access_Range_DAd[j+1];
                                  }
                            Code_Access_No = Code_Access_No - 1;
                            spacheckagain = 1;
                            break;
                           }

                      // *****************************************************
                      //
                      //           *******************************
                      //           SAd[ii]                 DAd[ii]
                      //    *******************************************
                      //    SAd[jj]                             DAd[jj]
                      //
                      // *****************************************************
                      if (( Code_Access_Range_SAd[ii]  >= Code_Access_Range_SAd[jj]) &&
                          ( Code_Access_Range_DAd[ii]  <= Code_Access_Range_DAd[jj]) )
                           {

                             Code_Access_Range_SAd[ii] = Code_Access_Range_SAd[jj];
                             Code_Access_Range_DAd[ii] = Code_Access_Range_DAd[jj];
                             for (j=jj; j<Code_Access_No;j++)
                                 {
                                 Code_Access_Range_SAd[j] = Code_Access_Range_SAd[j+1];
                                 Code_Access_Range_DAd[j] = Code_Access_Range_DAd[j+1];
                                  }
                            Code_Access_No = Code_Access_No - 1;
                            spacheckagain = 1;
                            break;
                           }                                  
                      // *****************************************************
                      //
                      //   *******************************
                      //   SAd[ii]                 DAd[ii]
                      //                                  *******************************
                      //                                  SAd[jj]                 DAd[jj]
                      //
                      // *****************************************************
                      if ( ( Code_Access_Range_DAd[ii] + 1 )  == Code_Access_Range_SAd[jj] )
                           {
                             Code_Access_Range_DAd[ii] = Code_Access_Range_DAd[jj];
                             for (j=jj; j<Code_Access_No;j++)
                                 {
                                 Code_Access_Range_SAd[j] = Code_Access_Range_SAd[j+1];
                                 Code_Access_Range_DAd[j] = Code_Access_Range_DAd[j+1];
                                  }
                            Code_Access_No = Code_Access_No - 1;
                            spacheckagain = 1;
                            break;
                           }

                      // *****************************************************
                      //
                      //                                  *******************************
                      //                                  SAd[ii]                 DAd[ii]
                      //   *******************************
                      //   SAd[jj]                 DAd[jj]
                      //
                      // *****************************************************
                      if ( ( Code_Access_Range_DAd[jj] + 1 )  == Code_Access_Range_SAd[ii] )
                           {
                             Code_Access_Range_SAd[ii] = Code_Access_Range_SAd[jj];
                             for (j=jj; j<Code_Access_No;j++)
                                 {
                                 Code_Access_Range_SAd[j] = Code_Access_Range_SAd[j+1];
                                 Code_Access_Range_DAd[j] = Code_Access_Range_DAd[j+1];
                                  }
                            Code_Access_No = Code_Access_No - 1;
                            spacheckagain = 1;
                            break;
                           }                                                

                      }
          if ( spacheckagain == 1)   break;
          }
     }
}

