#
#  Name: makefile.mak
#
#  Description: Make definitions for PICPack firmware
#               for FrankLin C make.exe
#
#  $Log$
#
#  $Header$
#
#  COPYRIGHT (C) 1996 MICROTEK INTERNATIONAL, INC.
#

#
# files
#
SRC = .
BIN = bin
#FCDIR = c:\TOOL\c51.v24
FCDIR = r:\tools\c51.v32
INC = $(FCDIR)\inc
#CCDIR = $(FCDIR)
CCDIR = $(FCDIR)\BIN
#ASMDIR = $(FCDIR)
ASMDIR = $(FCDIR)\BIN
LNKDIR = $(FCDIR)
#LNKDIR = $(FCDIR)\BIN
USDDIR = c:\USD
LIBDIR = $(FCDIR)\LIB
#DEEMAX = c:\deemax
TMPDIR = c:
# Verison number

VER = 00

.SUFFIXES:      .HEX .ABS .OBJ .C .A51 .H .A${VER}

#		*Translator Definitions*
#  Macros definition
#
ASM = $(ASMDIR)\A51
ASMFLAG = DEBUG
#LINK = $(LNKDIR)\xlink86
#LINK = $(LNKDIR)\xlink86e
LOC = $(ASMDIR)\L51
OH51 = $(ASMDIR)\oh51
CONV = $(USDDIR)\CONVERT
CONVEZ = CONVEZ
#OMFCONV = $(DEEMAX)\omfconv
CODEGEN = conv52
CHKSUM = omfcksum
CC = $(CCDIR)\c51
CFLAG = large debug oe OT(5) CODE


#		*Implicit Rules*
.C.obj:
 SET C51INC=${INC}
 SET C51TEMP=${TMPDIR}
 ${CC} ${SRC}\$*.c ${CFLAG} PR(${TMPDIR}\ERR.LST) OJ(${BIN}\$*.obj)
#find "error " ${TMPDIR}\err.lst > $*.lst
#find "warning " ${TMPDIR}\err.lst >> $*.lst

.A${VER}.obj:
 ${ASM} ${SRC}\$*.A${VER} ${ASMFLAG} NOPR EP(${TMPDIR}\err.lst) OJ(${BIN}\$*.obj)

.A51.obj:
 $(ASM) ${SRC}\$*.A51 ${ASMFLAG} NOPR EP(${TMPDIR}\err.lst) OJ(${BIN}\$*.obj)

# define all objs
LNK_depends = ${BIN}\XFWMAIN.obj
#
${BIN}\mm.ABS : ${LNK_depends}
 SET C51LIB=$(LIBDIR)
 echo ${BIN}\yfwcomm.obj,       &  > ${TMPDIR}\tmp.lnk
 echo to ${BIN}\yfwcomm.abs      &  >> ${TMPDIR}\tmp.lnk
 echo IXREF MAP SYMBOLS       &  >> ${TMPDIR}\tmp.lnk
 ${LOC}  @${TMPDIR}\tmp.lnk
 del ${TMPDIR}\tmp.lnk
 ${CHKSUM} ${BIN}\fwpic.abs 0ffff
 if exist ${TMPDIR}\ERR.LST del ${TMPDIR}\TMP.LST
 if exist ${SRC}\fwpic.HDF del ${SRC}\fwpic.HDF
 if exist ${BIN}\fwpic.hex del ${BIN}\fwpic.hex
 copy ${BIN}\fwpic.abs .
 set TMP=c:
#${CONVEZ} fwpic.abs


${BIN}\yfwcomm.OBJ: ${SRC}\hwsubpic.A$(VER) ${SRC}\IO.equ ${SRC}\spoon.equ ${SRC}\spoon.dw

