/**************************************************************************
**
** $Header:
**
** $Log:
** 
** Initial revision. 1.0
** 
***************************************************************************/
/****************************************************************************
**
**  Name:         PICRS232.C
**
**  Description:  RS232-C Communication  C source routines of PICPack firmware.
**
**  Status:    PRELIMINARY
**
**  Modification:
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <reg51.h>
#include "xfwcmd.h"
#include "io.h"

/******************************************************************************/
                  /**********************
                  *  extern data        *
                  **********************/
/////////////////////////////////////////////////////////////////////////////
// Global variables.
extern bit EPrunningFlag ;
extern bit TimerOut;
extern bit ChkTimerOut;
extern bit TimerOut;
extern bit ChkTimerOut;
extern unsigned char transmit_data ;
extern unsigned char diagnostic_flag ;
extern unsigned char spa_flag;
extern unsigned int delay ;
extern unsigned char ReceiveByte(void);
/////////////////////////////////////////////////////////////////////////////

                  /**********************
                  *  extern code        *
                  **********************/
extern void TransmitByte(void);
extern void Ini_rs232_buf1(void);
extern unsigned char Rs232_check_buf(void);
extern void *memcpy(void *,void *,int );
extern void cp_ini(void);



/******************************************************************************/
unsigned char chksum;
unsigned int Rs232TimCount ;
unsigned int TStreamLen;
unsigned int  RStreamLen;
unsigned int commandStreamLen;
unsigned char commandStream[2048];
unsigned char receiveBuf[2048];
unsigned char TransmitBuf[2048];

void current_hw_status(void) ;
void ReceiveStream(void);
void TransmitStream(void);
void ProcessCommand(void);
void  hand_shake( void);
void rec_fail_service(void);

/****************************************************************************
**
**  ReceiveStream
**
**  Description: Receive data from communication and check the length and
**               checksum, the data format is :       XXXXxxx....xxxX
**                                                  length   data   checksum
**
**  Parameters:
**       input: receive_buffer
**      output: CommandStream[]
**
*****************************************************************************/
void ReceiveStream(void)
{
register unsigned int lp;
unsigned char aa[4];
RStreamLen = 0;
chksum = 0;
while(1){
          aa[0] = 0;
          aa[1] = 0;
          aa[2] = 0;
          aa[3] = 0;
          TimerOut = 0;
          ChkTimerOut = 0;
          Rs232TimCount = 0;
//-----------------------------------------------------------------------
//             receive '?'  from    ABI
//             if a '?' has been received then transmit a '!' to ABI
//             and continue to receive '?' until a ':' has been received
//             if timerout then clear time counter and continue receive '?'
//------------------------------------------------------------------------
           while (1)
           {
            if(Rs232_check_buf() == 1)
              {
               aa[0] =  ReceiveByte();
               if (aa[0] == '?')
                       {
                        Ini_rs232_buf1( );
                        transmit_data = '!' ;
                        TransmitByte();
                        continue;
                        }
               if( aa[0] == LEAD_CODE ) break;
              }
           else
              {
                if(diagnostic_flag == 0x1)
                  {
                    current_hw_status() ;
                  }
                if(spa_flag !=0x0)
                  {
                    EX0 = 1 ;
                    for (delay = 0; delay <= 0x10; delay++)
                      {
                      }
                  }
              }
          }
//--------------------------------------------------------------------------
//                 end of receive '?'
//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
//         receive head  from  ABI
//         aa[0] store LEAD_CODE
//         aa[1] store Data Length High
//         aa[2] store Data Length Low
//         aa[3] store chksum
//         aa[0] + aa[1] + aa[2] + aa[3] == 0
//-------------------------------------------------------------------------
           lp = 1;
           while( lp < 4 )
                {
                 if(Rs232_check_buf() == 1) {
                       aa[lp] = ReceiveByte();
                       Rs232TimCount = 0;
                       lp++;
                       }
                  else {
                       Rs232TimCount += 1;
                       if (Rs232TimCount >= 0x2800) TimerOut = 1;
                       }
                 if ( TimerOut )
                      {
                       transmit_data = '$' ;
                       TransmitByte();
                       break;
                       }
                 }//receive four
           if (TimerOut) continue;
           for (lp = 1; lp < 4; lp++) chksum += aa[lp];
           if ((aa[0] == LEAD_CODE) && (chksum == 0)) // command length.
              {
               RStreamLen =(unsigned int)aa[2] * 256 + aa[1];
              transmit_data =REC_OK ;
              TransmitByte();
               }
           else
               {
               transmit_data =REC_FAIL ;
               TransmitByte();
               rec_fail_service();
               }
          if (TimerOut) continue;

//-----------------------------------------------------------------------------
//             receive  recoder
//----------------------------------------------------------------------------
         while(1)
              {

//-----------------------------------------------------------------------------
//             receive ':' before a recoder
//----------------------------------------------------------------------------
               while(1){
                     if(Rs232_check_buf() == 1) {
                            aa[0] = ReceiveByte();
                            Rs232TimCount = 0;
                            if (aa[0] == LEAD_CODE) break;
                            }  
                  else {
                       Rs232TimCount += 1;
                       if (Rs232TimCount >= 0x2800) TimerOut = 1;
                       }
                     if ( TimerOut ) break;
                     }
               if ( TimerOut )  break;
//----------------------------------------------------------------------------
//              end of receive ':' before a recoder
//----------------------------------------------------------------------------
//
//----------------------------------------------------------------------------
//             receive recoder
//----------------------------------------------------------------------------
               chksum = 0;               
               Rs232TimCount = 0;
               for (lp = 0; lp < RStreamLen; lp++) {
                     while(1){
                          if(Rs232_check_buf() == 1) {
                                  receiveBuf[lp] = ReceiveByte();
                                  Rs232TimCount = 0;
                                  break;
                                  }
                           else {
                                Rs232TimCount += 1;
                                if (Rs232TimCount >= 0x2800) TimerOut = 1;
                                }
                          if ( TimerOut )
                                  {
                                   transmit_data ='$';
                                   TransmitByte();
                                   break;
                                   }
                          }
                     if ( TimerOut ) break;
                    }//for
              if ( TimerOut ) break;
              Rs232TimCount = 0;
//----------------------------------------------------------------------------
//             receive all of the recoder and chksum the recoder
//----------------------------------------------------------------------------
              for (lp = 0; lp < RStreamLen; lp++) {
                   chksum += receiveBuf[lp];
                   }
              if (chksum == 0) {    // The End of ReceiveBuf char is Data checksum
                   memcpy(commandStream,&receiveBuf[0],RStreamLen);
                   commandStreamLen = RStreamLen;
                   transmit_data =ACK;
                   TransmitByte();
                   ChkTimerOut = 0;
                   return;
                   }
              else {
                   transmit_data =NACK;
                   TransmitByte();
                   continue;
                   }    
//----------------------------------------------------------------------------
//             end of receive recoder
//----------------------------------------------------------------------------
            } //   end of receive recoder
            
      }    //   end of receive stream biggest while
      
}      //  end of routine





/****************************************************************************
**
**  rec_fail_service(void)
**
**  Description:   if che checksum of the stream that had just received is
**                 not equal to zero the call this routine back to receive
**                 "?" from ABI to try to communication with ABI and rereceive
**                 the stream again.
**  Parameters:    none
**       input:    none
**      output:    none
**
*****************************************************************************/

void rec_fail_service(void)
{
   unsigned char lp;
   unsigned char aa[4];
   transmit_data =REC_FAIL;
   TransmitByte();
   TimerOut = 0;
   Rs232TimCount = 0;
   while(1)
         {
              while(1)
                   {
                    if(Rs232_check_buf() == 1)
                          {
                           Rs232TimCount = 0;
                           aa[0] =  ReceiveByte();
                           if (aa[0] != LEAD_CODE ) continue;
                           TimerOut = 0;
                           break;
                           }
                    else {
                          Rs232TimCount += 1;
                          if (Rs232TimCount >= 0x2800) TimerOut = 1;
                         }
                     if(TimerOut) return;
                     }

              lp = 1;
              TimerOut = 0;
              while( lp < 4 )
                   {
                    if(Rs232_check_buf() == 1) {
                            Rs232TimCount = 0;
                            aa[lp] = ReceiveByte();
                            TimerOut = 0;
                            lp++;
                            }
                    else {
                          Rs232TimCount += 1;
                          if (Rs232TimCount >= 0xfff0) TimerOut = 1;
                         }
                    if ( TimerOut ) return;
                    }//receive four
              chksum = 0;
              for (lp = 1; lp < 4; lp++) chksum += aa[lp];
                   if ((aa[0] == LEAD_CODE) && (chksum == 0)) // command length.
                      {
                       RStreamLen =(unsigned int)aa[2] * 256 + aa[1];
                       transmit_data =REC_OK;
                       TransmitByte();
                       TimerOut = 0;
                       return;
                       }
              transmit_data =REC_FAIL;
              TransmitByte();
              TimerOut = 0;
       }

 }

//---------------------------------------------------------------------------
//    end of  head_fail routine
//---------------------------------------------------------------------------
/****************************************************************************
**
**  void hand_shake (void)
**
**  Description: check the receive buffer to find if "PICPack" had been received
**               try to set communication with ABI .
**  Parameters:    none
**       input:    none
**      output:    none
**
*****************************************************************************/
       
void hand_shake (void)
{
  unsigned char aa;
  while(1)
       {
        while (1)
             {
              if(Rs232_check_buf() == 1)
                   {
                    aa =  ReceiveByte();
                    Rs232TimCount = 0;
                    break;
                   }
              else {
                    Rs232TimCount += 1;
                    if (Rs232TimCount >= 0x3000) TimerOut = 1;
                   }
              if (TimerOut) break;
              }
         if (TimerOut)
            {
             cp_ini();
             continue;
            }
         if (aa != 'P') continue;
         while (1)
             {
              if(Rs232_check_buf() == 1)
                   {
                    aa =  ReceiveByte();
                    Rs232TimCount = 0;
                    break;
                   }
              else {
                    Rs232TimCount += 1;
                    if (Rs232TimCount >= 0x3000) TimerOut = 1;
                   }
              if (TimerOut) break;

              }
         if (TimerOut)
            {
             cp_ini();
             continue;
            }
         if (aa != 'I') continue;
         while (1)
             {
              if(Rs232_check_buf() == 1)
                   {
                    aa =  ReceiveByte();
                    Rs232TimCount = 0;
                    break;
                   }
              else {
                    Rs232TimCount += 1;
                    if (Rs232TimCount >= 0x3000) TimerOut = 1;
                   }
              if (TimerOut)    break;
              }
         if (TimerOut)
            {
             cp_ini();
             continue;
            }
         if (aa != 'C') continue;
         while (1)
             {
              if(Rs232_check_buf() == 1)
                   {
                    aa =  ReceiveByte();
                    Rs232TimCount = 0;
                    break;
                   }
              else {
                    Rs232TimCount += 1;
                    if (Rs232TimCount >= 0x3000) TimerOut = 1;
                   }

              if (TimerOut) break;
              }
         if (TimerOut)
            {
             cp_ini();
             continue;
            }
         if (aa != 'P') continue;
         while (1)
             {
              if(Rs232_check_buf() == 1)
                   {
                    aa =  ReceiveByte();
                    Rs232TimCount = 0;
                    break;
                   }
              else {
                    Rs232TimCount += 1;
                    if (Rs232TimCount >= 0x3000) TimerOut = 1;
                   }
              if (TimerOut) break;
              }
         if (TimerOut)
            {
             cp_ini();
             continue;
            }
         if (aa != 'a') continue;
         while (1)
             {
              if(Rs232_check_buf() == 1)
                   {
                    aa =  ReceiveByte();
                    Rs232TimCount = 0;
                    break;
                   }
              else {
                    Rs232TimCount += 1;
                    if (Rs232TimCount >= 0x3000) TimerOut = 1;
                   }
              if (TimerOut) break;
             }
         if (TimerOut)
            {
             cp_ini();
             continue;
            }
         if (aa != 'c') continue;
         while (1)
             {
              if(Rs232_check_buf() == 1)
                   {
                    aa =  ReceiveByte();
                    Rs232TimCount = 0;
                    break;
                   }
              else {
                    Rs232TimCount += 1;
                    if (Rs232TimCount >= 0x3000) TimerOut = 1;
                   }
              if (TimerOut)  break;

              }

         if (TimerOut)
            {
             cp_ini();
             continue;
            }
         if (aa != 'k') continue;

         transmit_data ='P';
         TransmitByte();
         transmit_data ='I';
         TransmitByte();
         transmit_data ='C';
         TransmitByte();
         transmit_data ='P';
         TransmitByte();
         transmit_data ='a';
         TransmitByte();
         transmit_data ='c';
         TransmitByte();
         transmit_data ='k';
         TransmitByte();
         return;
   }

}




/****************************************************************************
**
**  TransmitStream
**
**  Description: Transmit data(length + data + checksum) to
**               communication port.
**               the data format is :  XXXXxxx....xxxX
**                                   length   data   checksum
**
**  Parameters:
**       input: Transmit_buffer[0..translen+1]
**      output:
**
*****************************************************************************/
/*
   Transmit data(length + data + checksum) to communication port.
   the data format is : LENGTH(2 bytes)DATA(number of length)CHECKSUM(1 byte)
*/
void TransmitStream(void) {

register unsigned int lp;
unsigned char highLen,lowLen,aa;

chksum = 0;
for (lp = 0; lp < TStreamLen; lp++)
chksum += TransmitBuf[lp];
TransmitBuf[TStreamLen] = ( unsigned char )(~chksum+1);
TStreamLen++;

highLen = (unsigned char)(TStreamLen/256);
lowLen =  (unsigned char) TStreamLen;
chksum = (unsigned char) (~(lowLen+highLen) ) + 1;
//--------------------------------------------------------------------------
//        begin to transmit a stream
//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
//        transmit '?' to ABI
//        and receive 100 times if  a '!' have receive then break
//-------------------------------------------------------------------------

     TimerOut = 0;
     ChkTimerOut = 0;
     Rs232TimCount = 0;
     while(1)
          {
           transmit_data ='?';
           TransmitByte();
           aa=0;
           for(lp=0;lp<200;lp++){
                  if(Rs232_check_buf() == 1) {
                      aa =  ReceiveByte();
                      Rs232TimCount = 0;
                      if (aa == '!')  break;
                      }
              else {
                    Rs232TimCount += 1;
                    if (Rs232TimCount >= 0x2800) TimerOut = 1;
                   }
                  if (TimerOut) return;
                  }
           if (aa == '!') break;
           }
//-------------------------------------------------------------------------
//        a '!' has been received end transmit '?' to ABI
//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
//        begin to transmit head
//        LEAD_CODE   ':'
//        Data Length High
//        Data Length Low
//        chksum
//------------------------------------------------------------------------

     TimerOut = 0;
     ChkTimerOut = 0;
     Rs232TimCount = 0;
     while(1)
          {

           transmit_data =LEAD_CODE;
           TransmitByte();
           transmit_data =lowLen;
           TransmitByte();
           transmit_data =highLen;
           TransmitByte();
           transmit_data =chksum;
           TransmitByte();
           while(1){
                 if(Rs232_check_buf() == 1) {
                        aa =  ReceiveByte();
                        Rs232TimCount = 0;
                        if (aa == '?')  continue;
                        if (aa == REC_OK) break;
                        if (aa == REC_FAIL) break;
                        if (aa == '$') return;
                        }
              else {
                    Rs232TimCount += 1;
                    if (Rs232TimCount >= 0x2800) TimerOut = 1;
                   }
                  if (TimerOut)  return;
                 }
          if (aa == REC_FAIL) continue;
          if (aa == REC_OK) break;
          }
     TimerOut = 0;
     ChkTimerOut = 0;
     Rs232TimCount = 0;
     while(1)
          {
           transmit_data =LEAD_CODE;
           TransmitByte();
           for (lp = 0; lp < TStreamLen; lp++)
              {
                transmit_data =TransmitBuf[lp];
                TransmitByte();
              }
           while(1){
                if(Rs232_check_buf() == 1) {
                       aa =  ReceiveByte();
                       Rs232TimCount = 0;
                       if (aa == '?')  continue;
                       if (aa == ACK) return;
                       if (aa == '$') return;
                       if (aa == NACK) break;
                       }
              else {
                    Rs232TimCount += 1;
                    if (Rs232TimCount >= 0x2800) TimerOut = 1;
                   }
                if (TimerOut)  return;
                }
           if (aa == NACK) continue;
         }
}

