
/**************************************************************************
**
** $Header:
**
** $Log:
** 
** 
** Initial revision. 1.0
** 
***************************************************************************/

/****************************************************************************
**
**  Name:          picswmem.c
**
**  Description:   this file include routine of memory checksum, compare,
**                 copy,read,fill,search,test
**
**
**  Status:  PRELIMINARY
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/


#include <reg51.h>
#include <string.h>
#include <stdio.h>
#include <io.h>                                    
#include <c6xio.h>

/******************************************************************************/
                  /**********************
                  *  extern data        *
                  **********************/

/////////////////////////////////////////////////////////////////////////////
// Global variables.
extern unsigned char rd_mem_length_low ;
extern unsigned char rd_mem_length_high ;
extern unsigned int  rd_mem_length ;
extern unsigned char  EPrunningFlag ;
extern unsigned char  commandStream[2048];
extern unsigned char emu_add[16383];
extern unsigned char EP_type   ;
extern unsigned char save_reg[504];   
extern unsigned char spa_flag ;       
extern unsigned char  ME_IDENTIFY;
extern unsigned char status_low ;
extern unsigned char status_high ;
extern unsigned char reg_value0   ;
extern unsigned char reg_value1   ;
extern unsigned int  register_id ;
extern unsigned int  register_c6x_id ;
extern unsigned char conv_id ;                               

/////////////////////////////////////////////////////////////////////////////

                        /****************************
                         *                          *
                         *    EXTERNAL code         *
                         *                          *
                         ****************************/

/////////////////////////////////////////////////////////////////////////////

extern void set_cp_access_emu(void) ;
extern void set_ep_access_emu(void) ;
extern void ModifyReg(void) ;                                
extern void C6xModifyReg(void) ;
extern void GetRegister(void)  ;
extern void C6xGetRegister(void);
extern void C6xToBank0();
extern void C6xToBank1();
extern void C6xToBank2();
extern void C6xToBank3();
extern void ToBank0();
extern void ToBank1();
extern void ToBank2();
extern void ToBank3();


unsigned char gpr_value ;
unsigned char save_gpr_bank0[256];
unsigned char checksum_low ;
unsigned char checksum_high ;
unsigned char compare_low ;
unsigned char compare_high ;
unsigned char copy_low ;
unsigned char copy_high ;
unsigned char fill_low ;
unsigned char fill_high ;
unsigned char read_memory[1024] ;
unsigned char rd_mem_length_low ;
unsigned char rd_mem_length_high ;
unsigned int  rd_mem_length ;
unsigned int  SearchResoult ;
unsigned int  TestResoult ;
unsigned int  search_low ;
unsigned int  search_high ;
unsigned int  test_low ;
unsigned int  test_high ;



void C6xModifyGpr(void) ;
void C5xModifyGpr(void) ;
void C5xCopyReg(void);
unsigned char fw_mem_checksum(void)  ;
unsigned char fw_mem_compare(void)  ;
unsigned char fw_mem_copy(void)  ;
unsigned char fw_mem_read(void)  ;
unsigned char fw_mem_fill(void)  ;
unsigned char fw_mem_search(void)  ;
unsigned char fw_mem_test(void)  ;


/*************************************************************************
;******************************************************************************
;*
;*  mem_checksum
;*
;*
;* description:check_sum the memory
;* input:
;*      byte1  type  1:proram, 3 data
;*      byte2  start address low
;*      byte3  start address high
;*      byte4  type  1:proram, 3 data
;*      byte5  end   address low
;*      byte6  end   address high
;* output:
;*       byte1:status: Command Execute Ok, Eprunning
;*       byte2: the low byte
;*       byte3: the high byte
;****************************************************************************/
unsigned char fw_mem_checksum(void)
{
   unsigned int checksum ;
   unsigned int i ;
   unsigned int j ;
   unsigned int t ;
   if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
    {
      return EpRunning ;
    }
    else
     {
       checksum = 0x0 ;              //initial checksum value
       i = (commandStream[3] * 256 + commandStream[2])*2   ; //start address
       j = (commandStream[6] * 256 + commandStream[5]) * 2 +1 ; //end address
       if ( i > j )  return  ParaError;
       if(commandStream[1]== 0x1)
           {
             set_cp_access_emu()  ;        //set the cp access the EMU
             for (t=i; t <=j; t=t+2)
             {
              checksum = checksum + emu_add[t]  ;         //add the checksum
              if( ME_IDENTIFY == 0x1)
                  {
                  checksum = checksum + (emu_add[t+1] & 0x0f)  ;         //add the checksum
                  }
              if( ME_IDENTIFY != 0x1)
                  {
                  checksum = checksum + (emu_add[t+1] & 0x3f)  ;         //add the checksum
                  }
             }
             checksum_low = checksum ;                 //get the low/high byte
             checksum_high = checksum / 256  ;
             set_ep_access_emu()  ;        //set the ep access the EMU
             return CommandExeOk ;
           }
        if(commandStream[1]== 0x3)
           {

           i = (commandStream[3] * 256 + commandStream[2]) ; //start address
           j = (commandStream[6] * 256 + commandStream[5]) ; //end address
           if( ME_IDENTIFY == 0x1)
              {
               C5xCopyReg();
               for (t=i; t <=j; t++)
                  {
                   checksum = checksum + save_gpr_bank0[t]  ;
                  }
                  checksum_low = checksum ;
                  checksum_high = checksum / 256  ;
                  set_ep_access_emu()  ;        //set the ep access the EMU
                  return CommandExeOk ;
              }

           if( ME_IDENTIFY != 0x1)
              {
               // C6xCopyReg();
               for (t=i; t <=j; t++)
                  {
                   checksum = checksum + save_gpr_bank0[t]  ;
                  }
                  checksum_low = checksum ;
                  checksum_high = checksum / 256  ;
                  set_ep_access_emu()  ;        //set the ep access the EMU
                  return CommandExeOk ;
              } // end of if( ME_IDENTIFY != 0x1)
           } // end of if(commandStream[1]== 0x3)
     }  // end of else if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
}

/*************************************************************************
;******************************************************************************
;*
;*  mem_compare
;*
;*
;* description:compare the memory
;* input:
;*      byte1~3  type(1:proram, 3 data), start address  low, start address high
;*      byte4~6  type(1:proram, 3 data), end address  low, end address high
;*      byte7~9  type(1:proram, 3 data), destination address low, destination address high
;* output:
;*       byte1:status: Command Execute Ok, Eprunning, or MemWrFail
;*       byte2: the low byte
;*       byte3: the high byte
;****************************************************************************/
unsigned char fw_mem_compare(void)
{
   unsigned int i ;
   unsigned int j ;
   unsigned int k ;
   unsigned int t ;


   if((EPrunningFlag == 0x1) && (spa_flag == 0x0))      // Jason 08/02/1996
    {
      return EpRunning ;            //the ep is running
    }
    else
    {
      i = (commandStream[3] * 256 + commandStream[2])*2   ; //start address
      j = (commandStream[6] * 256 + commandStream[5])*2+1   ; //end address
      k = (commandStream[9] * 256 + commandStream[8])*2   ; //destination address
      if ( i > j )  return  ParaError;
      if(commandStream[1]== 0x1)
           {
            set_cp_access_emu()  ;        //set the cp access the EMU

           if( ME_IDENTIFY == 0x1)
                {
                  for (t=i; t <=j; t=t+2)
                     {
                      if( (emu_add[t] != emu_add[t+k-i]) || (((emu_add[t+1]) & 0X0f) != ((emu_add[t+k+1-i]) & 0x0f) )  )   //compare
                          {
                            break ;
                          }
                      }
                }
           if( ME_IDENTIFY != 0x1)
                {
                  for (t=i; t <=j; t=t+2)
                     {
                      if( (emu_add[t] != emu_add[t+k-i]) || (((emu_add[t+1]) & 0X3f) != ((emu_add[t+k+1-i]) & 0x3f) )  )   //compare
                          {
                            break ;
                          }
                      }
                }


            if (t!=j+1)
                {
                  compare_low =t/2 ;             //the low address
                  compare_high =t/512 ;          //the high address
                  set_ep_access_emu()  ;         //set the ep access the EMU
                  return MemWrFail ;
                }
            else
                {
                  set_ep_access_emu()  ;        //set the ep access the EMU
                  return CommandExeOk ;
                }
          }

        if(commandStream[1]== 0x3)
          {

           i = (commandStream[3] * 256 + commandStream[2])   ; //start address
           j = (commandStream[6] * 256 + commandStream[5])   ; //end address
           k = (commandStream[9] * 256 + commandStream[8])   ; //destination address

           if( ME_IDENTIFY == 0x1)
              {
                C5xCopyReg();
                for (t=i; t <=j; t=t+1)
                   {
                    if( (save_gpr_bank0[t] != save_gpr_bank0[t-i+k]) )   //compare
                        {
                          break ;
                        }
                    }
                   if (t!=j+1)
                       {
                         compare_low =t ;             //the low address
                         compare_high =t/256 ;          //the high address
                         set_ep_access_emu()  ;         //set the ep access the EMU
                         return MemWrFail ;
                       }
                   else
                       {
                         set_ep_access_emu()  ;        //set the ep access the EMU
                         return CommandExeOk ;
                       }
              }
           if( ME_IDENTIFY != 0x1)
              {
                // C6xCopyReg();
                for (t=i; t <=j; t=t+1)
                   {
                    if( (save_gpr_bank0[t] != save_gpr_bank0[t-i+k]) )   //compare
                        {
                          break ;
                        }
                    }
                if (t!=j+1)
                    {
                      compare_low =t ;             //the low address
                      compare_high =t/256 ;          //the high address
                      set_ep_access_emu()  ;         //set the ep access the EMU
                      return MemWrFail ;
                    }
                else
                    {
                      set_ep_access_emu()  ;        //set the ep access the EMU
                      return CommandExeOk ;
                    }
              } // end of if( ME_IDENTIFY != 0x1)
           } // end of if(commandStream[1]== 0x3)
    } // end of else if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
}

/*************************************************************************
;******************************************************************************
;*
;*  mem_copy
;*
;*
;* description:copy the memory
;* input:
;*      byte1~3  type(1:proram, 3 data), start address  low, start address high
;*      byte4~6  type(1:proram, 3 data), end address  low, end address high
;*      byte7~9  type(1:proram, 3 data), destination address low, destination address high
;* output:
;*       byte1:status: Command Execute Ok, Eprunning, or MemWrFail
;*       byte2: the low byte
;*       byte3: the high byte
;****************************************************************************/
unsigned char fw_mem_copy(void)
{
   unsigned int i ;
   unsigned int j ;
   unsigned int k ;
   unsigned int t ;

   if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
    {
      return EpRunning ;            //the ep is running
    }
    else
    { 
      i = (commandStream[3] * 256 + commandStream[2])*2   ; //start address
      j = (commandStream[6] * 256 + commandStream[5])*2 +1  ; //end address
      k = (commandStream[9] * 256 + commandStream[8])*2   ; //destination address
      if(commandStream[1]== 0x1)
          {
           set_cp_access_emu()  ;        //set the cp access the EMU
           for (t=i; t <=j; t=t+1)
           {
              emu_add[k+t-i] = emu_add[t]  ;      //low byte copy
              if(emu_add[t+k-i] != emu_add[t])
                    {
                     break   ;
                    }
           }
           if (t!=j+1)
               {
                 copy_low =(k+t-i)/2 ;             //the low address
                 copy_high =(k+t-i)/512;         //the high address
                 set_ep_access_emu()  ;         //set the ep access the EMU
                 return MemWrFail ;
               }
           else
               {
                 set_ep_access_emu()  ;        //set the ep access the EMU
                 return CommandExeOk ;
               }
          } // end of if(commandStream[1]== 0x1)
        if(commandStream[1]== 0x3)
          {           
           set_ep_access_emu()  ;        //set the ep access the EMU
           i = (commandStream[3] * 256 + commandStream[2])   ; //start address
           j = (commandStream[6] * 256 + commandStream[5])   ; //end address
           k = (commandStream[9] * 256 + commandStream[8])   ; //destination address
           if( ME_IDENTIFY == 0x1)
              {
               C5xCopyReg();
               if (k <= 0x1f)
                   {
                    // ToBank0();
                    for (t=i; t <=j; t=t+1)
                        {
                        ToBank0();
                        reg_value0 = save_gpr_bank0[t];
                        conv_id = (k + t - i);
                        C5xModifyGpr();
                        GetRegister();
                        C5xCopyReg();
                        if ( save_gpr_bank0[t] != save_gpr_bank0[k+t-i])
                            {
                             break;
                            }
                         }
                    if (t!=j+1)
                         {
                           copy_low =(k+t-i) ;             //the low address
                           copy_high =(k+t-i)/256;         //the high address
                           set_ep_access_emu()  ;         //set the ep access the EMU
                           return MemWrFail ;
                          }
                     else
                          {
                           set_ep_access_emu()  ;        //set the ep access the EMU
                           return CommandExeOk ;
                          }
                    }
               if ((k >= 0x20)&&(k <= 0x3f))
                   {
                    // ToBank1();
                    for (t=i; t <=j; t=t+1)
                        {
                        ToBank1();
                        reg_value0 = save_gpr_bank0[t];
                        conv_id = (k + t - i - 0x20);
                        C5xModifyGpr();
                        GetRegister();
                        C5xCopyReg();
                        if ( save_gpr_bank0[t] != save_gpr_bank0[k+t-i])
                            {
                             break;
                            }
                         }
                        if (t!=j+1)
                            {
                              copy_low =(k+t-i) ;             //the low address
                              copy_high =(k+t-i)/256;         //the high address
                              set_ep_access_emu()  ;         //set the ep access the EMU
                              return MemWrFail ;
                            }
                        else
                            {
                              set_ep_access_emu()  ;        //set the ep access the EMU
                              return CommandExeOk ;
                            }     
                        
                    }


               if ((k >= 0x40)&&(k <= 0x5f))
                   {
                   // ToBank2();
                    for (t=i; t <=j; t=t+1)
                        {
                       ToBank2();
                        reg_value0 = save_gpr_bank0[t];
                        conv_id = (k + t - i - 0x40);
                        C5xModifyGpr();
                        GetRegister();
                        C5xCopyReg();
                        if ( save_gpr_bank0[t] != save_gpr_bank0[k+t-i])
                            {
                             break;
                            }
                        }
                        if (t!=j+1)
                            {
                              copy_low =(k+t-i) ;             //the low address
                              copy_high =(k+t-i)/256;         //the high address
                              set_ep_access_emu()  ;         //set the ep access the EMU
                              return MemWrFail ;
                            }
                        else
                            {
                              set_ep_access_emu()  ;        //set the ep access the EMU
                              return CommandExeOk ;
                            }     
                        
                    }

               if ((k >= 0x60)&&(k <= 0x7f))
                   {
                   // ToBank3();
                    for (t=i; t <=j; t=t+1)
                        {
                        ToBank3();
                        reg_value0 = save_gpr_bank0[t];
                        conv_id = (k + t - i - 0x60);
                        C5xModifyGpr();
                        GetRegister();
                        C5xCopyReg();
                        if ( save_gpr_bank0[t] != save_gpr_bank0[k+t-i])
                            {
                             break;
                            }
                     }
                        if (t!=j+1)
                            {
                              copy_low =(k+t-i) ;             //the low address
                              copy_high =(k+t-i)/256;         //the high address
                              set_ep_access_emu()  ;         //set the ep access the EMU
                              return MemWrFail ;
                            }
                        else
                            {
                              set_ep_access_emu()  ;        //set the ep access the EMU
                              return CommandExeOk ;
                            }     
                        
                    }
                                                  
              }  // end of if( ME_IDENTIFY == 0x1)

           if( ME_IDENTIFY != 0x1)
              {
               // C6xCopyReg();
               if (k <= 0x7f)
                   {
                    C6xToBank0();
                    for (t=i; t <=j; t=t+1)
                        {
                        reg_value0 = save_gpr_bank0[t];
                        conv_id = (k + t - i);
                        C6xModifyGpr();
                        C6xGetRegister();
                        // C6xCopyReg();
                        if ( save_gpr_bank0[t] != save_gpr_bank0[k+t-i])
                            {
                             break;
                            }
                         }      
                        if (t!=j+1)
                            {
                              copy_low =(k+t-i) ;             //the low address
                              copy_high =(k+t-i)/256;         //the high address
                              set_ep_access_emu()  ;         //set the ep access the EMU
                              return MemWrFail ;
                            }
                        else
                            {
                              set_ep_access_emu()  ;        //set the ep access the EMU
                              return CommandExeOk ;
                            }     
                     }

               if (k >= 0x80)
                   {
                   C6xToBank1();
                    for (t=i; t <=j; t=t+1)
                        {
                        reg_value0 = save_gpr_bank0[t];
                        conv_id = (k + t - i -0x80);
                        C6xModifyGpr();
                        C6xGetRegister();
                        // C6xCopyReg();
                        if ( save_gpr_bank0[t] != save_gpr_bank0[k+t-i])
                            {
                             break;
                            }
                         }
                        if (t!=j+1)
                            {
                              copy_low =(k+t-i) ;             //the low address
                              copy_high =(k+t-i)/256;         //the high address
                              set_ep_access_emu()  ;         //set the ep access the EMU
                              return MemWrFail ;
                            }
                        else
                            {
                              set_ep_access_emu()  ;        //set the ep access the EMU
                              return CommandExeOk ;
                            }                             
                    }

              }  // end of if( ME_IDENTIFY != 0x1)

          }

    }  // end of  if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
}

/*************************************************************************
;******************************************************************************
;*
;*  mem_fill
;*
;*
;* description:fill the memory
;* input:
;*      byte1~3  type(1:proram, 3 data), start address  low, start address high
;*      byte4~6  type(1:proram, 3 data), end address  low, end address high
;*      byte7~8  length low, length high
;*      byte9~n  data   low, data high
;* output:
;*       byte1:status: Command Execute Ok, Eprunning, or MemWrFail
;*       byte2: the low address byte
;*       byte3: the high address byte
;****************************************************************************/
unsigned char fw_mem_fill(void)
{
   unsigned int i ;
   unsigned int j ;
   unsigned int k ;
   unsigned int t ;
   unsigned int l ;
   if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
    {
      return EpRunning ;
    }
    else
    {
      if(commandStream[1] == 0x1)
        {
          set_cp_access_emu()  ;
          i = (commandStream[3] * 256 + commandStream[2])*2   ; //start address
          j = (commandStream[6] * 256 + commandStream[5])*2+1   ; //end address
          k = (commandStream[8] * 256 + commandStream[7])*2   ; //data length
          for (t=i; t <=j; t=t+2)
          {
             l=9+(t-i)-((t-i)/k)*k   ;  // get the data point
             emu_add[t]=commandStream[l]   ;   //fill
             emu_add[t+1]=commandStream[l+1] ;
             if((status_low & 0x80) ==1)      //verify on
                  {
                   if ((emu_add[t] != commandStream[l] ) ||
                     (emu_add[t+1]  != (commandStream[l+1])))
                       {
                         break   ;
                        }
                   }
            }// end of for (t=i; t <=j; t=t+2)
          if (t!=j+1)
              {
                fill_low =t/2 ;             //the low address
                fill_high =t/512 ;       //the high address
                set_ep_access_emu()  ;         //set the ep access the EMU
                return MemWrFail ;
              }
          else
              {
                set_ep_access_emu()  ;        //set the ep access the EMU
                return CommandExeOk ;
              }
        } // end of if(commandStream[1] == 0x1)

      if(commandStream[1] == 0x3)
        {         //register
    //   set_ep_access_emu()  ;        //set the ep access the EMU
         i = (commandStream[3] * 256 + commandStream[2]);
         j = (commandStream[6] * 256 + commandStream[5]);
         k = (commandStream[8] * 256 + commandStream[7]);

         if (ME_IDENTIFY == 0x01)
              {

               if ((j <= 0x1f) && (i >= 0x00))
                  {
                   // ToBank0();
                   for (t=i; t <=j; t=t+1)
                       {
                        ToBank0();
                        l=9+((t-i)-((t-i)/k)*k)*2   ;  // get the data point
                        conv_id = t;
                        reg_value0  = commandStream[l]   ;   //fill
                        C5xModifyGpr();
                        // GetRegister();
                        if((status_low & 0x80) == 0x80)      //verify on
                            {
                             GetRegister();
                             // C5xCopyReg();
                             if(save_gpr_bank0[t] != commandStream[l])
                                 {
                                  break   ;
                                 }
                            }
                       } // end of for (t=i; t <=j; t=t+1)

                  GetRegister();    // Jason /8/27/1996
                  if (t!=j+1)
                      {
                        fill_low =t ;             //the low address
                        fill_high =t/256 ;       //the high address
                        set_ep_access_emu()  ;         //set the ep access the EMU
                        return MemWrFail ;
                      }
                  else
                      {
                        set_ep_access_emu()  ;        //set the ep access the EMU
                        return CommandExeOk ;
                      } 
                   } // end of if ((j <= 0x1f) && (i >= 0x00))  

               if ((j <= 0x3f) && (i >= 0x20))
                  {
                  // ToBank1();  // Jason 08/27/1996
                   for (t=i; t <=j; t=t+1)
                       {
                        ToBank1();     // Jason 08/27/1996
                        l=9+((t-i)-((t-i)/k)*k)*2   ;  // get the data point
                        conv_id = t- 0x20;
                        reg_value0  = commandStream[l]   ;   //fill
                        C5xModifyGpr();
                        //  GetRegister();
                        if((status_low & 0x80) == 0x80)      //verify on
                            {
                             GetRegister();
                             // C5xCopyReg();
                             if(save_gpr_bank0[t] != commandStream[l])
                                 {
                                  break   ;
                                 }
                            }
                       }// end of for (t=i; t <=j; t=t+1)
                  GetRegister();   // Jason 08/27/1996
                  if (t!=j+1)
                      {
                        fill_low =t ;             //the low address
                        fill_high =t/256 ;       //the high address
                        set_ep_access_emu()  ;         //set the ep access the EMU
                        return MemWrFail ;
                      }
                  else
                      {
                        set_ep_access_emu()  ;        //set the ep access the EMU
                        return CommandExeOk ;
                      } 
                   } // end of if ((j <= 0x3f) && (i >= 0x20))  

               if ((j <= 0x5f) && (i >= 0x40))
                  {
                   // ToBank2();  // Jason 8/27/1996
                   for (t=i; t <=j; t=t+1)
                       {
                        ToBank2();    // Jason 08/27/1996
                        l=9+((t-i)-((t-i)/k)*k)*2   ;  // get the data point
                        conv_id = t- 0x40;
                        reg_value0  = commandStream[l]   ;   //fill
                        C5xModifyGpr();
                        if((status_low & 0x80) == 0x80)      //verify on
                            {
                             GetRegister();
                            //  C5xCopyReg();
                             if(save_gpr_bank0[t] != commandStream[l])
                                 {
                                  break   ;
                                 }
                            }
                       }
                  GetRegister();   // Jason 08/27/1996
                  if (t!=j+1)
                      {
                        fill_low =t ;             //the low address
                        fill_high =t/256 ;       //the high address
                        set_ep_access_emu()  ;         //set the ep access the EMU
                        return MemWrFail ;
                      }
                  else
                      {
                        set_ep_access_emu()  ;        //set the ep access the EMU
                        return CommandExeOk ;
                      } 
                  }// end of if ((j <= 0x5f) && (i >= 0x40))
               if ((j <= 0x7f) && (i >= 0x60))
                  {
                   // ToBank3();
                   for (t=i; t <=j; t=t+1)
                       {
                        ToBank3();   // Jason  /8/27/1996
                        l=9+((t-i)-((t-i)/k)*k)*2   ;  // get the data point
                        conv_id = t- 0x60;
                        reg_value0  = commandStream[l]   ;   //fill
                        C5xModifyGpr();
                        if((status_low & 0x80) == 0x80)      //verify on
                            {
                             GetRegister();
                             // C5xCopyReg();
                             if(save_gpr_bank0[t] != commandStream[l])
                                 {
                                  break   ;
                                 }
                            }
                       }
                  GetRegister();   // Jason 08/27/1996
                  if (t!=j+1)
                      {
                        fill_low =t ;             //the low address
                        fill_high =t/256 ;       //the high address
                        set_ep_access_emu()  ;         //set the ep access the EMU
                        return MemWrFail ;
                      }
                  else
                      {
                        set_ep_access_emu()  ;        //set the ep access the EMU
                        return CommandExeOk ;
                      } 
                 }// end of if ((j <= 0x7f) && (i >= 0x60))     
              }  // end of if( ME_IDENTIFY == 0X01)




         if (ME_IDENTIFY != 0x01)
             {
               if ((j <= 0x7f) && (i >= 0x00))
                  {
                   // C6xToBank0();    // Jason 8/27/1996
                   for (t=i; t <=j; t=t+1)
                       {
                        C6xToBank0();   // Jason 8/27/1996
                        l=9+((t-i)-((t-i)/k)*k)*2   ;  // get the data point
                        conv_id = t;
                        reg_value0  = commandStream[l]   ;   //fill
                        C6xModifyGpr();
                        // C6xGetRegister();
                        if((status_low & 0x80) == 0x80)      //verify on
                            {
                             C6xGetRegister();
                             // C6xCopyReg();
                             if(save_gpr_bank0[t] != commandStream[l])
                                 {
                                  break   ;
                                 }
                            }
                       }// end of for (t=i; t <=j; t=t+1)
                  C6xGetRegister();   // Jason 8/27/1996
                  if (t!=j+1)
                      {
                        fill_low =t ;             //the low address
                        fill_high =t/256 ;       //the high address
                        set_ep_access_emu()  ;         //set the ep access the EMU
                        return MemWrFail ;
                      }
                  else
                      {
                        set_ep_access_emu()  ;        //set the ep access the EMU
                        return CommandExeOk ;
                      }
                 }// end of if ((j <= 0x7f) && (i >= 0x00))

               if ((j <= 0xff) && (i >= 0x80))
                 {
                   // C6xToBank1();      // Jason 08/27/1996
                   for (t=i; t <=j; t=t+1)
                       {
                        C6xToBank1();   // Jason 08/27/1996
                        l=9+((t-i)-((t-i)/k)*k) * 2   ;  // get the data point
                        conv_id = t - 0x80;
                        reg_value0  = commandStream[l]   ;   //fill
                        C6xModifyGpr();
                        //C6xGetRegister();
                        if((status_low & 0x80) == 0x80)      //verify on
                            {
                             C6xGetRegister();   // Jason 8/27/1996
                             // C6xCopyReg();
                             if(save_gpr_bank0[t] != commandStream[l])
                                 {
                                  break   ;
                                 }
                            }
                       }  // end of for (t=i; t <=j; t=t+1)
                  C6xGetRegister();   // Jason 8/27/1996
                  if (t!=j+1)
                      {
                        fill_low =t ;             //the low address
                        fill_high =t/256 ;       //the high address
                        set_ep_access_emu()  ;         //set the ep access the EMU
                        return MemWrFail ;
                      }
                  else
                      {
                        set_ep_access_emu()  ;        //set the ep access the EMU
                        return CommandExeOk ;
                      }
                 }// end of if ((j >= 0xc0) && (i >= 0x80))
               set_ep_access_emu()  ;                             // Jason  07/30/1996        //
               C6xGetRegister();                                 // Jason  08/02/1996         //
               // C6xCopyReg();
               return CommandExeOk ;                              // Jason  07/30/1996        //
         }// end of if (ME_IDENTIFY != 0x01)                                                        // Jason  07/30/1996        //
     } // end of if(commandStream[1] == 0x3)
  }// end of else if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
}


/*************************************************************************
;******************************************************************************
;*
;*  mem_read
;*
;*
;* description:read the memory
;* input:
;*      byte1~3  type(1:proram, 3 data), start address  low, start address high
;*      byte4~6  type(1:proram, 3 data), end address  low, end address high
;* output:
;*       byte1:status: Command Execute Ok, Eprunning
;*       byte2: the length loy byte
;*       byte3: the length high byte
;*       byte4~n data content
;****************************************************************************/
unsigned char fw_mem_read(void)
{
   unsigned int i ;
   unsigned int j ;
   unsigned int t ;

   if((EPrunningFlag == 0x1) && (spa_flag == 0x0))

    {
      return EpRunning ;
    }
    else
    {
      if(commandStream[1] == 0x1)
          {                             // code memory
           set_cp_access_emu()  ;        //set the cp access the EMU
           i = (commandStream[3] * 256 + commandStream[2])*2   ; //start address
           j = (commandStream[6] * 256 + commandStream[5])*2+1   ; //end address
           rd_mem_length_low=(j-i+1)/2  ;    // the length low
           rd_mem_length_high=(j-i+1)/512  ;// the length high
           rd_mem_length=j-i+1 ;          //  the length high

          if (ME_IDENTIFY == 0x01)
              {
               for (t=i; t <=j; t=t+2)
                {
                 read_memory[t-i]=emu_add[t]   ;  //read the memory
                 read_memory[t-i+1]=emu_add[t+1] & 0x0f  ;  //read the memory
                 }
              set_ep_access_emu()  ;        //set the ep access the EMU
              return CommandExeOk ;
              }
          if (ME_IDENTIFY != 0x01)
              {
               for (t=i; t <=j; t=t+2)
                {
                 read_memory[t-i]=emu_add[t]   ;  //read the memory
                 read_memory[t-i+1]=emu_add[t+1] & 0x3f ;  //read the memory
                 }
              set_ep_access_emu()  ;        //set the ep access the EMU
              return CommandExeOk ;
              }
           else
               {  
                set_ep_access_emu()  ;        //set the ep access the EMU
                return ParaError;
               }
          }

      if(commandStream[1] == 0x3)
         {
          i = (commandStream[3] * 256 + commandStream[2])   ; //start address
          j = (commandStream[6] * 256 + commandStream[5])   ; //end address
          if (ME_IDENTIFY == 0x01)
              {                                             // Jason  07/16/1996
    //        C5xCopyReg();
              }
         if (ME_IDENTIFY != 0x01)
             {
              // C6xCopyReg();
            }
         rd_mem_length_low=(j-i+1)  ;    // the length low
         rd_mem_length_high=(j-i+1)/256 ;// the length high
         rd_mem_length=(j-i+1) * 2 ;          //  the length high
         for (t=i; t <=j; t=t+1)
             {
              read_memory[2*(t-i)]=save_gpr_bank0[t]   ;  //read the memory
              read_memory[2*(t-i)+1]=0x00 ;  //read the memory
              }
         set_ep_access_emu()  ;        //set the ep access the EMU
         return CommandExeOk ;
        }    
     }   
} 


/*************************************************************************
;******************************************************************************
;*
;*  mem_search
;*
;*
;* description:search data in the memory
;* input:
;*      byte1~3  type(1:proram, 3 data), start address  low, start address high
;*      byte4~6  type(1:proram, 3 data), end address  low, end address high
;*      byte7    case_flag: 0 case_sensitive, 1 case_insensitive
;*      byte8    length
;*      byte9~n  data (2 x n byte, max is 64 byte)
;* output:
;* case1:
;*       byte1:status: Eprunning
:* case2:
;*       byte1:commandExeOk
;*       byte2:MemSearchNotFind
;* case3:
;*       byte1:CommandExeOk
;*       byte2:MemSearchFind
;*       byte3: type
;*       byte2: the address low byte
;*       byte3: the address high byte
;****************************************************************************/

unsigned char fw_mem_search(void)
{
   unsigned int i ;
   unsigned int j ;
   unsigned int t ;
   unsigned char k ;
   unsigned char l ;
   unsigned char m ;
   unsigned char search_temphigh;
   unsigned char search_templow ;

   unsigned int SearchData[32];
   unsigned char case_insensitive_low ;
   unsigned char case_insensitive_high;

   if((EPrunningFlag == 0x1) && (spa_flag == 0x0))          // Jason 08/02/1996
        {
         return EpRunning ;            //the ep is running
        }
    else
    {
         if(commandStream[1] == 0x1)
             {
              set_cp_access_emu()  ;        //set the cp access the EMU
              i = (commandStream[3] * 256 + commandStream[2])*2   ; //start address
              j = (commandStream[6] * 256 + commandStream[5])*2+1   ; //end address
              k = commandStream[8] ;        //the data length
              if (ME_IDENTIFY == 0x01)
                   {
                   for (t=i; t <=j; t=t+2)
                       {
                        (emu_add[t+1])= ((emu_add[t+1]) & 0X0f);
                        }
                   }
              if (ME_IDENTIFY != 0x01)
                   {
                   for (t=i; t <=j; t=t+2)
                       {
                        (emu_add[t+1])= ((emu_add[t+1]) & 0X3f);
                        }
                   }                        
              if(commandStream[7] == 0x0)  // case judge
                    {
                     for (t=0; t<k; t++)
                           {
                            SearchData[t]=commandStream[t*2+9] + ((commandStream[t*2+9+1] * 256))  ;
                            }
                    }
              else // if(commandStream[7] !=0x0)  // case judge

                    {
                     for (t=0; t<k; t++)
                           {
			    case_insensitive_low = commandStream[t*2+9];
			    case_insensitive_high = commandStream[t*2+9+1];
			    if (((case_insensitive_low >='A') && (case_insensitive_low <='Z'))
				||((case_insensitive_low >='a') && (case_insensitive_low <='z')))
				 case_insensitive_low = case_insensitive_low & 0xdf;
			    if (((case_insensitive_high >='A') && (case_insensitive_high <='Z'))
			      ||((case_insensitive_high >='a') && (case_insensitive_high <='z')))
				 case_insensitive_high = case_insensitive_high & 0xdf;
			    SearchData[t]= case_insensitive_low  + ((case_insensitive_high * 256))  ;
                            }
                    }
              // for (t=i; t <=j; t++)   Jason 08/30/1996
              for (t=i; t <=j; t = t+2 )
                    {
                     m = 0x0  ;
                     for (l=0; l<k;l++)
                            {
                             if(commandStream[7] ==0x0)          //case judge
                                      {                                 //case sensitive
                                       if(SearchData[l]==((emu_add[t+l*2+1]) * 256)  + emu_add[t+l*2])
                                                {
                                                  m=m+1 ;       //if the data is equal, add
                                                 }
                                      }
                             else  // if(commandStream[7] != 0x0)
                                      {                                 //case insensitive
				       // case_insensitive_low	= SearchData[l]  ;
				       // case_insensitive_high  = (SearchData[l]/256)	;
				       // if (((case_insensitive_low >='A') && (case_insensitive_low <='Z'))
				       // ||((case_insensitive_low >='a') && (case_insensitive_low <='z')))
				       //	  {
				       //	   case_insensitive_low = case_insensitive_low & 0xdf;
				       //	  }
				       // if (((case_insensitive_high >='A') && (case_insensitive_high <='Z'))
				       // ||((case_insensitive_high >='a') && (case_insensitive_high <='z')))
				       //	  {
				       //	   case_insensitive_high = case_insensitive_high & 0xdf;
				       //	  }
				       // SearchData[l] =case_insensitive_low + case_insensitive_high*256 ;

                                      if (((emu_add[t+l*2+1] >='A') && (emu_add[t+l*2+1] <='Z'))
                                      ||((emu_add[t+l*2+1] >='a') && (emu_add[t+l*2+1] <='z')))
                                                {
                                                 search_temphigh = emu_add[t+l*2+1] & 0xdf;
                                                }

                                      if (((emu_add[t+l*2] >='A') && (emu_add[t+l*2] <='Z'))
                                      ||((emu_add[t+l*2] >='a') && (emu_add[t+l*2] <='z')))
                                               {
                                                // emu_add[t+l*2] = emu_add[t+l*2] & 0xdf;
                                                search_templow  = emu_add[t+l*2] & 0xdf;
                                               }

                                      //if(SearchData[l]==((emu_add[t+l*2+1]) * 256)  + emu_add[t+l*2])
                                      if(SearchData[l]== (search_temphigh * 256 + search_templow))
                                              {
                                               m=m+1 ;       //if the data is equal, add
                                              }
                                      }
                            }
                    if(m==k)
                            {
                             set_ep_access_emu()  ;        //set the ep access the EMU
                             SearchResoult = MemSearchFind;
                             search_low =  t/2 ;
                             search_high = t/256/2 ;
                             return CommandExeOk;
                            }
                     else
                            {
                             m=0x0;
                            }
                    }
          set_ep_access_emu()  ;        //set the ep access the EMU
          SearchResoult = MemSearchNotFind ;
          return CommandExeOk ;
        } // end of if(commandStream[1] == 0x1)

	 if(commandStream[1] == 0x3)
             {
              i = (commandStream[3] * 256 + commandStream[2])   ; //start address
              j = (commandStream[6] * 256 + commandStream[5])   ; //end address
              k = commandStream[8] ;        //the data length

              if(commandStream[7] == 0x0)  // case judge
                    {
                     for (t=0; t<k; t++)
                           {
                            SearchData[t]=commandStream[t*2+9] + ((commandStream[t*2+9+1] * 256))  ;
                            }
                    }
              else // if(commandStream[7] !=0x0)  // case judge
                    {
                     for (t=0; t<k; t++)
                           {
			    case_insensitive_low = commandStream[t*2+9];
			    case_insensitive_high = commandStream[t*2+9+1];
			    if (((case_insensitive_low >='A') && (case_insensitive_low <='Z'))
				||((case_insensitive_low >='a') && (case_insensitive_low <='z')))
				 case_insensitive_low = case_insensitive_low & 0xdf;
			    if (((case_insensitive_high >='A') && (case_insensitive_high <='Z'))
			      ||((case_insensitive_high >='a') && (case_insensitive_high <='z')))
				 case_insensitive_high = case_insensitive_high & 0xdf;
			    SearchData[t]= case_insensitive_low  + ((case_insensitive_high * 256))  ;
                            }
                    }

		    if (ME_IDENTIFY == 0x01)
			    {				    // Jason  07/16/1996
                              C5xCopyReg();
			    }
                    // if (ME_IDENTIFY != 0x01)
                    //        {
                              // C6xCopyReg();
                    //          }
                    for (t=i; t <=j; t++)
                          {
                           m = 0x0  ;
                           for (l=0; l<k;l++)
                                  {
                                   if(commandStream[7] ==0x0)          //case judge
                                            {                                 //case sensitive
                                             if(SearchData[l]== save_gpr_bank0[t+l])
                                                      {
                                                        m=m+1 ;       //if the data is equal, add
                                                       }
                                            }
                                   else  // if(commandStream[7] != 0x0)
                                            {                                 //case insensitive
                                            if (((save_gpr_bank0[t+l] >='A') && (save_gpr_bank0[t+l] <='Z'))
                                            ||((save_gpr_bank0[t+l] >='a') && (save_gpr_bank0[t+l] <='z')))
                                                      {
                                                       search_temphigh = save_gpr_bank0[t+l] & 0xdf;
                                                      }
                                            if(SearchData[l]== (search_temphigh))
                                                    {
                                                     m=m+1 ;       //if the data is equal, add
                                                    }
                                            }
                                  }
                          if(m==k)
                                  {
                                   set_ep_access_emu()  ;        //set the ep access the EMU
                                   SearchResoult = MemSearchFind;
                                   search_low =  t ;
                                   search_high = t/256 ;
                                   return CommandExeOk;
                                  }
                           else
                                  {
                                   m=0x0;
                                  }
                          }
                    set_ep_access_emu()  ;        //set the ep access the EMU
                    SearchResoult = MemSearchNotFind ;
                    return CommandExeOk ;
	     } // end of if(commandStream[1] == 0x3)
     }
}

/*************************************************************************
;******************************************************************************
;*
;*  mem_test
;*
;*
;* description:test the memory
;* input:
;*      byte1~3  type(1:proram, 3 data), start address  low, start address high
;*      byte4~6  type(1:proram, 3 data), end address  low, end address high
;* output:
;* case1:
;*       byte1:status: Eprunning
;* case2:
;*       byte1:status: Command Execute Ok
;*       byte2: MemWrOk
;* case3
;*       byte1:status: Command Execute Ok
;*       byte2: MemWrFail
;*       byte3: type
;*       byte4: the error address low byte
;*       byte5: the errormaddress high byte
;****************************************************************************/
unsigned char fw_mem_test(void)
{
   unsigned int i ;
   unsigned int j ;
   unsigned int t ;
   unsigned char A ;
   unsigned char B ;
   unsigned char C ;
   unsigned char D ;
   unsigned char E ;
   unsigned char F ;
   unsigned char temp ;
   if((EPrunningFlag == 0x1) && (spa_flag == 0x0))    // Jason 08/02/1996
    {
      return EpRunning ;            //the ep is running
    }
    else
    {     
      if ( commandStream[1] == 0x01)
         {
           i = (commandStream[3] * 256 + commandStream[2])*2   ; //start address
           j = (commandStream[6] * 256 + commandStream[5])*2+1   ; //end address
           set_cp_access_emu()  ;        //set the cp access the EMU
           for (t=i; t <=j; t++)
             {
               A= (t/256/16) & 0x0f ;
               A= ~A ;
               B= (t/256) & 0x0f ;
               B= ~B ;
               C=(t/16) & 0x0f ;
               D= t & 0x0f ;
               E= ((A-C) & 0x0f) * 16 ;
               F= (B-D) & 0x0f ;
               emu_add[t]=  (E|F) ;
              }// end of for (t=i; t <=j; t++)

           for (t=i; t <=j; t++)
             {
               A= (t/256/16) & 0x0f ;
               A= ~A ;
               B= (t/256) & 0x0f ;
               B= ~B ;
               C=(t/16) & 0x0f ;
               D= t & 0x0f ;
               E= ((A-C) & 0x0f) * 16 ;
               F= (B-D) & 0x0f ;
               if(emu_add[t]!= (E|F))
                  {
                   test_low = t/2 ;
                   test_high = t/512 ;
                   TestResoult = MemWrFail ;
                   return CommandExeOk ;
                  }
               }  // end of for (t=i; t <=j; t++)
           set_ep_access_emu()  ;        //set the ep access the EMU
           TestResoult = MemWrOk ;
           return CommandExeOk ;
       }// end of if ( commandStream[1] == 0x01)

      if ( commandStream[1] == 0x03)
         {
         i = (commandStream[3] * 256 + commandStream[2])   ; //start address
         j = (commandStream[6] * 256 + commandStream[5])   ; //end address
         if (ME_IDENTIFY == 0x01)
              {
               if ((j <= 0x1f) && (i >= 0x00))
                  {
                   // ToBank0();
                   for (t=i; t <=j; t++)
                     {
                       ToBank0();
                       A= (t/256/16) & 0x0f ;
                       A= ~A ;
                       B= (t/256) & 0x0f ;
                       B= ~B ;
                       C=(t/16) & 0x0f ;
                       D= t & 0x0f ;
                       E= ((A-C) & 0x0f) * 16 ;
                       F= (B-D) & 0x0f ;
                       conv_id = t;
                       reg_value0  = (E|F) ;
                       C5xModifyGpr();
                      }// end of for (t=i; t <=j; t++)

                   GetRegister();
                   C5xCopyReg();
                   for (t=i; t <=j; t++)
                     {
                       A= (t/256/16) & 0x0f ;
                       A= ~A ;
                       B= (t/256) & 0x0f ;
                       B= ~B ;
                       C=(t/16) & 0x0f ;
                       D= t & 0x0f ;
                       E= ((A-C) & 0x0f) * 16 ;
                       F= (B-D) & 0x0f ;
                       if(save_gpr_bank0[t]!= (E|F))
                          {
                           test_low = t ;
                           test_high = t/256 ;
                           TestResoult = MemWrFail ;
                           return CommandExeOk ;
                          }
                       }  // end of for (t=i; t <=j; t++)
                   set_ep_access_emu()  ;        //set the ep access the EMU
                   TestResoult = MemWrOk ;
                   return CommandExeOk ;   
                   }//  end of if ((j <= 0x1f) && (i >= 0x00))

               if ((j <= 0x3f) && (i >= 0x20))
                  {
                   // ToBank1();
                   for (t=i; t <=j; t++)
                     {
                       ToBank1();
                       A= (t/256/16) & 0x0f ;
                       A= ~A ;
                       B= (t/256) & 0x0f ;
                       B= ~B ;
                       C=(t/16) & 0x0f ;
                       D= t & 0x0f ;
                       E= ((A-C) & 0x0f) * 16 ;
                       F= (B-D) & 0x0f ;
                       conv_id = t - 0x20;
                       reg_value0  = (E|F) ;
                       C5xModifyGpr();
                      }// end of for (t=i; t <=j; t++)
                   GetRegister();
                   C5xCopyReg();
                   for (t=i; t <=j; t++)
                     {
                       A= (t/256/16) & 0x0f ;
                       A= ~A ;
                       B= (t/256) & 0x0f ;
                       B= ~B ;
                       C=(t/16) & 0x0f ;
                       D= t & 0x0f ;
                       E= ((A-C) & 0x0f) * 16 ;
                       F= (B-D) & 0x0f ;
                       if(save_gpr_bank0[t]!= (E|F))
                          {
                           test_low = t ;
                           test_high = t/256 ;
                           TestResoult = MemWrFail ;
                           return CommandExeOk ;
                          }
                       }  // end of for (t=i; t <=j; t++)
                   set_ep_access_emu()  ;        //set the ep access the EMU
                   TestResoult = MemWrOk ;
                   return CommandExeOk ;   
                   }//  end of if ((j <= 0x3f) && (i >= 0x20))

               if ((j <= 0x5f) && (i >= 0x40))
                  {
                   // ToBank2();
                   for (t=i; t <=j; t++)
                     {
                       ToBank2();
                       A= (t/256/16) & 0x0f ;
                       A= ~A ;
                       B= (t/256) & 0x0f ;
                       B= ~B ;
                       C=(t/16) & 0x0f ;
                       D= t & 0x0f ;
                       E= ((A-C) & 0x0f) * 16 ;
                       F= (B-D) & 0x0f ;
                       conv_id = t - 0x40;
                       reg_value0  = (E|F) ;
                       C5xModifyGpr();
                      }// end of for (t=i; t <=j; t++)
                   GetRegister();
                   C5xCopyReg();
                   for (t=i; t <=j; t++)
                     {
                       A= (t/256/16) & 0x0f ;
                       A= ~A ;
                       B= (t/256) & 0x0f ;
                       B= ~B ;
                       C=(t/16) & 0x0f ;
                       D= t & 0x0f ;
                       E= ((A-C) & 0x0f) * 16 ;
                       F= (B-D) & 0x0f ;
                       if(save_gpr_bank0[t]!= (E|F))
                          {
                           test_low = t ;
                           test_high = t/256 ;
                           TestResoult = MemWrFail ;
                           return CommandExeOk ;
                          }
                       }  // end of for (t=i; t <=j; t++)
                   set_ep_access_emu()  ;        //set the ep access the EMU
                   TestResoult = MemWrOk ;
                   return CommandExeOk ;   
                   }//  end of if ((j <= 0x5f) && (i >= 0x40))

               if ((j <= 0x7f) && (i >= 0x60))
                  {
                   // ToBank3();
                   for (t=i; t <=j; t++)
                     {
                       ToBank3();
                       A= (t/256/16) & 0x0f ;
                       A= ~A ;
                       B= (t/256) & 0x0f ;
                       B= ~B ;
                       C=(t/16) & 0x0f ;
                       D= t & 0x0f ;
                       E= ((A-C) & 0x0f) * 16 ;
                       F= (B-D) & 0x0f ;
                       conv_id = t - 0x60;
                       reg_value0  = (E|F) ;
                       C5xModifyGpr();
                      }// end of for (t=i; t <=j; t++)
                   GetRegister();
                   C5xCopyReg();
                   for (t=i; t <=j; t++)
                     {
                       A= (t/256/16) & 0x0f ;
                       A= ~A ;
                       B= (t/256) & 0x0f ;
                       B= ~B ;
                       C=(t/16) & 0x0f ;
                       D= t & 0x0f ;
                       E= ((A-C) & 0x0f) * 16 ;
                       F= (B-D) & 0x0f ;
                       if(save_gpr_bank0[t]!= (E|F))
                          {
                           test_low = t ;
                           test_high = t/256 ;
                           TestResoult = MemWrFail ;
                           return CommandExeOk ;
                          }
                       }  // end of for (t=i; t <=j; t++)
                   set_ep_access_emu()  ;        //set the ep access the EMU
                   TestResoult = MemWrOk ;
                   return CommandExeOk ;   
                   }//  end of if ((j <= 0x7f) && (i >= 0x60))
              } // end of if (ME_IDENTIFY == 0X01)

         if (ME_IDENTIFY != 0x01)
             { 
               if ((j <= 0x7f) && (i >= 0x00))
                  {
                   for (t=i; t <=j; t++)
                     {
                       C6xToBank0();            // Jason 1996/10/03
                       A= (t/256/16) & 0x0f ;
                       A= ~A ;
                       B= (t/256) & 0x0f ;
                       B= ~B ;
                       C=(t/16) & 0x0f ;
                       D= t & 0x0f ;
                       E= ((A-C) & 0x0f) * 16 ;
                       F= (B-D) & 0x0f ;
                       conv_id = t;
                       reg_value0  = (E|F) ;
                       C6xModifyGpr();
                      }// end of for (t=i; t <=j; t++)
                   C6xGetRegister();
                   // C6xCopyReg();
                   for (t=i; t <=j; t++)
                     {
                       A= (t/256/16) & 0x0f ;
                       A= ~A ;
                       B= (t/256) & 0x0f ;
                       B= ~B ;
                       C=(t/16) & 0x0f ;
                       D= t & 0x0f ;
                       E= ((A-C) & 0x0f) * 16 ;
                       F= (B-D) & 0x0f ;
                       if(save_gpr_bank0[t]!= (E|F))
                          {
                           test_low = t ;
                           test_high = t/256 ;
                           TestResoult = MemWrFail ;
                           return CommandExeOk ;
                          }
                       }  // end of for (t=i; t <=j; t++)
                   set_ep_access_emu()  ;        //set the ep access the EMU
                   TestResoult = MemWrOk ;
                   return CommandExeOk ;   
                   }//  end of if ((j <= 0x7f) && (i >= 0x20))

               if ((j <= 0xff) && (i >= 0x80))
                  {
                   for (t=i; t <=j; t++)
                     {
                       C6xToBank1();          // Jason 1996/10/03
                       A= (t/256/16) & 0x0f ;
                       A= ~A ;
                       B= (t/256) & 0x0f ;
                       B= ~B ;
                       C=(t/16) & 0x0f ;
                       D= t & 0x0f ;
                       E= ((A-C) & 0x0f) * 16 ;
                       F= (B-D) & 0x0f ;
                       conv_id = t - 0x80;
                       reg_value0  = (E|F) ;
                       C6xModifyGpr();
                      }// end of for (t=i; t <=j; t++)
                     C6xGetRegister();
                     // C6xCopyReg();
                   for (t=i; t <=j; t++)
                     {
                       A= (t/256/16) & 0x0f ;
                       A= ~A ;
                       B= (t/256) & 0x0f ;
                       B= ~B ;
                       C=(t/16) & 0x0f ;
                       D= t & 0x0f ;
                       E= ((A-C) & 0x0f) * 16 ;
                       F= (B-D) & 0x0f ;
                       if(save_gpr_bank0[t]!= (E|F))
                          {
                           test_low = t ;
                           test_high = t/256 ;
                           TestResoult = MemWrFail ;
                           return CommandExeOk ;
                          }
                       }  // end of for (t=i; t <=j; t++)
                   set_ep_access_emu()  ;        //set the ep access the EMU
                   TestResoult = MemWrOk ;
                   return CommandExeOk ;   
                   }//  end of if ((j <= 0xff) && (i >= 0x80))
            }
       }// end of if ( commandStream[1] == 0x03)

   }// end of else eprunning
}// end of function

/************************************************************
void C6xCopyReg(void)
{
 save_gpr_bank0[0]=0x00;
 save_gpr_bank0[1]=save_reg[26];
 save_gpr_bank0[2]=save_reg[0];
 save_gpr_bank0[3]=save_reg[28];
 save_gpr_bank0[4]=save_reg[30];
 save_gpr_bank0[5]=save_reg[32];
 save_gpr_bank0[6]=save_reg[34];
 save_gpr_bank0[7]=save_reg[36];
 save_gpr_bank0[8]=save_reg[38];
 save_gpr_bank0[9]=save_reg[40];
 save_gpr_bank0[10]=save_reg[42];//a
 save_gpr_bank0[11]=save_reg[44];//b
 save_gpr_bank0[12]=save_reg[46];//c
 save_gpr_bank0[13]=save_reg[48];//d
 save_gpr_bank0[14]=save_reg[18];//e
 save_gpr_bank0[15]=save_reg[19];//f
 save_gpr_bank0[16]=save_reg[50];//10
 save_gpr_bank0[17]=save_reg[52];//11
 save_gpr_bank0[18]=save_reg[54];//12
 save_gpr_bank0[19]=save_reg[56];//13
 save_gpr_bank0[20]=save_reg[58];//14
 save_gpr_bank0[21]=save_reg[20];//15
 save_gpr_bank0[22]=save_reg[21];//16
 save_gpr_bank0[23]=save_reg[60];//17
 save_gpr_bank0[24]=save_reg[62];//18
 save_gpr_bank0[25]=save_reg[64];//19
 save_gpr_bank0[26]=save_reg[66];//1a
 save_gpr_bank0[27]=save_reg[22];//1b
 save_gpr_bank0[28]=save_reg[23];//1c
 save_gpr_bank0[29]=save_reg[68];//1d
 save_gpr_bank0[30]=save_reg[68];//1e
 save_gpr_bank0[31]=save_reg[70];//1f


 save_gpr_bank0[128]=0x00;
 save_gpr_bank0[129]=save_reg[72];//option
 save_gpr_bank0[130]=save_reg[0]; //pcl
 save_gpr_bank0[131]=save_reg[28];//status
 save_gpr_bank0[132]=save_reg[30];//fsr
 save_gpr_bank0[133]=save_reg[74];//trisa
 save_gpr_bank0[134]=save_reg[76];//trisb
 save_gpr_bank0[135]=save_reg[78];//trisc
 save_gpr_bank0[136]=save_reg[80];//trisd
 save_gpr_bank0[137]=save_reg[82];//trise
 save_gpr_bank0[138]=save_reg[42];//8a  pclath
 save_gpr_bank0[139]=save_reg[44];//8b  intcon
 save_gpr_bank0[140]=save_reg[84];//8c  pie1
 save_gpr_bank0[141]=save_reg[86];//8d  pie2
 save_gpr_bank0[142]=save_reg[88];//8e  pcon
 save_gpr_bank0[143]=save_reg[19];//8f
 save_gpr_bank0[144]=save_reg[50];//90
 save_gpr_bank0[145]=save_reg[52];//91
 save_gpr_bank0[146]=save_reg[90];//92  pr2
 save_gpr_bank0[147]=save_reg[92];//93  sspadd
 save_gpr_bank0[148]=save_reg[94];//94  sspstat
 save_gpr_bank0[149]=save_reg[20];//95
 save_gpr_bank0[150]=save_reg[21];//96
 save_gpr_bank0[151]=save_reg[60];//97
 save_gpr_bank0[152]=save_reg[96];//98 txsta
 save_gpr_bank0[153]=save_reg[98];//99  spbrg
 save_gpr_bank0[154]=save_reg[21];//9a
 save_gpr_bank0[155]=save_reg[22];//9b
 save_gpr_bank0[156]=save_reg[23];//9c
 save_gpr_bank0[157]=save_reg[68];//9d
 save_gpr_bank0[158]=save_reg[68];//9e
 save_gpr_bank0[159]=save_reg[100];//9f vrcon
}

************************************************************/
void C5xCopyReg(void)
{
 unsigned char c5xtemp;
 save_gpr_bank0[0]=0x00;
 save_gpr_bank0[1]=save_reg[4];      // tmr0
 save_gpr_bank0[2]=save_reg[0];       // pcl
 save_gpr_bank0[3]=save_reg[5];      //status
 save_gpr_bank0[4]=save_reg[3];     // fsr  FSR
 save_gpr_bank0[5]=save_reg[6];    // PORTA
 save_gpr_bank0[6]=save_reg[7];   // PORTB
 save_gpr_bank0[7]=save_reg[8];   // PORTC
 for ( c5xtemp = 1; c5xtemp<=7; c5xtemp++)
      {
       save_gpr_bank0[c5xtemp+0x20] = save_gpr_bank0[c5xtemp];
       save_gpr_bank0[c5xtemp+0x40] = save_gpr_bank0[c5xtemp];
       save_gpr_bank0[c5xtemp+0x60] = save_gpr_bank0[c5xtemp];
      }
}
