

/**************************************************************************
**
** $Header:
**
** $Log:
** 
** 
** Initial revision. 1.0
** 
***************************************************************************/
/****************************************************************************
**
**  Name:          swsubpic.c
**
**  Description:   This is the main sur-routine
**
**  Status: PRELIMINARY
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/



#include <reg51.h>
#include <string.h>
#include <stdio.h>
#include <io.h>
///////////////////////////////////////////////////////////////
#include <c6xio.h>                                           //
///////////////////////////////////////////////////////////////
                        /****************************
                         *                          *
                         *    EXTERNAL code         *
                         *                          *
                         ****************************/
extern unsigned char get_stkpnt_reg(void) ;
void push_stackpoint(void) ;
void pop_stackpoint(void) ;
extern unsigned int read_spoon(void) ;
void p16c02_ini(void)  ;
void clr_code_coverage(void) ;
void GetPoint(void)  ;
void ToBank0(void)   ;
void ToBank1(void)   ;
void ToBank2(void)   ;
void ToBank3(void)   ;
void C6xToBank0();
///////////////////////////////////////////////////////////
void C6xToBank1();                                       //
void C6xToBank2();                                       //
void C6xToBank3();                                       //
///////////////////////////////////////////////////////////
extern unsigned char check_eprunning(void) ;
void reset_ep(void)  ;
void GetRegister(void)  ;
///////////////////////////////////////////////////////////
void C6xGetRegister(void)  ; // Jason 07/09/1996         //
///////////////////////////////////////////////////////////
void clr_ext_bp(void)   ;
void ModifyReg(void) ;
///////////////////////////////////////////////////////////
void C6xModifyReg(void) ;                                //
extern void C6xModifyGPR(unsigned char) ;                                //
void C6x_Save_general_bank0(void);                       //
void C6x_Save_general_bank1(void);                       //
void C6x_Read_general_bank0(void);
void C6x_Read_general_bank1(void);
///////////////////////////////////////////////////////////
void check_exeOk(void)  ;
void ignor_bp(void) ;
void resume_bp(void) ;
void set_trigger(void) ;
void set_trigger_type(void) ;
extern unsigned char sleep_mode_check(void);
extern unsigned char read_tbank(void);
extern unsigned char get_exebp(void);
void set_break_type(void) ;
void set_exe_bp_addr(void) ;
void set_ep_access_emu(void) ;
void set_cp_access_emu(void) ;
void set_ev1_counter(void) ;
void clear_time_calculate(void)  ;
extern unsigned char read_exe_time(void) ;
void run_ep(void)         ;

void halt_ep(void) ;
void ep_type_select(void) ;
void write_spoon(void)  ;
void reset_disable(void)  ;
void reset_enable(void)  ;
void watchdog_enable(void)  ;
void watchdog_disable(void)  ;
void c6x_watchdog_enable(void)  ;
void c6x_watchdog_disable(void)  ;
void prepheral_disable(void)  ;
void prepheral_enable(void)  ;
void set_clock(void) ;
void set_emu_bank0(void)  ;
void set_emu_bank1(void)  ;
void set_emu_break(void)  ;
void set_break_emu(void)  ;
void clr_exe_bp_addr(void) ;
void step_ep(void) ;
void set_ev1_addr(void) ;
void set_ev2_addr(void) ;
void set_qualify_addr(void) ;
void sel_cp_trace(void) ;
void sel_ep_trace(void) ;
void set_trace1(void) ;
void set_trace2(void) ;
void load_trace_frame(void) ;
void inc_trace_frame(void) ;
void read_trace_frame(void) ;
void read_trace_value(void) ;
void sel_code_coverage(void) ;
void ev3_select(void) ;
void ep_ini(void) ;
void C6X_Resume_Time0(void);

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

extern unsigned char  ME_IDENTIFY;
extern unsigned char TransmitBuf[2048] ;
extern unsigned int TStreamLen ;
extern unsigned char retvalue;                         
extern unsigned char commandStream[2048];              
extern unsigned char go_till_addrl ;
extern unsigned char go_till_addrh  ;
extern bit step_range_flag;
extern bit go_till_flag;
extern unsigned char emu_add[16383];
extern unsigned register_modifiable;


                        /****************************
                         *                          *
                         *    LOCAL    VARIABLES    *
                         *                          *
                         ****************************/


unsigned char stkpnt_flag ;
unsigned char save_add_temp0, save_add_temp1 ;
unsigned int op_frame_start;
unsigned int op_frame_end;
unsigned int delay_time ;
unsigned char delay_time_low ;
unsigned char delay_time_high ;
unsigned char TH1_BAK;
unsigned char TL1_BAK;
unsigned char read_exe_time_bak;
unsigned int delay ;
float exe_time ;
float cycle_base ;
float clock_rate ;
float mhz ;
unsigned char Coverage_Flg ; 
unsigned char trace_on_off ; 
unsigned int Trace1_end_frame ;
unsigned int Trace2_end_frame ;
unsigned int Trace2_start_frame ;
unsigned int Trace1_start_frame ;
unsigned char exe_bp_addr0  ;
unsigned char stack_point_low  ;
unsigned char change_pc_low  ;
unsigned char change_pc_high ;
unsigned char stack_point_high  ;
unsigned char exe_bp_addr1  ;
unsigned char break_type_in  ;
unsigned char break_type_out ;
unsigned char trigger_condition  ;
unsigned char trigger_type ;
unsigned char trigger_type_bak ;
unsigned char EPstatus ;         
unsigned char save_reg[504];     
unsigned int check_exe  ;
unsigned int check_exe_id  ;
unsigned char EP_type   ;
unsigned char reg_value0   ;
unsigned char reg_value1   ;
unsigned int  register_id ;
unsigned int  register_c6x_id ;
unsigned char conv_id ;
unsigned char  reset_type ;
unsigned char  EPrunningFlag ;
unsigned char trigger_condition_bak  ;
unsigned char spoon_data0  ;
unsigned char spoon_data1  ;
unsigned char control_set_bak  ;
unsigned char sel_clk  ;
unsigned char PortValue  ;
unsigned char status_low ;
unsigned char status_high ;
extern unsigned char checksum_low ;
extern unsigned char checksum_high ;
extern unsigned char compare_low ;
extern unsigned char compare_high ;
extern unsigned char copy_low ;
extern unsigned char copy_high ;
extern unsigned char fill_low ;
extern unsigned char fill_high ;
extern unsigned char rd_mem_length_low ;
extern unsigned char rd_mem_length_high ;
extern unsigned int  rd_mem_length ;
extern unsigned int  SearchResoult ;
extern unsigned int  TestResoult ;
extern unsigned int  search_low ;
extern unsigned int  search_high ;
extern unsigned int  test_low ;
extern unsigned int  test_high ;
unsigned char Select_break;
unsigned int  find_bp_low ;
unsigned int  find_bp_high ;
unsigned char ep_support[30] ;
unsigned char event1_buffer[30] ;
unsigned char event2_buffer[30] ;
unsigned char qualify_buffer[30] ;
unsigned char EvQfStatus ;
unsigned int clear_exebp_addr0 ;
unsigned int clear_exebp_addr1 ;
unsigned int clear_ev1_addr0 ;
unsigned int clear_ev1_addr1 ;
unsigned int clear_ev2_addr0 ;
unsigned int clear_ev2_addr1 ;
unsigned int clear_qualify_addr0 ;
unsigned int clear_qualify_addr1 ;
unsigned char ev1_addr0 ;
unsigned char ev1_addr1 ;
unsigned char ev2_addr0 ;
unsigned char ev2_addr1 ;
unsigned char qualify_addr0 ;
unsigned char qualify_addr1 ;
unsigned char ev1_counter ;
unsigned char fw_trace_ini(void) ;
unsigned char trigger_framel ;
unsigned char trigger_frameh ;
unsigned char end_framel ;
unsigned char end_frameh ;
unsigned char go_run_flag ;
unsigned char TraceBank ;
unsigned char trace_framel ;
unsigned char trace_frameh ;
unsigned char trace_addrl ;
unsigned char trace_addrh ;
unsigned char pic_addrl ;
unsigned char pic_addrh ;
unsigned char pic_rb    ;
unsigned char trace_port;
unsigned char sel_ev3 ;
unsigned char trace_frame_over ;
unsigned char trace_frame_number ;
unsigned char get_trace_framel[256];
unsigned char get_trace_frameh[256];
unsigned char get_trace_addrl[256];
unsigned char get_trace_addrh[256];
unsigned char get_trace_rb[256];
unsigned char get_trace_port[256];
unsigned char trace_full;
unsigned char traceCntLow  ;
unsigned char traceCntHigh ;
unsigned char stop_type;
unsigned long TimerCalculate ;
unsigned char Coverage_Range_No  ;
unsigned int Coverage_Range_SAd1 ;
unsigned int Coverage_Range_DAd1 ;
unsigned int Coverage_Range_SAd2 ;
unsigned int Coverage_Range_DAd2 ;
unsigned int Coverage_Range_SAd3 ;
unsigned int Coverage_Range_DAd3 ;
unsigned int Coverage_Range_SAd4 ;
unsigned int Coverage_Range_DAd4 ;       
unsigned int end_spa_address ;
unsigned char spa_flag ;          
unsigned register_modifiable;
unsigned char HALT_STATUS ;


                         /***************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

unsigned char fw_Mhz_get(void) ;
void target_clock_get(void) ;
float target_clock_calculate(void) ;
void target_mhz_calculate(void) ;
void stack_point1_change(void) ;
void stack_point0_change(void) ;
void change_pc(void) ;
void change_bank(void) ;
void check_stkpnt(void) ;
void Change_C6x_Bank(void) ;  
void ToCalculateTime(void) ;
void start_end_frame_check(void) ;
void break_ep(void) ;
unsigned char Epsleeping_check(void) ;
unsigned char fw_ep_reset(void)  ;
unsigned char fw_ep_start(void)  ;
unsigned char fw_ep_halt(void)  ;
unsigned char fw_cpu_select(void)  ;
unsigned char fw_control_get(void)  ;
unsigned char fw_control_set(void)  ;
unsigned char fw_port_out(void)  ;
unsigned char fw_port_in(void)  ;
unsigned char fw_verify_set(void)  ;
unsigned char fw_trig_logic_set(void)  ;
unsigned char fw_trig_status_set(void) ;
extern unsigned char fw_mem_checksum(void)  ;
extern unsigned char fw_mem_compare(void)  ;
extern unsigned char fw_mem_copy(void)  ;
extern unsigned char fw_mem_read(void)  ;
extern unsigned char fw_mem_fill(void)  ;
extern unsigned char fw_mem_search(void)  ;
extern unsigned char fw_mem_test(void)  ;
unsigned char fw_reg_modify(void)  ;
unsigned char fw_bp_set(void)  ;
unsigned char fw_bp_clr(void)  ;
unsigned char fw_get_bp(void)  ;
unsigned char fw_step_one(void) ;
unsigned char fw_step_over(void) ;
void break_ini(void);
void fw_ep_support_get(void) ;
unsigned char fw_event_set(void) ;
unsigned char fw_event_clr(void) ;
void clr_exebp(void) ;
void clr_ev1(void) ;
void clr_ev2(void) ;
void clr_qualify(void) ;
unsigned char fw_trace_bank(void)  ;
unsigned char fw_trace_cc(void)  ;
unsigned char fw_trace_read(void) ;
unsigned char fw_lastframe_get(void) ;
unsigned char fw_select_ev3(void) ;
float execution_calculate(void) ;
float execution_calculate_base(void) ;
void sysini(void) ;
unsigned char fw_SpaBreakpointSet(void) ;
unsigned char fw_CoverageGo(void) ;


/*****************************************************************************/
/*************************************************************************
//initial the control hw
**************************************************************************/
void sysini(void)
{
   unsigned int i;
   ep_ini() ;
   delay = 0x0 ;
   step_range_flag = 0x0 ;
   stop_type = user ;      //the ep is  stop by user
   sel_ev3 = 0x0 ;
   ev3_select() ;
   go_till_flag = 0x0 ;
   EPstatus = 0x0 ;
   EPrunningFlag = 0x0 ;
   status_low = 0x0 ;
   status_high = 0x0 ;
   delay_time = 0xff;
   delay_time_low = 0xff;
   delay_time_high = 0x0;
   spa_flag = 0x0 ;              
   TimerCalculate = 0x0 ;
//   control_set_bak = 0x1D ;
   control_set_bak = 0x15 ;
   reset_enable()  ;
//   watchdog_enable()  ;
   watchdog_disable()  ;
   prepheral_enable()  ;
   trace_on_off = trace_on;
   trigger_type = Trigger_off ;
   trigger_type_bak = Trigger_off ;
   exe_time = 0;
   clock_rate =67.81684028;
   ev1_counter = 0xfe ;
   TraceBank = 0x1  ;
   Trace1_end_frame = 0x0 ;
   Trace2_end_frame = 0x0 ;
   Trace1_start_frame = 0x0 ;
   Trace2_start_frame = 0x0 ;
   Coverage_Flg = 0;
   Coverage_Range_No = 0x0;
   Coverage_Range_SAd1 = 0x0 ;
   Coverage_Range_DAd1 = 0x0 ;
   Coverage_Range_SAd2 = 0x0 ;
   Coverage_Range_DAd2 = 0x0 ;
   Coverage_Range_SAd3 = 0x0 ;
   Coverage_Range_DAd3 = 0x0 ;
   Coverage_Range_SAd4 = 0x0 ;
   Coverage_Range_DAd4 = 0x0 ;
   for (i=0;i<=124;i++)
       {
         save_reg[i] = 0;
        }
   stop_type = user ;
   IP = 0x10 ;
   TL1 = 0X0 ;
   TH1 = 0X0 ;
   TMOD = 0X51 ;
   IT0 = 1 ;
   IT1 = 1 ;
   EA = 1 ;
   ES = 1 ;
   ET1 = 1;
   ET0 = 1 ;
   EX1 = 1 ;
   EX0 = 1 ;
   TR1 = 1 ;

  set_cp_access_emu()  ;
  set_break_emu() ;     
  set_emu_bank0() ;
  for(i=0x0; i<=0x3fff; i++)
     {
       emu_add[i] = 0x0f ;  //clr the ev1,ev2,qualify,exebp seeting
     }
  set_emu_bank1() ;
  for(i=0x0; i<=0x3fff; i++)
     {
       emu_add[i] = 0x0f ;  //clr the ev1,ev2,qualify,exebp seeting
     }
  set_emu_break() ;
  for(i=0x0; i<=0x3fff; i++)
     {
       emu_add[i] = 0x0 ;
     }
  HALT_STATUS = 1 ;
  reset_ep() ;
  set_emu_bank0() ;
}



/*****************************************************************************/
/*************************************************************************
//initial the control hw
**************************************************************************/
void break_ini(void)
{
   unsigned int i;
   trace_on_off = trace_off;
   trigger_type = Trigger_off ;
   trigger_type_bak = Trigger_off ;
   ev1_counter = 0xfe ;
   set_cp_access_emu()  ;
   set_break_emu() ;
   set_emu_bank0() ;
   for(i=0x0; i<=0x3fff; i++)
      {
        emu_add[i] = 0x0f ;  //clr the ev1,ev2,qualify,exebp seeting
      }
   set_emu_bank1() ;
   for(i=0x0; i<=0x3fff; i++)
      {
        emu_add[i] = 0x0f ;  //clr the ev1,ev2,qualify,exebp seeting
      }
   set_emu_break() ;
   for(i=0x0; i<=0x3fff; i++)
     {
       emu_add[i] = 0x0 ;
     }
   reset_ep() ;
   set_emu_bank0() ;
}



/*****************************************************************************/
/*************************************************************************
//input save_reg[0],save_reg[1], output : change_pc_low, change_pc_high
**************************************************************************/
void change_pc(void)
{
   unsigned int temp ;
   temp = (save_reg[1] & 0x7) * 256 + save_reg[0] ;
   if (temp < 0x5)
     {
        temp = reset_type * 256 + 0xff - 4 + save_reg[0] ;
     }
   else
     {
        temp = temp - 5     ;
     }
   change_pc_low = temp ;
   change_pc_high = temp /256 ;
}

/*************************************************************************
;******************************************************************************
;*
;*  void check_stkpnt(void)
;*
;*
;* description:        check the PIC16C6XX stack pointer if it was underflow or
;*                     overflow after firmware reading the stack , if it was
;*                     underflow or overflow only because of firmware's reading
;*                     the stack the resume the stack status. if it was 
;*                     underflow because of after firmware's reading then push
;*                     the stack 8 times, if it was  overflow because of after
;*                     firmware's reading then pop the stack 8 times
;*
;* input:
;*        save_reg[104]  ; the stack pointer of PIC16C02_ME
;*
;* output:
;*        none
;*
;*
;****************************************************************************/

void check_stkpnt(void)
{
   unsigned char stkpnt_bak;
   stkpnt_flag = 0 ;
   stkpnt_bak = get_stkpnt_reg()  ;
   if  ((((save_reg[104] & 0xc0) == 0) && ((stkpnt_bak & 0xc0) == 0x80))
    || (((save_reg[104] & 0xc0) == 0x40) && ((stkpnt_bak & 0xc0) == 0))
    || (((save_reg[104] & 0xc0) == 0x40) && ((stkpnt_bak & 0xc0) == 0x80))
    || (((save_reg[104] & 0x8) == 8) && ((stkpnt_bak & 0x8) == 0)))
                                                                   //shall push

      {
        push_stackpoint() ;
      }

   if  ((((save_reg[104] & 0xc0) == 0) && ((stkpnt_bak & 0xc0) == 0x40))
    || (((save_reg[104] & 0xc0) == 0x80) && ((stkpnt_bak & 0xc0) == 0))
    || (((save_reg[104] & 0xc0) == 0x80) && ((stkpnt_bak & 0xc0) == 0x40))
    || (((save_reg[104] & 0x8) == 0) && ((stkpnt_bak & 0x8) == 8)))
                                                                    //shall pop
      {
        pop_stackpoint() ;
      }
   stkpnt_bak = get_stkpnt_reg() ;
   if (stkpnt_bak != save_reg[104])
     {
       stkpnt_flag = 1 ;
     }


}

/*************************************************************************
;******************************************************************************
;*
;*  void change_bank(void)
;*
;*
;* description: EPSLD for PICPack access the General Purpose Register File
;*              by the ID code of the register.this routine can transfer
;*              the ID code to the PIC16C5XX's register physical address.
;*
;* input:
;*	  register_id
;*
;* output:
;*	  put the PIC16C5XX's register physical address to  "conv_id".
;*
;*
;****************************************************************************/
/*****************************************************************************/
void change_bank(void)
{
  if (register_id >=0x11 && register_id <=0x28)    // the register is in bank0
        {                                          // gpr 8 ~ 1f
         ToBank0();
         conv_id = register_id - 0x9 ;
        }

  if   ((register_id ==0x6)|| (register_id ==0x7)||
       (register_id ==0x8))     // the register is in bank0
        {                                // port a,b,c
         ToBank0();
         conv_id = register_id - 0x1 ;
        }

  if   (register_id ==0x4)     // the register is in bank0
        {                                        //rtcc
         ToBank0();
         conv_id = 0x1 ;
        }

  if (register_id >=0x29 && register_id <=0x38)     // the register is in bank1
       {                                            //gpr 30~3f
         ToBank1() ;
         register_id=register_id-0x10;
         conv_id = register_id - 0x9 ;
       }

  if (register_id >=0x39 && register_id <=0x48)   // the register is in bank2
       {                                         //gpr 50~5f
         ToBank2() ;
         register_id=register_id-0x20;
         conv_id = register_id - 0x9 ;
       }

  if (register_id >=0x49 && register_id <=0x58)    // the register is in bank3
       {
         ToBank3();
         register_id=register_id-0x30;
         conv_id = register_id - 0x9 ;
       }

  if (register_id >=0xa && register_id <=0xc) // the register is in bank3
       {                                  // trisa,b,c
         ToBank3();
         conv_id = register_id - 0x5 ;
       }

  if (register_id ==0x9) // the register is in bank3
       {                         // option
         ToBank3();
         conv_id = 0x1 ;
       }
}

/*************************************************************************
;******************************************************************************
;*
;*  void Change_C6x_Bank(void)
;*
;*
;* description: EPSLD for PICPack access the General Purpose Register File
;*              by the ID code of the register.this routine can transfer
;*		the ID code to the PIC16C6X's register physical address.
;*
;* input:
;*	  register_id
;*
;* output:
;*	  put the PIC16C6XX's register physical address to  "conv_id".
;*
;*
;****************************************************************************/
/*****************************************************************************/
void Change_C6x_Bank(void)
{

if (register_id < 9    )
      {
       return;
      }
if (register_id ==12 )       // W
     {
       return;
     }
if (register_id == 14 )
      {
       C6xToBank0();
       conv_id = register_id - 11;
       register_modifiable=0;
       return;
      }
if (register_id ==15)
      {
       C6xToBank0();
       conv_id = register_id - 11;
       register_modifiable=1;
       return;
      }
if (register_id >=16 && register_id <=21)
      {
       C6xToBank0();
       conv_id = register_id - 11;
       register_modifiable=0;
       return;
      }
if (register_id ==22 )
      {
       C6xToBank0();
       conv_id = register_id - 11;
       register_modifiable=1;
       return;
      }
if (register_id >=23 && register_id <=24)
      {
       C6xToBank0();
       conv_id = register_id - 11;
       register_modifiable=0;
       return;
      }
if (register_id == 25)
      {
       C6xToBank0();
       conv_id = register_id - 9 ;
       register_modifiable=0;
       return;
      }
if (register_id == 26)
      {
       C6xToBank0();
       conv_id = register_id - 9 ;
       register_modifiable=1;
       return;
      }
if (register_id == 27)
      {
       C6xToBank0();
       conv_id = register_id - 9 ;
       register_modifiable=0;
       return;
      }
if (register_id >=28 && register_id <=29)
      {
       C6xToBank0();
       conv_id = register_id - 9 ;
       return;
      }
if (register_id >=30 && register_id <=33)
      {
       C6xToBank0();
       conv_id = register_id - 7 ;
       register_modifiable=0;
       return;
      }
if (register_id == 37  )
    {
       C6xToBank1() ;
       conv_id = register_id - 32;
       register_modifiable=0;
       return;
     }
if ((register_id >= 38) && (register_id <= 39))   //  bank1
     {
       C6xToBank1() ;
       conv_id = register_id - 32;
       return;
     }
if ((register_id >= 40) && (register_id <=41))   //  bank1
     {
       C6xToBank1() ;
       conv_id = register_id - 32;
       register_modifiable=0;
       return;
     }
if ((register_id >=42) && (register_id <=43))   //  bank1
     {
       C6xToBank1() ;
       conv_id = register_id - 30;
       return;
     }
if (register_id == 44)
     {
       C6xToBank1() ;
       conv_id = register_id - 30;
       register_modifiable=0;
       return;
     }
if ((register_id >=45) && (register_id <=46))   //  bank1
     {
       C6xToBank1() ;
       conv_id = register_id - 27;
       return;
     }
if (register_id == 47 )
     {
       C6xToBank1() ;
       conv_id = register_id - 27;
       register_modifiable=0;
       return;
     }
if (register_id ==36 )       // OPTION
     {
       C6xToBank1() ;
       conv_id =1;
       return;
     }
if (register_id ==13 )       // TMR0
     {
       C6xToBank0() ;
       conv_id =  1 ;
       return;
     }
if (register_id ==9  )       // TMR1
     {
       C6xToBank0() ;
       conv_id =0X0E;
       return;
     }
if (register_id ==10 )       // CCPR1
     {
       C6xToBank0() ;
       conv_id =0X15;
       return;
     }
if (register_id ==11 )       // CCPR2
     {
       C6xToBank0() ;
       conv_id =0X1B;
       return;
     }
if (register_id ==48 )       // TXSTA
     {
       C6xToBank1() ;
       conv_id =0X18;
       register_modifiable=0;
       return;
     }
if (register_id ==34 )       // CCP2CON
     {
       C6xToBank0() ;
       conv_id =0X1D;
       register_modifiable=0;
       return;
     }
if (register_id ==35 )       // CMCON
     {
       C6xToBank0() ;
       conv_id =0X1F;
       register_modifiable=0;
       return;
     }
if (register_id ==49 )       // SPBRG
     {
       C6xToBank1() ;
       conv_id =0X19;
       return;
     }
if (register_id ==50 )       // VRCON
     {
       C6xToBank1() ;
       conv_id =0X1F;
       register_modifiable=0;
       return;
     }
if (register_id ==51 )       // EMCON
     {
       C6xToBank2() ;
       conv_id =0X01;
       return;
     }

if (register_id ==52)     // STKPNT
     {
       C6xToBank2() ;
       conv_id =0X06;
       return;
     }

if (register_id ==53)     // ADRES OF PIC16C73 / PIC16C74
     {
       C6xToBank0() ;
       conv_id =0X1E;
       return;
     }

if ((EP_type==PIC16C61)||(EP_type==PIC16C71)||(EP_type==PIC16C84))
    {
      if (register_id >=60 && register_id<96)
          {
            C6xToBank0();
            conv_id = (register_id - 60) + 0x0C;
            return;
          }
      if (register_id >=96 && register_id<132)
          {
            C6xToBank1();
            conv_id = (register_id -96) + 0x0C ;
            return;
          }
      if (register_id >= 132)
          {
            return;
          }
      }
else
    {
       if (register_id >=60 && register_id <156)
            {
              C6xToBank0();
              conv_id = (register_id - 60) + 0x20;
              return;
            }
       if (register_id >=156)
            {
              C6xToBank1();
              conv_id = (register_id -156) + 0x20 ;
              return;
            }
   }

}

/*****************************************************************************/
/*************************************************************************
//input save_reg
**************************************************************************/
void stack_point1_change(void)
{
   unsigned int temp ;
   temp = save_reg[sp1l_id] + save_reg[sp1h_id] * 256 ;
   if(temp == 0x0)
     {
       temp = reset_type * 256 + 0xff  ;
     }
   else
     {
      stack_point_low = temp -1 ;
      stack_point_high = (temp -1)/256 ;
     }
}

void stack_point0_change(void)
{
   unsigned int temp ;
   temp = save_reg[sp0l_id] + save_reg[sp0h_id] * 256 ;
   if(temp == 0x0)
     {
       temp = reset_type * 256 + 0xff  ;
     }
   else
     {
      stack_point_low = temp -1 ;
      stack_point_high = (temp -1)/256 ;
     }
}
/*****************************************************************************/
/*************************************************************************
//input none , to calculate execution time
**************************************************************************/
void ToCalculateTime(void)
{
   TimerCalculate++ ;
}

/*****************************************************************************/
/*************************************************************************
//input none , to check whether the ep is in sleep mode
**************************************************************************/
unsigned char Epsleeping_check(void)
{
/*
 if(sleep_mode_check()==0x1)      // check sleep mode
   {
    status_low = status_low  & 0x8f| 0x70 ;  //the status indicate the epsleep
    return EPsleeping  ;          // ep is in sleeping mode, return sleep flag
   }
   else
   {
    return CommandExeOk  ;
   }
*/
  return CommandExeOk  ;
}

/*****************************************************************************/
/*************************************************************************
//input none , to check the start & end frame
**************************************************************************/
/*****************************************************************************/
void start_end_frame_check(void)
{
   unsigned int temp ;
   read_trace_frame()  ;
   set_break_emu();
   temp = read_spoon()*2-1    ;
   if(((trace_full == not_full) && (trigger_type != Forward))
    ||((trigger_type == Forward) && ((emu_add[temp] & 0x8) == 0x0)))
       {
            if(TraceBank == 0x1)
           {
               Trace1_end_frame = (end_framel + end_frameh * 256) +2;
               Trace1_start_frame = 0x0 ;
           }
         if(TraceBank == 0x2)
           {
               Trace2_end_frame = (end_framel + end_frameh * 256) +2;
               Trace2_start_frame = 0x0 ;
           }
       }

   if  (((trigger_type == Trigger_off) && (trace_full == full))
      ||((trigger_type == Forward) && ((emu_add[temp] & 0x8) != 0x0)))
       {
         if(TraceBank == 0x1)
           {
               Trace1_start_frame = (end_framel + end_frameh * 256+2)     ;
               Trace1_end_frame = Trace1_start_frame + 0x4000;
           }
         if(TraceBank == 0x2)
           {
               Trace2_start_frame = (end_framel + end_frameh * 256+2)   ;
               Trace2_end_frame = Trace2_start_frame + 0x4000;
           }
       }

   if((trigger_type == Backward) && (trace_full == full))
       {
         if(TraceBank == 0x1)
           {
             Trace1_start_frame = (trigger_framel + trigger_frameh * 256 + 2) ;
             Trace1_end_frame = Trace1_start_frame + 0x4000;
           }
         if(TraceBank == 0x2)
           {
             Trace2_start_frame = (trigger_framel + trigger_frameh * 256 + 2) ;
             Trace2_end_frame = Trace2_start_frame + 0x4000;
           }
       }
     set_emu_break() ;
}
/*************************************************************************
//input none , to clear exebp setting
**************************************************************************/
void clr_exebp(void)
{
   unsigned int i ;
   set_cp_access_emu()  ;               // the cp access the emu
   set_break_emu() ;
   for(i=clear_exebp_addr0 ;i<=clear_exebp_addr1 ;i++)
      {
         emu_add[i*2+1] = emu_add[i*2+1] | 0x08 ;  //clr the exebp seeting
      }
   set_emu_break() ;
}

/*****************************************************************************/
/*************************************************************************
//input none , to clear ev1 setting
**************************************************************************/

void clr_ev1(void)
{
   unsigned int i ;
   set_cp_access_emu()  ;               // the cp access the emu
   set_break_emu() ;
   for(i=clear_ev1_addr0;i<=clear_ev1_addr1;i++)
      {
         emu_add[i*2+1] = emu_add[i*2+1] | 0x01 ;  //clr the ev1 seeting
      }
   set_emu_break() ;
}


/*****************************************************************************/
/*************************************************************************
//input none , to clear ev2 setting
**************************************************************************/
void clr_ev2(void)
{
   unsigned int i ;
   set_cp_access_emu()  ;               // the cp access the emu
   set_break_emu() ;
   for(i=clear_ev2_addr0;i<=clear_ev2_addr1;i++)
      {
         emu_add[i*2+1] = emu_add[i*2+1] | 0x02 ;  //clr the ev2 seeting
      }
   set_emu_break() ;
}

/*****************************************************************************/
/*************************************************************************
//input none , to clear qualify setting
**************************************************************************/
void clr_qualify(void)
{
   unsigned int i ;
   set_cp_access_emu()  ;               // the cp access the emu
   set_break_emu() ;
   for(i=clear_qualify_addr0;i<=clear_qualify_addr1;i++)
      {
         emu_add[i*2+1] = emu_add[i*2+1] | 0x04 ;  //clr the qualify seeting
      }
   set_emu_break() ;
}



/*************************************************************************
;******************************************************************************
;*
;*
;* description:halt EP by exebp or event, not user break
;* input: None
;* output: None
;****************************************************************************/
void break_ep(void)
{
      unsigned int temp ;
      TH1_BAK = TH1 ;
      TL1_BAK = TL1 ;
      read_exe_time_bak = read_exe_time() ;
      set_cp_access_emu() ;
      sel_cp_trace() ;
      start_end_frame_check() ;
      EPrunningFlag = 0x0;               // the EP running flag is cleared


      if (EP_type<=PIC16CR58A)
          {
            GetRegister();        // read the EP's register
            watchdog_disable() ;
            temp = (save_reg[1] * 256 + save_reg[0]) *2 -1 ;
            set_break_emu() ;
            if((emu_add[temp] & 0x8) == 0x0)
               {                //this break is exebp, so pc = pc-1
                temp = save_reg[1] * 256 + save_reg[0]  ;
                if (temp == 0)
                   {
                    reg_value0 = 0xff ;
                    reg_value1 = reset_type   ;
                    }
                else
                    {
                    reg_value0 = temp-1   ;
                    reg_value1 = (temp-1)/256   ;
                    }
                register_id = pcl_id  ;      // the PC register ID
                ModifyReg()   ;      // modify the PC (jump to PC)
                GetRegister();            // read the EP's register
               }                               
         }
        else
          {
            C6xGetRegister();
            c6x_watchdog_disable() ;
            temp = (save_reg[1] * 256 + save_reg[0]) *2 -1 ;
            set_break_emu() ;
            if((emu_add[temp] & 0x8) == 0x00)
               {                //this break is exebp, so pc = pc-1
                temp = save_reg[1] * 256 + save_reg[0]  ;
                reg_value0 = temp-1   ;
                reg_value1 = (temp-1)/256   ;
                register_id = pcl_id  ;
                register_c6x_id = 2 * register_id;
                C6xModifyReg();
                C6xGetRegister();
               }
          }

      set_emu_break() ;

      clr_ext_bp();      // clear the Go_till_Bp and Step_range_bp
      resume_bp() ;      // resume the Exebp if the runflag =1
      trigger_condition=trigger_condition_bak; //restore the trigger condition
      set_trigger() ;                              //resume the trigger
      if(spa_flag == 0x1)
       {
         trigger_condition = 0x0 ;
         set_trigger() ;                              //resume the trigger
         trigger_type = 0x0 ;
         set_trigger_type() ;
         if ((end_spa_address == (save_reg[0] + (save_reg[1] & 0x3f) * 256))
          || ((ME_IDENTIFY==0X01)&&(end_spa_address == reset_type * 256 + 0xff)
               && ((save_reg[0] + (save_reg[1] & 0x3f) * 256) == 0x0 )))
           {
            status_low = status_low & 0x8f | 0x60  ;// the status indicate halt
            spa_flag = 0x0 ;
           }
         else
           {
             if(ME_IDENTIFY != 0x01)
                {
                   prepheral_disable();
                   C6X_Resume_Time0();
                   prepheral_enable() ;
                }
             if((control_set_bak & 0x8)== 0x8)
               {
                 if(ME_IDENTIFY == 0x01)
                   {
                      watchdog_enable()  ;
                      spoon_data0=0x01     ;       //the ExeBp code is 0x01
                      spoon_data1=0x0      ;
                      write_spoon()        ;       //write to the spoon buffer
                   }
                 else
                   {
                     c6x_watchdog_enable() ;
                     spoon_data0=0x61     ;       //the ExeBp code is 0x61
                     spoon_data1=0x0      ;
                     write_spoon()        ;       //write to the spoon buffer
                   }
               }
             else
               {
                 if(ME_IDENTIFY == 0x01)
                   {
                      spoon_data0=0x01     ;       //the ExeBp code is 0x01
                      spoon_data1=0x0      ;
                      write_spoon()        ;       //write to the spoon buffer
                   }
                 else
                   {
                     spoon_data0=0x61     ;       //the ExeBp code is 0x61
                     spoon_data1=0x0      ;
                     write_spoon()        ;       //write to the spoon buffer
                   }
               }
             TraceBank = 0x1 ;
             set_trace1()        ;
             sel_ep_trace()       ;       //trace buf to EP
             sel_code_coverage()  ;
             stop_type = user ;      //the ep is stop by user
             temp = (save_reg[0] + save_reg[1] * 256 )*2 +1 ;
             set_cp_access_emu()  ;
             set_break_emu() ;
             emu_add[temp] = emu_add[temp] | 0x8 ;  // clear the breakpoint
             set_emu_break() ;
             set_ep_access_emu()  ;
             HALT_STATUS = 1;
             step_ep()  ;
             for(delay = 0; delay < 0xf;)
               {
                if (check_eprunning() == EpNotrunning)
                   {
                     delay = 0xff ;
                   }
               }
             set_cp_access_emu()  ;
             set_break_emu() ;
             emu_add[temp] = emu_add[temp] & 0xf7 ;  // clear the breakpoint
             set_emu_break() ;
             set_ep_access_emu()  ;
             EPrunningFlag = 0x1  ;       //set the ep running flag
             status_low=status_low & 0x8f | 0x40;//the status indicate running
             stop_type = not_user ;      //the ep is not stop by user
             EX0 = 0 ;
             HALT_STATUS = 1;
             run_ep()   ;
           }
       }
     else
       {
        status_low = status_low & 0x8f | 0x60  ;// the status indicate halt
        EX0 = 1;
       }
}

/*************************************************************************
;******************************************************************************
;*
;*  ep_reset: reset EP
;*
;*
;* description:Reset CPU & change program counter to pPC
;* input:
;*      byte1: type  0: ignor the next address, after reset, the PC is 1ff(512)
;*                                                               PC is 3ff(1k)
;*                                                               PC is 7ff(2k)
;*                   1: the PC shall be jumped to next address
;*      byte2: address low
;*      byte3: address high
;* output: status: Command Execute Ok or target can not step
;****************************************************************************/
unsigned char fw_ep_reset(void)
{
   unsigned char temp ;
   stop_type = user ;      //user stop the EP
   if(EPrunningFlag != 0x0)
     {
      TH1_BAK = TH1 ;
      TL1_BAK = TL1 ;
      spa_flag = 0;
      halt_ep();                           //to halt EP
      read_exe_time_bak = read_exe_time() ;
      set_cp_access_emu() ;
      sel_cp_trace() ;
      start_end_frame_check() ;
     }
   set_ep_access_emu() ;

   set_emu_bank1() ;
   HALT_STATUS = 1 ;
   reset_ep();                           //to reset EP
   set_emu_bank0() ;
   set_cp_access_emu() ;
   sel_cp_trace() ;

   status_low = status_low & 0xfb ;   //status indicate trace off
   trace_on_off = trace_off;
   EPrunningFlag = 0x0;              // the EP running flag is cleared
   if (EP_type<=PIC16CR58A)
        {
         GetRegister();                        // read the EP's register
         }

   else
        {
        C6xGetRegister();
        }


   clr_ext_bp();                // clear the Go_till_Bp and Step_range_bp

   resume_bp() ;    // resume the Exebp if the runflag =1
   trigger_condition = trigger_condition_bak ;  //restore the trigger condition
   set_trigger() ;                              //resume the trigger
   if (EP_type<=PIC16CR58A)
      {
       if (commandStream[1]==0x1)      //check the command : type 0 or 1
         {
          reg_value0 = commandStream[2];  //type =1, jump to the netx address a
          reg_value1 = commandStream[3];  //after the EP reset
         }
       else
          {
           reg_value0 = 0xff   ;               //use the Reset address
           reg_value1 = reset_type   ;
          }
           register_id = pcl_id  ;            // the PC register ID
           ModifyReg()   ;                    // modify the PC (jump to PC)
           GetRegister() ;                    // read the EP's register again
           reg_value0  = 0x0      ;
           register_id = status_id;
           ModifyReg() ;
           GetRegister() ;                // read the EP's register again
           status_low = status_low & 0x8f | 0x60  ;// the status indicate halt
           return CommandExeOk;                    // return , the pc is right
     }

   else
      {
       if (commandStream[1]==0x1)         //check the command : type 0 or 1
          {
           reg_value0 = commandStream[2];
           reg_value1 = commandStream[3];
          }
       else
          {
           reg_value0 = 0x0;
           reg_value1 = 0x0 ;
          }

           register_id = pcl_id  ;
           register_c6x_id = 2 * register_id;
           C6xModifyReg();
           C6xGetRegister();
           if((save_reg[register_id]==reg_value0) &&
               (save_reg[register_id+1]==reg_value1))
               {
                status_low = status_low & 0x8f | 0x60  ;
                return CommandExeOk;
               }
            else
               {
     //           return CommandExeOk;
                 return TargetCanotStep ;
               }
     }

}
/*************************************************************************
;******************************************************************************
;*
;*  ep_start: to run the EP
;*
;*
;* description:go, go till, go run, go from till
;* input:
;*        byte1: RunFlag :0 normal, 1 running ignor exebp and trigger
;*        byte2: type   :0 the follow address is no sense
;*                      :1 the follow address is sense
;*        byte3:start address low
;*        byte4:start address high
;*        byte5: type   :0 the follow address is no sense, free run
;*                      :1 the follow address is sense, go till
;*        byte6:end address low
;*        byte7:end address high
;*
;* output: status: Command Execute Ok or target can not step
;*                  EPsleeping, EPrunning
;****************************************************************************/

unsigned char fw_ep_start(void)
{
   unsigned int temp;
   if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
     {
      return EPsleeping ;
     }
   if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
    {
      return EpRunning    ;            //ep is running, return running flag
    }
    else
    {

      set_cp_access_emu()  ;       //the CP will use the EMU
      go_run_flag = commandStream[1]  ;   //the go_run flag
      resume_bp() ;                 // resume the Exebp if the runflag =1
      if (commandStream[1]==1)      //if the runflag=1, ignor bp and trig
        {
        ignor_bp() ;
        trigger_condition_bak=trigger_condition; //backup the trigger condition
        trigger_condition = 0x0 ;           //trigger off
        set_trigger() ;
        }
      if(commandStream[2]==1)            //check the type
        {                                 // 1 :go from spicified address
         reg_value0 = commandStream[3] ;
         reg_value1 = commandStream[4] ;
         register_id = pcl_id ;        // to pc register ID
         if (EP_type<=PIC16CR58A)
             {
               ModifyReg()   ;                    // modify the PC (jump to PC)
               GetRegister();                        // read the EP's register
             }
        else
             {
              register_c6x_id = 2 * register_id;
              C6xModifyReg();
              C6xGetRegister();
             }
        }

       if(commandStream[5]==1)    //check whether is go till command
        {
         temp=(commandStream[6] + commandStream[7] * 256) *2 +1 +0xc000;
         if ((reset_type==(temp-1-0xc000)/2/256) &&
             ((((temp-1-0xc000)/2) & 0xff) == 0xff))


            {                      //reset address
              temp = 0xc001 ;
            }
         go_till_addrl=temp ;    //the go_till_address
         go_till_addrh=temp/256 ;
         if(get_exebp()!=0x0)               // check whether the address has
                                            // been setted the exebp
            {
             break_type_in = ExebpType    ;  //the break type is exebp
             set_break_type()  ;
             exe_bp_addr0 = temp  ;
             exe_bp_addr1 = temp/256;
             set_exe_bp_addr()  ;         // to set a exebp
             go_till_flag = 1 ;    //set the go till flag
            }
        }



      if(ME_IDENTIFY != 0x01)
       {
         prepheral_disable();
         C6X_Resume_Time0();
         prepheral_enable() ;
       }
       trace_full = not_full ;
       temp = (save_reg[0] + save_reg[1] * 256) * 2 + 1 ;  //get current PC
       if((control_set_bak & 0x8)== 0x8)
         {
           if(ME_IDENTIFY == 0x01)
             {
                watchdog_enable()  ;
                spoon_data0=0x01     ;       //the ExeBp code is 0x01
                spoon_data1=0x0      ;
                write_spoon()        ;       //write to the spoon buffer
             }
           else
             {
               c6x_watchdog_enable() ;
               spoon_data0=0x61     ;       //the ExeBp code is 0x61
               spoon_data1=0x0      ;
               write_spoon()        ;       //write to the spoon buffer
             }
        }
      else
        {
           if(ME_IDENTIFY == 0x01)
             {
                spoon_data0=0x01     ;       //the ExeBp code is 0x01
                spoon_data1=0x0      ;
                write_spoon()        ;       //write to the spoon buffer
             }
           else
             {
               spoon_data0=0x61     ;       //the ExeBp code is 0x61
               spoon_data1=0x0      ;
               write_spoon()        ;       //write to the spoon buffer
             }
        }
     TH1 = 0;
     TL1 = 0;
     TimerCalculate = 0x0 ;
     clear_time_calculate()     ;       //to clear the time calculate counter
     sel_cp_trace()       ;       // the CP access the trace RAM
     trace_framel =0xff  ;       // the start trace frame =0
     trace_frameh =0x0    ;
     load_trace_frame()   ;
     if(TraceBank == 0x1)
       {
         set_trace1()        ;
       }
     else
       {
         set_trace2()        ;
       }

     if(trace_on_off == trace_off)
       {
        sel_cp_trace()    ;
       }
     else
       {
        sel_ep_trace()       ;       //trace buf to EP
       }
     stop_type = user ;
     set_cp_access_emu()  ;       //the CP will use the EMU
     set_break_emu() ;
     if ((emu_add[temp] & 0x8) == 0x00)
         {                    //current PC has breakpoint
            emu_add[temp] = emu_add[temp] | 0x8 ;  // clear the breakpoint
            set_emu_break() ;
            set_ep_access_emu()  ;       //the CP will use the EMU
            HALT_STATUS = 1;
            step_ep();
            for(delay = 0; delay < 0xf;)
            {
              if (check_eprunning() == EpNotrunning)
                {
                  delay = 0xff ;
                }
            }
            set_cp_access_emu()  ;       //the CP will use the EMU
            set_break_emu();
            emu_add[temp] = emu_add[temp] & 0xf7 ;
         }
       set_emu_break() ;
       set_ev1_counter()    ;       // re-write the ev1 counter
       set_ep_access_emu()  ;       //the CP will use the EMU
       stop_type = not_user ;

       EPrunningFlag = 0x1  ;       //set the ep running flag
       HALT_STATUS = 0X01;
       run_ep()             ;       // let the ep run   Jason 10/07/96
       status_low = status_low & 0x8f | 0x40  ;// the status indicate running
       return CommandExeOk  ;       // return
      }
}

/*************************************************************************
;******************************************************************************
;*
;*  ep_halt: halt EP
;*
;*
;* description:halt EP by used
;* input: None
;* output: status: Command Execute Ok or target can not step
;*                 EPsleeping
;****************************************************************************/
unsigned char fw_ep_halt(void)
{  

  if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
    {
     return EPsleeping ;
    }
   if((EPrunningFlag == 0x0) && (spa_flag == 0x0))
    {
      return CommandExeOk ;    //ep is in halt state, return command exe ok
    }
    else
    {
      TH1_BAK = TH1 ;
      TL1_BAK = TL1 ;
      spa_flag = 0;
      stop_type = user ;      //user stop the EP
      halt_ep();                           //to halt EP
      EX0 = 1 ;
      read_exe_time_bak = read_exe_time() ;
      set_cp_access_emu() ;
      sel_cp_trace() ;
      start_end_frame_check() ;
      EPrunningFlag = 0x0;         // the EP running flag is cleared
      if (EP_type<=PIC16CR58A)
         {
          GetRegister();                   // read the EP's register
          watchdog_disable() ;
         }
      else
           {
            C6xGetRegister();
            c6x_watchdog_disable() ;
            prepheral_enable()  ;
           }           
      clr_ext_bp();         // clear the Go_till_Bp and Step_range_bp
      resume_bp() ;         // resume the Exebp if the runflag =1
      trigger_condition=trigger_condition_bak;  //restore the trigger condition
      set_trigger() ;                              //resume the trigger
      status_low = status_low & 0x8f | 0x60  ;// the status indicate halt
      return CommandExeOk;                      // return
    }

}

/*************************************************************************
;******************************************************************************
;*
;*  cpu_select:
;*
;*
;* description:to select the EP type
;* input:
;*       byte1: type
;*              1           PIC16C54    ;
;*              2           PIC16C54A   ;
;*              3           PIC16CR54   ;
;*              4           PIC16C55    ;
;*              5           PIC16C56    ;
;*              6           PIC16C57    ;
;*              7           PIC16CR57A  ;
;*              8           PIC16C58A   ;
;*              9           PIC16CR58A  ;
;*              10          PIC16C61    ;
;*              11          PIC16C620   ;
;*              12          PIC16C621   ;
;*              13          PIC16C622   ;
;*              14          PIC16C62A   ;
;*              15          PIC16C63    ;
;*              16          PIC16C64A   ;
;*              17          PIC16C65A   ;
;*              18          PIC16C71    ;
;*              19          PIC16C73A   ;
;*              20          PIC16C74A   ;
;*              21          PIC16C84    ;
;*              22          PIC16C72    ;
;*         byte2: 0x0
;* output: status: Command Execute Ok, Eprunning, EPsleeping
;****************************************************************************/
unsigned char fw_cpu_select(void)
{
      EP_type = commandStream[1] +1  ;            // the EP type ID
      ep_type_select() ;                       // to set the EP type
     set_emu_bank1() ;
      reset_ep()  ;
     set_emu_bank0() ;

      if (EP_type<=PIC16CR58A)
          {
          reg_value0 = 0x80 ;
          register_id = sfr_id ;
          ModifyReg()   ;
	  reg_value0 = 0xff   ; 	     //use the Reset address
	  reg_value1 = reset_type   ;
	  register_id = pcl_id	;	     // the PC register ID
	  ModifyReg()	;		     // modify the PC (jump to PC)
          }
        else
          {
           reg_value0 = 0x00   ;
           reg_value1 = 0x00   ;
           register_id = pcl_id  ;
           register_c6x_id = 2 * register_id;
           C6xModifyReg();
           C6xGetRegister();
          }
    return CommandExeOk  ;

}

/*************************************************************************
;******************************************************************************
;*
;*  control_get:
;*
;*
;* description:to get the control signal status and the EP clock type
;* input: None
;* output:
         byte1:status: Command Execute Ok, Eprunning, EPsleeping
         byte2: content
               bit0:   0  : disable reset
                       1  : enable reset
               bit1-2: 0  : LP
                       1  : XT
                       2  : HS
                       3  : RS
               bit3:   0  : disable watchdog
                       1  : enable watchdog
               bit4:   0  : disable prepheral
                       1  : enable prepheral
;****************************************************************************/
unsigned char fw_control_get(void)
{
   return control_set_bak  ;  // to return the setting backup
}
/*************************************************************************
;******************************************************************************
;*
;*  control_set:
;*
;*
;* description:to set the control signal status and the EP clock type
;* input:
         byte1:
               bit0:   0  : disable reset
                       1  : enable reset
               bit1-2: 0  : LP
                       1  : XT
                       2  : HS
                       3  : RS
               bit3:   0  : disable watchdog
                       1  : enable watchdog
               bit4:   0  : disable prepheral
                       1  : enable prepheral
;* output: status
;****************************************************************************/
unsigned char fw_control_set(void)
{
 unsigned char temp  ;

 control_set_bak = commandStream[1] | 0x10    ;
 temp = control_set_bak & 0x1          ; //to get the reset control bit
 if (temp==1)
   {
     reset_enable()  ;
   }
 else
   {
     reset_disable() ;
   }
 temp = control_set_bak & 0x8          ; //to get the watchdog control bit
 if (temp==8)
   {
     if(ME_IDENTIFY == 0x01)
        {
          watchdog_enable()  ;
        }
     else
         {
          c6x_watchdog_enable() ;
         }
   }
 else
   {
     if(ME_IDENTIFY == 0x01)
         {
           watchdog_disable() ;
         }
     else
         {
          c6x_watchdog_disable() ;
         }
   }
/*
 if(ME_IDENTIFY != 0x01)
 {
    temp = control_set_bak & 0x10       ; //to get the prepheral control bit
    if (temp==0x10)
      {
        prepheral_enable()  ;
      }
    else
      {
        prepheral_disable() ;
      }
 }
*/
  sel_clk = (control_set_bak & 0x6) * 8      ;     // to get the clock setting
  set_clock()  ;
  control_set_bak = commandStream[1] | 0x10   ;
  return CommandExeOk ;
}

/*************************************************************************
;******************************************************************************
;*
;*  port_out:
;*
;*
;* description:to out port
;* input:
;*      byte1    port ID
;*                  0x0: RA
;*                  0x1: RB
;*                  0x2: RC
;*                  0x3: RD
;*                  0x4: RE
;*      byte2    data
;*      byte3    mask_bit
;*                  1:   mask
;*                  0:   no-mask
;* output:
;*       byte1:status: Command Execute Ok, Eprunning, EPsleeping
;****************************************************************************/
unsigned char fw_port_out(void)
{

  if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
    {
     return EPsleeping ;
    }
   if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
    {
      return EpRunning ;            //the ep is running
    }
    else
    {
      if (EP_type<=PIC16CR58A)
          {
          register_id = commandStream[1] + 0x6; // the port ID to port address
          reg_value0 = commandStream[2]       ;      //the data
          ModifyReg()   ;                    // modify the PC (jump to PC)
          register_id = commandStream[1] + 0xa;   // the TRIS ID ot address ID
          reg_value0 =  commandStream[3]      ;   //the mask bit
          ModifyReg()   ;                    // modify the PC (jump to PC)
          GetRegister();                        // read the EP's register
          register_id = commandStream[1] + 0x6;  // the port ID to port address
          reg_value0 = commandStream[2]       ;      //the data
          if (save_reg[register_id]==reg_value0)     //check 0the port daya
            {
             return CommandExeOk ;
            }
          else
            {
             return TargetCanotStep ;       // return  , the pc is error
            }
          }

        else
          {
           register_id = commandStream[1] + 16  ;
           reg_value0 = commandStream[2]       ;
           register_c6x_id = 2 * register_id;
           C6xModifyReg();
           register_id = commandStream[1] + 37;
           reg_value0 =  commandStream[3]       ;
           register_c6x_id = 2 * register_id;
           C6xModifyReg();
           C6xGetRegister();
           register_id = commandStream[1] + 16;
           reg_value0 = commandStream[2]       ;
           if (save_reg[register_c6x_id]==reg_value0)
           {
           return CommandExeOk ;
           }
           else
           {
            return TargetCanotStep ;
           }
        }

    }
}

/*************************************************************************
;******************************************************************************
;*
;*  port_in:
;*
;*
;* description:to inport
;* input:
;*      byte1    port ID
;*                  0x0: RA
;*                  0x1: RB
;*                  0x2: RC
;*                  0x3: RD
;*                  0x4: RE
;* output:
;*       byte1:status: Command Execute Ok, Eprunning, EPsleeping
;*       byte2: PortValue
;****************************************************************************/
unsigned char fw_port_in(void)
{
    unsigned char temp  ;
  if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
    {
     return EPsleeping ;
    }
   if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
    {
      return EpRunning ;            //the ep is running
    }
    else
    {

      if (EP_type<=PIC16CR58A)
          {
           temp = commandStream[1] + 0x6 ;            //port ID to address
           PortValue = save_reg[temp] ;
           return CommandExeOk ;
         }
      else
          {
           temp = (commandStream[1] + 16) * 2 ;
           PortValue = save_reg[temp] ;
           return CommandExeOk ;
         }

    }
}

/*************************************************************************
;******************************************************************************
;*
;*  verify_set
;*
;*
;* description:to set the verify on/off
;* input:
;*      byte1    verify flag   0: off  1: on
;* output:
;*       byte1:status: Command Execute Ok, Eprunning, EPsleeping
;****************************************************************************/
unsigned char fw_verify_set(void)
{
  if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
    {
     return EPsleeping ;
    }
   if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
    {
      return EpRunning ;            //the ep is running
    }
    else
    {
      if (commandStream[1]==0)
        {
         status_low = status_low & 0x7f;   //the status_low bit7=0, the verify
        }                                  //flag = 0  off
      else
        {
          status_low = status_low | 0x80;  // the status_low bit7=1, the verify
        }                                  // flag = 1 on
          return CommandExeOk ;

    }
}

/*************************************************************************
;******************************************************************************
;*
;*  trig_logic_set
;*
;*
;* description:to set the trigger logic
;* input:
;*      byte1
;*             0x1 EV1
;*             0x2 EV2
;*             0x3 EV3
;*             0x4 EV1 OR EV2
;*             0x5 EV1 OR EV3
;*             0x6 EV2 OR EV3
;*             0x7 EV1 OR EV2 OR EV3
;*             0x8 EV1 THEN EV2
;*             0x9 EV1 THEN EV3
;*             0xA EV2 THEN EV1
;*             0xB EV2 THEN EV3
;*             0xC EV3 THEN EV1
;*             0xD EV3 THEN EV2
;*      byte2
;*             0x0 Trigger_off
;*             0x1 Forward
;*             0x2 Center
;*             0x3 Backward
;* output:
;*       byte1:status: Command Execute Ok, Eprunning, EPsleeping
;****************************************************************************/
unsigned char fw_trig_logic_set(void)
{
  if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
    {
     return EPsleeping ;
    }
   if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
    {
      return EpRunning ;            //the ep is running
    }
    else
    {
      trigger_condition = commandStream[1]   ; //the trigger condition
      trigger_condition_bak=trigger_condition ;//restore the trigger condition
      set_trigger()   ;
      trigger_type = commandStream[2] ;        //the trigger type
      if(trigger_type == 0x2)
        {                    // center
          set_trace1()  ;
          TraceBank = 0x1 ;
        }
      if(trigger_type==0x0)
        {
          status_low = status_low & 0xf7  ;    //the status bit is 0
        }
     else
        {
          status_low = status_low | 0x08  ;    //the status bit is 1
          trigger_type_bak = trigger_type ;
        }
      set_trigger_type()   ;
      return CommandExeOk ;
    }
}

/*************************************************************************
;******************************************************************************
;*
;*  trig_status_set
;*
;*
;* description:to set the trigger logic
;* input:
;*      byte1
;*             0x0 Trigger_off 0x1 trigger on
;* output:
;*       byte1:status: Command Execute Ok, Eprunning, EPsleeping
;****************************************************************************/
unsigned char fw_trig_status_set(void)
{
  if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
    {
     return EPsleeping ;
    }
   if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
    {
      return EpRunning ;            //the ep is running
    }
    else
    {
    trigger_type = commandStream[1] ;        //the trigger type
    if(trigger_type == Trigger_off)
        {
          status_low = status_low & 0xf7  ;    //the status bit is 0
        }
     else
        {
          status_low = status_low | 0x08  ;    //the status bit is 1
          trigger_type = trigger_type_bak ;
        }

      set_trigger_type()   ;
      return CommandExeOk ;
    }
}   

/*************************************************************************
;******************************************************************************
;*
;*  reg_modify
;*
;*
;* description:to modify register
;* input:
;*      byte1~2  reg_id
;*               pc           0
;*               sp0          1
;*               sp1          2
;*               sp2          3
;*               sp3          4
;*               sp4          5
;*               sp5          6
;*               sp6          7
;*               sp7          8
;*               w            9
;*               fsr          10
;*               rtcc         11
;*               status       12
;*               porta        13
;*               portb        14
;*               portc        15
;*               option       16
;*               trisa        17
;*               trisb        18
;*               trisc        19
;*               gprf         50
;*      byte3~4  data
;* output:
;* case1:
;*     byte1:status: Eprunning, target can not step, epsleeping,command exe ok
;****************************************************************************/
unsigned char fw_reg_modify(void)
{
   unsigned int input_reg_id ;
  if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
    {
     return EPsleeping ;
    }
   if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
    {
      return EpRunning ;            //the ep is running
    }
    else
    {
      if (EP_type<=PIC16CR58A)
          {
           input_reg_id = commandStream[1]+commandStream[2] * 256 ;
                                                         //the input register ID

           if(input_reg_id == 0x0)
             {                                    //pc
              register_id = 0x0  ;      //the register ID
             }
           if(input_reg_id == 0x1)
               {                                         //sp0
                register_id = 0xd ;      //the register ID
                }
           if(input_reg_id == 0x2)
               {                                         //sp1
                register_id = 0xf ;      //the register ID
                }
           if((input_reg_id >= 9) && ( input_reg_id <= 19))
               {                                         //w ~ trisc
                register_id = input_reg_id - 7 ;      //the register ID
                }
           if(input_reg_id >= 50)
               {                                         //gprf
               register_id = input_reg_id - 33 ;      //the register ID
               }
            reg_value0 = commandStream[3]  ;       //data
            reg_value1 = commandStream[4]  ;
            ModifyReg()   ;                    // modify the PC (jump to PC)
            GetRegister();                        // read the EP's register
            return CommandExeOk ;
          }
      else
          {
           register_id = commandStream[1]+commandStream[2] * 256 ;
           reg_value0 = commandStream[3]  ;
           reg_value1 = commandStream[4]  ;
           register_c6x_id = 2 * register_id;
           C6xModifyReg();
           C6xGetRegister();
           return CommandExeOk ;                                               //
          }                                                                         //
    }
}

/*************************************************************************
;******************************************************************************
;*
;*  bp_set
;*
;*
;* description:to set exebp
;* input:
;*      byte1~3 type, address low, address high
;* output:
;*       byte1:status: Eprunning, target can not step, epsleeping,
;*             command exe ok,NotSelectExeBp
;****************************************************************************/
unsigned char fw_bp_set(void)
{
   unsigned int temp;
  if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
    {
     return EPsleeping ;
    }
   if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
    {
      return EpRunning ;            //the ep is running
    }
    else
    {
     set_cp_access_emu() ;        //cp access emu
     temp = (commandStream[2] + commandStream[3] * 256) * 2+1 + 0xc000;
     if (ME_IDENTIFY  == 0x1)
        {
        if ((reset_type == (temp-1-0xc000)/2 /256) &&
                           ((((temp-1-0xc000)/2) & 0xff) == 0xff))

           {                      //reset address
            temp = 0xc001 ;
           }
        }
     exe_bp_addr0 = temp ;   //get the address low
     exe_bp_addr1 = temp/256;   //get the address high
     break_type_in = ExebpType  ;        //breaktype is exebp
     set_break_type();                   //set the break type is exebp
     set_exe_bp_addr() ;                 //set the exebp
     set_ep_access_emu() ;               //ep access emu
     return CommandExeOk ;
    }
}

/*************************************************************************
;******************************************************************************
;*
;*  bp_clr
;*
;*
;* description:to clr exebp
;* input:
;*      byte1~3 type, address low, address high
;*      if type = 0, clear all
;* output:
;*       byte1:status: Eprunning, target can not step, epsleeping,
;*                     command exe ok, NotSelectExeBp
;****************************************************************************/
unsigned char fw_bp_clr(void)
{
   unsigned int temp  ;
  if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
    {
     return EPsleeping ;
    }
   if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
    {
      return EpRunning ;            //the ep is running
    }
    else
    {

     temp =(commandStream[2] + commandStream[3]*256)*2+1 + 0xc000;
     if ((reset_type == (temp-1-0xc000)/2 /256) &&
                        ((((temp-1-0xc000)/2) & 0xff) == 0xff))

        {                      //reset address
          temp = 0xc001 ;
        }
     set_cp_access_emu() ;               //cp access emu
     exe_bp_addr0 = temp ;   //get the address low
     exe_bp_addr1 = temp/256;   //get the address high
     break_type_in = ExebpType  ;        //breaktype is exebp
     set_break_type();                   //set the break type is exebp
     if (commandStream[1] == 0x0)
       {
         clear_exebp_addr0 = 0x0 ;
         clear_exebp_addr1 = 0x1fff ;
         clr_exebp()  ;
       }
     else
       {
          clr_exe_bp_addr() ;                 //clr the exebp
       }
     set_ep_access_emu() ;               //ep access emu
     return CommandExeOk ;
    }
}

/*************************************************************************
;******************************************************************************
;*
;*  get_bp
;*
;*
;* description:to get the exebp address
;* input:
;*      byte1~3 type, start address low, start address high
;*      byte4~6 type, end address low, end address high
;* output:
;* case1
;*       byte1:status: Eprunning, target can not step, epsleeping,
;*                     BpNotFound.,NotSelectExeBp
;* case2
;*       byte1:status: Bpfound
;*       byte2~4: bp address (type, low, high)
;****************************************************************************/
unsigned char fw_get_bp(void)
{

     unsigned int i ;
     unsigned int j ;
     unsigned int t ;
     set_cp_access_emu() ;               //cp access emu
     i = (commandStream[3] * 256 + commandStream[2])*2+1   ; //start address
     j = (commandStream[6] * 256 + commandStream[5])*2+1   ; //end address
     set_break_emu() ;
     for(t=i;t<=j;t=t+2)
      {
       if((emu_add[t] & 0x08) == 0x00)
         {
          find_bp_low = t/2 ;        //ExeBp find
          find_bp_high =t/256/2 ;
          set_ep_access_emu() ;
          set_emu_break() ;
          return BpFound  ;
         }
      }
     set_emu_break() ;
     set_ep_access_emu() ;
     return BpNotFound  ;
}

/*************************************************************************
;******************************************************************************
;*
;*  step_one:
;*
;*
;* description:step the ep
;* input: None
;*
;* output: status: Command Execute Ok or target can not step
;*                  EPsleeping, EPrunning
;****************************************************************************/
unsigned char fw_step_one(void)
{
   unsigned int temp ;
  if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
    {
     return EPsleeping ;
    }
   if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
    {
      return EpRunning    ;            //ep is running, return running flag
    }
    else
    {
       stop_type = user ;  //the ep is stoped by used , do not server interrupt
       temp = (save_reg[0] + save_reg[1] * 256) * 2 + 1 ;  //get current PC
       set_cp_access_emu()  ;       //the CP will use the EMU
       set_break_emu() ;
       if(ME_IDENTIFY != 0x01)
           {
              prepheral_disable();
              C6X_Resume_Time0();
              prepheral_enable() ;
           }
       if ((emu_add[temp] & 0x8) == 0x00)
           {                    //current PC has breakpoint
              emu_add[temp] = emu_add[temp] | 0x8 ;  // clear the breakpoint
              set_emu_break() ;
              set_ep_access_emu()  ;       //the CP will use the EMU

              HALT_STATUS = 1;
              step_ep();
              for(delay = 0; delay < 0xf;)
                {
                 if (check_eprunning() == EpNotrunning)
                   {
                     delay = 0xff ;
                   }
                }
              set_cp_access_emu()  ;       //the CP will use the EMU
              set_break_emu() ;
              emu_add[temp] = emu_add[temp] & 0xf7 ;
              set_ep_access_emu()  ;       //the CP will use the EMU
              set_emu_break() ;
           }
      else
          {
          set_emu_break() ;
          set_ep_access_emu()  ;       //the CP will use the EMU
          HALT_STATUS = 1;
          step_ep()            ;       // let the ep step
          for(delay = 0; delay < 0xf;)
              {
               if (check_eprunning() == EpNotrunning)
                 {
                   delay = 0xff ;
                 }
              }
          }
       if (EP_type<=PIC16CR58A)
            {
             GetRegister();                        // read the EP's register
             watchdog_disable() ;
             }

       else
            {
            C6xGetRegister();
            c6x_watchdog_disable() ;
            }


       return CommandExeOk  ;       // return
    }
}

/*************************************************************************
;******************************************************************************
;*
;*  step_over
;*
;*
;* description:instruction step one assemble command. (not go into sub rouyine)
;* input: None
;*
;* output: status: Command Execute Ok or target can not step
;*                  EPsleeping, EPrunning
;****************************************************************************/
unsigned char fw_step_over(void)
{
   unsigned int temp ;
   unsigned char breakpoint_flag;
   breakpoint_flag = 0 ;
  if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
    {
     return EPsleeping ;
    }
   if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
    {
      return EpRunning    ;            //ep is running, return running flag
    }
    else
    {
      resume_bp() ;                 // resume the Exebp if the runflag =1
      set_cp_access_emu()  ;   //the cp will access the emu for setting ext-bp

      temp = (save_reg[1] * 256 + save_reg[0] + 1 ) * 2 + 1 + 0xc000;

                                                            //the next address,

      if ((reset_type== (temp-1-0xc000)/2 /256) &&
                         ((((temp-1-0xc000)/2) & 0xff)==0xff))

         {                      //reset address
           temp = 0xc001 ;
         }
     if(ME_IDENTIFY != 0x01)
         {
             prepheral_disable();
             C6X_Resume_Time0();
             prepheral_enable() ;
         }

      if((((emu_add[((temp-1-0xc000)/2)*2-1] & 0xf) != PIC16C5X_CALL) &&
          ( ME_IDENTIFY  ==0x1)) ||
          (((emu_add[((temp-1-0xc000)/2)*2-1] & 0x38) != PIC16C6X_CALL) &&
          ( ME_IDENTIFY  !=0x1)))
        {                  // current instruction is not call instruction,
                           // to use "step into" to do

             stop_type = user ;      //  the ep is stoped by used ,
                                     //  do not server interrupt
             temp = (save_reg[0] + save_reg[1] * 256) * 2 + 1; //get current PC
             set_break_emu() ;
             if ((emu_add[temp] & 0x8) == 0x00)
                  {                    //current PC has breakpoint
                   emu_add[temp] = emu_add[temp] | 0x8; // clear the breakpoint
                   breakpoint_flag = 0x1 ;
                  }
             set_emu_break() ;
             set_ep_access_emu()  ;       //the CP will use the EMU
             HALT_STATUS = 1;
             step_ep()            ;       // let the ep step
             for(delay = 0; delay < 0xf;)
              {
                if (check_eprunning() == EpNotrunning)
                  {
                    delay = 0xff ;
                  }
              }
              set_cp_access_emu()  ;       //the CP will use the EMU
              if(breakpoint_flag == 0x1)
                 {
                   breakpoint_flag = 0 ;
                   set_break_emu() ;
                   emu_add[temp] = emu_add[temp] & 0xf7 ;  //set the breakpoint
                   set_emu_break() ;
                 }
              if (EP_type<=PIC16CR58A)
                   {
                    GetRegister();                        // read the EP's register
                    watchdog_disable() ;
                    }

              else
                   {
                   C6xGetRegister();
                   c6x_watchdog_disable() ;
                   }
             return CommandExeOk  ;       // return
           }

      else
        {            // current instruction is call instruction,
                     // to use set breakpoint and go
          if((control_set_bak & 0x8)== 0x8)
            {
              if(ME_IDENTIFY == 0x01)
                {
                   watchdog_enable()  ;
                   spoon_data0=0x01     ;       //the ExeBp code is 0x01
                   spoon_data1=0x0      ;
                   write_spoon()        ;       //write to the spoon buffer
                }
              else
                {
                  c6x_watchdog_enable() ;
                  prepheral_enable() ;
                  spoon_data0=0x61     ;       //the ExeBp code is 0x61
                  spoon_data1=0x0      ;
                  write_spoon()        ;       //write to the spoon buffer
                }
            }
          else
            {
              if(ME_IDENTIFY == 0x01)
                {
                   spoon_data0=0x01     ;       //the ExeBp code is 0x01
                   spoon_data1=0x0      ;
                   write_spoon()        ;       //write to the spoon buffer
                }
              else
                {
                  prepheral_disable();
                  C6X_Resume_Time0();
                  prepheral_enable() ;
                  spoon_data0=0x61     ;       //the ExeBp code is 0x61
                  spoon_data1=0x0      ;
                  write_spoon()        ;       //write to the spoon buffer
                }
            }
         TH1 = 0;
         TL1 = 0;
         TimerCalculate = 0x0 ;
         clear_time_calculate()     ;    //to clear the time calculate counter
         trace_full = not_full ;
         sel_cp_trace()       ;       // the CP access the trace RAM
         trace_framel =0xff   ;       // the start trace frame =0
         trace_frameh =0x0    ;
         load_trace_frame()   ;
         if(TraceBank == 0x1)
            {
              set_trace1()        ;
            }
         else
            {
              set_trace2()        ;
            }
         if(trace_on_off == trace_off)
           {
            sel_cp_trace()    ;
           }
         else
           {
            sel_ep_trace()       ;       //trace buf to EP
           }
       set_break_emu() ;
         if((emu_add[((temp-1-0xc000)/2)*2+1] & 0x8) !=0x00)
           {                       //the destination address has no exebp set
            break_type_in = ExebpType ;
            set_break_type()  ;        //set ext exebp type
            exe_bp_addr0 = temp  ;
            exe_bp_addr1 = temp/256 ;
            set_exe_bp_addr() ;        //set ext exebp
            go_till_addrl = temp ;
            go_till_addrh = temp/256 ;
            go_till_flag =1      ;       // set the go till flag
           }
         EPrunningFlag = 0x1  ;       //set the ep running flag
         temp = (save_reg[0] + save_reg[1] * 256) * 2 + 1 ;  //get current PC
         set_cp_access_emu()  ;       //the CP will use the EMU
         set_break_emu() ;
         if ((emu_add[temp] & 0x8) == 0x00)
           {                    //current PC has breakpoint
              emu_add[temp] = emu_add[temp] | 0x8 ;  // clear the breakpoint
              set_emu_break() ;
              set_ep_access_emu()  ;       //the CP will use the EMU
              stop_type = user ;
              HALT_STATUS = 1;
              step_ep();
              for(delay = 0; delay < 0xf;)
                {
                  if (check_eprunning() == EpNotrunning)
                    {
                      delay = 0xff ;
                    }
                }
              set_cp_access_emu()  ;       //the CP will use the EMU
              set_break_emu() ;
              emu_add[temp] = emu_add[temp] & 0xf7 ;
           }


         set_emu_break() ;
         set_ev1_counter()    ;       // re-write the ev1 counter
         set_ep_access_emu()  ;       //the CP will use the EMU
         stop_type = not_user ;
         HALT_STATUS = 1 ;
         run_ep()             ;       // let the ep run
         return CommandExeOk  ;       // return
       }
    }
}


/*************************************************************************
;******************************************************************************
;*
;*  ep_support_get
;*
;*
;* description:to send the ep support cpu type
;* input: None
;*
;* output:
;*       byte0: status: Command Execute
;*       byte1: Ep_num
;*       byte2~n: ep type (use the id, 1 id use two bytes)
;****************************************************************************/
void fw_ep_support_get(void)
{
  if( ME_IDENTIFY == 0x01)
    {
      ep_support[0] = 0xa ;
      ep_support[1] = PIC16C54 ;
      ep_support[2] = 0X0;
      ep_support[3] = PIC16C54A ;
      ep_support[4] = 0X0;
      ep_support[5] = PIC16CR54 ;
      ep_support[6] = 0X0;
      ep_support[7] = PIC16C55 ;
      ep_support[8] = 0X0;
      ep_support[9] = PIC16C56 ;
      ep_support[10] = 0X0;
      ep_support[11] = PIC16C57 ;
      ep_support[12] = 0X0;
      ep_support[13] = PIC16CR57A ;
      ep_support[14] = 0X0;
      ep_support[15] = PIC16C58A ;
      ep_support[16] = 0X0;
      ep_support[17] = PIC16CR58A ;
      ep_support[18] = 0X0;
      ep_support[19] = PIC16C54 ;
      ep_support[20] = 0X0;
    }
  if( ME_IDENTIFY == 0x02)
    {
      ep_support[0] = 0x1 ;
      ep_support[1] = PIC16C61 ;
      ep_support[2] = 0X0;
    }
//  if(get_ep_id()== 0x03)
  if( ME_IDENTIFY == 0x03)
    {
      ep_support[0] = 0x3 ;
      ep_support[1] = PIC16C620 ;
      ep_support[2] = 0X0;
      ep_support[3] = PIC16C621 ;
      ep_support[4] = 0X0;
      ep_support[5] = PIC16C622 ;
      ep_support[6] = 0X0;
    }
 // if(get_ep_id()== 0x04)
  if( ME_IDENTIFY == 0x04)
    {
      ep_support[0] = 0x7 ;
      ep_support[1] = PIC16C74A ;
      ep_support[2] = 0X0;
      ep_support[3] = PIC16C73A ;
      ep_support[4] = 0X0;
      ep_support[5] = PIC16C72  ;
      ep_support[6] = 0X0;
      ep_support[7] = PIC16C65A ;
      ep_support[8] = 0X0;
      ep_support[9] = PIC16C64A ;
      ep_support[10] = 0X0;
      ep_support[11] = PIC16C63 ;
      ep_support[12] = 0X0;
      ep_support[13] = PIC16C62A ;
      ep_support[14] = 0X0;
    }
//  if(get_ep_id()== 0x05)
  if( ME_IDENTIFY == 0x05)
    {
      ep_support[0] = 0x1 ;
      ep_support[1] = PIC16C84 ;
      ep_support[2] = 0X0;
    }
//  if(get_ep_id()== 0x06)
  if( ME_IDENTIFY == 0x06)
    {
      ep_support[0] = 0x1 ;
      ep_support[1] = PIC16C71 ;
      ep_support[2] = 0X0;
    }
//  if(get_ep_id()== 0x07)
  if( ME_IDENTIFY == 0x07)
    {
      ep_support[0] = 0x1 ;
      ep_support[1] = PIC16C64A ;
      ep_support[2] = 0X0;
    }
//  if((get_ep_id() >= 0x07) & (get_ep_id() == 0x00))
  if(( ME_IDENTIFY  >= 0x07) & (ME_IDENTIFY  == 0x00))
    {
      ep_support[0] = 0x0 ;
    }
}

/*************************************************************************
;******************************************************************************
;*
;*  event_and_qualiy_set
;*
;*
;* description:to set event and qualify
;* input:
;*      byte1 break type
;*                  0 qualify
;*                  1 ev1
;*                  2 ev2
;*      byte2 address type
;*               0  not used
;*               1  bit wide card
;*               2  range
;*               3  invert range
;*               4  address group
;*      byte3  data type
;*               0  not used
;*               1  bit wide card
;*               2  range
;*      byte4  ev1 counter 0: not set, 1 set
;*      byte5-6 data start
;*      byte7-8 data end
;*      byte9     ev1 count
;*      byte10    address count
;*      byte11-30 address-start,address end: [10] word
;*                 if is bit wide, [0] is the value, [1] is mask, 0 to mask
;*                 if is bit range, [0] is start, [1] is end
;*                 if is bit group, [x] are used
;* output:
;*       byte1:status: Eprunning, target can not step, epsleeping,
;*                     command exe ok,NotSelectExeBp
;****************************************************************************/

unsigned char fw_event_set(void)
{
   unsigned int address_value[10];
   unsigned int data_start;
   unsigned int data_end;
   unsigned int i;
   unsigned int j;
   unsigned int  temp;
   unsigned int temp_address ;

  if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
    {
     return EPsleeping ;
    }
 if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
   {
      return EpRunning ;            //the ep is running
   }
 else
   {
      for(j=11;j<30;j=j+2)
        {                                      //get the address value
          address_value[(j-11)/2]=commandStream[j] + commandStream[j+1] * 256;
        }
    data_start = commandStream[5] + commandStream[6] * 256 ;  //get data value
    data_end = commandStream[7] + commandStream[8] * 256 ;

    if (commandStream[1] == 0x01)
      {
        memcpy(event1_buffer, &commandStream[1], 30) ;
        clear_ev1_addr0 = 0 ;
        clear_ev1_addr1 = 0x1fff ;
        clr_ev1()  ;                // clear the ev1
        EvQfStatus  = EvQfStatus | 0x2  ;
        break_type_in = Ev1Type  ;  // the break type is ev1
        set_break_type() ;
      }
    if (commandStream[1] == 0x02)
      {
        memcpy(event2_buffer, &commandStream[1], 30) ;
        clear_ev2_addr0 = 0 ;
        clear_ev2_addr1 = 0x1fff ;
        clr_ev2()  ;                // clear the ev2
        EvQfStatus  = EvQfStatus | 0x4  ;
        break_type_in = Ev2Type  ;  // the break type is ev2
        set_break_type() ;
      }
    if (commandStream[1] == 0x00)   //change
      {
        memcpy(qualify_buffer, &commandStream[1], 30) ;
        clear_qualify_addr0 = 0 ;
        clear_qualify_addr1 = 0x1fff ;
        clr_qualify()  ;                // clear the qualify
        EvQfStatus  = EvQfStatus | 0x1  ;
        break_type_in = QualifyType  ;  // the break type is qualify
        set_break_type() ;
      }
    if(commandStream[2]==0x1)
     {                             //the address type is bit wide card
       for (i=0;i<=0x1fff;i++)
        {
          if((((address_value[1] & 0x000f) ==0x000f) &&   //low 4 bits
             ((address_value[0] & 0x000f) == (i & 0x000f))) //Actual value
             ||(address_value[1] & 0x000f) == 0x0 )     //wide card
             {
               if((((address_value[1] & 0x00f0)==0x00f0) &&   //middle low 4 bits
                 ((address_value[0] & 0x00f0) == (i & 0x00f0))) //Actual value
                 ||(address_value[1] & 0x00f0) == 0x0 )     //wide card
                 {
                   if((((address_value[1] & 0x0f00) ==0x0f00) &&   //middle high 4 bits
                     ((address_value[0] & 0x0f00) == (i & 0x0f00))) //Actual value
                     ||(address_value[1] & 0x0f00) == 0x0 )     //wide card
                     {
                       if((((address_value[1] & 0xf000) ==0xf000) &&   //high 4 bits
                         ((address_value[0] & 0xf000) == (i & 0xf000))) //Actual value
                         ||(address_value[1] & 0xf000) == 0x0 )     //wide card
                         {
                           if (commandStream[1] == 0x01)
                              {                                 //ev1
                                temp_address =i*2 +1+0xc000 ;  //convert to cp's address
                                ev1_addr0 = temp_address ;
                                ev1_addr1 = temp_address/256 ;
                                set_ev1_addr()  ;           //set the ev1
                              }
                           if (commandStream[1] == 0x02)
                              {                                //ev2
                                temp_address =i*2 +1+0xc000 ;  //convert to cp's address
                                ev2_addr0 = temp_address ;
                                ev2_addr1 = temp_address/256 ;
                                set_ev2_addr()  ;           //set the ev2
                              }
                           if (commandStream[1] == 0x00)    //change
                              {                               //qualify
                                temp_address =i*2 +1+0xc000 ; // convert to cp's address
                                qualify_addr0 = temp_address ;
                                qualify_addr1 = temp_address/256 ;
                                set_qualify_addr()  ;           //set the qualify
                              }
                         }
                     }
                 }
             }
        }
     }
    if(commandStream[2]==0x2)
     {                             //the address type is range
       for(i=address_value[0];i<=address_value[1];i++)
          {
            if (commandStream[1] == 0x01)
               {
                 temp_address =i*2 +1+0xc000 ; // convert to cp's address
                 ev1_addr0 = temp_address ;
                 ev1_addr1 = temp_address/256 ;
                 set_ev1_addr()  ;           //set the ev1
               }
            if (commandStream[1] == 0x02)
               {
                 temp_address =i*2 +1+0xc000 ; // convert to cp's address
                 ev2_addr0 = temp_address ;
                 ev2_addr1 = temp_address/256 ;
                 set_ev2_addr()  ;           //set the ev2
               }
            if (commandStream[1] == 0x00)     //change
               {
                 temp_address =i*2 +1+0xc000 ; // convert to cp's address
                 qualify_addr0 = temp_address ;
                 qualify_addr1 = temp_address/256 ;
                 set_qualify_addr()  ;           //set the qualify
               }
          }
     }
    if(commandStream[2]==0x3)
     {                             //the address type is invert range
       if (commandStream[1] == 0x01)
        {
          for(i=0;i<=0x1fff;i++)
             {
                temp_address =i*2 +1+0xc000 ; // convert to cp's address
                ev1_addr0 = temp_address ;
                ev1_addr1 = temp_address/256 ;
                set_ev1_addr()  ;           //set the ev1
             }
          clear_ev1_addr0 = address_value[0] ;
          clear_ev1_addr1 = address_value[1] ;
          clr_ev1()  ;                // clear the ev1
        }
       if (commandStream[1] == 0x02)
        {
          for(i=0;i<=0x1fff;i++)
             {
                temp_address =i*2 +1+0xc000 ; // convert to cp's address
                ev2_addr0 = temp_address ;
                ev2_addr1 = temp_address/256 ;
                set_ev2_addr()  ;           //set the ev2
             }
          clear_ev2_addr0 = address_value[0] ;
          clear_ev2_addr1 = address_value[1] ;
          clr_ev2()  ;                // clear the ev2
        }
       if (commandStream[1] == 0x00)      //change
        {
          for(i=0;i<=0x1fff;i++)
             {
                temp_address =i*2 +1+0xc000 ; // convert to cp's address
                qualify_addr0 = temp_address ;
                qualify_addr1 = temp_address/256 ;
                set_qualify_addr()  ;           //set the qualify
             }
          clear_qualify_addr0 = address_value[0] ;
          clear_qualify_addr1 = address_value[1] ;
          clr_qualify()  ;                // clear the qualify
        }
     }
    if(commandStream[2]==0x4)
     {                             //the address type is group
       if (commandStream[1] == 0x01)
        {
           for(i=0;i<commandStream[10];i++)
            {                                    //in the address count
              ev1_addr0 = address_value[i]*2 +1 +0xc000;
              ev1_addr1 = (address_value[i]*2 +1 +0xc000)/256 ;
              set_ev1_addr()  ;                // set the ev1
            }
        }
       if (commandStream[1] == 0x02)
        {
           for(i=0;i<commandStream[10];i++)
            {                                    //in the address count
              ev2_addr0 = address_value[i]*2 +1 +0xc000 ;
              ev2_addr1 = (address_value[i]*2 +1 +0xc000)/256 ;
              set_ev2_addr()  ;                // set the ev2
            }
        }
       if (commandStream[1] == 0x0)           //change
        {
           for(i=0;i<commandStream[10];i++)
            {                                    //in the address count
              qualify_addr0 = address_value[i]*2 +1 +0xc000 ;
              qualify_addr1 = (address_value[i]*2 +1 +0xc000)/256 ;
              set_qualify_addr()  ;                // set the qualify
            }
        }
     }

    if(commandStream[3]==0x2)
     {
       for (i =0; i< 2000; i = i+2)
        if(((emu_add[i] + emu_add[i+1] * 256) >= data_start) &&
          ((emu_add[i] + emu_add[i+1] * 256) <= data_end))
          {
                 if (commandStream[1] == 0x1)
                   {
                     temp_address =i +1+0xc000 ;  //convert to cp's address
                     ev1_addr0 = temp_address ;
                     ev1_addr1 = temp_address/256 ;
                     set_ev1_addr()  ;           //set the ev1
                   }
                 if (commandStream[1] == 0x2)
                   {
                     temp_address =i +1+0xc000 ;  //convert to cp's address
                     ev2_addr0 = temp_address ;
                     ev2_addr1 = temp_address/256 ;
                     set_ev2_addr()  ;           //set the ev2
                   }
                 if (commandStream[1] == 0x0)      //change
                   {
                     temp_address =i +1+0xc000 ;  //convert to cp's address
                     qualify_addr0 = temp_address ;
                     qualify_addr1 = temp_address/256 ;
                     set_qualify_addr()  ;           //set the qualify
                   }
          }
     }

    if(commandStream[3]==0x1)
     {                             //the data type is bit wide card
       for (i=0;i<=0x1fff;i++)
          {
            if((((data_end & 0x000f) ==0x000f) &&   //low 4 bits
               ((data_start & 0x000f) == (emu_add[i] & 0x0f))) //Actual value
               ||(data_end & 0x000f) == 0x0 )     //wide card
               {
                 if((((data_end & 0x00f0) ==0x00f0) &&   //middle low 4 bits
                   ((data_start & 0x00f0) == (emu_add[i] & 0xf0))) //Actual value
                   ||(data_end & 0x00f0) == 0x0 )     //wide card
                   {
                     if((((data_end & 0x0f00) ==0x0f00) &&   //middle high 4 bits
                       (((data_start & 0x0f00)/256) == (emu_add[i+1] & 0x0f))) //Actual value
                       ||(data_end & 0x0f00) == 0x0 )     //wide card
                       {
                         if((((data_end & 0xf000) ==0xf000) &&   //high 4 bits
                           (((data_start & 0xf000)/256) == (emu_add[i+1] & 0xf0))) //Actual value
                           ||(data_end & 0xf000) == 0x0 )     //wide card
                           {
                             if (commandStream[1] == 0x1)
                               {
                                 temp_address =i +1+0xc000 ;  //convert to cp's address
                                 ev1_addr0 = temp_address ;
                                 ev1_addr1 = temp_address/256 ;
                                 set_ev1_addr()  ;           //set the ev1
                               }
                             if (commandStream[1] == 0x2)
                               {
                                 temp_address =i +1+0xc000 ;  //convert to cp's address
                                 ev2_addr0 = temp_address ;
                                 ev2_addr1 = temp_address/256 ;
                                 set_ev2_addr()  ;           //set the ev2
                               }
                             if (commandStream[1] == 0x0)      //change
                               {
                                 temp_address =i +1+0xc000 ;  //convert to cp's address
                                 qualify_addr0 = temp_address ;
                                 qualify_addr1 = temp_address/256 ;
                                 set_qualify_addr()  ;           //set the qualify
                               }
                           }
                       }
                   }
               }
          }
     }

    if (commandStream[1] == 0x00)    //change
      {                              //qualify
         set_break_emu() ;
         for(i =1;i<= 0x1fff;i=i+2)
           if((emu_add[i] & 0x4) == 0x4)
             {
               emu_add[i] = emu_add[i] & 0xfb ;
             }
           else
             {
               emu_add[i] = emu_add[i] | 0x4 ;
             }
         set_emu_break() ;
      }

    if(commandStream[4]==0x1)
      {                            //the ev1 counter is seeting
         ev1_counter = 0xff -commandStream[9] ;
      }
    else
      {
         ev1_counter = 0xfe ;            //only 1 ev1 will break the ep
      }
    return CommandExeOk ;
   }
}
/*************************************************************************
;******************************************************************************
;*
;*  event_and_qualiy_clear
;*
;*
;* description:to clear event and qualify
;* input:
;*      byte1
;*                  0 qualify
;*                  1 ev1
;*                  2 ev2
;*                  3 ev3
;* output:
;*       byte1:status: Eprunning, target can not step, epsleeping,command exe ok,NotSelectExeBp
;****************************************************************************/

unsigned char fw_event_clr(void)
{
  if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
    {
     return EPsleeping ;
    }
 if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
   {
      return EpRunning ;            //the ep is running
   }
 else
   {

    if (commandStream[1] == 0x01)
      {
        EvQfStatus  = EvQfStatus & 0xfd  ;
        clear_ev1_addr0 = 0 ;
        clear_ev1_addr1 = 0x1fff ;
        clr_ev1()  ;                // clear the ev1
      }
    if (commandStream[1] == 0x02)
      {
        EvQfStatus  = EvQfStatus & 0xfb  ;
        clear_ev2_addr0 = 0 ;
        clear_ev2_addr1 = 0x1fff ;
        clr_ev2()  ;                // clear the ev2
      }
    if (commandStream[1] == 0x00)
      {
        EvQfStatus  = EvQfStatus & 0xf7  ;
        clear_qualify_addr0 = 0 ;
        clear_qualify_addr1 = 0x1fff ;
        clr_qualify()  ;                // clear the qualify
      }
    return CommandExeOk ;
   }
}

/*************************************************************************
;******************************************************************************
;*
;*  trace_ini
;*
;*
;* description:to on/off trace buf
;* input:
;*      byte1
;*                  0 off
;*                  1 on
;* output:
;*       byte1:status: command exe ok
;****************************************************************************/

unsigned char fw_trace_ini(void)
{
   if(commandStream[1] == 0x0)
     {
        sel_cp_trace() ;     //the cp access the trace buffer, means trace off
        status_low = status_low & 0xfb ;   //status indicate trace off
        trace_on_off = trace_off;

//      Trace1_end_frame = 0x0 ;
//      Trace2_end_frame = 0x0 ;
//      Trace1_start_frame = 0x0 ;
//      Trace1_start_frame = 0x0 ;
        return CommandExeOk ;
     }
   else
     {
        sel_ep_trace() ;     //the ep access the trace buffer, means trace on
        status_low = status_low | 0x04 ;   //status indicate trace on
        trace_on_off = trace_on;
        return CommandExeOk ;
     }
}


/*************************************************************************
;******************************************************************************
;*
;*  select_trace_bank
;*
;*
;* description:to select the trace bank
;* input:
;*      byte1
;*                  1: trace1
;*                  2: trace2
;* output:
;*       byte1:status: command exe ok, eprunning
;****************************************************************************/

unsigned char fw_trace_bank(void)
{
  if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
    {
       return EpRunning    ;            //ep is running, return running flag
    }
  TraceBank = commandStream[1] ;        //get the trace select
  if(TraceBank == 0x1)
     {
       set_trace1()        ;
       status_high = status_high & 0xfd ;
       return CommandExeOk ;
     }
  if(TraceBank == 0x2)
     {
       set_trace2()   ;
       status_high = status_high | 0x2 ;
       return CommandExeOk ;
     }

}

/*************************************************************************
;******************************************************************************
;*
;*  select_trace_cc
;*
;*
;* description:to select the trace or code-coverage
;* input:
;*      byte1
;*                  1: trace
;*                  2: code coverage
;* output:
;*       byte1:status: command exe ok, eprunning
;****************************************************************************/

unsigned char fw_trace_cc(void)
{
  if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
    {
       return EpRunning    ;            //ep is running, return running flag
    }
  if(commandStream[1] == 0x1)
     {
       sel_cp_trace        ;
       return CommandExeOk ;
     }
  if(commandStream[1] == 0x2)
     {
       sel_code_coverage()   ;
       return CommandExeOk ;
     }

}

/*************************************************************************
;******************************************************************************
;*
;*  trace_read
;*
;*
;* description:to read trace buffer
;* input:
;*      byte1  bank select: 1 trace1, 2 trace2
;*      byte2~3 start frame
;*      byte4~5 end frame
;*      byte6   break type
;*                  0 qualify
;*                  1 ev1
;*                  2 ev2
;*                  3 ev3
;*      byte7 address type
;*               0  all wide card
;*               1  bit wide card
;*               2  range
;*               3  invert range
;*               4  address group
;*      byte8  data type
;*               0  all wide card
;*               1  bit wide card
;*      byte9    ev1 counter 0: not set, 1 set
;*      byte10-11 data start
;*      byte12~13 data end
;*      byte14    ev1 count
;*      byte15    address count
;*      byte16~35  address-start,address end: [1] word
;*                 if is bit wide, [0] is the value, [1] is mask, 0 to mask
;*                 if is bit range, [0] is start, [1] is end
;*                 if is bit group, [x] are used
;* output:
;*       byte1:   status: command exe ok
;*       byte2:  total_frame
;*       byte3:   read_end 0:trace over , 1: normal
;*       byte4~n frame_low, frame_high, address_low, address_high, portb, external port
;****************************************************************************/

unsigned char fw_trace_read(void)
{
  unsigned int i;
  unsigned int j;
  unsigned int temp_address;
  unsigned int trace_start_frame;
  unsigned int trace_end_frame;
  unsigned int address_value[10] ;

  sel_cp_trace()  ;                // the cp will access trace RAM
  status_low = status_low & 0xfb ;   //status indicate trace off
  trace_on_off = trace_off;

  if(commandStream[1] == 0x1)  //select trace1
    {
      set_trace1()  ;
      trace_start_frame = (Trace1_start_frame/2) *2;
      trace_end_frame = (Trace1_end_frame/2) *2;
    }
  if(commandStream[1] == 0x2)  //select trace2
    {
      set_trace2()  ;
      trace_start_frame = (Trace2_start_frame/2)*2;
      trace_end_frame = (Trace2_end_frame/2) *2;
    }
  for(j=16;j<35;j=j+2)
    {                                      //get the address value
      address_value[(j-16)/2]=commandStream[j] + commandStream[j+1] * 256 ;
    }
  op_frame_start = (commandStream[2] + commandStream[3] * 256) *2    //the SW windows show frame
                   + (trace_start_frame) ;
//  op_frame_end = (commandStream[2] + commandStream[3] * 256) *2    //the SW windows show frame   9/27/96 xu
//                   + (trace_end_frame) ;
  op_frame_end = (trace_end_frame) ;     //the SW windows show frame
  trace_frame_number=0 ;
  for(i=op_frame_start;i<op_frame_end;i=i+2)
    {
       if (trace_frame_number >= commandStream[4] + commandStream[5] * 256 )
         {
            break ;
         }
       trace_addrl = i ;
       trace_addrl = trace_addrl -1 ;
       trace_addrh = i/256 ;
       read_trace_value() ;                //read the trace value


       temp_address = (pic_addrl + pic_addrh * 256) & 0x3fff  ;  //the traced pic's address
       if(commandStream[7]==0x1)
          {                             //the address type is bit wide card
              if((((address_value[1] & 0x000f) ==0x000f) &&   //low 4 bits
                 ((address_value[0] & 0x000f) == (temp_address & 0x000f))) //Actual value
                 ||(address_value[1] & 0x000f) == 0x0 )     //wide card
                 {
                   if((((address_value[1] & 0x00f0) ==0x00f0) &&   //middle low 4 bits
                     ((address_value[0] & 0x00f0) == (temp_address & 0x00f0))) //Actual value
                     ||(address_value[1] & 0x00f0) == 0x0 )     //wide card
                     {
                       if((((address_value[1] & 0x0f00) ==0x0f00) &&   //middle high 4 bits
                         ((address_value[0] & 0x0f00) == (temp_address & 0x0f00))) //Actual value
                         ||(address_value[1] & 0x0f00) == 0x0 )     //wide card
                         {
                           if((((address_value[1] & 0xf000) ==0xf000) &&   //high 4 bits
                             ((address_value[0] & 0xf000) == (temp_address & 0xf000))) //Actual value
                             ||(address_value[1] & 0xf000) == 0x0 )     //wide card
                             {              //address fit the filter
                               get_trace_framel[trace_frame_number]= (i -trace_start_frame)/2 ;
                               get_trace_frameh[trace_frame_number]= (i -trace_start_frame)/256/2;
                               get_trace_addrl[trace_frame_number]= pic_addrl;
                               get_trace_addrh[trace_frame_number]= pic_addrh;
                               get_trace_rb[trace_frame_number]= pic_rb;
                               get_trace_port[trace_frame_number]= trace_port;
                               trace_frame_number=trace_frame_number+1 ;
                             }
                         }
                     }
                 }
          }

       if(commandStream[7]==0x2)
         {                             //the address type is range
            if((temp_address>=address_value[0]) ||
               (temp_address<=address_value[1]))
               {
                   get_trace_framel[trace_frame_number]= (i -trace_start_frame)/2;
                   get_trace_frameh[trace_frame_number]= (i -trace_start_frame)/256/2;
                   get_trace_addrl[trace_frame_number]= pic_addrl;
                   get_trace_addrh[trace_frame_number]= pic_addrh;
                   get_trace_rb[trace_frame_number]= pic_rb;
                   get_trace_port[trace_frame_number]= trace_port;
                   trace_frame_number=trace_frame_number+1  ;
               }
         }
       if(commandStream[7]==0x3)
         {                             //the address type is invert range
            if((temp_address<address_value[0]) &&
               (temp_address>address_value[1]))
               {
                   get_trace_framel[trace_frame_number]= (i -trace_start_frame)/2;
                   get_trace_frameh[trace_frame_number]= (i -trace_start_frame)/256/2;
                   get_trace_addrl[trace_frame_number]= pic_addrl;
                   get_trace_addrh[trace_frame_number]= pic_addrh;
                   get_trace_rb[trace_frame_number]= pic_rb;
                   get_trace_port[trace_frame_number]= trace_port;
                   trace_frame_number=trace_frame_number+1 ;
               }
         }
       if(commandStream[7]==0x4)
         {                      //the address type is group
           for(j=0;j<commandStream[15];j++)
             {
               if(temp_address==address_value[j])
                 {
                   get_trace_framel[trace_frame_number]= (i -trace_start_frame)/2;
                   get_trace_frameh[trace_frame_number]= (i -trace_start_frame)/256/2;
                   get_trace_addrl[trace_frame_number]= pic_addrl;
                   get_trace_addrh[trace_frame_number]= pic_addrh;
                   get_trace_rb[trace_frame_number]= pic_rb;
                   get_trace_port[trace_frame_number]= trace_port;
                   trace_frame_number=trace_frame_number+1 ;
                 }
             }
         }
       if(commandStream[7] == 0x0)
         {                                                      //trace list all
              get_trace_framel[trace_frame_number]= (i -trace_start_frame)/2;
              get_trace_frameh[trace_frame_number]= (i -trace_start_frame)/256/2;
              get_trace_addrl[trace_frame_number]= pic_addrl;
              get_trace_addrh[trace_frame_number]= pic_addrh;
              get_trace_rb[trace_frame_number]= pic_rb;
              get_trace_port[trace_frame_number]= trace_port;
              trace_frame_number=trace_frame_number+1 ;
         }
    }
  if(trace_frame_number==0)
    {                             //the trace frame is over
       trace_frame_over = 0x0 ;
    }
  else
    {
       trace_frame_over = 0x1 ;
    }
  if(TraceBank == 0x1)
    {
      set_trace1()        ;
    }
  else
    {
      set_trace2()        ;
    }
  return CommandExeOk ;
}


/*************************************************************************
;******************************************************************************
;*
;*  lastframe_get
;*
;*
;* description:to get the last frame
;* input:
;*      byte1: trace bank 1: trace1, 2 trace2
;* output:
;*       byte1:status: command exe ok
;*       byte2: traceCntLow
;*       byte3: traceCntHigh
;****************************************************************************/
unsigned char fw_lastframe_get(void)
{
  unsigned int temp ;
  if(EPrunningFlag == 0x1)
  {
     traceCntLow = 0xff ;
     traceCntHigh= 0x1f ;
     temp = read_tbank() ;
     if(temp == 0x0)
       {
         Trace1_start_frame = 0 ;
         Trace1_end_frame = 0x4000;
       }
     else
       {
         Trace2_start_frame = 0 ;
         Trace2_end_frame = 0x4000;
       }
     return CommandExeOk ;
  }
  else
  {
  if(commandStream[1] == 0x1)
    {
     if((Trace1_end_frame - Trace1_start_frame)!= 0x0)
       {
         temp = (Trace1_end_frame-Trace1_start_frame) /2 -1 ;
       }
     else
       {
         temp = 0x0 ;
       }
     traceCntLow = temp ;
     traceCntHigh= temp/256 ;
     return CommandExeOk ;
    }
  else
    {
     if((Trace2_end_frame-Trace2_start_frame) != 0x0)
       {
         temp = (Trace2_end_frame-Trace2_start_frame) /2 -1 ;
       }
     else
       {
         temp = 0x0 ;
       }
     traceCntLow = temp ;
     traceCntHigh= temp/256 ;
     return CommandExeOk ;
    }
 }
}


/*************************************************************************
;******************************************************************************
;*
;*  select_ev3
;*
;*
;* description:to select the ev3
;* input:
;*       0       E-TB0
;*       1       E-TB1
;*       2       E-TB2
;*       3       E-TB3
;*       4       E-TB4
;*       5       E-TB5
;*       6       E-TB6
;*       7       E-TB7
;*
;* output:
;*       byte1:status: command exe ok
;****************************************************************************/
unsigned char fw_select_ev3(void)
{
       sel_ev3 = commandStream[1] ;
       ev3_select() ;
       return CommandExeOk ;

}

/*************************************************************************
;******************************************************************************
;*
;*  execution_calculate
;*
;*
;* description:to calculate the exe time base
;* input: none
;*
;* output:
;*       byte1:status time
;****************************************************************************/
float execution_calculate_base(void)
{
   return cycle_base ;
}

/*************************************************************************
;******************************************************************************
;*
;*  execution_calculate
;*
;*
;* description:to calculate the exe time
;* input: none
;*
;* output:
;*       byte1:status time
;****************************************************************************/
float execution_calculate(void)
{
  float temp ;
  unsigned long yy1,yy2 ;
  unsigned int  yy3 ;
  unsigned char  yy4 ;
//if(EPrunningFlag == 0x1)
//  {
//    TH1_BAK = TH1 ;
//    TL1_BAK =TL1 ;
//  }
  temp = 16.777216 ;
  temp = TimerCalculate * temp ;
  temp =  temp * 1000 ;
  temp =  temp * 1000 ;
//  temp =  temp
//              + TH1_BAK * 65536
//               + TL1_BAK * 256
//               + read_exe_time_bak  ;
  yy2 = TH1_BAK * 65536 ;
  yy3 = TL1_BAK * 256 ;
  yy4 = read_exe_time_bak  ;
  yy1 = yy2 + yy3 + yy4 ;
  temp = temp + yy1 ;
  exe_time = clock_rate * temp ;
   return exe_time ;
}


/*************************************************************************
;******************************************************************************
;*
;*  target_clock_calculate
;*
;*
;* description:to calculate the target clock
;* input: none
;*
;* output:
;*       byte1:status time
;****************************************************************************/
unsigned char fw_Mhz_get(void)
{
  if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
    {
     return EPsleeping ;
    }
   if((EPrunningFlag == 0x1) && (spa_flag == 0x0))    // Jason 08/02/1996
    {
      return EpRunning    ;            //ep is running, return running flag
    }
    else
    {
      EX0 = 1;                               // Jason 08/02/1996
      target_clock_get() ;
      for(delay = 0; delay < 0xf;)
       {
         if (check_eprunning() == EpNotrunning)
           {
             delay = 0xff ;
           }
       }
      target_mhz_calculate() ;

      delay_time = 14.7456 / mhz +1 ;
      delay_time_high = delay_time /256;
      delay_time_low = delay_time ;
      set_emu_bank0() ;
      if (EP_type<=PIC16CR58A)            // Jason  08/02/1996
          {                               // Jason  08/02/1996
            GetRegister();                // Jason  08/02/1996
          }                               // Jason  08/02/1996
      else
        {                                 // Jason  08/02/1996             //
          C6xGetRegister();               // Jason  08/02/1996             //
        }                                 // Jason  08/02/1996             //
/////////////////////////////////////////////////////////////////////////////

      reg_value0 = save_add_temp0  ;
      reg_value1 = save_add_temp1  ;
      register_id = pcl_id  ;            // the PC register ID

      if (EP_type<=PIC16CR58A)            // Jason  07/26/1996
          {
            ModifyReg()   ;                    // modify the PC (jump to PC)
          }
      else
          {                                                                //
           register_c6x_id = 2 * register_id;  // Jason  07/12/1996        //
           C6xModifyReg();                     // Jason  07/09/1996        //
           C6xGetRegister();
          }                                                                //
/////////////////////////////////////////////////////////////////////////////

      set_cp_access_emu() ;
      trigger_type = trigger_type_bak ;
      trigger_condition = trigger_condition_bak ;
      set_trigger() ;
      set_trigger_type() ;
      if(TraceBank == 0x1)
        {
          set_trace1()        ;
        }
      else
        {
          set_trace2()        ;
        }
      EX0 = 1;                               // Jason 08/15/1996
     //  EX0 = 0;
      return CommandExeOk ;
    }
}

/*************************************************************************
;******************************************************************************
;*
;*
;* to get the target clock
;* input: None
;* output: float
;****************************************************************************/
void target_clock_get(void)
{
  unsigned int i ;
  set_cp_access_emu() ;
  sel_cp_trace() ;
  EPrunningFlag = 0x0;                      // the EP running flag is cleared
  save_add_temp0 = save_reg[0] ;
  save_add_temp1 = save_reg[1] ;
  reg_value0 = 0x0   ;              //use the Reset address
  reg_value1 = 0x0   ;
  register_id = pcl_id  ;            // the PC register ID
  if (EP_type<=PIC16CR58A)            // Jason  07/26/1996
      {
        ModifyReg()   ;                    // modify the PC (jump to PC)
        GetRegister();                        // read the EP's register
      }

  else
      {                                                                    //
       register_c6x_id = 2 * register_id;              // Jason  07/12/1996//
       C6xModifyReg();                                 // Jason  07/09/1996//
       C6xGetRegister();                               // Jason  07/09/1996//
      }                                                                    //
/////////////////////////////////////////////////////////////////////////////

  set_emu_bank1()  ;
  for (i=0; i<=0x1fff; i++)
    {
      emu_add[i] = 0x0 ;
    }
  set_break_emu() ;
  emu_add[11] = 0xd ;   //ev2
  set_emu_break() ;
  trigger_type = Forward ;
  trigger_condition = 0x2 ;
  set_trigger() ;
  set_trigger_type() ;
  trace_full = not_full ;
  trace_framel =0xff  ;       // the start trace frame =0
  trace_frameh =0x0    ;
  load_trace_frame()   ;

  TL1 = 0x0 ;
  TH1 = 0x0 ;
  TimerCalculate = 0x0 ;
  clear_time_calculate()     ;       //to clear the time calculate counter
  if(TraceBank == 0x1)
     {
         set_trace2()        ;
     }
  else
    {
         set_trace1()        ;
    }
  stop_type = user ;      //the interrupt sub-routine need not server
  set_ep_access_emu()  ;       //the EP will use the EMU
  sel_ep_trace() ;
  run_ep()             ;       // let the ep run
}

float target_clock_calculate(void)      // Jason 08/02/1996
{
  float temp ;
  unsigned long xx1,xx2 ;
  unsigned int  xx3 ;
  unsigned char  xx4 ;
  temp = 16.777216 ;
  temp = TimerCalculate * temp ;
  temp =  temp * 1000 ;
  temp =  temp * 1000 ;
//  temp =  temp
//               + TH1_BAK * 65536
//               + TL1_BAK * 256
//               + read_exe_time_bak  ;
  xx2 = TH1_BAK * 65536 ;
  xx3 = TL1_BAK * 256 ;
  xx4 = read_exe_time_bak  ;
  xx1 = xx2 + xx3 + xx4 ;
  temp = temp + xx1 ;
  exe_time = clock_rate * temp ;
  cycle_base = (exe_time / (0x1fff +5)) * 0x1ff ;
  mhz = ((0x1fff + 5) * 4000) / exe_time ;
  return mhz ;
}

/******************************************************************************/
/******************************************************************************
;*
;*  SpaBreakpointSet
;*
;*
;* description:To set the code coverage breakpoints before code coverage go
;* input: byte1   : run flag 0: normal, 1 Run (ignal event)
;*        byte2   : reserved
;*        byte3,4,5: address start
;*        byte6,7,8: address end
;*        byte9    : breakpoint number
;*        byte10~  : break point address ( 2 byte) * n
;* output: status: Command Execute Ok or target can not step
******************************************************************************/

unsigned char fw_SpaBreakpointSet(void)
 {
  unsigned int i ;
  unsigned int temp;
  if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
    {
     return EPsleeping ;
    }
  if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
    {
      return EpRunning ;            //the ep is running
    }
   set_cp_access_emu() ;                      // cp access the EMU
   break_type_in = ExebpType  ;        //breaktype is exebp
   set_break_type();                   //set the break type is exebp
   clear_exebp_addr0 = 0x0 ;
   clear_exebp_addr1 = 0x1fff ;
   clr_exebp()  ;
   for (i = 1; i <= commandStream[9] ; i ++) {
      temp = (commandStream[8+i*2]+commandStream[9+i*2] * 256) * 2+1;
      exe_bp_addr0 = temp ;   //get the address low
      exe_bp_addr1 = temp/256 + 0xc0 ;   //get the address high
      set_exe_bp_addr() ;                 //set the exebp
      }
    resume_bp() ;                          // resume the Exebp if the runflag =1
    reg_value0 = commandStream[4] ;
    reg_value1 = commandStream[5] ;
    register_id = pcl_id ;        // to pc register ID
    if (EP_type<=PIC16CR58A)
         {
           ModifyReg()   ;
           GetRegister();
         }
    else
         {
          register_c6x_id = 2 * register_id;
          C6xModifyReg();
          C6xGetRegister();
         }
     if(ME_IDENTIFY != 0x01)
       {
         prepheral_disable();
         C6X_Resume_Time0();
         prepheral_enable() ;
       }
     if((control_set_bak & 0x8)== 0x8)
         {
           if(ME_IDENTIFY == 0x01)
             {
                watchdog_enable()  ;
                spoon_data0=0x01     ;       //the ExeBp code is 0x01
                spoon_data1=0x0      ;
                write_spoon()        ;       //write to the spoon buffer
             }
           else
             {
               c6x_watchdog_enable() ;
               spoon_data0=0x61     ;       //the ExeBp code is 0x61
               spoon_data1=0x0      ;
               write_spoon()        ;       //write to the spoon buffer
             }
        }
      else
        {
           if(ME_IDENTIFY == 0x01)
             {
                spoon_data0=0x01     ;       //the ExeBp code is 0x01
                spoon_data1=0x0      ;
                write_spoon()        ;       //write to the spoon buffer
             }
           else
             {
               spoon_data0=0x61     ;       //the ExeBp code is 0x61
               spoon_data1=0x0      ;
               write_spoon()        ;       //write to the spoon buffer
               prepheral_enable() ;         // Jason 10/09/96
             }
        }
     set_ep_access_emu()  ;       //the EP will use the EMU
     TH1 = 0;
     TL1 = 0;
     TimerCalculate = 0x0 ;
     clear_time_calculate()     ;       //to clear the time calculate counter
     trace_full = not_full ;
     trigger_condition = 0x0   ; //the trigger condition : no trigger
     trigger_condition_bak = 0x0   ; //the trigger condition : no trigger
     set_trigger()   ;
     trigger_type = Trigger_off ;        //the trigger type
     set_trigger_type()   ;
     TraceBank = 0x1 ;
     set_trace1()        ;
     clr_code_coverage() ;
     sel_ep_trace()       ;       //trace buf to EP
     sel_code_coverage()  ;
     EPrunningFlag = 0x1  ;       //set the ep running flag
     write_spoon()        ;       //write to the spoon buffer
     trace_full = not_full ;
     stop_type = user ;      //the ep is not stop by user
     temp = (save_reg[0] + save_reg[1] * 256) * 2 + 1 ;  //get current PC
     set_cp_access_emu()  ;       //the CP will use the EMU
     set_break_emu() ;
     if ((emu_add[temp] & 0x8) == 0x0)
           {                    //current PC has breakpoint
              emu_add[temp] = emu_add[temp] | 0x8 ;  // clear the breakpoint
              set_emu_break() ;
              set_ep_access_emu()  ;       //the CP will use the EMU
              stop_type = user ;
              HALT_STATUS = 1;
              step_ep();
              for(delay = 0; delay < 0xf;)
                 {
                   if (check_eprunning() == EpNotrunning)
                      {
                        delay = 0xff ;
                      }
                  }
              set_cp_access_emu()  ;       //the CP will use the EMU
              set_break_emu() ;
              emu_add[temp] = emu_add[temp] & 0xf7 ;
           }
     set_emu_break() ;
     set_ev1_counter()    ;       // re-write the ev1 counter
     set_ep_access_emu()  ;       //the CP will use the EMU
     stop_type = not_user ;
     HALT_STATUS = 1 ;
     run_ep()             ;       // let the ep run
     status_low = status_low & 0x8f | 0x40  ;// the status indicate running
     return CommandExeOk  ;       // return

}

/******************************************************************************/
/******************************************************************************
;*
;*  CoverageGo
;*
;*
;* description:To go the code coverage
;* input:
;*        byte1    : segment number = 4
;*        byte2,3,6,7,10,11,14,15  : address start
;*        byte4,5,8,9,12,13,16,17 : address end
;*        byte18    : run flag
;*        byte21,22 : range from
;*        byte24,25 : range end
;* output: status: Command Execute Ok or target can not step
******************************************************************************/
unsigned char fw_CoverageGo(void)
 {
  unsigned int i ;
  unsigned int temp;
  if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
    {
     return EPsleeping ;
    }
  if((EPrunningFlag == 0x1) && (spa_flag == 0x0))
    {
      return EpRunning ;            //the ep is running
    }
   Coverage_Range_No = commandStream[1];
   Coverage_Range_SAd1 = commandStream[2] + commandStream[3] * 256;
   Coverage_Range_DAd1 = commandStream[4] + commandStream[5] * 256;
   Coverage_Range_SAd2 = commandStream[6] + commandStream[7] * 256;
   Coverage_Range_DAd2 = commandStream[8] + commandStream[9] * 256;
   Coverage_Range_SAd3 = commandStream[10] + commandStream[11] * 256;
   Coverage_Range_DAd3 = commandStream[12] + commandStream[13] * 256;
   Coverage_Range_SAd4 = commandStream[14] + commandStream[15] * 256;
   Coverage_Range_DAd4 = commandStream[16] + commandStream[17] * 256;
   set_cp_access_emu() ;                      // cp access the EMU
   break_type_in = ExebpType  ;        //breaktype is exebp
   set_break_type();                   //set the break type is exebp
   clear_exebp_addr0 = 0x0 ;
   clear_exebp_addr1 = 0x1fff ;
   clr_exebp()  ;
   for (i = 1; i <= commandStream[1] *2  ; i ++)
     {
      temp = (commandStream[i*2]+commandStream[i*2+1] * 256) * 2+1;
      exe_bp_addr0 = temp ;   //get the address low
      exe_bp_addr1 = temp/256 + 0xc0 ;   //get the address high
      set_exe_bp_addr() ;                 //set the exebp
      }
    temp = (commandStream[24] + commandStream[25] * 256) * 2 + 1 ;
    end_spa_address = commandStream[24] + commandStream[25] * 256 ;
    exe_bp_addr0 = temp ;   //get the address low
    exe_bp_addr1 = temp/256 + 0xc0 ;   //get the address high
    set_exe_bp_addr() ;                 //set the exebp
    resume_bp() ;                          // resume the Exebp if the runflag =1
    reg_value0 = commandStream[21] ;
    reg_value1 = commandStream[22] ;
    register_id = pcl_id ;        // to pc register ID

    if (EP_type<=PIC16CR58A)
         {
           ModifyReg()   ;
           GetRegister();
         }
    else
         {
          register_c6x_id = 2 * register_id;
          C6xModifyReg();
          C6xGetRegister();
         }

     if(ME_IDENTIFY != 0x01)
       {
         prepheral_disable();
         C6X_Resume_Time0();
         prepheral_enable() ;
       }
     if((control_set_bak & 0x8)== 0x8)
         {
           if(ME_IDENTIFY == 0x01)
             {
                watchdog_enable()  ;
                spoon_data0=0x01     ;       //the ExeBp code is 0x01
                spoon_data1=0x0      ;
                write_spoon()        ;       //write to the spoon buffer
             }
           else
             {
               c6x_watchdog_enable() ;
               spoon_data0=0x61     ;       //the ExeBp code is 0x61
               spoon_data1=0x0      ;
               write_spoon()        ;       //write to the spoon buffer
             }
        }
     else
        {
           if(ME_IDENTIFY == 0x01)
             {
                spoon_data0=0x01     ;       //the ExeBp code is 0x01
                spoon_data1=0x0      ;
                write_spoon()        ;       //write to the spoon buffer
             }
           else
             {
               spoon_data0=0x61     ;       //the ExeBp code is 0x61
               spoon_data1=0x0      ;
               write_spoon()        ;       //write to the spoon buffer
               prepheral_enable() ;
             }
        }
     set_ep_access_emu()  ;       //the EP will use the EMU
     TH1 = 0;
     TL1 = 0;
     TimerCalculate = 0x0 ;
     clear_time_calculate()     ;       //to clear the time calculate counter
     trace_full = not_full ;
     trigger_condition = 0x0   ; //the trigger condition : no trigger
     trigger_condition_bak = 0x0   ; //the trigger condition : no trigger
     set_trigger()   ;
     trigger_type = Trigger_off ;        //the trigger type
     set_trigger_type()   ;
     TraceBank = 0x1 ;
     set_trace1()        ;
     clr_code_coverage() ;
     sel_ep_trace()       ;       //trace buf to EP
     sel_code_coverage()  ;
     EPrunningFlag = 0x1  ;       //set the ep running flag
     trace_full = not_full ;
     stop_type = user ;      //the ep is not stop by user
     spa_flag  = 0x1      ; // the spa flag
     temp = (save_reg[0] + save_reg[1] * 256) * 2 + 1 ;  //get current PC
     set_cp_access_emu()  ;       //the CP will use the EMU
     set_break_emu() ;
     if ((emu_add[temp] & 0x8) == 0x00)
           {                    //current PC has breakpoint
              emu_add[temp] = emu_add[temp] | 0x8 ;  // clear the breakpoint
              set_emu_break() ;
              set_ep_access_emu()  ;       //the CP will use the EMU
              stop_type = user ;
              HALT_STATUS = 1;
              step_ep();
              for(delay = 0; delay < 0xf;)
                  {
                     if (check_eprunning() == EpNotrunning)
                        {
                           delay = 0xff ;
                        }
                  }
              set_cp_access_emu()  ;       //the CP will use the EMU
              set_break_emu() ;
              emu_add[temp] = emu_add[temp] & 0xf7 ;
           }
     set_emu_break() ;
     set_ev1_counter()    ;       // re-write the ev1 counter
     set_ep_access_emu()  ;       //the CP will use the EMU
     stop_type = not_user ;
     EX0 = 0;
     HALT_STATUS = 1;
     run_ep()             ;       // let the ep run
     status_low = status_low & 0x8f | 0x40  ;// the status indicate running
     return CommandExeOk  ;       // return

}


