/**************************************************************************
**
** $Header:
**
** $Log:
** 
** 
** Initial revision. 1.0
** 
***************************************************************************/
/****************************************************************************
**
**  Name:          test.c
**
**  Description:   This is the diagnostic test program, it includes the
                   test item, current F/W and H/W status
**
**  Status:  PRELIMINARY
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/


#include <reg51.h>
#include <string.h>
#include <stdio.h>
#include <io.h>
#include <test.h>


                        /****************************
                         *                          *
                         *    EXTERNAL code         *
                         *                          *
                         ****************************/
void test_CP_Program_EPROM(void);
void test_CP_Data_SRAM_Addr(void);
void test_CP_Data_SRAM_IC(void);
void test_CP_IO_Buffer(void);
//void test_IO_Buffer(void);
//void test_Exe_Time_Calculate_HW(void);
//void test_Control_CPU_Others(void);
void test_EMU_RAM_Control_Signal(void);
void test_EMU_RAM_Addr_Buffer(void);
void test_EMU_RAM_IC_Low(void);
void test_EMU_RAM_IC_High(void);
void test_Break_RAM_IC(void);
//void test_EMU_Memory_Others(void);
void test_EP_CPU_Work(void);
void test_EP_AD_Bus(void);
//void test_EP_Others(void);
void test_Spoon_Control(void);
void test_Step_Control(void);
void test_Go_Control(void);
//void test_Run_Control_others(void);
void test_Breakpoint_Control(void);
void test_Ev1_Control(void);
void test_Ev1_Counter_Control(void);
void test_Ev2_Control(void);
void test_Trig_Ev1_or_Ev2_Control(void);
void test_Trig_Ev1_then_Ev2_Control(void);
//void test_Break_Others(void);
void test_Trace_Addr_Buffer(void);
void test_Trace_Counter(void);
void test_Trace_RAM(void);
//void test_Trace_Data_Buffer(void);
//void test_Qualify_Control(void);
//void test_Code_coverage_Control(void);
//void test_Trace_Others(void);


void current_CP_Program_EPROM(void);
void current_CP_Data_SRAM_Addr(void);
void current_CP_Data_SRAM_IC(void);
void current_CP_IO_Buffer(void);
//void current_IO_Buffer(void);
//void current_Exe_Time_Calculate_HW(void);
//void current_Control_CPU_Others(void);
void current_EMU_RAM_Control_Signal(void);
void current_EMU_RAM_Addr_Buffer(void);
void current_EMU_RAM_IC_Low(void);
void current_EMU_RAM_IC_High(void);
void current_Break_RAM_IC(void);
//void current_EMU_Memory_Others(void);
void current_EP_CPU_Work(void);
void current_EP_AD_Bus(void);
//void current_EP_Others(void);
void current_Spoon_Control(void);
void current_Step_Control(void);
void current_Go_Control(void);
//void current_Run_Control_others(void);
void current_Breakpoint_Control(void);
void current_Ev1_Control(void);
void current_Ev1_Counter_Control(void);
void current_Ev2_Control(void);
void current_Trig_Ev1_or_Ev2_Control(void);
void current_Trig_Ev1_then_Ev2_Control(void);
//void current_Break_Others(void);
void current_Trace_Addr_Buffer(void);
void current_Trace_Counter(void);
void current_Trace_RAM(void);
//void current_Trace_Data_Buffer(void);
//void current_Qualify_Control(void);
//void current_Code_coverage_Control(void);
//void current_Trace_Others(void);

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

extern unsigned char commandStream[2048];
extern unsigned char TransmitBuf[2048] ;
extern unsigned int TStreamLen;

                        /****************************
                         *                          *
                         *    LOCAL    VARIABLES    *
                         *                          *
                         ****************************/

unsigned char bit_map_percent[201] ;
unsigned char bit_map_belong[201] ;
unsigned char error_code[50] ;
unsigned char error_code_number;
unsigned char current_status;
unsigned char test_item ;
unsigned char bit_map_number ;
unsigned char new_percent ;
                         /***************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/
void fw_diagnostic(void) ;
void current_hw_status(void) ;

                         /***************************
                         *                          *
                         *      program             *
                         *                          *
                         ****************************/

/**********************************************************************
function: to test the control H/W

input:
   test_item : 1 ~ 39 byte
output:
   byte0    : commandExeOk
   byte 1   : current HW status
   word 200 : bit map
   byte 1   : error code number :  m
   byte m   : error code
**********************************************************************/

void fw_diagnostic(void)
{
  unsigned int i ;

/**********************************************************************
   initial
**********************************************************************/
  for (i = 0; i<=200; i++)
      {
       bit_map_percent[i] = 0x0 ;   // clear bit map
       bit_map_belong[i]  = 0x0 ;
      }

  for (i = 0; i<50; i++)
      {
        error_code[i] = 0x0 ;      // clear error code
      }
  error_code_number = 0x0 ;         // no error code
  current_status = 0x0 ;            // the HW is ok, test end

/**********************************************************************
   test program
**********************************************************************/
  for (i=1; i< 40 ; i++)
      {
       if( (commandStream[i] & 0x1) == 0x1 )    // check whether this item need test
         {
            test_item = i ;
            switch (i)
             {

               case CP_Program_EPROM:
                  test_CP_Program_EPROM() ;
                  break ;

               case CP_Data_SRAM_Addr:
                  test_CP_Data_SRAM_Addr() ;
                  break ;

               case CP_Data_SRAM_IC:
                  test_CP_Data_SRAM_IC() ;
                  break ;

               case CP_IO_Buffer:
                  test_CP_IO_Buffer() ;
                  break ;

//             case IO_Buffer:
//                test_IO_Buffer() ;
//                break ;

//             case Exe_Time_Calculate_HW:
//                test_Exe_Time_Calculate_HW() ;
//                break ;

//             case Control_CPU_Others:
//                test_Control_CPU_Others() ;
//                break ;

               case EMU_RAM_Control_Signal:
                  test_EMU_RAM_Control_Signal() ;
                  break ;

               case EMU_RAM_Addr_Buffer:
                  test_EMU_RAM_Addr_Buffer() ;
                  break ;

               case EMU_RAM_IC_Low:
                  test_EMU_RAM_IC_Low() ;
                  break ;

               case EMU_RAM_IC_High:
                  test_EMU_RAM_IC_High() ;
                  break ;

               case Break_RAM_IC:
                  test_Break_RAM_IC() ;
                  break ;

//             case EMU_Memory_Others:
//                test_EMU_Memory_Others() ;
//                break ;

               case EP_CPU_Work:
                  test_EP_CPU_Work() ;
                  break ;

               case EP_AD_Bus:
                  test_EP_AD_Bus() ;
                  break ;

//             case EP_Others:
//                test_EP_Others() ;
//                break ;

               case Spoon_Control:
                  test_Spoon_Control() ;
                  break ;

               case Step_Control:
                  test_Step_Control() ;
                  break ;

               case Go_Control:
                  test_Go_Control() ;
                  break ;

//             case Halt_Control:
//                test_Halt_Control() ;
//                break ;

//             case Reset_Control:
//                test_Reset_Control() ;
//                break ;

//             case Run_Control_others:
//                test_Run_Control_others() ;
//                break ;

               case Breakpoint_Control:
                  test_Breakpoint_Control() ;
                  break ;

               case Ev1_Control:
                  test_Ev1_Control() ;
                  break ;

               case Ev1_Counter_Control:
                  test_Ev1_Counter_Control() ;
                  break ;

               case Ev2_Control:
                  test_Ev2_Control() ;
                  break ;

//             case Trig_Ev1_Control:
//                test_Trig_Ev1_Control() ;
//                break ;

//             case Trig_Ev2_Control:
//                test_Trig_Ev2_Control() ;
//                break ;

               case Trig_Ev1_or_Ev2_Control:
                  test_Trig_Ev1_or_Ev2_Control() ;
                  break ;

               case Trig_Ev1_then_Ev2_Control:
                  test_Trig_Ev1_then_Ev2_Control() ;
                  break ;


//             case Break_Others:
//                test_Break_Others() ;
//                break ;

               case Trace_Addr_Buffer:
                  test_Trace_Addr_Buffer() ;
                  break ;

               case Trace_Counter:
                  test_Trace_Counter() ;
                  break ;

//             case Trace_RAM:
//                test_Trace_RAM() ;
//                break ;

//             case Trace_Data_Buffer:
//                test_Trace_Data_Buffer() ;
//                break ;

//             case Qualify_Control:
//                test_Qualify_Control() ;
//                break ;

//             case Code_coverage_Control:
//                test_Code_coverage_Control() ;
//                break ;

//             case Trace_Others:
//                test_Trace_Others() ;
//                break ;

               defalut:
               break ;

             }
         }

      }

/**********************************************************************
   test resoult
**********************************************************************/
  current_status = error_code[0] ;    // the HW current status
  TransmitBuf[0]=CommandExeOk;
  TransmitBuf[1] = current_status;
  for(i = 0; i<200; i++)
      {                                       // send bit map
        TransmitBuf[i*2+2] = bit_map_percent[i+1] ;
        TransmitBuf[i*2+3] = bit_map_belong[i+1] ;
      }
  TransmitBuf[402] = error_code_number;      // send error code number
  for (i = 0; i< error_code_number; i++)
      {                                     // send error code
        TransmitBuf[403 +i] = error_code[i] ;
      }                                     // send H/W current status
  TStreamLen = 402 + error_code_number + 1;

}

/**********************************************************************
function: indicate current HW status when the error occur

input:
   error_code[0]
output:
   none
**********************************************************************/
void current_hw_status(void)
{
   switch (error_code[0])
      {
               case CP_Program_EPROM:
                  current_CP_Program_EPROM() ;
                  break ;

               case CP_Data_SRAM_Addr:
                  current_CP_Data_SRAM_Addr() ;
                  break ;

               case CP_Data_SRAM_IC:
                  current_CP_Data_SRAM_IC() ;
                  break ;

               case CP_IO_Buffer:
                  current_CP_IO_Buffer() ;
                  break ;

//               case IO_Buffer:
//                  current_IO_Buffer() ;
//                  break ;

//               case Exe_Time_Calculate_HW:
//                  current_Exe_Time_Calculate_HW() ;
//                  break ;

//             case Control_CPU_Others:
//                current_Control_CPU_Others() ;
//                break ;

               case EMU_RAM_Control_Signal:
                  current_EMU_RAM_Control_Signal() ;
                  break ;

               case EMU_RAM_Addr_Buffer:
                  current_EMU_RAM_Addr_Buffer() ;
                  break ;

               case EMU_RAM_IC_Low:
                  current_EMU_RAM_IC_Low() ;
                  break ;

               case EMU_RAM_IC_High:
                  current_EMU_RAM_IC_High() ;
                  break ;

               case Break_RAM_IC:
                  current_Break_RAM_IC() ;
                  break ;

//             case EMU_Memory_Others:
//                current_EMU_Memory_Others() ;
//                break ;

               case EP_CPU_Work:
                  current_EP_CPU_Work() ;
                  break ;

               case EP_AD_Bus:
                  current_EP_AD_Bus() ;
                  break ;

//             case EP_Others:
//                current_EP_Others() ;
//                break ;

               case Spoon_Control:
                  current_Spoon_Control() ;
                  break ;

               case Step_Control:
                  current_Step_Control() ;
                  break ;

               case Go_Control:
                  current_Go_Control() ;
                  break ;

//             case Halt_Control:
//                current_Halt_Control() ;
//                break ;

//             case Reset_Control:
//                current_Reset_Control() ;
//                break ;

//             case Run_Control_others:
//                current_Run_Control_others() ;
//                break ;

               case Breakpoint_Control:
                  current_Breakpoint_Control() ;
                  break ;

               case Ev1_Control:
                  current_Ev1_Control() ;
                  break ;

               case Ev1_Counter_Control:
                  current_Ev1_Counter_Control() ;
                  break ;

               case Ev2_Control:
                  current_Ev2_Control() ;
                  break ;

//             case Trig_Ev1_Control:
//                current_Trig_Ev1_Control() ;
//                break ;

//             case Trig_Ev2_Control:
//                current_Trig_Ev2_Control() ;
//                break ;

               case Trig_Ev1_or_Ev2_Control:
                  current_Trig_Ev1_or_Ev2_Control() ;
                  break ;

               case Trig_Ev1_then_Ev2_Control:
                  current_Trig_Ev1_then_Ev2_Control() ;
                  break ;


//             case Break_Others:
//                current_Break_Others() ;
//                break ;

               case Trace_Addr_Buffer:
                  current_Trace_Addr_Buffer() ;
                  break ;

               case Trace_Counter:
                  current_Trace_Counter() ;
                  break ;

               case Trace_RAM:
                  current_Trace_RAM() ;
                  break ;

//             case Trace_Data_Buffer:
//                current_Trace_Data_Buffer() ;
//                break ;

//             case Qualify_Control:
//                current_Qualify_Control() ;
//                break ;

//             case Code_coverage_Control:
//                current_Code_coverage_Control() ;
//                break ;

//             case Trace_Others:
//                current_Trace_Others() ;
//                break ;

               defalut:
               break ;
      }
}
