/**************************************************************************
**
** $Header:
**
** $Log:
** 
** 
** Initial revision. 1.0
***************************************************************************/
/****************************************************************************
**
**  Name:          testsub.c
**
**  Description:   The diagnostic test program sub-routine
**
**  Status:  PRELIMINARY
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/


#include <reg51.h>
#include <string.h>
#include <stdio.h>
#include <io.h>
#include <test.h>


                        /****************************
                         *                          *
                         *    EXTERNAL code         *
                         *                          *
                         ****************************/
extern unsigned char eprom_checksum(void) ;
extern unsigned char read_addr(void) ;
extern void write_addr(void) ;
extern unsigned char backup_addr(void) ;
extern unsigned char sram_ic_program(void);
extern unsigned char read_tbank(void) ;
extern unsigned char check_eprunning(void) ;
extern void set_trace1(void) ;
extern void set_trace2(void) ;
extern unsigned char exe_calculate_buffer(void) ;
extern void set_emu_break(void) ;
extern void set_break_emu(void) ;
extern void set_emu_bank0(void) ;
extern void set_emu_bank1(void) ;
extern void set_ep_access_emu(void) ;
extern void set_cp_access_emu(void) ;
extern void reset_ep(void) ;
extern unsigned char sleep_mode_check(void) ;
extern unsigned int read_spoon(void);
extern void write_spoon(void);
extern void spoon_ep(void);
extern void step_ep(void);
extern void run_ep(void);
extern void halt_ep(void);
extern void resume_bp(void) ;
extern void set_trigger(void) ;
extern void set_trigger_type(void) ;
extern void set_ev1_counter(void)    ;
extern void sel_cp_trace(void)    ;
extern void sel_ep_trace(void)    ;
extern void load_trace_frame(void)    ;
extern void read_trace_frame(void)    ;
extern void read_trace_value(void) ;
extern void C6xModifyReg(void) ;
extern void ModifyReg(void)    ;
extern void GetRegister(void)  ;
extern void C6xGetRegister(void)  ;
                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

extern unsigned int register_id ;
extern unsigned char pic_rb ;
extern unsigned char reg_value0 ;
extern unsigned int register_c6x_id ;
extern unsigned int delay ;
extern unsigned char bit_map_percent[201] ;
extern unsigned char bit_map_belong[201] ;
extern unsigned char error_code[50] ;
extern unsigned char error_code_number;
extern unsigned char current_status;
extern unsigned char test_item ;
extern unsigned char bit_map_number ;
extern unsigned char new_percent ;
extern unsigned char emu_add[16383];
extern unsigned char spoon_data0 ;
extern unsigned char spoon_data1 ;
extern unsigned char EP_type   ;
extern unsigned char trigger_type;
extern unsigned char trigger_condition ;
extern unsigned char ev1_counter;
extern unsigned char stop_type;
extern unsigned char trace_framel;
extern unsigned char trace_frameh;
extern unsigned char end_framel ;
extern unsigned char end_frameh ;
extern unsigned char pic_addrl ;
extern unsigned char pic_addrh ;
extern unsigned char trace_addrl ;
extern unsigned char trace_addrh ;

                        /****************************
                         *                          *
                         *    LOCAL    VARIABLES    *
                         *                          *
                         ****************************/
unsigned char write_addr_low ;
unsigned char write_addr_high ;
unsigned char write_data ;
unsigned char write_data_error ;
unsigned char data_emu_low ;
unsigned char data_emu_high ;
unsigned char data_emu_break ;
unsigned int  addr_emu_low ;
unsigned int  addr_emu_high ;
unsigned int  addr_emu_break ;
unsigned char read_addr_low ;
unsigned char read_addr_high ;
unsigned int  emu_addr_write_error;
unsigned int  emu_addr_read_error;
                         /***************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/
void test_CP_Program_EPROM(void);
void test_CP_Data_SRAM_Addr(void);
void test_CP_Data_SRAM_IC(void);
void test_CP_IO_Buffer(void);
//void test_IO_Buffer(void);
//void test_Exe_Time_Calculate_HW(void);
//void test_Control_CPU_Others(void);
void test_EMU_RAM_Control_Signal(void);
void test_EMU_RAM_Addr_Buffer(void);
void test_EMU_RAM_IC_Low(void);
void test_EMU_RAM_IC_High(void);
void test_Break_RAM_IC(void);
//void test_EMU_Memory_Others(void);
void test_EP_CPU_Work(void);
void test_EP_AD_Bus(void);
//void test_EP_Others(void);
void test_Spoon_Control(void);
void test_Step_Control(void);
void test_Go_Control(void);
//void test_Run_Control_others(void);
void test_Breakpoint_Control(void);
void test_Ev1_Control(void);
void test_Ev1_Counter_Control(void);
void test_Ev2_Control(void);
void test_Trig_Ev1_or_Ev2_Control(void);
void test_Trig_Ev1_then_Ev2_Control(void);
//void test_Break_Others(void);
void test_Trace_Addr_Buffer(void);
void test_Trace_Counter(void);
void test_Trace_RAM(void);
//void test_Trace_Data_Buffer(void);
//void test_Qualify_Control(void);
//void test_Code_coverage_Control(void);
//void test_Trace_Others(void);

void current_CP_Program_EPROM(void);
void current_CP_Data_SRAM_Addr(void);
void current_CP_Data_SRAM_IC(void);
void current_CP_IO_Buffer(void);
//void current_IO_Buffer(void);
//void current_Exe_Time_Calculate_HW(void);
//void current_Control_CPU_Others(void);
void current_EMU_RAM_Control_Signal(void);
void current_EMU_RAM_Addr_Buffer(void);
void current_EMU_RAM_IC_Low(void);
void current_EMU_RAM_IC_High(void);
void current_Break_RAM_IC(void);
//void current_EMU_Memory_Others(void);
void current_EP_CPU_Work(void);
void current_EP_AD_Bus(void);
//void current_EP_Others(void);
void current_Spoon_Control(void);
void current_Step_Control(void);
void current_Go_Control(void);
//void current_Run_Control_others(void);
void current_Breakpoint_Control(void);
void current_Ev1_Control(void);
void current_Ev1_Counter_Control(void);
void current_Ev2_Control(void);
void current_Trig_Ev1_or_Ev2_Control(void);
void current_Trig_Ev1_then_Ev2_Control(void);
//void current_Break_Others(void);
void current_Trace_Addr_Buffer(void);
void current_Trace_Counter(void);
void current_Trace_RAM(void);
//void current_Trace_Data_Buffer(void);
//void current_Qualify_Control(void);
//void current_Code_coverage_Control(void);
//void current_Trace_Others(void);

void error_program(void) ;
void bit_map_program(void) ;
void all_break_cleared(void) ;
void ini_all_break(void) ;
void break_error_list(void) ;
void break_end_all(void) ;
                         /***************************
                         *                          *
                         *      program             *
                         *                          *
                         ****************************/


/******************************************************************************
error code 1:
   The test method is:
      A checksum byte was written at the end of EPROM, All the EPROM bytes
      checksum shall be 0x0. But the test program finds that the checksum
      is not 0x0. So the EPROM some bytes may be wrong.
      Please check the EPROM (U38, 27512)
******************************************************************************/
void test_CP_Program_EPROM(void)
{
   if(eprom_checksum() != 0x0)
      {
        error_program() ;
        bit_map_number = cb_u38 ;
        new_percent = per90 ;
        bit_map_program() ;
        bit_map_number = cb_u24 ;
        new_percent = per1 ;
        bit_map_program() ;
      }
}



/******************************************************************************
error code 2:
   The test method is:
      first to write the control CPU data SRAM with 0xaa at the test address,
      then a byte: 0x55 is written at one of the test address of SRAM, these
      test address are :  0x1, 0x2, 0x4, 0x8, 0x10, 0x20, 0x40, 0x80, 0x100,
      0x200, 0x400, 0x800, 0x1000, 0x2000, 0x4000. Such as: first write at
      address 0x1, then read it at address: 0x1, 0x2 ..., compare it and find
      some address may be wrong.
      Please check the SRAM (U24, SRAM, 24257)
******************************************************************************/
void test_CP_Data_SRAM_Addr(void)
{
   unsigned int x, y ,z;
   unsigned char error_find ;
   unsigned char read_temp ;
   unsigned char backup_a[15],t;
   error_find = 0x0 ;
   t= 0 ;
   for (x = 1 ; x <= 0x4000; x= x*2)
     {
       write_addr_low = x ;
       write_addr_high = x/256 ;
       backup_a[t] = backup_addr() ;
       t = t+1 ;
       write_data = 0xaa ;
       write_addr() ;
     }

   for (x = 1 ; x <= 0x4000; x= x*2)
     {
       write_addr_low = x ;
       write_addr_high = x/256 ;
       write_data = 0x55 ;
       write_addr() ;
       for (y = 1 ; y <= 0x4000; y= y*2)
         {
           read_addr_low = y ;
           read_addr_high = y/256 ;

           read_temp = read_addr() ;

           if ( ( (read_temp == 0x55) && (x != y ) ) ||
                ( (read_temp != 0x55) && (x == y ) ) )
              {
                 error_find = 0x1 ;
                 z = y ;
              }
         }
       write_addr_low = x ;
       write_addr_high = x/256 ;
       write_data = 0xaa ;
       write_addr() ;
     }

   t= 0 ;
   for (x = 1 ; x <= 0x4000; x= x*2)
     {
       write_addr_low = x ;
       write_addr_high = x/256 ;
       write_data = backup_a[t]  ;
       t = t+1 ;
       write_addr() ;
     }

   if(error_find == 0x1)
     {
        read_addr_low = z ;
        read_addr_high = z/256 ;
        error_program() ;
        bit_map_number = cb_u24 ;
        new_percent = per90 ;
        bit_map_program() ;
     }
}

/******************************************************************************
error code 3:
   The test method is:
      first to write the control CPU data SRAM with one of the data :  0x1
      0x2, 0x4, 0x8, 0x10, 0x20, 0x40, 0x80 then read and compare it and
      find some address may be wrong.
      Please check the SRAM (U24, SRAM, 24257)
******************************************************************************/
void test_CP_Data_SRAM_IC(void)
{
   if(sram_ic_program() == 0x1)
     {
        error_program() ;
        bit_map_number = cb_u24 ;
        new_percent = per90 ;
        bit_map_program() ;
     }

}

/******************************************************************************
error code 4:
   The test method is:
      Clear and set some extended I/O and read it, find some error
      Please check CB-U42 pin 16, CB-U30 pin 19 and pin 1, CB-U26, CB-U28
      EB-U19
******************************************************************************/

void test_CP_IO_Buffer(void)
{
      unsigned char x,y ;
      set_trace1() ;
      x = read_tbank() ;
      set_trace2() ;
      y = read_tbank() ;
      if( ( x != 0x0) || ( y != 0x80) )
        {
           error_program() ;
           bit_map_number = cb_u42 ;
           new_percent = per10 ;
           bit_map_program() ;
           bit_map_number = cb_u30 ;
           new_percent = per10 ;
           bit_map_program() ;
           bit_map_number = cb_u26 ;
           new_percent = per5 ;
           bit_map_program() ;
           bit_map_number = cb_u28 ;
           new_percent = per5 ;
           bit_map_program() ;
           bit_map_number = eb_u19 ;
           new_percent = per5 ;
           bit_map_program() ;
        }
}
/******************************************************************************
error code 5:
   The test method is:
      Clear and set the Control CPU P1 port
      Please check CB-U43 P1 port
******************************************************************************/
/*
void test_IO_Buffer(void)
{
   unsigned char x ;
   for (x=1; x<0xff; x++)
   {
     P1 = x ;
     if (x != P1)
     {
        error_program() ;
        bit_map_number = cb_u43 ;
        new_percent = per50 ;
        bit_map_program() ;
     }
   }
}
*/
/******************************************************************************
error code 6:
   The test method is:
      To let the "execution time calculate H/W" free run and get the execution time
      Please check EB-U5 (74LS161), EB-U14 (74LS161), EB-20 (74HCT244),
      CB-U51 (GAL16V8)
******************************************************************************/
/*
void test_Exe_Time_Calculate_HW(void)
{
   if (exe_calculate_buffer() != 0x0)
     {
        error_program() ;
        bit_map_number = cb_u51 ;
        new_percent = per30 ;
        bit_map_program() ;
        bit_map_number = eb_u5 ;
        new_percent = per10 ;
        bit_map_program() ;
        bit_map_number = eb_u14 ;
        new_percent = per10 ;
        bit_map_program() ;
        bit_map_number = eb_u20 ;
        new_percent = per1 ;
        bit_map_program() ;
        bit_map_number = cb_u30 ;
        new_percent = per1 ;
        bit_map_program() ;
     }
}
*/
/******************************************************************************
error code 8:
   The test method is:
      1) fill the Emulation memory with 0x0
      2) change one byte in the emulation memory ( low byte) to 0xff
      3) if the the byte is changed, this means the emulation memory
         read/write is good.
      4) if the byte is 0x0, then change one byte in the emulation memory
         (high byte)
      5) if the the byte is changed, this means the emulation memory
         read/write is good.
      Now the FW find that the two emulation memorys can't be changed
      This may be the control signal(WE/OE/CE) wrong.
      Please check CB-U42 (GAL20V8), CB-U21, CB-U22, CB-U23,CB-U27 (74F257)
      CB-U16, CB-U17 (RAM, 32K 24257), CB-U6, CB-U7 (74HCT245),EB_U28(GAL20V8)
******************************************************************************/
void test_EMU_RAM_Control_Signal(void)
{
   unsigned char temp ;
   unsigned int t;
   set_cp_access_emu() ;
   set_emu_break() ;
   set_emu_bank0() ;
   for(t=0;t<0x3fff;t++)
      {
        emu_add[t] = 0x0 ;
      }
   emu_add[0] = 0xff ;
   emu_add[1] = 0xff ;
   emu_add[0x3ffe] = 0xff ;
   emu_add[0x3fff] = 0xff ;
   if ( (emu_add[0] == 0x0) || (emu_add[1] == 0x0) ||
        (emu_add[0x3ffe] == 0x0) || (emu_add[0x3fff] == 0x0)  )
       {
          error_program() ;
          bit_map_number = cb_u42 ;
          new_percent = per40 ;
          bit_map_program() ;
          bit_map_number = cb_u21 ;
          new_percent = per1 ;
          bit_map_program() ;
          bit_map_number = cb_u22 ;
          new_percent = per1 ;
          bit_map_program() ;
          bit_map_number = cb_u23 ;
          new_percent = per1 ;
          bit_map_program() ;
          bit_map_number = cb_u27 ;
          new_percent = per1 ;
          bit_map_program() ;
          bit_map_number = cb_u16 ;
          new_percent = per5 ;
          bit_map_program() ;
          bit_map_number = cb_u17 ;
          new_percent = per5 ;
          bit_map_program() ;
          bit_map_number = cb_u6;
          new_percent = per1 ;
          bit_map_program() ;
          bit_map_number = cb_u7;
          new_percent = per1 ;
          bit_map_program() ;
          bit_map_number = eb_u28;
          new_percent = per10 ;
          bit_map_program() ;
       }
}

/******************************************************************************
error code 9:
   The test method is:
      first to write the emulation memory SRAM with 0xaa at the test address,
      then a byte: 0x55 is written at one of the test address of SRAM, these
      test address are :  0x1, 0x2, 0x4, 0x8, 0x10, 0x20, 0x40, 0x80, 0x100,
      0x200, 0x400, 0x800, 0x1000, 0x2000.  for example : first write at
      address 0x1, then read it at address: 0x1, 0x2 ..., compare it and find
      some address may be wrong.
      Please check CB-U42 (GAL20V8), CB-U21, CB-U22, CB-U23,CB-U27 (74F257)
      CB-U16, CB-U17 (RAM, 32K 24257), CB-U6, CB-U7 (74HCT245)
******************************************************************************/
void test_EMU_RAM_Addr_Buffer(void)
{
   unsigned int x,y;
   unsigned char error_find;
   error_find = 0x0 ;
   set_cp_access_emu() ;
   set_emu_break() ;
   set_emu_bank0() ;
   for(x=0;x<0x3fff; x++)
      {
        emu_add[x] = 0xaa ;
      }
   for(x=1; x<=0x2000;x=x*2)
      {
        emu_add[x] = 0x55 ;
        for(y=1;y<=0x2000;y=y*2)
          {
            if((emu_add[y] == 0x55) && (x!=y))
              {
                 error_find = 0x1 ;
                 emu_addr_write_error = x ;
                 emu_addr_read_error = y ;
              }
          }
        emu_add[x] = 0xaa ;
      }
    if(error_find == 0x1)
      {
        error_program() ;
        bit_map_number = cb_u42 ;
        new_percent = per1 ;
        bit_map_program() ;
        bit_map_number = cb_u21 ;
        new_percent = per20 ;
        bit_map_program() ;
        bit_map_number = cb_u22 ;
        new_percent = per20 ;
        bit_map_program() ;
        bit_map_number = cb_u23 ;
        new_percent = per20 ;
        bit_map_program() ;
        bit_map_number = cb_u27 ;
        new_percent = per20 ;
        bit_map_program() ;
        bit_map_number = cb_u16 ;
        new_percent = per10 ;
        bit_map_program() ;
        bit_map_number = cb_u17 ;
        new_percent = per10 ;
        bit_map_program() ;
      }
}

/******************************************************************************
error code 10:
   The test method is:
      first to write the emulation memory SRAM low byte with one of the data:
      0x1 0x2, 0x4, 0x8, 0x10, 0x20, 0x40, 0x80 then read and compare it and
      find some bytes may be wrong.
      Please check CB-U16, (RAM, 32K 24257), CB-U6 (74HCT245)
******************************************************************************/
void test_EMU_RAM_IC_Low(void)
{
   unsigned int x,y;
   unsigned char error_find;
   error_find = 0x0 ;
   set_cp_access_emu() ;
   set_emu_break() ;
   set_emu_bank0() ;
   for (x=0; x<0x3fff;x=x+2)
     {
       for(y=1;y<=0x80;y=y*2)
         {
           emu_add[x] = y ;
           if(y != emu_add[x])
             {
               error_find = 0x1 ;
               data_emu_low = y ;
               addr_emu_low = x ;
             }
         }
     }
    if(error_find == 0x1)
      {
        error_program() ;
        bit_map_number = cb_u16 ;
        new_percent = per40 ;
        bit_map_program() ;
        bit_map_number = cb_u6 ;
        new_percent = per10 ;
        bit_map_program() ;
      }

}
/******************************************************************************
error code 11:
   The test method is:
      first to write the emulation memory SRAM high byte with one of the data:
      0x1 0x2, 0x4, 0x8, 0x10, 0x20, 0x40, 0x80 then read and compare it and
      find some bytes may be wrong.
      Please check CB-U17, (RAM, 32K 24257), CB-U7 (74HCT245)
******************************************************************************/
void test_EMU_RAM_IC_High(void)
{
   unsigned int x,y;
   unsigned char error_find;
   error_find = 0x0 ;
   set_cp_access_emu() ;
   set_emu_break() ;
   set_emu_bank0() ;
   for (x=1; x<0x3fff;x=x+2)
     {
       for(y=1;y<=0x80;y=y*2)
         {
           emu_add[x] = y ;
           if(y != emu_add[x])
             {
               error_find = 0x1 ;
               data_emu_high = y ;
               addr_emu_high = x ;
             }
         }
     }
    if(error_find == 0x1)
      {
        error_program() ;
        bit_map_number = cb_u17 ;
        new_percent = per40 ;
        bit_map_program() ;
        bit_map_number = cb_u7 ;
        new_percent = per10 ;
        bit_map_program() ;
      }
}
/******************************************************************************
error code 12:
   The test method is:
      first to write the break memory SRAM high byte with one of the data:
      0x1 0x2, 0x4, 0x8, 0x10, 0x20, 0x40, 0x80 then read and compare it and
      find some bytes may be wrong.
      Please check CB-U39, (RAM, 32K 24257), CB-U40 (74HCT245)
******************************************************************************/
void test_Break_RAM_IC(void)
{
   unsigned int x,y;
   unsigned char error_find;
   error_find = 0x0 ;
   set_cp_access_emu() ;
   set_break_emu() ;
   set_emu_bank0() ;
   for (x=1; x<0x3fff;x=x+2)
     {
       for(y=1;y<=0x80;y=y*2)
         {
           emu_add[x] = y ;
           if(y != emu_add[x])
             {
               error_find = 0x1 ;
               data_emu_break = y ;
               addr_emu_break = x ;
             }
         }
     }
    if(error_find == 0x1)
      {
        error_program() ;
        bit_map_number = cb_u39 ;
        new_percent = per40 ;
        bit_map_program() ;
        bit_map_number = cb_u40 ;
        new_percent = per10 ;
        bit_map_program() ;
      }
}

/******************************************************************************
error code 14:
   The test method is:
      The Emulation CPU' ALE signal is not active.
      Please check EB-U7 (PIC16C01/02), or together with EB-U16, EB-U17
      (PIC16CXX-ME)
******************************************************************************/
void test_EP_CPU_Work(void)
{
   reset_ep() ;
   if(sleep_mode_check() == 0x1)
     {
        error_program() ;
        bit_map_number = eb_u7 ;
        new_percent = per50 ;
        bit_map_program() ;
        bit_map_number = eb_u16 ;
        new_percent = per10 ;
        bit_map_program() ;
        bit_map_number = eb_u17 ;
        new_percent = per10 ;
        bit_map_program() ;
     }
}

/******************************************************************************
error code 15:
   The test method is:
      Use spoon to spoon EP, the spoon code is NOP instruction, so the EP address
      shall be +1, but now find it is wrong.
      Please check EB-U7 (PIC16C01/02), or together with EB-U16, EB-U17
      (PIC16CXX-ME), EB-U6, EB-U15 (74HCT373). CB-U52 (GAL20V8)
      CB-U45, CB-U46 (74HC74).
******************************************************************************/
void test_EP_AD_Bus(void)
{
       unsigned int temp,x,y ;
       unsigned char error_find ;
       reset_ep() ;
       spoon_data0=0x0       ;
       spoon_data1=0x0       ;
       write_spoon() ;
       error_find=0x0       ;
       temp = read_spoon() & 0x3fff    ;
       for(x=0;x<=0xf0;x++)
         {
           spoon_ep() ;
           temp = temp +1 ;
           y = read_spoon() & 0x3fff ;
           if(temp != y)
             {
               error_find = 0x1 ;
             }
         }
       if(error_find == 0x1)
          {
             error_program() ;
             bit_map_number = eb_u7 ;
             new_percent = per50 ;
             bit_map_program() ;
             bit_map_number = eb_u16 ;
             new_percent = per10 ;
             bit_map_program() ;
             bit_map_number = eb_u17 ;
             new_percent = per10 ;
             bit_map_program() ;
             bit_map_number = eb_u6 ;
             new_percent = per10 ;
             bit_map_program() ;
             bit_map_number = eb_u15 ;
             new_percent = per10 ;
             bit_map_program() ;
             bit_map_number = cb_u52 ;
             new_percent = per10 ;
             bit_map_program() ;
             bit_map_number = cb_u45 ;
             new_percent = per1 ;
             bit_map_program() ;
             bit_map_number = cb_u46 ;
             new_percent = per1 ;
             bit_map_program() ;
          }
}

/******************************************************************************
error code 17:
   The test method is:
      Use spoon to spoon EP, the spoon code is GOTO instruction, so the EP address
      shall goto the specified address (from 0x1 to 0xff), but now find it is wrong.
      Please check EB-U11, EB-U9 (spoon buffer 74HCT374). EB-U7 (emulation CPU
      PIC16C01/02),  CB-U52 (GAL20V8), CB-U45, CB-U46 (74HC74).
******************************************************************************/
void test_Spoon_Control(void)
{
   unsigned char x ;
   unsigned char error_find ;
   error_find = 0x0 ;
   if(EP_type <=PIC16CR58A)
     {
        spoon_data1 = 0xa ;    // goto instruction for pic16c01
     }
   else
     {
        spoon_data1 = 0x28 ;   // goto instruction for pic16c02
     }
   for (spoon_data0=1; spoon_data0<0xff ; spoon_data0++)
      {
         write_spoon() ;
         spoon_ep();
         x = read_spoon() ;
         if(x != spoon_data0)
           {
             error_find = 0x1 ;
           }
      }
   if(error_find == 0x1)
          {
             error_program() ;
             bit_map_number = eb_u7 ;
             new_percent = per20 ;
             bit_map_program() ;
             bit_map_number = eb_u11 ;
             new_percent = per20 ;
             bit_map_program() ;
             bit_map_number = eb_u9 ;
             new_percent = per20 ;
             bit_map_program() ;
             bit_map_number = cb_u52 ;
             new_percent = per10 ;
             bit_map_program() ;
             bit_map_number = cb_u45 ;
             new_percent = per1 ;
             bit_map_program() ;
             bit_map_number = cb_u46 ;
             new_percent = per1 ;
             bit_map_program() ;
          }
}

/******************************************************************************
error code 18:
   The test method is:
      First fill the Emulation with 0x0 (NOP instruction), use step command to
      step EP, so the EP address shall +1, but now find it is wrong.
      Please check CB-U2, CB-U3 (74F244). EB-U7 (emulation CPU
      PIC16C01/02),  CB-U52 (GAL20V8), CB-U45, CB-U46 (74HC74).
******************************************************************************/
void test_Step_Control(void)
{
   unsigned int x ;
   unsigned char y, error_find ,z;
   error_find = 0x0 ;
   all_break_cleared();
   set_emu_break() ;
   set_ep_access_emu() ;
   reset_ep() ;
   for (x=0; x<0x20; x++)
     {
       y=read_spoon() ;
       step_ep() ;
       z = read_spoon() ;
       if(z != (y+1) )
         {
           error_find = 0x1 ;
         }
     }
   TR1 = 1 ;
   TR0 = 1 ;
   EX1 = 1 ;
   EX0 = 1 ;
   ET0 = 1 ;
   ET1 = 1 ;
   if (error_find == 0x1)
     {
             error_program() ;
             bit_map_number = eb_u7 ;
             new_percent = per10 ;
             bit_map_program() ;
             bit_map_number = cb_u2 ;
             new_percent = per10 ;
             bit_map_program() ;
             bit_map_number = cb_u3 ;
             new_percent = per10 ;
             bit_map_program() ;
             bit_map_number = cb_u52 ;
             new_percent = per20 ;
             bit_map_program() ;
             bit_map_number = cb_u45 ;
             new_percent = per1 ;
             bit_map_program() ;
             bit_map_number = cb_u46 ;
             new_percent = per1 ;
             bit_map_program() ;
     }
}

/******************************************************************************
error code 19:
   The test method is:
      First fill the Emulation with 0x0 (NOP instruction), use Go command to
      free run EP, so the EP the HALT, HACK signals shall be low, After HALT
      command and Reset command, these two signals shall be high.
      but now find it is wrong.
      Please check CB-U2, CB-U3 (74F244). EB-U7 (emulation CPU
      PIC16C01/02),  CB-U52 (GAL20V8), CB-U45, CB-U46 (74HC74).
******************************************************************************/
void test_Go_Control(void)
{
   unsigned int x ;
   unsigned char y, error_find;
   error_find = 0x0 ;
   all_break_cleared() ;
   set_emu_break() ;
   ev1_counter = 0xfe ;
   trigger_type =  0x0;
   trigger_condition = 0x0 ;
   set_ev1_counter()    ;       // re-write the ev1 counter
   set_trigger_type() ;
   set_trigger() ;
   set_ep_access_emu() ;
   stop_type = user ;      //the ep is  stop by user
   reset_ep() ;
   run_ep() ;
   y = check_eprunning() ;
   if (y != 0x0)
     {
       error_find = 0x1 ;
     }
   halt_ep() ;
   reset_ep() ;
   TR1 = 1 ;
   TR0 = 1 ;
   EX1 = 1 ;
   EX0 = 1 ;
   ET0 = 1 ;
   ET1 = 1 ;
   y = check_eprunning() ;
   if (y != 0x40)
     {
       error_find = 0x1 ;
     }
   if (error_find == 0x1)
     {
             error_program() ;
             bit_map_number = eb_u7 ;
             new_percent = per20 ;
             bit_map_program() ;
             bit_map_number = cb_u2 ;
             new_percent = per10 ;
             bit_map_program() ;
             bit_map_number = eb_u3 ;
             new_percent = per10 ;
             bit_map_program() ;
             bit_map_number = cb_u52 ;
             new_percent = per20 ;
             bit_map_program() ;
             bit_map_number = eb_u47 ;
             new_percent = per1 ;
             bit_map_program() ;
             bit_map_number = eb_u46 ;
             new_percent = per1 ;
             bit_map_program() ;
     }
}



/******************************************************************************
error code 23:
   The test method is:
      First fill the Emulation with 0x0 (NOP instruction),  set a breakpoint
      at 0x55, use Go command to free run EP, so the EP shall be stoped at 0x56
      Please check EB-U7 (emulation CPU PIC16C01/02),  CB-U52, EB-U28 (GAL20V8),
******************************************************************************/
void test_Breakpoint_Control(void)
{
   unsigned int x,z ;
   unsigned char y ;
   all_break_cleared() ;
   emu_add[0xab] = 0x7 ;
   set_emu_break() ;
   ev1_counter = 0xfe ;
   trigger_type =  0x0;
   trigger_condition = 0x0 ;
   set_ev1_counter()    ;       // re-write the ev1 counter
   set_trigger_type() ;
   set_trigger() ;
   set_ep_access_emu() ;
   resume_bp() ;
   if(EP_type <=PIC16CR58A)
     {
       spoon_data0=0x01     ;       //the ExeBp code is 0x01
       spoon_data1=0x0      ;
     }
   else
     {
       spoon_data0=0x61     ;       //the ExeBp code is 0x61
       spoon_data1=0x0      ;
     }
   write_spoon()        ;       //write to the spoon buffer
   reset_ep() ;
   stop_type = user ;      //the ep is  stop by user
   run_ep() ;
   for (x = 0; x<= 0xfff; x++)
     {
     }
   y = check_eprunning() ;
   z = read_spoon() ;
   halt_ep() ;
   reset_ep() ;
   if ((z != 0x56) || (y == 0x0))
     {
             error_program() ;
             bit_map_number = eb_u7 ;
             new_percent = per20 ;
             bit_map_program() ;
             bit_map_number = cb_u52 ;
             new_percent = per20 ;
             bit_map_program() ;
             bit_map_number = eb_u28 ;
             new_percent = per20 ;
             bit_map_program() ;
     }
   break_end_all() ;
}

/******************************************************************************
error code 24:
   The test method is:
      First fill the Emulation with 0x0 (NOP instruction),  set ev1 at address
      0x55, trigger is backward, use Go command to free run EP, so the EP shall
      be stoped at 0x56
      Please check EB-U7 (emulation CPU PIC16C01/02),  CB-U52, EB-U28 (GAL20V8),
      EB-U21, EB-U27 (74LS161)
******************************************************************************/
void test_Ev1_Control(void)
{
   unsigned int x,z ;
   unsigned char y ;
   all_break_cleared() ;
   emu_add[0xab] = 0xe ;
   ev1_counter = 0xfe ;
   trigger_type =  Backward;
   trigger_condition = 0x1 ;
   ini_all_break() ;
   y = check_eprunning() ;
   z = read_spoon() ;
   halt_ep() ;
   reset_ep() ;
   if ((z != 0x56) || (y == 0x0))
     {
        break_error_list() ;
     }
   break_end_all() ;
}

/******************************************************************************
error code 25:
   The test method is:
      First fill the Emulation with 0x0 (NOP instruction),  set ev1 at address
      0x55, ev1 counter is 0x10, trigger is backward, use Go command to free
      run EP, so the EP shall be stoped at 0x56
      Please check EB-U7 (emulation CPU PIC16C01/02),  CB-U52, EB-U28 (GAL20V8),
      EB-U21, EB-U27 (74LS161)
******************************************************************************/
void test_Ev1_Counter_Control(void)
{
   unsigned int x,z ;
   unsigned char y ;
   all_break_cleared() ;
   emu_add[0xab] = 0xe ;
   ev1_counter = 0xff- 0x10 ;
   trigger_type =  Backward;
   trigger_condition = 0x1 ;
   ini_all_break() ;
   y = check_eprunning() ;
   z = read_spoon() ;
   halt_ep() ;
   reset_ep() ;
   if ((z != 0x56) || (y == 0x0))
     {
        break_error_list() ;
     }
   break_end_all() ;
}

/******************************************************************************
error code 26:
   The test method is:
      First fill the Emulation with 0x0 (NOP instruction),  set ev2 at address
      0x55, trigger is backward, use Go command to free run EP, so the EP shall
      be stoped at 0x56
      Please check EB-U7 (emulation CPU PIC16C01/02),  CB-U52, EB-U28 (GAL20V8),
******************************************************************************/
void test_Ev2_Control(void)
{
   unsigned int x,z ;
   unsigned char y ;
   all_break_cleared() ;
   emu_add[0xab] = 0xd ;
   trigger_type =  Backward;
   trigger_condition = 0x2 ;
   ini_all_break() ;
   y = check_eprunning() ;
   z = read_spoon() ;
   halt_ep() ;
   reset_ep() ;
   if ((z != 0x56) || (y == 0x0))
     {
        break_error_list() ;
     }
   break_end_all() ;
}

/******************************************************************************
error code 29:
   The test method is:
      First fill the Emulation with 0x0 (NOP instruction),  set ev1 at address
      0x55, ev2 at address 0xaa, trigger is backward with ev1 or ev2, use Go
      command to free run EP, so the EP shall first be stoped at 0x56, run the
      EP again and the EP shall be stoped at 0xab
      Please check EB-U7 (emulation CPU PIC16C01/02),  CB-U52, EB-U28 (GAL20V8),
      EB-U21, EB-U27 (74LS161)
******************************************************************************/
void test_Trig_Ev1_or_Ev2_Control(void)
{
   unsigned int x,z,m ;
   unsigned char y,n ;
   all_break_cleared() ;
   emu_add[0xab] = 0xe ;
   emu_add[0x155] = 0xd ;
   ev1_counter = 0xfe ;
   trigger_type =  Backward;
   trigger_condition = 0x4 ;
   ini_all_break();
   y = check_eprunning() ;
   z = read_spoon() ;
   set_cp_access_emu();
   ev1_counter = 0xfe ;
   set_ev1_counter()    ;       // re-write the ev1 counter
   set_ep_access_emu();
   run_ep() ;
   for (x = 0; x<= 0xfff; x++)
     {
     }
   n = check_eprunning() ;
   m = read_spoon() ;
   halt_ep() ;
   reset_ep() ;
   if (((z != 0x56) || (y == 0x0)) || ((m != 0xab) || (n == 0x0)))
     {
        break_error_list() ;
     }
   break_end_all() ;
}

/******************************************************************************
error code 30:
   The test method is:
      First fill the Emulation with 0x0 (NOP instruction),  set ev1 at address
      0x55, ev2 at address 0xaa, trigger is backward with ev1 then ev2, use Go
      command to free run EP, so the EP shall be stoped at 0xab
      Please check EB-U7 (emulation CPU PIC16C01/02),  CB-U52, EB-U28 (GAL20V8),
      EB-U21, EB-U27 (74LS161)
******************************************************************************/
void test_Trig_Ev1_then_Ev2_Control(void)
{
   unsigned int x,z,m ;
   unsigned char y,n ;
   all_break_cleared() ;
   emu_add[0xab] = 0xe ;
   emu_add[0x155] = 0xd ;
   ev1_counter = 0xfe ;
   trigger_type =  Backward;
   trigger_condition = 0x8 ;
   ini_all_break();
   y = check_eprunning() ;
   z = read_spoon() ;
   halt_ep() ;
   reset_ep() ;
   if ((z != 0xab) || (y == 0x0))
     {
        break_error_list() ;
     }
   break_end_all() ;
}


/******************************************************************************
error code 33:
   The test method is:
      1) First load the trace address counter low byte with (0x0~0xff)
         read the value and compare it
      2) Then load the trace address counter high byte with (0x0~0xff)
         read the value and compare it
         If only the trace address counter low byte is error, please check
         CB-U5, CB-U18 (74F161), CB-U10, CB-U19 (74F257), CB-U9 (74HCT244)
         If only the trace address counter high byte is error, please check
         CB-U31, CB-U48 (74F161), CB-U32, CB-U50 (74F257), CB-U29 (74HCT244)
         If both  the trace address counter high and low  byte are error,
         please check CB-U49 (GAL20V8), EB-U25 (74HCT374)
******************************************************************************/
void test_Trace_Addr_Buffer(void)
{
     unsigned int x ;
     unsigned char error_find ;
     error_find = 0x0 ;
     sel_cp_trace()       ;       // the CP access the trace RAM
     trace_frameh =0x0    ;
     for(x=2; x<=0xfd; x++)
       {
        trace_framel = x  ;       // the start trace frame =0
        load_trace_frame()   ;
        read_trace_frame();
        if(end_framel !=(x+1))
           {
             error_find = error_find | 0x1 ;
           }
       }
     trace_framel =0x00    ;
     for(x=1; x<=0x1f; x++)
       {
        trace_frameh = x  ;       // the start trace frame =0
        load_trace_frame()   ;
        read_trace_frame();
        if(end_frameh != x)
           {
             error_find = error_find | 0x10 ;
           }
       }
     switch (error_find)
       {
           case  trace_buffer1_error :
             error_program() ;
             bit_map_number = cb_u5 ;
             new_percent = per20 ;
             bit_map_program() ;
             bit_map_number = cb_u18 ;
             new_percent = per20 ;
             bit_map_program() ;
             bit_map_number = cb_u10 ;
             new_percent = per20 ;
             bit_map_program() ;
             bit_map_number = cb_u19 ;
             new_percent = per20 ;
             bit_map_program() ;
             bit_map_number = cb_u9 ;
             new_percent = per20 ;
             bit_map_program() ;
           break ;

           case  trace_buffer2_error :
             error_program() ;
             bit_map_number = cb_u31 ;
             new_percent = per50 ;
             bit_map_program() ;
             bit_map_number = cb_u48 ;
             new_percent = per50 ;
             bit_map_program() ;
             bit_map_number = cb_u29 ;
             new_percent = per20 ;
             bit_map_program() ;
             bit_map_number = cb_u50 ;
             new_percent = per20 ;
             bit_map_program() ;
             bit_map_number = cb_u32 ;
             new_percent = per20 ;
             bit_map_program() ;
           break ;

           case  trace_all_error :
             error_program() ;
             bit_map_number = cb_u49 ;
             new_percent = per30 ;
             bit_map_program() ;
             bit_map_number = eb_u25 ;
             new_percent = per30 ;
             bit_map_program() ;
           break ;

           default :
           break ;
       }
}

/******************************************************************************
error code 34:
   The test method is:
      1) First load the trace address counter with 0x0000
      2) set a breapoint at 0x11.
         The trace counter shall be stoped at 0x25. but now find it wrong
         please check CB-U49 (GAL20V8)
******************************************************************************/
void test_Trace_Counter(void)
{
   unsigned int x,z ;
   unsigned char y ;
   all_break_cleared() ;
   emu_add[0x23] = 0x7 ;
   set_emu_break() ;
   ev1_counter = 0xfe ;
   trigger_type =  0x0;
   trigger_condition = 0x0 ;
   set_ev1_counter()    ;       // re-write the ev1 counter
   set_trigger_type() ;
   set_trigger() ;
   set_ep_access_emu() ;
   resume_bp() ;
   if(EP_type <=PIC16CR58A)
     {
       spoon_data0=0x01     ;       //the ExeBp code is 0x01
       spoon_data1=0x0      ;
     }
   else
     {
       spoon_data0=0x61     ;       //the ExeBp code is 0x61
       spoon_data1=0x0      ;
     }
   write_spoon()        ;       //write to the spoon buffer
   reset_ep() ;
   stop_type = user ;      //the ep is  stop by user
   sel_cp_trace()       ;       // the CP access the trace RAM
   trace_framel =0xff  ;       // the start trace frame =0
   trace_frameh =0x0    ;
   load_trace_frame()   ;
   sel_ep_trace()       ;       //trace buf to EP
   set_trace1()        ;
   run_ep() ;
   for (x = 0; x<= 0xfff; x++)
     {
     }
   sel_cp_trace()       ;       //trace buf to EP
   read_trace_frame();
   x = end_framel + end_frameh * 256 ;
   if ((x<=0x20) || (x>= 0x30))
     {
             error_program() ;
             bit_map_number = cb_u49 ;
             new_percent = per50 ;
             bit_map_program() ;
     }
   halt_ep() ;
   reset_ep() ;
   break_end_all() ;
}

/******************************************************************************
error code 35:
   The test method is:
      1) First load the trace address counter with 0x0000
      2) set a breapoint at 0x1f0
      3) Outport B with 0x55
      The test resoult shall be
      1) The trace address from 0x0 to 0x1f0
      2) The trace port B shall be 0x55
      Now find some is wrong
      Please refer to the component error percent to check the components
        1) If only trace address error, please check CB-U14, CB-U13 (74HCT244)
        1) If only trace port error, please check CB-U15, CB-U34 (74HCT244)
        1) If both trace address and  trace port error, please check
        CB-U11 (RAM 32K), CB-U13 (74HCT244)
******************************************************************************/
void test_Trace_RAM(void)
{
   unsigned int x,z ;
   unsigned int y ;
   unsigned char error_find;
   error_find = 0x0 ;
   reset_ep() ;
   if (EP_type<=PIC16CR58A)
     {
       register_id = 0x7 ;
       reg_value0 = 0x55 ;
       ModifyReg()       ;
       register_id = 0xb ;
       reg_value0 =  0x0 ;
       ModifyReg()       ;
       GetRegister();                        // read the EP's register
     }
  else
     {
        register_id = 17  ;
        reg_value0 = 0x55 ;
        register_c6x_id = 2 * register_id ;
        C6xModifyReg()    ;
        register_id = 38  ;
        reg_value0 =  0x0 ;
        register_c6x_id = 2 * register_id;
        C6xModifyReg()    ;
        C6xGetRegister();                      // Jason  07/12/1996     //
     }
   all_break_cleared() ;
   emu_add[0x3E1] = 0x7 ;
   resume_bp() ;
   set_emu_break() ;
   ev1_counter = 0xfe ;
   trigger_type =  0x0;
   trigger_condition = 0x0 ;
   set_ev1_counter()    ;       // re-write the ev1 counter
   set_trigger_type() ;
   set_trigger() ;
   set_ep_access_emu() ;
   if(EP_type <=PIC16CR58A)
     {
       spoon_data0=0x01     ;       //the ExeBp code is 0x01
       spoon_data1=0x0      ;
     }
   else
     {
       spoon_data0=0x61     ;       //the ExeBp code is 0x61
       spoon_data1=0x0      ;
     }
   write_spoon()        ;       //write to the spoon buffer
   stop_type = user ;      //the ep is  stop by user
   set_trace1()        ;
   sel_cp_trace()       ;       // the CP access the trace RAM
   trace_framel =0x3  ;       // the start trace frame =0
   trace_frameh =0x0    ;
   load_trace_frame()   ;
   sel_ep_trace()       ;       //trace buf to EP
   run_ep() ;
   for(delay = 0; delay < 0xf;)
        {
           if (check_eprunning() == EpNotrunning)
           {
              delay = 0xff ;
           }
        }
   sel_cp_trace()       ;       //trace buf to EP
   for (x =14; x<= 0x3c0; x++)
      {
         trace_addrl = x ;
         trace_addrl = trace_addrl -1 ;
         trace_addrh = x/256 ;
         read_trace_value() ;                //read the trace value
         z = (pic_addrl + pic_addrh * 256) & 0x3fff  ;  //the traced pic's address
         x = x+2 ;
         trace_addrl = x ;
         trace_addrl = trace_addrl -1 ;
         trace_addrh = x/256 ;
         read_trace_value() ;                //read the trace value
         y = (pic_addrl + pic_addrh * 256) & 0x3fff  ;  //the traced pic's address
         if (y != (z+1))
           {
             error_find = error_find | 0x1 ;
           }
         if(pic_rb != 0x55)
           {
             error_find = error_find | 0x10 ;
           }
      }
     switch (error_find)
       {
           case  trace_buffer1_error :
             error_program() ;
             bit_map_number = cb_u14;
             new_percent = per30 ;
             bit_map_program() ;
             bit_map_number = cb_u35 ;
             new_percent = per10 ;
             bit_map_program() ;
             bit_map_number = cb_u13 ;
             new_percent = per20 ;
             bit_map_program() ;
           break ;

           case  trace_buffer2_error :
             error_program() ;
             bit_map_number = cb_u15 ;
             new_percent = per30 ;
             bit_map_program() ;
             bit_map_number = cb_u34 ;
             new_percent = per20 ;
             bit_map_program() ;
           break ;

           case  trace_all_error :
             error_program() ;
             bit_map_number = cb_u11 ;
             new_percent = per40 ;
             bit_map_program() ;
             bit_map_number = cb_u33 ;
             new_percent = per10 ;
             bit_map_program() ;
             bit_map_number = cb_u13 ;
             new_percent = per20 ;
             bit_map_program() ;
           break ;

           default :
           break ;
       }
   halt_ep() ;
   reset_ep() ;
   break_end_all() ;

}


/**********************************************************************
   error program
**********************************************************************/
void error_program(void)
{
   error_code[error_code_number] = test_item ;   // the error code
   error_code_number = error_code_number +1 ;    // error code number

}

/**********************************************************************
   bit map program
input : bit_map_number
        test_item
        new_percent
**********************************************************************/
void bit_map_program(void)
{
   bit_map_belong[bit_map_number] = error_occur + test_item ;
   if ((bit_map_percent[bit_map_number] + new_percent) >= per90)
      {
         bit_map_percent[bit_map_number] = per90 ;
      }
   else
      {
         bit_map_percent[bit_map_number] = bit_map_percent[bit_map_number]
                                           + new_percent ;
      }
}



/******************************************************************************
   Now the control CPU is doing follow:
      1) Read program
      2) Use the MOVC instruction to get the program code
      3) Use the MOVX read/write SRAM.
   please check the U38 (EPROM, 27512, 64K) and the U24 ( SRAM, 24257, 32k)
******************************************************************************/
void current_CP_Program_EPROM(void)
{
   test_item=eprom_checksum() ;
}


/******************************************************************************
   Now the control CPU is doing follow:
      1) Read program
      2) Use the MOVX read at the error byte of SRAM.
   please check the U24 ( SRAM, 24257, 32k)
******************************************************************************/
void current_CP_Data_SRAM_Addr(void)
{
   test_item = read_addr() ;
}

/******************************************************************************
   Now the control CPU is doing follow:
      1) Read program
      2) Use the MOVX to write the error data to the error address
      3) Use the MOVX to read the data from the error address
   please check the U24 ( SRAM, 24257, 32k)
******************************************************************************/
void current_CP_Data_SRAM_IC(void)
{
       write_addr() ;
       test_item = backup_addr() ;
}

/******************************************************************************
   Now the control HW status is:
      1) set P1.1 to high
      2) Use the MOVX to write the buffer CB-U19, 74HCT244
      3) clear P1.1 to low
      4) Use the MOVX to write the buffer U19, 74HCT244
   please check the CB-U42 ( GAL20V8), CB-U30 (74LS245).
   CB-U26, CB-U28 (74HCT138), EB-U19 (74HCT245)
******************************************************************************/
void current_CP_IO_Buffer(void)
{
      set_trace1() ;
      test_item = read_tbank() ;
      set_trace2() ;
      test_item = read_tbank() ;
}

/******************************************************************************
   Now the control HW status is:
      1) set P1 to high
      3) clear P1 to low
   please check the CB-U43 ( 8032).
******************************************************************************/
/*
void current_IO_Buffer(void)
{
   P1 = 0xff ;
   P1 = 0x0  ;
}
*/
/******************************************************************************
   Now the control HW status is:
      1) clear the execution time counter EB-U5, EB-U14
      3) read the value
   please check the EB-U5, EB-U14 (74LS161). CB-U51 (GAL16V8) ,EB-20 (74HCT244)
******************************************************************************/
/*
void current_Exe_Time_Calculate_HW(void)
{
   test_item = exe_calculate_buffer() ;
}
*/

/******************************************************************************
   Now the control HW status is:
      1) write data: 0x55 to emulation addr 0 (low byte) and read it
      2) write data: 0x55 to emulation addr 1 (high byte) and read it
      3) write data: 0x55 to emulation addr 0x1fff (low byte) and read it
      4) write data: 0x55 to emulation addr 0x1fff (low byte) and read it
      Please check CB-U42 (GAL20V8)pin 18, pin 19, pin 17, pin 21 (low pulse),
      CB-U21, CB-U22, CB-U23,CB-U27 (74F257) pin 1 (high level)
      CB-U16, CB-U17 (RAM, 32K 24257) pin 27 (low pulse),
      CB-U6, CB-U7 (74HCT245) pin 19, pin 1 (low pulse)
******************************************************************************/
void current_EMU_RAM_Control_Signal(void)
{
   set_cp_access_emu() ;
   set_emu_break() ;
   set_emu_bank0() ;
   emu_add[0] = 0x55 ;
   test_item = emu_add[0] ;
   emu_add[1] = 0x55 ;
   test_item = emu_add[1] ;
   emu_add[0x3ffe] = 0x55 ;
   test_item = emu_add[0x3ffe] ;
   emu_add[0x3fff] = 0x55;
   test_item = emu_add[0x3fff] ;
}

/******************************************************************************
   Now the control HW status is:
      1) write data: 0x55 to emulation memory (xxx)
      2) read data at another emulation memory (yyy) , the (xxx) may shorts
         with (yyy)
      Please check CB-U21, CB-U22, CB-U23,CB-U27 (74F257)
      CB-U16, CB-U17, CB-U39 (RAM 24257)
******************************************************************************/
void current_EMU_RAM_Addr_Buffer(void)
{
   set_cp_access_emu() ;
   set_emu_break() ;
   set_emu_bank0() ;
   emu_add[emu_addr_write_error] = 0x55 ;
   test_item = emu_add[emu_addr_read_error] ;
}

/******************************************************************************
   Now the control HW status is:
      1) Use the MOVX to write the error data to the error address
      2) Use the MOVX to read the data from the error address
      Please check CB-U16, (RAM, 32K 24257), CB-U6 (74HCT245)
******************************************************************************/
void current_EMU_RAM_IC_Low(void)
{
   set_cp_access_emu() ;
   set_emu_break() ;
   set_emu_bank0() ;
   emu_add[addr_emu_low] = data_emu_low ;
   test_item = emu_add[addr_emu_low] ;
}

/******************************************************************************
   Now the control HW status is:
      1) Use the MOVX to write the error data to the error address
      2) Use the MOVX to read the data from the error address
      Please check CB-U17, (RAM, 32K 24257), CB-U7 (74HCT245)
******************************************************************************/
void current_EMU_RAM_IC_High(void)
{
   set_cp_access_emu() ;
   set_emu_break() ;
   set_emu_bank0() ;
   emu_add[addr_emu_high] = data_emu_high ;
   test_item = emu_add[addr_emu_high] ;
}

/******************************************************************************
   Now the control HW status is:
      1) Use the MOVX to write the error data to the error address
      2) Use the MOVX to read the data from the error address
      Please check CB-U39, (RAM, 32K 24257), CB-U40 (74HCT245)
******************************************************************************/
void current_Break_RAM_IC(void)
{
   set_cp_access_emu() ;
   set_break_emu() ;
   set_emu_bank0() ;
   emu_add[addr_emu_break] = data_emu_break ;
   test_item = emu_add[addr_emu_break] ;
}

/******************************************************************************
   Now the control HW status is:
      1) reset the emulation
      2) delay and reset it again
      Please check EB-U7 (PIC16C01/02), or together with EB-U16, EB-U17
      (PIC16CXX-ME)
******************************************************************************/
void current_EP_CPU_Work(void)
{
   unsigned int x ;
   reset_ep() ;
   for (x=0; x<0x1fff;x++)
    {
    }
}

/******************************************************************************
   Now the control HW status is:
      1) spoon the emulation CPU
      2) read the address on the buffer (EB-U4, EB-U2)
      Please check EB-U7 (PIC16C01/02) pib 37, 40 (low pulse)
      CB-U52 pin 5 (high pulse) EB-U6 pin 11 (high pulse)
      EB-U4, EB-U2
******************************************************************************/
void current_EP_AD_Bus(void)
{
   spoon_ep() ;
   test_item = read_spoon() ;
}

/******************************************************************************
   Now the control HW status is:
      1) spoon the emulation CPU with goto instruction (on EB-U11, EB-U9)
      2) read the address on the buffer (EB-U4, EB-U2)
      Please check EB-U11, EB-U9 (spoon buffer 74HCT374). EB-U7 (emulation CPU
      PIC16C01/02),  CB-U52 (GAL20V8), CB-U45, CB-U46 (74HC74).
******************************************************************************/
void current_Spoon_Control(void)
{
   if(EP_type <=PIC16CR58A)
     {
        spoon_data1 = 0xa ;    // goto instruction for pic16c01
     }
   else
     {
        spoon_data1 = 0x28 ;   // goto instruction for pic16c02
     }
   for (spoon_data0=1; spoon_data0<0xff ; spoon_data0++)
      {
         write_spoon() ;
         spoon_ep();
         test_item = read_spoon() ;
      }
}


/******************************************************************************
   Now the control HW status is:
      1) step the EP with NOP instruction
      The yellow LED shall be on/off
      Please check CB-U2, CB-U3 (74F244). EB-U7 (emulation CPU
      PIC16C01/02),  CB-U52 (GAL20V8), CB-U45, CB-U46 (74HC74).
******************************************************************************/
void current_Step_Control(void)
{
   unsigned int x ;
   set_emu_break() ;
   set_ep_access_emu() ;
   step_ep() ;
}

/******************************************************************************
   Now the control HW status is:
      1) Free run the EP with NOP instruction
      2) Halt the EP
      3) Reset the EP
      The yellow LED shall be on/off
      Please check CB-U2, CB-U3 (74F244). EB-U7 (emulation CPU
      PIC16C01/02),  CB-U52 (GAL20V8), CB-U45, CB-U46 (74HC74).
******************************************************************************/
void current_Go_Control(void)
{
   unsigned int x ;
   TR1 = 0 ;
   TR0 = 0 ;
   EX1 = 0 ;
   EX0 = 0 ;
   ET0 = 0 ;
   ET1 = 0 ;
   set_cp_access_emu();
   set_emu_break() ;
   for(x=0;x<= 0x3fff; x++)
     {
       emu_add[x] = 0x0 ;
     }
   set_break_emu() ;
   for(x=0;x<= 0x3fff; x++)
     {
       emu_add[x] = 0x0ff ;
     }
   set_emu_break() ;
   set_ep_access_emu() ;
   stop_type = user ;      //the ep is  stop by user
   run_ep() ;
   for(x=0; x<0x1fff; x++)
     {
     }
   halt_ep() ;
   reset_ep() ;
   TR1 = 1 ;
   TR0 = 1 ;
   EX1 = 1 ;
   EX0 = 1 ;
   ET0 = 1 ;
   ET1 = 1 ;
}

/******************************************************************************
   Now the control HW status is:
      1) Set a breakpoint at 0x55
      2) Reset the EP
      3) Free run the EP with NOP instruction
      The yellow LED shall be on/off
      Please check EB-U7 (emulation CPU PIC16C01/02),  CB-U52, EB-U28 (GAL20V8),
******************************************************************************/
void current_Breakpoint_Control(void)
{
   unsigned int x;
   all_break_cleared() ;
   emu_add[0xab] = 0x7 ;
   set_emu_break() ;
   set_ep_access_emu() ;
   resume_bp() ;
   if(EP_type <=PIC16CR58A)
     {
       spoon_data0=0x01     ;       //the ExeBp code is 0x01
       spoon_data1=0x0      ;
     }
   else
     {
       spoon_data0=0x61     ;       //the ExeBp code is 0x61
       spoon_data1=0x0      ;
     }
   write_spoon()        ;       //write to the spoon buffer
   reset_ep() ;
   stop_type = user ;      //the ep is  stop by user
   run_ep() ;
   for (x = 0; x<= 0xfff; x++)
     {
     }
   TR1 = 1 ;
   TR0 = 1 ;
   EX1 = 1 ;
   EX0 = 1 ;
   ET0 = 1 ;
   ET1 = 1 ;
}

/******************************************************************************
   Now the control HW status is:
      1) Set a EV1 at 0x55, trigger is Backward
      2) Reset the EP
      3) Free run the EP with NOP instruction
      The yellow LED shall be on/off
      Please check EB-U7 (emulation CPU PIC16C01/02),  CB-U52, EB-U28 (GAL20V8),
      EB-U21, EB-U27 (74LS161)
******************************************************************************/
void current_Ev1_Control(void)
{
   unsigned char y;
   unsigned int z ;
   all_break_cleared();
   emu_add[0xab] = 0xe ;
   ev1_counter = 0xfe ;
   trigger_type =  Backward;
   trigger_condition = 0x1 ;
   ini_all_break();
   y = check_eprunning() ;
   z = read_spoon() ;
   halt_ep() ;
   reset_ep() ;
   break_end_all() ;
}

/******************************************************************************
   Now the control HW status is:
      1) Set a EV1 at 0x55, counter is 0x10, trigger is Backward
      2) Reset the EP
      3) Free run the EP with NOP instruction
      The yellow LED shall be on/off
      Please check EB-U7 (emulation CPU PIC16C01/02),  CB-U52, EB-U28 (GAL20V8),
      EB-U21, EB-U27 (74LS161)
******************************************************************************/
void current_Ev1_Counter_Control(void)
{
   unsigned char y;
   unsigned int z ;
   all_break_cleared();
   emu_add[0xab] = 0xe ;
   ev1_counter = 0xfe - 0x10 ;
   trigger_type =  Backward;
   trigger_condition = 0x1 ;
   ini_all_break();
   y = check_eprunning() ;
   z = read_spoon() ;
   halt_ep() ;
   reset_ep() ;
   break_end_all() ;
}

/******************************************************************************
   Now the control HW status is:
      1) Set a EV2 at 0x55, trigger is Backward
      2) Reset the EP
      3) Free run the EP with NOP instruction
      The yellow LED shall be on/off
      Please check EB-U7 (emulation CPU PIC16C01/02),  CB-U52, EB-U28 (GAL20V8),
******************************************************************************/
void current_Ev2_Control(void)
{
   unsigned char y;
   unsigned int z ;
   all_break_cleared();
   emu_add[0xab] = 0xd ;
   trigger_type =  Backward;
   trigger_condition = 0x2 ;
   ini_all_break();
   y = check_eprunning() ;
   z = read_spoon() ;
   halt_ep() ;
   reset_ep() ;
   break_end_all() ;
}

/******************************************************************************
   Now the control HW status is:
      1) Set a EV1 at 0x55, EV2 ad 0xaa , trigger is Backward with EV1 then EV2
      2) Reset the EP
      3) Free run the EP with NOP instruction
      The yellow LED shall be on/off
      Please check EB-U7 (emulation CPU PIC16C01/02),  CB-U52, EB-U28 (GAL20V8),
******************************************************************************/
void current_Trig_Ev1_or_Ev2_Control(void)
{
   all_break_cleared() ;
   emu_add[0xab] = 0xe ;
   emu_add[0x155] = 0xd ;
   ev1_counter = 0xfe ;
   trigger_type =  Backward;
   trigger_condition = 0x8 ;
   ini_all_break();
   halt_ep() ;
   reset_ep() ;
   break_end_all() ;
}

/******************************************************************************
   Now the control HW status is:
      1) Set a EV1 at 0xaa, EV2 ad 0x55 , trigger is Backward with EV2 then EV1
      2) Reset the EP
      3) Free run the EP with NOP instruction
      The yellow LED shall be on/off
      Please check EB-U7 (emulation CPU PIC16C01/02),  CB-U52, EB-U28 (GAL20V8),
******************************************************************************/
void current_Trig_Ev1_then_Ev2_Control(void)
{
   all_break_cleared() ;
   emu_add[0xab] = 0xd ;
   emu_add[0x155] = 0xe ;
   ev1_counter = 0xfe ;
   trigger_type =  Backward;
   trigger_condition = 0xa ;
   ini_all_break();
   break_end_all() ;
}

/******************************************************************************
   Now the control HW status is:
      1) First load the trace address counter low byte with (0x0~0xff)
         read the value and compare it
      2) Then load the trace address counter high byte with (0x0~0xff)
         read the value and compare it
         (Please refer to the component error percent to check the component
         If only the trace address counter low byte is error, please check
         CB-U5, CB-U18 (74F161), CB-U10, CB-U19 (74F257), CB-U9 (74HCT244)
         If only the trace address counter high byte is error, please check
         CB-U31, CB-U48 (74F161), CB-U32, CB-U50 (74F257), CB-U29 (74HCT244)
         If both  the trace address counter high and low  byte are error,
         please check CB-U49 (GAL20V8), EB-U25 (74HCT374)
******************************************************************************/
void current_Trace_Addr_Buffer(void)
{
     unsigned int x ;
     sel_cp_trace()       ;       // the CP access the trace RAM
     trace_frameh =0x0    ;
     for(x=1; x<=0xfd; x++)
       {
        trace_framel = x  ;       // the start trace frame =0
        load_trace_frame()   ;
        read_trace_frame();
       }
     trace_framel =0x00    ;
     for(x=1; x<=0x1f; x++)
       {
        trace_frameh = x  ;       // the start trace frame =0
        load_trace_frame()   ;
        read_trace_frame();
       }
}

/******************************************************************************
   Now the control HW status is:
      1) Free run the EP with NOP instruction
      2) Halt the EP
      3) Reset the EP
      The yellow LED shall be on/off
      Please check CB-U49 (GAL20V8)
******************************************************************************/
void current_Trace_Counter(void)
{
   unsigned int x ;
   all_break_cleared() ;
   set_emu_break() ;
   ev1_counter = 0xfe ;
   trigger_type =  0x0;
   trigger_condition = 0x0 ;
   set_ev1_counter()    ;       // re-write the ev1 counter
   set_trigger_type() ;
   set_trigger() ;
   set_ep_access_emu() ;
   reset_ep() ;
   stop_type = user ;      //the ep is  stop by user
   sel_cp_trace()       ;       // the CP access the trace RAM
   trace_framel =0xff  ;       // the start trace frame =0
   trace_frameh =0x0    ;
   load_trace_frame()   ;
   sel_ep_trace()       ;       //trace buf to EP
   set_trace1()        ;
   run_ep() ;
   for (x = 0; x<= 0xfff; x++)
     {
     }
   sel_cp_trace()       ;       //trace buf to EP
   read_trace_frame();
   halt_ep() ;
   break_end_all() ;
}

/******************************************************************************
   Now the control HW status is:
      1) First load the trace address counter with 0x0000
      2) set a breapoint at 0x1f0
      3) Outport B with 0x55
      4) Free run EP with NOP instruction
      The yellow LED shall be on/off
      Please refer to the component error percent to check the components
        1) If only trace address error, please check CB-U14, CB-U13 (74HCT244)
        1) If only trace port error, please check CB-U15, CB-U34 (74HCT244)
        1) If both trace address and  trace port error, please check
        CB-U11 (RAM 32K), CB-U13 (74HCT244)
******************************************************************************/
void current_Trace_RAM(void)
{
   unsigned int x ;
   reset_ep() ;
   if (EP_type<=PIC16CR58A)
     {
       register_id = 0x7 ;
       reg_value0 = 0x55 ;
       ModifyReg()       ;
       register_id = 0xb ;
       reg_value0 =  0x0 ;
       ModifyReg()       ;
       GetRegister();                        // read the EP's register
     }
  else
     {
        register_id = 17  ;
        reg_value0 = 0x55 ;
        register_c6x_id = 2 * register_id ;
        C6xModifyReg()    ;
        register_id = 38  ;
        reg_value0 =  0x0 ;
        register_c6x_id = 2 * register_id;
        C6xModifyReg()    ;
        C6xGetRegister();                      // Jason  07/12/1996     //
     }
   all_break_cleared() ;
   emu_add[0x3E1] = 0x7 ;
   set_emu_break() ;
   ev1_counter = 0xfe ;
   trigger_type =  0x0;
   trigger_condition = 0x0 ;
   set_ev1_counter()    ;       // re-write the ev1 counter
   set_trigger_type() ;
   set_trigger() ;
   set_ep_access_emu() ;
   resume_bp() ;
   if(EP_type <=PIC16CR58A)
     {
       spoon_data0=0x01     ;       //the ExeBp code is 0x01
       spoon_data1=0x0      ;
     }
   else
     {
       spoon_data0=0x61     ;       //the ExeBp code is 0x61
       spoon_data1=0x0      ;
     }
   write_spoon()        ;       //write to the spoon buffer
   stop_type = user ;      //the ep is  stop by user
   sel_cp_trace()       ;       // the CP access the trace RAM
   trace_framel =0xff  ;       // the start trace frame =0
   trace_frameh =0x0    ;
   load_trace_frame()   ;
   sel_ep_trace()       ;       //trace buf to EP
   set_trace1()        ;
   run_ep() ;
   for(delay = 0; delay < 0xf;)
        {
           if (check_eprunning() == EpNotrunning)
           {
              delay = 0xff ;
           }
        }
   sel_cp_trace()       ;       //trace buf to EP
   for (x =2; x<= 0x3c0; x++)
      {
         trace_addrl = x ;
         trace_addrl = trace_addrl -1 ;
         trace_addrh = x/256 ;
         read_trace_value() ;                //read the trace value
       }
   halt_ep() ;
   reset_ep() ;
   break_end_all() ;
}


void ini_all_break(void)
{
   unsigned int l ;
   resume_bp() ;                          // resume the Exebp if the runflag =1
   set_trigger_type() ;
   set_trigger() ;
   set_emu_break() ;
   set_ev1_counter()    ;       // re-write the ev1 counter
   set_ep_access_emu() ;
   reset_ep() ;
   stop_type = user ;      //the ep is  stop by user
   run_ep() ;
   for (l = 0; l<= 0xfff; l++)
     {
     }
}


void break_error_list(void)
{
             error_program() ;
             bit_map_number = eb_u7 ;
             new_percent = per20 ;
             bit_map_program() ;
             bit_map_number = cb_u52 ;
             new_percent = per20 ;
             bit_map_program() ;
             bit_map_number = eb_u28 ;
             new_percent = per20 ;
             bit_map_program() ;
             bit_map_number = eb_u21 ;
             new_percent = per20 ;
             bit_map_program() ;
             bit_map_number = eb_u27 ;
             new_percent = per20 ;
             bit_map_program() ;
}

void all_break_cleared(void)
{
   unsigned int l ;
   TR1 = 0 ;
   TR0 = 0 ;
   EX1 = 0 ;
   EX0 = 0 ;
   ET0 = 0 ;
   ET1 = 0 ;
   set_cp_access_emu();
   set_emu_break() ;
   for(l=0;l<= 0x3fff; l++)
     {
       emu_add[l] = 0x0 ;
     }
   set_break_emu() ;
   for(l=0;l<= 0x3fff; l++)
     {
       emu_add[l] = 0xff ;
     }
}

void break_end_all(void)
{
   unsigned int x ;
   set_cp_access_emu();
   set_break_emu() ;
   for(x=0; x<=0x3fff; x++)
   {
      emu_add[x] = 0xff;
   }
   set_emu_break() ;
   trigger_type =  Trigger_off;
   set_trigger_type() ;
   trigger_condition = 0x0 ;
   set_trigger() ;
   TR1 = 1 ;
   TR0 = 1 ;
   EX1 = 1 ;
   EX0 = 1 ;
   ET0 = 1 ;
   ET1 = 1 ;
}
