/**************************************************************************
**
** $Header:
**
** $Log:
** 
** 
** Initial revision. 1.0
** 
***************************************************************************/

/****************************************************************************
**
**  Name:         TRACECRD.C
**
**  Description:     this file include some routines for the ABI command
**                   trace_c_read
**
**  Status: PRELIMINARY
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <reg51.h>
#include "io.h"

/******************************************************************************/
                  /**********************
                  *  extern data        *
                  **********************/

/////////////////////////////////////////////////////////////////////////////
// Global variables.

extern unsigned char  EPrunningFlag ;
extern unsigned int  trace1_start_frame;
extern unsigned char traceCntLow  ;
extern unsigned char traceCntHigh ;
extern unsigned char fw_lastframe_get(void) ;
extern unsigned char trace_full;
extern unsigned char trace_addrl ;
extern unsigned char trace_addrh ;
extern unsigned char pic_addrl ;
extern unsigned char pic_addrh ;
extern unsigned char commandStream[2048];
extern unsigned int TStreamLen;
extern unsigned char TransmitBuf[1600] ;              
extern unsigned char  ME_IDENTIFY;
extern unsigned char EP_type   ;
extern unsigned int Coverage_Range_SAd1;
extern unsigned int Coverage_Range_DAd1;
extern unsigned int Coverage_Range_SAd2;
extern unsigned int Coverage_Range_DAd2;
extern unsigned int Coverage_Range_SAd3;
extern unsigned int Coverage_Range_DAd3;
extern unsigned int Coverage_Range_SAd4;
extern unsigned int Coverage_Range_DAd4;
extern unsigned int Code_Access_Range_SAd[17];
extern unsigned int Code_Access_Range_DAd[17];




                  /**********************
                  *  extern code        *
                  **********************/


extern void set_cp_access_emu(void) ;
extern void sel_cp_trace(void) ;
extern void read_trace_value(void) ;
extern void ToBank0(void)   ;
extern void ToBank1(void)   ;




data unsigned int Code_Access_Tmp;
unsigned char trace_temp1,trace_temp2;
unsigned int Frame_No[200];
unsigned int Frame_adr[200];
unsigned int PictraceCnt;

unsigned char TraceCRead(void) ;
void GetPictraceCnt(void);
unsigned char GetCTraceBuf( unsigned char,  unsigned char );
unsigned int Read_Trace_Content(unsigned int);


//-----------------------------------------------------------------------
//==========================================================================
//
// unsigned char TraceCRead(void)
//
// input : byte 0 : banksellect :    1   bank 0
//                                   2   bank 1
//         byte1~2: start frame      start frame number
//         byte 3 : count            how many frame to be read
//         4 x count : start address , end address
//         type:
//               0x0  :   don't care range
//               0x1  :   range 1
//               0x1  :   range 2
//               0x1  :   range 3
//               0x1  :   range 4
//               0x1  :   range 5
//               0xf1 :   range 5 -> range 1
//               0xf2 :   range 5 -> range 2
//               0xf3 :   range 5 -> range 3
//               0xf4 :   range 5 -> range 4
// output :
//         1. CommandExeOK
//            frame   : ( low , high )
//            address : ( low , high )
//            real count
//         2. EpRunning
//         3. EPsleeping
//         4. CmdInvalid
//==========================================================================
unsigned char TraceCRead(void)
{         
  sel_cp_trace()  ;                // the cp will access trace RAM
if(commandStream[1] == 0x1 )
   {
   if(ME_IDENTIFY == 0x01)
        {
        ToBank0()   ;
        }
   }                                                
if(commandStream[1] == 0x2 )
   {
   if(ME_IDENTIFY == 0x01)
        {
        ToBank1()   ;
        }
   }
if((commandStream[1] != 0x1 )&&(commandStream[1] != 0x2 ))
      {
      return CmdInvalid;
      }
GetPictraceCnt();   // how many frames have been recorded in the trace buffer
Code_Access_Range_SAd[0] = commandStream[5] + commandStream[6] * 256;
Code_Access_Range_DAd[0] = commandStream[7] + commandStream[8] * 256;
Code_Access_Range_SAd[1] = commandStream[9] + commandStream[10] * 256;
Code_Access_Range_DAd[1] = commandStream[11] + commandStream[12] * 256;
Code_Access_Range_SAd[2] = commandStream[13] + commandStream[14] * 256;
Code_Access_Range_DAd[2] = commandStream[15] + commandStream[16] * 256;
Code_Access_Range_SAd[3]= commandStream[17] + commandStream[18] * 256;
Code_Access_Range_DAd[3] = commandStream[19] + commandStream[20] * 256;
Code_Access_Range_SAd[4] = commandStream[21] + commandStream[22] * 256;
Code_Access_Range_DAd[4] = commandStream[23] + commandStream[24] * 256;
TransmitBuf[0] = GetCTraceBuf( commandStream[4], commandStream[25]);
TransmitBuf[1] = trace_temp2;
for (trace_temp1=0;trace_temp1<trace_temp2;trace_temp1++)
    {
     TransmitBuf[trace_temp1 * 4 + 2] = Frame_No[trace_temp1] & 0x00ff;
     TransmitBuf[trace_temp1 * 4 + 3] = Frame_No[trace_temp1] / 256;
     TransmitBuf[trace_temp1 * 4 + 4] = Frame_adr[trace_temp1] & 0x00ff;
     TransmitBuf[trace_temp1 * 4 + 5] = Frame_adr[trace_temp1] / 256;
    }
TStreamLen = 2 + (trace_temp2 * 4);

      return CommandExeOk;
}
//==========================================================================
// unsigned char GetCTraceBuf( unsigned char count, unsigned char rangeCount)
// input : unsigned char count  commandStream[3]
//         unsigned rangeCount  commandStream[24]
// output  :
//         1. CommandExeOk
//         2. CmdInvalid
//
//==========================================================================
unsigned char GetCTraceBuf( unsigned char count, unsigned char rangeCount)

{
   unsigned char x, retcount = 0;
   unsigned int StartFrame;
   StartFrame = commandStream[2] + commandStream[3] * 256;
   if (count > 60)
   {
      return CmdInvalid;
   }
   if(StartFrame <= PictraceCnt)
   {
      if (rangeCount == 0)
      {
         for (x=0;x<count;x++)
         {
          if (StartFrame == 0X0)
             {
                Frame_adr[3*x  ] = Read_Trace_Content(StartFrame);
                Frame_adr[3*x+1] = Read_Trace_Content(StartFrame);
                Frame_adr[3*x+2] = Read_Trace_Content(StartFrame+1);
                Frame_No[3*x  ] = StartFrame;
                Frame_No[3*x+1] = StartFrame;
                Frame_No[3*x+2] = StartFrame+1;
            }
          else
             {
             if (StartFrame == PictraceCnt)
                {
                 Frame_adr[3*x  ] = Read_Trace_Content(StartFrame-1);
                 Frame_adr[3*x+1] = Read_Trace_Content(StartFrame);
                 Frame_adr[3*x+2] = Read_Trace_Content(StartFrame);
                 Frame_No[3*x+0] = StartFrame-1;
                 Frame_No[3*x+1] = StartFrame;
                 Frame_No[3*x+2] = StartFrame;
                }
             else
                {
              Frame_adr[3*x  ] = Read_Trace_Content(StartFrame-1);
              Frame_adr[3*x+1] = Read_Trace_Content(StartFrame);
              Frame_adr[3*x+2] = Read_Trace_Content(StartFrame+1);
              Frame_No[3*x+0] = StartFrame-1;
              Frame_No[3*x+1] = StartFrame;
              Frame_No[3*x+2] = StartFrame+1;
               }
            }
          StartFrame ++;
          if(StartFrame >= PictraceCnt)  break;
         }
         retcount = x;
      }
      else
      {
         if (rangeCount < 0xf5 && rangeCount > 0xf0)
         {
            rangeCount = rangeCount - 0xf0;
            for(Coverage_Range_SAd1 = StartFrame;
               Coverage_Range_SAd1 <  PictraceCnt; Coverage_Range_SAd1++ )
               {
               Code_Access_Tmp =( Read_Trace_Content(Coverage_Range_SAd1)) & 0x3fff;
               if((Code_Access_Tmp >= Code_Access_Range_SAd[4])
               && (Code_Access_Tmp <= Code_Access_Range_DAd[4]))
                  {
                   StartFrame = Coverage_Range_SAd1;

                  if (StartFrame == 0X0)
                     {
                      Frame_No[retcount*3  ] = StartFrame;
                      Frame_No[retcount*3+1] = StartFrame;
                      Frame_No[retcount*3+2] = StartFrame+1;

                      Frame_adr[retcount*3+1] = Read_Trace_Content(Coverage_Range_SAd1);
                      Frame_adr[retcount*3  ] = Read_Trace_Content(Coverage_Range_SAd1);
                      Frame_adr[retcount*3+2] = Read_Trace_Content(Coverage_Range_SAd1+1);
                     }
                 else
                     {                    
                     if (StartFrame == PictraceCnt)
                        {
                         Frame_No[retcount*3  ] = StartFrame-1;
                         Frame_No[retcount*3+1] = StartFrame;
                         Frame_No[retcount*3+2] = StartFrame;

                         Frame_adr[retcount*3+1] = Read_Trace_Content(Coverage_Range_SAd1);
                         Frame_adr[retcount*3+2] = Read_Trace_Content(Coverage_Range_SAd1);
                         Frame_adr[retcount*3  ] = Read_Trace_Content(Coverage_Range_SAd1-1);
                        }
                     else
                        {
                         Frame_No[retcount*3  ] = StartFrame-1;
                         Frame_No[retcount*3+1] = StartFrame;
                         Frame_No[retcount*3+2] = StartFrame+1;

                         Frame_adr[retcount*3+1] = Read_Trace_Content(Coverage_Range_SAd1);
                         Frame_adr[retcount*3  ] = Read_Trace_Content(Coverage_Range_SAd1-1);
                         Frame_adr[retcount*3+2] = Read_Trace_Content(Coverage_Range_SAd1+1);
                         }
                     }

                   retcount++;
                   StartFrame++;
                   break;
                  }
              }
         goto NORM;
         }
      if (rangeCount > 5 || rangeCount == 0)
        {
            return CmdInvalid;
         }
         for(;StartFrame <  PictraceCnt; StartFrame++)
         {
            Code_Access_Tmp = (Read_Trace_Content(StartFrame)) & 0x3fff;
            if((Code_Access_Tmp <= Code_Access_Range_SAd[0])
            || (Code_Access_Tmp > Code_Access_Range_DAd[0]))
               {

                  if (StartFrame == 0X0)
                     {
                      Frame_No[retcount*3  ] = StartFrame;
                      Frame_No[retcount*3+1] = StartFrame;
                      Frame_No[retcount*3+2] = StartFrame+1;

                      Frame_adr[retcount*3+1] = Read_Trace_Content(StartFrame);
                      Frame_adr[retcount*3  ] = Read_Trace_Content(StartFrame);
                      Frame_adr[retcount*3+2] = Read_Trace_Content(StartFrame+1);
                     }
                 else
                     {                    
                     if (StartFrame == PictraceCnt)
                        {
                         Frame_No[retcount*3  ] = StartFrame-1;
                         Frame_No[retcount*3+1] = StartFrame;
                         Frame_No[retcount*3+2] = StartFrame;

                         Frame_adr[retcount*3+1] = Read_Trace_Content(StartFrame);
                         Frame_adr[retcount*3+2] = Read_Trace_Content(StartFrame);
                         Frame_adr[retcount*3  ] = Read_Trace_Content(StartFrame-1);
                        }
                     else
                        {
                         Frame_No[retcount*3  ] = StartFrame-1;
                         Frame_No[retcount*3+1] = StartFrame;
                         Frame_No[retcount*3+2] = StartFrame+1;

                         Frame_adr[retcount*3+1] = Read_Trace_Content(StartFrame);
                         Frame_adr[retcount*3  ] = Read_Trace_Content(StartFrame-1);
                         Frame_adr[retcount*3+2] = Read_Trace_Content(StartFrame+1);
                         }
                     }

                  retcount++;
                  StartFrame++;
                  break;
               }
         if(retcount >= count )
            {
               trace_temp2 = retcount * 3;
               return CommandExeOk;
            }
         }
         NORM:
         do
         {
            for(x=0;x<rangeCount;x++)
            {
               if((Code_Access_Tmp >= Code_Access_Range_SAd[x])
                   &&(Code_Access_Tmp <= Code_Access_Range_DAd[x]))
               {
                  break;
               }
            }
            if(x==rangeCount)
            {
               trace_temp2 = retcount * 3;
               return CommandExeOk;
            }
            for(;StartFrame <  PictraceCnt; StartFrame++)
            {
               Code_Access_Tmp = (Read_Trace_Content(StartFrame)) & 0x3fff;
               if((Code_Access_Tmp <= Code_Access_Range_SAd[x])
                     || (Code_Access_Tmp > Code_Access_Range_DAd[x]))
                  {

                  if (StartFrame == 0X0)
                     {
                      Frame_No[retcount*3  ] = StartFrame;
                      Frame_No[retcount*3+1] = StartFrame;
                      Frame_No[retcount*3+2] = StartFrame+1;

                      Frame_adr[retcount*3+1] = Read_Trace_Content(StartFrame);
                      Frame_adr[retcount*3  ] = Read_Trace_Content(StartFrame);
                      Frame_adr[retcount*3+2] = Read_Trace_Content(StartFrame+1);
                     }
                 else
                     {                    
                     if (StartFrame == PictraceCnt)
                        {
                         Frame_No[retcount*3  ] = StartFrame-1;
                         Frame_No[retcount*3+1] = StartFrame;
                         Frame_No[retcount*3+2] = StartFrame;

                         Frame_adr[retcount*3+1] = Read_Trace_Content(StartFrame);
                         Frame_adr[retcount*3+2] = Read_Trace_Content(StartFrame);
                         Frame_adr[retcount*3  ] = Read_Trace_Content(StartFrame-1);
                        }
                     else
                        {
                         Frame_No[retcount*3  ] = StartFrame-1;
                         Frame_No[retcount*3+1] = StartFrame;
                         Frame_No[retcount*3+2] = StartFrame+1;

                         Frame_adr[retcount*3+1] = Read_Trace_Content(StartFrame);
                         Frame_adr[retcount*3  ] = Read_Trace_Content(StartFrame-1);
                         Frame_adr[retcount*3+2] = Read_Trace_Content(StartFrame+1);
                         }
                     }

                   retcount++;
                   StartFrame++;
                   break;
                 }
            }
            if(StartFrame >= PictraceCnt)
            {
               trace_temp2 = retcount*3;
               return CommandExeOk;
            }
         }while(retcount<count);
      }
   }
   trace_temp2 = retcount * 3;
   return CommandExeOk;
}
//-----------------------------------------------------------------------
//  unsigned int Read_Trace_Content(unsigned int Pic_Frame_Number)
//  input   :    unsigned int trace_frame_number
//  output  :    address in this trace_frame buffer
//----------------------------------------------------------------------
unsigned int Read_Trace_Content(unsigned int Pic_Frame_Number)
{
 unsigned int i;
 unsigned int PicTraceBufferAddress;
 unsigned char PicRamaddrh;
 unsigned char PicRamaddrl;
 i = Pic_Frame_Number;
 PicTraceBufferAddress = i * 2 + trace1_start_frame ;
 trace_addrh =  (unsigned char)(PicTraceBufferAddress/256);
 trace_addrl = (unsigned char)PicTraceBufferAddress - 1;
 read_trace_value();
 if( ME_IDENTIFY  == 0x1)  // Jason 08/09/1996
     {
      PicTraceBufferAddress = pic_addrl + 256 * pic_addrh;
     }
 else
     {
      PicTraceBufferAddress = pic_addrl + 256 * pic_addrh ;
     }

 return (PicTraceBufferAddress);
}

void GetPictraceCnt(void)
{                             
PictraceCnt = 8 * 1024;       
if(trace_full == not_full)
     {
     fw_lastframe_get();
     PictraceCnt  = (traceCntLow + 256 * traceCntHigh) ;
     }
}
