
/**************************************************************************
**
** $Header:
**
** $Log:
** 
** 
** Initial revision. 0.0
** 
***************************************************************************/
/****************************************************************************
**
**  Name:         xfwcmd.c
**
**  Description:  The ABI commond
**
**  Status: PRELIMINARY
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <reg51.h>
#include "xfwcmd.h"
#include "io.h"

                        /****************************
                         *                          *
                         *    EXTERNAL code         *
                         *                          *
                         ****************************/


extern unsigned char check_eprunning(void) ;
extern unsigned char fw_Mhz_get(void) ;
extern unsigned char Epsleeping_check(void) ;
extern unsigned char fw_ep_reset(void)  ;
extern unsigned char fw_ep_start(void)  ;
extern unsigned char fw_ep_halt(void)  ;
extern unsigned char fw_cpu_select(void)  ;
extern unsigned char fw_control_get(void)  ;
extern unsigned char fw_control_set(void)  ;
extern unsigned char fw_port_out(void)  ;
extern unsigned char fw_port_in(void)  ;
extern unsigned char fw_verify_set(void)  ;
extern unsigned char fw_trig_logic_set(void)  ;
extern unsigned char fw_trig_status_set(void);
extern unsigned char fw_mem_checksum(void)  ;
extern unsigned char fw_mem_compare(void)  ;
extern unsigned char fw_mem_copy(void)  ;
extern unsigned char fw_mem_read(void)  ;
extern unsigned char fw_mem_fill(void)  ;
extern unsigned char fw_mem_search(void)  ;
extern unsigned char fw_mem_test(void)  ;
extern unsigned char fw_reg_modify(void)  ;
extern unsigned char fw_bp_set(void)  ;
extern unsigned char fw_bp_clr(void)  ;
extern unsigned char fw_get_bp(void)  ;
extern unsigned char fw_step_one(void) ;
extern unsigned char fw_step_over(void) ;
extern void break_ini(void);
extern void fw_diagnostic(void);
void fw_ep_support_get(void) ;
void exe_calculate(void) ;
void exe_calculate_base(void) ;
extern unsigned char fw_event_set(void) ;
extern unsigned char fw_event_clr(void) ;
extern unsigned char fw_trace_ini(void) ;
extern unsigned char fw_trace_bank(void)  ;
extern unsigned char fw_trace_cc(void)  ;
extern unsigned char fw_trace_read(void) ;
extern unsigned char fw_lastframe_get(void) ;
extern unsigned char fw_select_ev3(void) ;
extern unsigned char fw_SpaBreakpointSet(void) ;
extern unsigned char fw_CoverageGo(void) ;
extern unsigned char fw_SpaCoverageGet(void) ;
extern unsigned char TraceCRead(void);

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

extern unsigned char spa_flag;
extern unsigned char target_clock0;
extern unsigned char target_clock1;
extern unsigned char target_clock2;
extern unsigned char target_clock3;
extern unsigned char exe_time0 ;
extern unsigned char exe_time1 ;
extern unsigned char exe_time2 ;
extern unsigned char exe_time3 ;
extern unsigned char exe_time_base0 ;
extern unsigned char exe_time_base1 ;
extern unsigned char exe_time_base2 ;
extern unsigned char exe_time_base3 ;
extern unsigned char commandStream[2048];
extern unsigned char trace_framel  ;
extern unsigned char trace_frameh  ;
extern unsigned char exe_bp_addr0  ;
extern unsigned char exe_bp_addr1  ;
extern unsigned char break_type_in  ;
extern unsigned char break_type_out ;
extern unsigned char trigger_condition  ;
extern unsigned char trigger_type ;
extern unsigned char EPstatus ;
extern unsigned char save_reg[504];
extern unsigned int check_exe  ;
extern unsigned int check_exe_id  ;
extern unsigned char EP_type   ;
extern unsigned char reg_value0   ;
extern unsigned char reg_value1   ;
extern unsigned int  register_id ;
extern unsigned char  reset_type ;
extern unsigned char  EPrunningFlag ;
extern unsigned char trigger_condition_bak  ;
extern unsigned char spoon_data0  ;
extern unsigned char spoon_data1  ;
extern unsigned char control_set_bak  ;
extern unsigned char sel_clk  ;
extern unsigned char PortValue  ;
extern unsigned char status_low ;
extern unsigned char status_high ;
extern unsigned char checksum_low ;
extern unsigned char checksum_high ;
extern unsigned char compare_low ;
extern unsigned char compare_high ;
extern unsigned char copy_low ;
extern unsigned char copy_high ;
extern unsigned char fill_low ;
extern unsigned char fill_high ;
extern unsigned char read_memory[1024] ;
extern unsigned char rd_mem_length_low ;
extern unsigned char rd_mem_length_high ;
extern unsigned int  rd_mem_length ;
extern unsigned int  SearchResoult ;
extern unsigned int  TestResoult ;
extern unsigned int  search_low ;
extern unsigned int  search_high ;
extern unsigned int  test_low ;
extern unsigned int  test_high ;
extern unsigned char Select_break;
extern unsigned int  find_bp_low ;
extern unsigned int  find_bp_high ;
extern unsigned char go_till_addrl ;
extern unsigned char go_till_addrh  ;
extern bit step_range_flag;
extern bit go_till_flag;
extern unsigned char emu_add[16383];
extern unsigned char ep_support[30] ;
extern unsigned char EvQfStatus ;
extern unsigned char event1_buffer[128] ;
extern unsigned char event2_buffer[128] ;
extern unsigned char qualify_buffer[128] ;
extern unsigned char trace_frame_over ;
extern unsigned char trace_frame_number ;
extern unsigned char get_trace_framel[256];
extern unsigned char get_trace_frameh[256];
extern unsigned char get_trace_addrl[256];
extern unsigned char get_trace_addrh[256];
extern unsigned char get_trace_rb[256];
extern unsigned char get_trace_port[256];
extern unsigned char traceCntLow  ;
extern unsigned char traceCntHigh ;
extern unsigned int TStreamLen;
extern unsigned char TransmitBuf[2048] ;
extern unsigned char sel_ev3 ;


                        /****************************
                         *                          *
                         *    LOCAL    VARIABLES    *
                         *                          *
                         ****************************/

unsigned char retvalue;
unsigned char diagnostic_flag ;

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

void ProcessCommand(void) ;

/***************************************************************************
**
**  ProcessCommand
**
**  Description: Idnetidy then command ID and call FW function.
**
**  Parameters:
**     input:
**        commandStream : Global varible commandStream.
**        commandStreamLen : Global varible length of commandStream.
**     output:
**        1. errNo(char) : The command execute result. Function return value.
**        2. outputStream :
**
****************************************************************************/
void ProcessCommand(void) {
unsigned int i,jj;
   TStreamLen = 1;
   diagnostic_flag = 0x0 ;
   switch ( commandStream[0] )
   {
       case FW_SUPPORT_GET :
         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = 22 ;
         TransmitBuf[2] = 0x0;
         TransmitBuf[3] = PIC16C54-1  ;
         TransmitBuf[4] = 0x0  ;
         TransmitBuf[5] = PIC16C54A-1 ;
         TransmitBuf[6] = 0x0  ;
         TransmitBuf[7] = PIC16CR54-1 ;
         TransmitBuf[8] = 0x0  ;
         TransmitBuf[9] = PIC16C55-1  ;
         TransmitBuf[10] = 0x0  ;
         TransmitBuf[11] = PIC16C56-1  ;
         TransmitBuf[12] = 0x0  ;
         TransmitBuf[13] = PIC16C57-1  ;
         TransmitBuf[14] = 0x0  ;
         TransmitBuf[15] = PIC16CR57A-1;
         TransmitBuf[16] = 0x0  ;
         TransmitBuf[17] = PIC16C58A-1 ;
         TransmitBuf[18] = 0x0  ;
         TransmitBuf[19] = PIC16CR58A-1;
         TransmitBuf[20] = 0x0  ;
         TransmitBuf[21] = PIC16C61-1  ;
         TransmitBuf[22] = 0x0  ;
         TransmitBuf[23] = PIC16C620-1 ;
         TransmitBuf[24] = 0x0  ;
         TransmitBuf[25] = PIC16C621-1 ;
         TransmitBuf[26] = 0x0  ;
         TransmitBuf[27] = PIC16C622-1 ;
         TransmitBuf[28] = 0x0  ;
         TransmitBuf[29] = PIC16C62A-1 ;
         TransmitBuf[30] = 0x0  ;
         TransmitBuf[31] = PIC16C63-1  ;
         TransmitBuf[32] = 0x0  ;
         TransmitBuf[33] = PIC16C64A-1 ;
         TransmitBuf[34] = 0x0  ;
         TransmitBuf[35] = PIC16C65A-1 ;
         TransmitBuf[36] = 0x0  ;
         TransmitBuf[37] = PIC16C71-1  ;
         TransmitBuf[38] = 0x0  ;
         TransmitBuf[39] = PIC16C72-1  ;
         TransmitBuf[40] = 0x0  ;
         TransmitBuf[41] = PIC16C73A-1 ;
         TransmitBuf[42] = 0x0  ;
         TransmitBuf[43] = PIC16C74A-1 ;
         TransmitBuf[44] = 0x0  ;
         TransmitBuf[45] = PIC16C84-1  ;
         TransmitBuf[46] = 0x0  ;
         TStreamLen = 47 ;
         break;

      case EP_SUPPORT_GET :
         fw_ep_support_get();
         for(i=1;i<=30;i=i+2)
           {
              ep_support[i] = ep_support[i]-1  ;  //because sw need
           }
         memcpy(&TransmitBuf[3],&ep_support[1],30) ;
         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = ep_support[0];
         TransmitBuf[2] = 0x0;
         TStreamLen = 31;
         break;

    case MHZ_GET:
         retvalue = fw_Mhz_get() ;
         TransmitBuf[0] = retvalue;
         TransmitBuf[1] = target_clock0 ;
         TransmitBuf[2] = target_clock1 ;
         TransmitBuf[3] = target_clock2 ;
         TransmitBuf[4] = (target_clock3 & 0x7f);
         TransmitBuf[5] = is_mhz ;
         TStreamLen = 6;


         break;

    case DIAGNOSTIC:
         fw_diagnostic();
         diagnostic_flag = 0x1 ;
         break;


      case TIMER_GET:
         exe_calculate() ;
         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = exe_time0;
         TransmitBuf[2] = exe_time1;
         TransmitBuf[3] = exe_time2;
         TransmitBuf[4] = (exe_time3 & 0x7f);
         TStreamLen = 5;
         break;

      case FWID_GET:
         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = fw_version_high ;
         TransmitBuf[2] = fw_version_low ;
         TStreamLen = 3;
         break;


      case CPU_SELECT :
         retvalue = fw_cpu_select();
            TransmitBuf[0] = retvalue;
            TransmitBuf[1] = EP_type -1;
            TransmitBuf[2] = 0x0 ;
            TStreamLen = 3;
            break;

      case CPU_GET :
         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = EP_type - 1;
         TransmitBuf[2] = 0x0;
         TStreamLen = 3;
         break;

      case EP_START :
         retvalue = fw_ep_start();
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
         break;

      case EP_RESET :
            retvalue = fw_ep_reset();
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;


      case EP_HALT :
         retvalue = fw_ep_halt();
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
         break;

      case STATUS_GET :
            TransmitBuf[0] = CommandExeOk;
            if(spa_flag ==0x0)
            {
              if((status_low & 0x70) != 0x70)
               {
                if (check_eprunning() == EpNotrunning)
                   {
                     status_low = status_low & 0x8f | 0x60  ;// the status indicate halt
//                   i=Epsleeping_check()  ;
                   }
                else
                   {
                     status_low = status_low & 0x8f | 0x40  ;// the status indicate running
//                   i=Epsleeping_check()  ;
                   }
               }
            }

            TransmitBuf[1] = status_low;
            TransmitBuf[2] = status_high;
            TStreamLen = 3;
         break;

      case CONTROL_SET :
         retvalue = fw_control_set();
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
         break;

      case CONTROL_GET :
            retvalue = fw_control_get();
            TransmitBuf[0] = CommandExeOk;
            TransmitBuf[1] = retvalue;
            TStreamLen = 2;
         break;


      case LASTFRAME_GET :
         retvalue = fw_lastframe_get() ;
            TransmitBuf[0] = retvalue;
            TransmitBuf[1] = traceCntLow ;
            TransmitBuf[2] = traceCntHigh ;
            TStreamLen = 3;
            break;

      case QUALIFY_SET :
            retvalue = fw_event_set();
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
            break;

      case EVENT_SET :
            retvalue = fw_event_set();
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
            break;

      case EVENT_CLR :
         retvalue = fw_event_clr();
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
            break;

      case QUALIFY_CLR :
         retvalue = fw_event_clr();
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
            break;

      case EVENT_GET :
         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = EvQfStatus;  // bit0: Qualify. bit1: Ev1. bit2: Ev2.
         TransmitBuf[2] = 0x1;
         memcpy(&TransmitBuf[0x3],qualify_buffer,30);     // qualify
         memcpy(&TransmitBuf[0x3+30],event1_buffer,30);  // event1
         memcpy(&TransmitBuf[0x3+30+30],event2_buffer,30); // event2
         TStreamLen =  3 + 90 ;       
         break;                       

      case PORT_OUT :
         retvalue = fw_port_out();
         TransmitBuf[0] = retvalue;
         TStreamLen = 1;
         break;

      case PORT_IN :
         retvalue = fw_port_in();
         TransmitBuf[0] = retvalue;
         TransmitBuf[1] = PortValue   ;
         TStreamLen = 2;
         break;

      case VERIFY_SET :
// 0 OFF,   1 ON
         retvalue = fw_verify_set();
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
         break;

      case TRIG_STATUS_SET :
// 0 OFF,   1 ON
         retvalue = fw_trig_status_set();
         TransmitBuf[0] = retvalue;
         TStreamLen = 1;
         break;

      case TRIG_LOGIC_SET :
         retvalue = fw_trig_logic_set();
         TransmitBuf[0] = retvalue;
         TStreamLen = 1;
         break;

      case TRACE_INI :
         retvalue = fw_trace_ini();
         TransmitBuf[0] = retvalue;
         TStreamLen = 1;
         break;

      case TRACE_C_READ :
         retvalue = TraceCRead() ;
         if (retvalue == CommandExeOk)
           {
             TransmitBuf[0] = retvalue;
             break ;
           }
          else
           {
             TransmitBuf[0] = retvalue;
             TStreamLen = 1;
             break ;
           }
      case TRACE_READ :
         retvalue = fw_trace_read();
         TransmitBuf[0] = retvalue ;             //commandExeOk
         TransmitBuf[1] = trace_frame_number ;   //frame number
         TransmitBuf[2] = trace_frame_over   ;   //over flag
         for(i=0; i<trace_frame_number;i++)
           {
            TransmitBuf[2+ i*6 +1] = get_trace_framel[i] ;
            TransmitBuf[2+ i*6 +2] = get_trace_frameh[i] ;
            TransmitBuf[2+ i*6 +3] = get_trace_addrl[i] ;
            TransmitBuf[2+ i*6 +4] = get_trace_addrh[i] ;
            TransmitBuf[2+ i*6 +5] = get_trace_rb[i] ;
            TransmitBuf[2+ i*6 +6] = get_trace_port[i] ;
            }
               TStreamLen = 3 + trace_frame_number * 6 ;
         break;


      case MEM_CHECKSUM :
         retvalue = fw_mem_checksum();
            if ( retvalue == CommandExeOk )
              {
               TransmitBuf[0] = retvalue;
               TransmitBuf[1] = checksum_low;
               TransmitBuf[2] = checksum_high;
               TStreamLen = 3;
              }
            else
              {
               TransmitBuf[0] = retvalue;
               TStreamLen = 1;
              }
         break;

      case MEM_COMPARE :
         retvalue = fw_mem_compare();
            if (retvalue == MemWrFail)
              {
               TransmitBuf[0] = retvalue;
               TransmitBuf[1] = commandStream[1] ;
               TransmitBuf[2] = compare_low;
               TransmitBuf[3] = compare_high;
               TStreamLen = 4;
              }
            else
              {
               TransmitBuf[0] = retvalue;
               TStreamLen = 1;
              }
         break;

      case MEM_COPY :
         retvalue = fw_mem_copy();
            if (( retvalue != CommandExeOk ) && (retvalue != MemWrFail))
              {
               TransmitBuf[0] = retvalue;
               TransmitBuf[1] = commandStream[1] ;
               TransmitBuf[2] = copy_low;
               TransmitBuf[3] = copy_high;
               TStreamLen = 4;
              }
            else
              {
               TransmitBuf[0] = retvalue;
               TStreamLen = 1;

              }
         break;


      case MEM_FILL :
         retvalue = fw_mem_fill();
            if (retvalue == MemWrFail)
              {
               TransmitBuf[0] = retvalue;
               TransmitBuf[1] = commandStream[1] ;
               TransmitBuf[2] = fill_low;
               TransmitBuf[3] = fill_high;
               TStreamLen = 4;
              }
            else
              {
               TransmitBuf[0] = retvalue;
               TStreamLen = 1;
              }
            break;

      case MEM_READ :
            retvalue = fw_mem_read () ;
            if (retvalue != EpRunning)
                {
                   TransmitBuf[0] = retvalue;
                   TransmitBuf[1] = rd_mem_length_low ;
                   TransmitBuf[2] = rd_mem_length_high ;
                   for(i=0; i<=rd_mem_length; i++)
                       {
                          TransmitBuf[3+i] = read_memory[i] ;
                       }

                  TStreamLen = 3+rd_mem_length;
                }
              else
                {
                   TransmitBuf[0] = retvalue;
                   TStreamLen = 1;
                }
            break;

      case MEM_SEARCH :
            retvalue = fw_mem_search();
            if (retvalue==EpRunning)
              {
                TransmitBuf[0] = retvalue;
                TStreamLen = 1;
              }
            if (retvalue==CommandExeOk)
              {
                if(SearchResoult==MemSearchNotFind)
                  {
                    TransmitBuf[0] = retvalue;
                    TransmitBuf[1] = SearchResoult;
                    TStreamLen = 2;
                  }
                else
                  {
                    TransmitBuf[0] = retvalue;
                    TransmitBuf[1] = SearchResoult;
                    TransmitBuf[2] = commandStream[1];
                    TransmitBuf[3] = search_low;
                    TransmitBuf[4] = search_high;
                    TStreamLen = 5;
                  }
              }
         break;

      case MEM_TEST :
            retvalue = fw_mem_test();
            if (retvalue==EpRunning)
              {
                TransmitBuf[0] = retvalue;
                TStreamLen = 1;
              }
            if (retvalue==CommandExeOk)
              {
                if(TestResoult==MemWrOk)
                  {
                    TransmitBuf[0] = retvalue;
                    TransmitBuf[1] = TestResoult;
                    TStreamLen = 2;
                  }
                else
                  {
                    TransmitBuf[0] = retvalue;
                    TransmitBuf[1] = TestResoult;
                    TransmitBuf[2] = commandStream[1] ;
                    TransmitBuf[3] = test_low;
                    TransmitBuf[4] = test_high;
                    TStreamLen = 5;
                  }
              }
         break;


      case REG_GETLEN :
         TransmitBuf[0] = CommandExeOk;
         TransmitBuf[1] = 0xe0;
         TransmitBuf[2] = 0x01;
         TStreamLen = 3;
         break;

      case REG_GETALL :

     if (EP_type<=PIC16CR58A)
       {
         if(Epsleeping_check()==EPsleeping)  //check whether the ep is sleep
            {
              TransmitBuf[0] = EPsleeping ;
              TStreamLen = 1;
            }
        else
           {
             if((EPrunningFlag == 0x1)&& (spa_flag == 0))

               {
                 TransmitBuf[0] = EpRunning ;            //the ep is running
                 TStreamLen = 1;
               }
             else
               {
                 for (i=1; i<=243; i=i+2)
                   {
                     if( i == 1)
                       {
                         TransmitBuf[i] = save_reg[0] ;
                         TransmitBuf[i+1] = save_reg[1] ;
                       }
                     if( i == 3)
                       {
                         TransmitBuf[i] = save_reg[0xd] ;
                         TransmitBuf[i+1] = save_reg[0xe] ;
                       }
                     if( i == 5)
                       {
                         TransmitBuf[i] = save_reg[0xf] ;
                         TransmitBuf[i+1] = save_reg[0x10] ;
                       }
                     if(( i >= 19) && (i <= 39))
                       {
                         TransmitBuf[i] = save_reg[(i/2)-7] ;
                         TransmitBuf[i+1] = 0x0 ;
                       }
                     if( i >= 101)
                       {
                         TransmitBuf[i] = save_reg[(i/2)-33] ;
                         TransmitBuf[i+1] = 0x0 ;
                       }

                   }
                 TransmitBuf[0] = CommandExeOk;
                 TStreamLen = 244;
               }
           }
      }
      
   if (EP_type>=PIC16C61)
       {
        if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
           {
             TransmitBuf[0] = EPsleeping ;
             TStreamLen = 1;
           }
        else
           {
             if((EPrunningFlag == 0x1)&& (spa_flag == 0))
               {
                 TransmitBuf[0] = EpRunning ;            //the ep is running
                 TStreamLen = 1;
               }
             else
               {
                 for (i=0; i<=124; i=i+1)
                   {
                    TransmitBuf[i+1] = save_reg[i] ;
                   }
                 TransmitBuf[0] = CommandExeOk;
                 TStreamLen = 124;
               }
           }
      }

         break;

      case REG_GETONE :

     if (EP_type<=PIC16CR58A)
       {
         if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
           {
             TransmitBuf[0] = EPsleeping  ;
             TStreamLen = 1;
           }
        else
           {
             if((EPrunningFlag == 0x1)&& (spa_flag == 0))
               {
                 TransmitBuf[0] = EpRunning ;            //the ep is running
                 TStreamLen = 1;
               }
             else
               {
                 i = commandStream[1]+ commandStream[2]*256  ;
                     if( i == 0)
                       {
                         TransmitBuf[1] = save_reg[0] ;
                         TransmitBuf[2] = save_reg[1] ;
                       }
                     if( i == 1)
                       {
                         TransmitBuf[1] = save_reg[0xd] ;
                         TransmitBuf[2] = save_reg[0xe] ;
                       }
                     if( i == 2)
                       {
                         TransmitBuf[1] = save_reg[0xf] ;
                         TransmitBuf[2] = save_reg[0x10] ;
                       }
                     if(( i >= 9) && (i <= 19))
                       {
                         TransmitBuf[1] = save_reg[i-7] ;
                         TransmitBuf[2] = 0x0 ;
                       }
                     if( i >= 50)
                       {
                         TransmitBuf[1] = save_reg[i-33] ;
                         TransmitBuf[2] = 0x0 ;
                       }
                 TransmitBuf[0] = CommandExeOk;
                 TStreamLen = 3;
               }
           }
      }



   if (EP_type>=PIC16C61)
       {
         if(Epsleeping_check()==EPsleeping)      //check whether the ep is sleep
           {
             TransmitBuf[0] = EPsleeping ;
             TStreamLen = 1;
           }
        else
           {
             if((EPrunningFlag == 0x1)&& (spa_flag == 0))
               {
                 TransmitBuf[0] = EpRunning ;            //the ep is running
                 TStreamLen = 1;
               }
             else
               {
                 i = commandStream[1]+ commandStream[2]*256  ;
                 i = i + i;
                 TransmitBuf[0] = CommandExeOk;
                 TransmitBuf[1] = save_reg[i] ;
                 TransmitBuf[2] = save_reg[i+1];
                 TStreamLen = 3;
               }
         }
      }

         break;

      case REG_MODIFY :
         retvalue = fw_reg_modify();
         TransmitBuf[0] = retvalue;
         TStreamLen = 1;
         break;

      case BP_SET :
         retvalue = fw_bp_set();
         TransmitBuf[0] = retvalue;
         TStreamLen = 1;
         break;
      case BP_CLR :
         retvalue = fw_bp_clr();
         TransmitBuf[0] = retvalue;
         TStreamLen = 1;
         break;
      case BP_QUERY :
         retvalue = fw_get_bp();
         TransmitBuf[0] = retvalue;
         if(retvalue == BpFound)
          {
            TransmitBuf[1] = 0x1;
            TransmitBuf[2] = find_bp_low ;
            TransmitBuf[3] = find_bp_high ;
            TStreamLen = 4;
          }
         else
         {
           TStreamLen = 1;
         }
         break;

      case STEP_ONE :
            retvalue = fw_step_one();
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
            break;
      case STEP_OVER :
            retvalue = fw_step_over();
            TransmitBuf[0] = retvalue;
            TStreamLen = 1;
            break ;

      case TRIG_GET:
            TransmitBuf[0] = CommandExeOk;
            TransmitBuf[1] = trigger_condition ;
            TransmitBuf[2] = trigger_type      ;
            TStreamLen = 3;
         break;

      case SELECT_BAUDRATE:
            TransmitBuf[0] = CommandExeOk;
            TStreamLen = 1;
         break;

      case SELECT_TRACE_BANK :
         retvalue = fw_trace_bank()  ;
         TransmitBuf[0] = retvalue;
         TStreamLen = 1;
         break;

      case SELECT_TRACE_CC :
         retvalue = fw_trace_cc()  ;
         TransmitBuf[0] = retvalue;
         TStreamLen = 1;
         break;

      case SELECT_EV3 :
         retvalue = fw_select_ev3()  ;
         TransmitBuf[0] = retvalue;
         TStreamLen = 1;
         break;

      case EV3_STATUS :
         TransmitBuf[0] = CommandExeOk ;
         TransmitBuf[1] = sel_ev3 ;
         TStreamLen = 2;
         break;

      case SPA_BP_SET :
         retvalue = fw_SpaBreakpointSet()  ;
         TransmitBuf[0] = retvalue;
         TStreamLen = 1;
         break;

      case COVERAGE_GO :
         retvalue = fw_CoverageGo()  ;
         TransmitBuf[0] = retvalue;
         TStreamLen = 1;
         break;

      case COVERAGE_GET :
           fw_SpaCoverageGet() ;
           break ;

      case GET_CYCLE_BASE :
           exe_calculate_base() ;
           TransmitBuf[0] = CommandExeOk;
           TransmitBuf[1] = exe_time_base0;
           TransmitBuf[2] = exe_time_base1;
           TransmitBuf[3] = exe_time_base2;
           TransmitBuf[4] = (exe_time_base3 & 0x7f);
           TStreamLen = 5;
           break ;

      case CHECK_COMMUNICATION :
           TransmitBuf[0] = CommandExeOk ;
           for(i=1;i<=256;i=i+1)
              {
               TransmitBuf[i] =  commandStream[i];
              }            
           TStreamLen = 257;
           break ;

      case COMM_INI :
         break_ini()  ;
         TransmitBuf[0] = CommandExeOk ;
         TStreamLen = 1;
         break;
      defalut:
           TransmitBuf[0] = CommandExeOk ;
           TStreamLen = 1 ;
           break ;

  }
}
