/**************************************************************************
**
** $Header:
**
** $Log:
** 
**
** Initial revision. 1.0
** 
***************************************************************************/
/****************************************************************************
**
**  Name:         xfwcomm.c
**
**  Description:  The communcation protocol
**
**  Status:  PRELIMINARY
**
**  Copyright (C) 1996 Microtek International.	All rights reserved.
*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <reg51.h>
#include "xfwcmd.h"
#include "io.h"


                        /****************************
                         *                          *
                         *    EXTERNAL code         *
                         *                          *
                         ****************************/

extern unsigned char ReceiveByte(void);
extern void TRANSMITBYTE(unsigned char);

                        /****************************
                         *                          *
                         *    LOCAL    VARIABLES    *
                         *                          *
                         ****************************/

unsigned char retvalue;
unsigned int  TStreamLen;
unsigned char TransmitBuf[2048] ;
unsigned char chksum;
unsigned int commandStreamLen;
unsigned char commandStream[2048];
unsigned char receiveBuf[2048];
void ReceiveStream(void);
void TransmitStream(void);


/****************************************************************************
**
**  ReceiveStream
**
**  Description: Receive data from communication and check the length and
**               checksum, the data format is :       XXXXxxx....xxxX
**                                                  length   data   checksum
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
void ReceiveStream(void)
{
register unsigned int lp;
unsigned char aa[4];
unsigned int  RStreamLen;
// aa[0] store LEAD_CODE
// aa[1] store Data Length High
// aa[2] store Data Length Low
// aa[3] store chksum
// aa[0] + aa[1] + aa[2] + aa[3] == 0

   RStreamLen = 0;
   chksum = 0;

   while(1) {
      // receive leading code and data length and checksum.

      aa[0] = 0;
      aa[1] = 0;
      aa[2] = 0;
      aa[3] = 0;
//      TimerOut = 0;
//      ChkTimerOut = 0;
//      TimCount = 0;


      while ( 1)
      {
         aa[0] =  ReceiveByte();
         if (aa[0] == '?')  break;
      }

         TRANSMITBYTE('!');
while(1)
       {
          lp = 0;
          while( lp < 4 )
                 {
                  aa[lp] = ReceiveByte();
//                      TimCount = 0;
                  lp ++;
                  if( aa[0] != LEAD_CODE ) lp = 0;
//                      else ChkTimerOut = 1;
//                      if (TimerOut) break;
                   }

//                      if (TimerOut) continue;   // To restart ReceiveStream

            for (lp = 1; lp < 4; lp++) chksum += aa[lp];
            if ((aa[0] == LEAD_CODE) && (chksum == 0)) // command length.
               {
                RStreamLen =(unsigned int)aa[2] * 256 + aa[1];
                TRANSMITBYTE(REC_OK);
                break;
                }
                else
                {
                TRANSMITBYTE(REC_FAIL);
                continue;                    // To restart ReceiveString.
                }
        }

while(1)
{
         aa[0] = ReceiveByte();
         if (aa[0] == '$') break;
         chksum = 0;
         for (lp = 0; lp < RStreamLen; lp++) {
//               TimCount = 0;
              receiveBuf[lp] = ReceiveByte();
//                if ( TimerOut ) break;
              chksum += receiveBuf[lp];
              }
//                if ( TimerOut) continue;
           if (chksum == 0) {    // The End of ReceiveBuf char is Data checksum
               memcpy(commandStream,&receiveBuf[0],RStreamLen);
               commandStreamLen = RStreamLen;
               TRANSMITBYTE(ACK);
//             while (1)
//                {
//                if (ReceiveByte() == ACK) break;
//                }
//                ChkTimerOut = 0;
               return;
               }
           else TRANSMITBYTE(NACK);

}
if (aa[0] == '$') continue;
   }
}



/****************************************************************************
**
**  ReceiveByte
**
**  Description: Receive one byte from communication.
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/

/****************************************************************************
**
**  TRANSMITBYTE
**
**  Description: Transmit one byte from communication.
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/




/****************************************************************************
**
**  TransmitStream
**
**  Description: Transmit data(length + data + checksum) to
**               communication port.
**               the data format is :  XXXXxxx....xxxX
**                                   length   data   checksum
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
/*
   Transmit data(length + data + checksum) to communication port.
   the data format is : LENGTH(2 bytes)DATA(number of length)CHECKSUM(1 byte)
*/
void TransmitStream(void) {

register unsigned int lp;
unsigned char highLen,lowLen,aa;

   chksum = 0;
   for (lp = 0; lp < TStreamLen; lp++)
      chksum += TransmitBuf[lp];
   TransmitBuf[TStreamLen] = ( unsigned char )(~chksum+1);
   TStreamLen++;

   highLen = (unsigned char)(TStreamLen/256);
   lowLen =  (unsigned char) TStreamLen;
   chksum = (unsigned char) (~(lowLen+highLen) ) + 1;

   while (1) {
              while(1)
              {
              TRANSMITBYTE('?');
              aa = ReceiveByte();
              if ( aa == '!') break;
              }
              while (1) {
                         TRANSMITBYTE(LEAD_CODE);
                         TRANSMITBYTE(lowLen);
                         TRANSMITBYTE(highLen);
                         TRANSMITBYTE(chksum);
                         aa = ReceiveByte();
                         if ( aa == '$') break;
                         if ( aa == REC_OK ) break;
                         }
              if ( aa == '$') continue;
              while (1)
                         {
                         TRANSMITBYTE(LEAD_CODE);
                         for (lp = 0; lp < TStreamLen; lp++)
                             TRANSMITBYTE(TransmitBuf[lp]);
                         aa = ReceiveByte();
                         if (aa == '$') break;
                         if (aa == ACK)          return ;
                         }
              if (aa == '$') continue;
              }
}


