/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/AA.CPP   1.6   20 Jun 1996 09:30:22   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/AA.CPP  $
** 
**    Rev 1.6   20 Jun 1996 09:30:22   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.4   10 Jun 1996 10:25:00   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.2   29 May 1996 09:38:34   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// aa.cpp
//
// Roger Zhang
//                                                                           
// 5/2/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "aa.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void AATool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);
    dc << "m_fCase = " << m_fCase << "\n";
    dc << "m_fDebug = " << m_fDebug << "\n";
    dc << "m_fList = " << m_fList << "\n";
    dc << "m_fListAll = " << m_fListAll << "\n";
    dc << "m_fOptimize = " << m_fOptimize << "\n";
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void AATool::SetDefault(void)
{
    m_fCase = FALSE;
    m_fDebug = TRUE;
    m_fList = FALSE;
    m_fListAll = FALSE;
    m_fOptimize = FALSE;
    m_strMore = "NOPR";
    m_strPath = "c:\\cc51 ";
}

BOOL AATool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 5;
    
    char ach[nCnt];
    
    if(fread(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_fCase = ach[0];
    m_fDebug = ach[1];
    m_fList = ach[2];
    m_fListAll = ach[3];
    m_fOptimize = ach[4];
    
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);
    
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}                 

BOOL AATool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 5;

    char ach[nCnt];
    
    ach[0] = m_fCase;
    ach[1] = m_fDebug;
    ach[2] = m_fList;
    ach[3] = m_fListAll;
    ach[4] = m_fOptimize;
    
    if(fwrite(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = m_strMore.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
              
    wLen =  m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);
    return TRUE;
}

CString AATool::GetOption(void) const
{
    CString str = " ";
    
    if(m_fCase)
        str += "CA ";
        
    if(!m_fDebug)
        str += "NODB ";
        
    if(!m_fList)
        str += "NOLI ";
        
    if(m_fListAll)   
        str += "LA ";
        
    if(!m_fOptimize)
        str += "NOOP ";
    
    str += m_strMore;
    str += " ";
    
    return str;
}

