/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/AC.CPP   1.6   20 Jun 1996 09:30:04   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/AC.CPP  $
** 
**    Rev 1.6   20 Jun 1996 09:30:04   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.4   10 Jun 1996 10:24:42   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.2   29 May 1996 09:37:42   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// ac.cpp
//
// Roger Zhang
//                                                                           
// 5/2/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "ac.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void ACTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);
    dc << "m_nRegBank = " << m_nRegBank << "\n";
    dc << "m_nMemoryModel = " << m_nMemoryModel << "\n";
    dc << "m_nOptimize = " << m_nOptimize << "\n";
    dc << "m_fStrInRom = " << m_fStrInRom << "\n";
    dc << "m_fUChar = " << m_fUChar << "\n";
    dc << "m_fNoWarn = " << m_fNoWarn << "\n";
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void ACTool::SetDefault(void)
{
    m_nRegBank = 0;     // 0-3
    m_nMemoryModel = 2; // 0 - 3 = s,a,l,r
    m_nOptimize = 0;    // 0 - 3
    m_fStrInRom = TRUE;
    m_fUChar = FALSE;
    m_fNoWarn = FALSE;
    m_strMore = "-err -t -g -s -C51";
    m_strPath = "c:\\cc51 ";
}

BOOL ACTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 6;
    
    char ach[nCnt];
    
    if(fread(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_nRegBank = ach[0];
    m_nMemoryModel = ach[1];
    m_nOptimize = ach[2];
    m_fStrInRom = ach[3];
    m_fUChar = ach[4];
    m_fNoWarn = ach[5];
    
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);
     if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}                 

BOOL ACTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 6;

    char ach[nCnt];
    
    ach[0] = m_nRegBank;
    ach[1] = m_nMemoryModel;
    ach[2] = m_nOptimize;
    ach[3] = m_fStrInRom;
    ach[4] = m_fUChar;
    ach[5] = m_fNoWarn;
    
    if(fwrite(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = m_strMore.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);
     
    wLen = m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen); 
    
    return TRUE;
}   
                            
static char * ar1[4] = { "-b0 ", "-b1 ", "-b2 ", "-b3 " };
static char * ar2[4] = { "-Ms ", "-Ma ", "-Ml ", "-Mr " };
static char * ar3[4] = { "-O0 ", "-O1 ", "-O2 ", "-O3 " };

CString ACTool::GetOption(void) const
{
    CString str = " ";
    
    str = ar1[m_nRegBank];
    str += ar2[m_nMemoryModel];
    str += ar3[m_nOptimize];
    
    if(m_fStrInRom)
        str += "-S ";
        
    if(m_fUChar)
        str += "-u ";
        
    if(m_fNoWarn)
        str += "-w ";
        
    str += m_strMore;
    str += " ";
    
    return str;     
}

