/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/ALIB.CPP   1.4   20 Jun 1996 09:29:18   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/ALIB.CPP  $
** 
**    Rev 1.4   20 Jun 1996 09:29:18   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.2   10 Jun 1996 10:23:56   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.0   29 May 1996 09:35:28   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// al.cpp
//
// Roger Zhang
//                                                                           
// 5/2/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "alib.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void ALIBTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);                    
    dc << "m_nMemoryModel = " << m_nMemoryModel << "\n";
    dc << "m_float = " << m_float << "\n";
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void ALIBTool::SetDefault(void)
{                                                    
    m_nMemoryModel=2;
    m_float   = TRUE;
    m_strMore = " ";
    m_strPath = "c:\\cc51 ";
}

BOOL ALIBTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 2;
    
    char ach[nCnt];
    
    if(fread(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_nMemoryModel = ach[0];
    m_float = ach[1];
   
    
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen); 
     
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen); 
    
    return TRUE;
}                 

BOOL ALIBTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 2;

    char ach[nCnt];
    
    ach[0] = m_nMemoryModel;
    ach[1] = m_float;
        
    if(fwrite(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = m_strMore.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    wLen = m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}
 
static char * ar1[4] = { "c51s.lib  ", "c51a.lib ", "c51l.lib ", "c51r.lib " }; 

CString ALIBTool::GetOption(void)
{
    CString str = " "; 
    CString alibstr;
    if(m_strPath[m_strPath.GetLength()-1]!='\\')
    alibstr = m_strPath + "\\"; 
    str += alibstr;
    str += ar1[m_nMemoryModel];
   
    if(m_float)
    {
    str +=",";
    str += alibstr;
    str += "float.lib ";
    }
    str += m_strMore;
    str += " ";
    
    return str;
}

