/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/AOPT.CPP   1.6   20 Jun 1996 09:28:22   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/AOPT.CPP  $
** 
**    Rev 1.6   20 Jun 1996 09:28:22   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.4   10 Jun 1996 10:23:00   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.2   29 May 1996 09:34:02   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// aopt.cpp
//
// Roger Zhang
//                                                                           
// 5/6/1996
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "resource.h"
#include "toolopt.h"    
#include "ac.h"
#include "acoption.h"
#include "aa.h"
#include "aaoption.h"
#include "al.h"
#include "aloption.h"
#include "ae.h"
#include "aeoption.h"
#include "alib.h"
#include "alibopti.h"
#include "atab.h"
#include "projopt.h"
#include "aopt.h"   

/////////////////////////////////////////////////////////////////////////////
// operations
void AOption::SetOption(CWnd *pParent)
{
    CATab dlg(&m_acTool, &m_aaTool, &m_alTool, &m_alibTool,&m_aeTool, pParent);
    dlg.DoModal();
}

BOOL AOption::SaveOption(FILE * fp)
{                              
    ASSERT(fp);
    
    if(!m_acTool.SaveOption(fp))
        return FALSE;
    if(!m_aaTool.SaveOption(fp))
        return FALSE;
    if(!m_alTool.SaveOption(fp))
        return FALSE;
    if(!m_alibTool.SaveOption(fp))
        return FALSE;
    
    if(!m_aeTool.SaveOption(fp))
        return FALSE;
    if((_stricmp(m_aeTool.m_strPath," ")!=0)&&(_stricmp(m_aeTool.m_strProg,"c:\\ ")!=0))
       m_fValid=TRUE;
    else
       m_fValid=FALSE; 
    return TRUE;
}
                
BOOL AOption::LoadOption(FILE * fp)
{                              
    ASSERT(fp);
    
    if(!m_acTool.LoadOption(fp))
        return FALSE;
    if(!m_aaTool.LoadOption(fp))
        return FALSE;
    if(!m_alTool.LoadOption(fp))
        return FALSE;
    if(!m_alibTool.LoadOption(fp))
        return FALSE;
    if(!m_aeTool.LoadOption(fp))
        return FALSE;
    if((_stricmp(m_aeTool.m_strPath," ")!=0)&&(_stricmp(m_aeTool.m_strProg,"c:\\ ")!=0))
       m_fValid=TRUE;
    else
       m_fValid=FALSE;   
    return TRUE;
}                
    
// return 0:c file, 1:asm file, 2:other file(library)    
int AOption::GetFileType(LPCSTR lpcszFile) const
{              
    ASSERT(lpcszFile);

    char ext[_MAX_EXT];

    _splitpath(lpcszFile, NULL, NULL, NULL, ext);
    if(_stricmp(ext, ".c") == 0) {
        return 0;                
    } else if(_stricmp(ext, ".asm") == 0) {
        return 1;
    } else {
        return 2;
    }
}        

BOOL AOption::CreateLinkCmdFile(const CStringList &lst, LPCSTR lpcszProj )
{
    POSITION pos;
    CString str1, str2;
    FILE * fp;
    int i;
    
    fp = fopen(GetName(lpcszProj, ".cmd"), "wt");
    if(!fp)
        goto CMDFAIL;
             
    for(i = 0, pos = lst.GetHeadPosition(); pos != NULL; i ++) {
        str2 = lst.GetNext(pos);
        
        if(GetFileType(str2) != 2)
            str1 = GetName(str2, ".obj");
        else
            str1 = str2;
            
        if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) 
            != 1)
            goto CMDFAIL;
        else
            str1.ReleaseBuffer();
            
        if(i < lst.GetCount() - 1) {
            if(fputc(',', fp) == EOF)          
                goto CMDFAIL;
        } else {
            if(fputc(' ', fp) == EOF)          
                goto CMDFAIL;
        }
        if(fputc('\n', fp) == EOF)          
            goto CMDFAIL;
    }
  
    str1 = ",";
    
    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else 
        str1.ReleaseBuffer();
        
    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;           
        
    str1 = m_alibTool.GetOption();

    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else
        str1.ReleaseBuffer();
    
    if(fputc(' ', fp) == EOF)          
        goto CMDFAIL;
    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;

                      
    str1 = "to ";
    str1 += GetName(lpcszProj, ".out");                   
    
    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else 
        str1.ReleaseBuffer();
        
    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;
        
    str1 = m_alTool.GetOption();

    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else
        str1.ReleaseBuffer();

    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;

    fclose(fp);
    return TRUE;
                     
CMDFAIL:
    AfxMessageBox("Failed to create link command file!");                    
    if(fp)
        fclose(fp);
    return FALSE;
}                                              

BOOL AOption::WriteBatchFile(FILE * fp, LPCSTR lpcszText)
{
    ASSERT(fp);
    
    if(fwrite(lpcszText, lstrlen(lpcszText), 1, fp) != 1) 
        goto BATFAIL;
    if(fputc('\n', fp) == EOF)
        goto BATFAIL;
        
    return TRUE;

BATFAIL:    
    fclose(fp); 
    AfxMessageBox("Failed to create batch file!");
    return FALSE;
}


void AOption::Build(const CStringList &lst, LPCSTR lpcszProj )
{
    POSITION pos;   
    CString str;
    CString strBuild;
     CString cstr;
    CString astr;
    CString lstr;
    if((m_acTool.m_strPath)[(m_acTool.m_strPath).GetLength()-1]!='\\')
    cstr = m_acTool.m_strPath + "\\";
    if((m_aaTool.m_strPath)[(m_aaTool.m_strPath).GetLength()-1]!='\\')
    astr = m_aaTool.m_strPath + "\\";
    if((m_alTool.m_strPath)[(m_alTool.m_strPath).GetLength()-1]!='\\')
    lstr = m_alTool.m_strPath + "\\"; 
    int nType;                   
    FILE * fp; 
    fp = fopen( GetName(lpcszProj, ".bat"),"wt");
    if(!fp) {
        AfxMessageBox("Failed to create batch file!");
        return;
    }
    
    // compile or macro preprocess
    for(pos = lst.GetHeadPosition(); pos != NULL; ) {
        str = lst.GetNext(pos);
        nType = GetFileType(str);
        if(nType == 0) {    // c file
            strBuild  = cstr + "cc51.exe ";
            strBuild += m_acTool.GetOption();
            strBuild += str;
            strBuild += " -o ";
            strBuild +=  GetName(str, ".src");
            
        }else if(nType == 1) {// asm file
            strBuild = cstr + "mpp51.exe ";
            strBuild += str;            
            strBuild += " ";
            strBuild += GetName(str, ".src");
            
        }
         else {
            continue;
        }            
                
        if(!WriteBatchFile(fp, strBuild))
            return;
        
        // assemble
        strBuild =astr + "asm51.exe "; 
        strBuild += GetName(str, ".src");
        strBuild += " ";
        strBuild += m_aaTool.GetOption();
        strBuild += "OJ(";
        strBuild += GetName(str, ".obj");
        strBuild += ")";
        if(!WriteBatchFile(fp, strBuild))
            return;
    }                                   
    
    // link
    if(!CreateLinkCmdFile(lst, lpcszProj))
        return;
    strBuild = lstr + "link51.exe ";
    strBuild += "@"; 
    strBuild += GetName(lpcszProj, ".cmd");
    if(!WriteBatchFile(fp, strBuild))
        return;

    strBuild = lstr + "ieee51.exe ";       
    strBuild += GetName(lpcszProj, ".out");
    strBuild += " ";
    strBuild += GetName(lpcszProj, ".abs");
    if(!WriteBatchFile(fp, strBuild))
        return;
        
    fclose(fp);
    
    WinExec(GetName(lpcszProj, ".bat"), SW_SHOW);
}
 
 void AOption::Editor(void)
  {
   CString str;             
   FILE *fp;                  
   fp = fopen("aedit.bat","wt");
    if(!fp) {
        AfxMessageBox("Failed to create batch file!");
        return;
    }
    
    char drive[_MAX_DRIVE], dir[_MAX_DIR];
    char fname[_MAX_FNAME],  ext[_MAX_EXT];
   
    _splitpath(m_aeTool.m_strPath, drive, dir, fname, ext);
    if(_stricmp(ext,".exe")==0||_stricmp(ext,".com")==0)
    {
     AfxMessageBox("Editor command error!");
     return;
     }
   str = m_aeTool.GetOption();
   if(!WriteBatchFile(fp, str))
        return;
   
   fclose(fp);
   WinExec("aedit.bat", SW_SHOW);
} 
                