/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/BA.CPP   1.5   20 Jun 1996 09:29:52   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/BA.CPP  $
** 
**    Rev 1.5   20 Jun 1996 09:29:52   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.3   10 Jun 1996 10:24:30   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.1   29 May 1996 09:36:32   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// ba.cpp
//
// Michael Long
//                                                                           
// 5/13/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "ba.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void BATool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);
    dc << "m_fX = " << m_fX << "\n";
    dc << "m_fE = " << m_fE << "\n";
    dc << "m_fS = " << m_fS << "\n";
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void BATool::SetDefault(void)
{
    m_fX = TRUE;
    m_fE = FALSE;
    m_fS= TRUE;
    m_strMore = " F  ";
    m_strPath = "c:\\icc51 ";
}

BOOL BATool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 3;
    
    char bch[nCnt];
    
    if(fread(bch, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_fX = bch[0];
    m_fE = bch[1];
    m_fS = bch[2];
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}                 

BOOL BATool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 3;

    char bch[nCnt];
    
    bch[0] = m_fX;
    bch[1] = m_fE;
    bch[2] = m_fS;
    
  if(fwrite(bch, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = m_strMore.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    wLen = m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}

CString BATool::GetOption(void) const
{
    CString str = " ";
    
    if(m_fX)
        str += "X ";
        
    if(m_fE)
        str += "E ";
        
    if(m_fS)   
        str += "S ";
        
    str += m_strMore;
    str += " ";
    
    return str;
}

