/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/BC.CPP   1.5   20 Jun 1996 09:29:52   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/BC.CPP  $
** 
**    Rev 1.5   20 Jun 1996 09:29:52   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.3   10 Jun 1996 10:24:30   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.1   29 May 1996 09:36:32   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// bc.cpp
//
// Michael Long
//                                                                           
// 5/13/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "bc.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void BCTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);
    dc << "m_nMemoryModel = " << m_nMemoryModel << "\n";
    dc << "m_nOptimize = " << m_nOptimize << "\n";
    dc << "m_fStrInVariable = " << m_fStrInVariable << "\n";
    dc << "m_fSChar = " << m_fSChar << "\n";
    dc << "m_fNoWarn = " << m_fNoWarn << "\n";
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void BCTool::SetDefault(void)
{
    m_nMemoryModel = 0; 
    m_nOptimize = 1;    
    m_fStrInVariable = TRUE;
    m_fSChar = FALSE;
    m_fNoWarn = FALSE;
    m_strMore = " -r2 -b ";
    m_strPath = "c:\\icc51";
}

BOOL BCTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 5;
    
    char bch[nCnt];
    
    if(fread(bch, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_nMemoryModel = bch[0];
    m_nOptimize = bch[1];   
    m_fNoWarn = bch[2];
    m_fStrInVariable = bch[3];
    m_fSChar = bch[4];
        
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
   
     if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

     m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}                 

BOOL BCTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 5;

    char bch[nCnt];
    
    bch[0] = m_nMemoryModel;
    bch[1] = m_nOptimize;
    bch[2] = m_fNoWarn;
    bch[3] = m_fStrInVariable;
    bch[4] = m_fSChar;
      
    if(fwrite(bch, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = m_strMore.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    wLen = m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}   
                            
static char * br1[6] = { "-Mt ", "-Ms ", "-Mc ", "-Mm ","-Ml","-Mb" };
static char * br2[2] = { "-sx ", "-zx " };

CString BCTool::GetOption(void) const
{
    CString str = " ";
    
    str += br1[m_nMemoryModel];
    str += br2[m_nOptimize];
    
    if(m_fStrInVariable)
        str += "-y ";
        
    if(m_fSChar)
        str += "-c ";
        
    if(m_fNoWarn)
        str += "-w ";
        
    str += m_strMore;
    str += " ";
    
    return str;     
}

