/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/BE.CPP   1.4   20 Jun 1996 09:29:20   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/BE.CPP  $
** 
**    Rev 1.4   20 Jun 1996 09:29:20   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.2   10 Jun 1996 10:23:58   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.0   29 May 1996 09:35:32   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// ac.cpp
//
// Roger Zhang
//                                                                           
// 5/2/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "be.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void BETool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);
    dc << "m_strProg = " << m_strProg << "\n";
    dc << "m_strPath = " << m_strPath << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void BETool::SetDefault(void)
{
    
    m_strProg = "c:\\ ";
    m_strPath = "c:\\dos\\edit.com ";
}

BOOL BETool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strProg.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strProg.ReleaseBuffer(wLen);
     if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}                 

BOOL BETool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
             
    WORD wLen = m_strProg.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strProg.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strProg.ReleaseBuffer(wLen);
     
    wLen = m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen); 
    
    return TRUE;
}   
                            

CString BETool::GetOption(void) const
{
    CString str = " ";
       
    str += m_strPath;
    str += " ";
    str += m_strProg;
    str += " ";
    
    return str;     
}

