/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/BL.CPP   1.5   20 Jun 1996 09:29:52   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/BL.CPP  $
** 
**    Rev 1.5   20 Jun 1996 09:29:52   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.3   10 Jun 1996 10:24:30   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.1   29 May 1996 09:36:34   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// bl.cpp
//
// Michael Long
//                                                                           
// 5/13/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "bl.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void BLTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);                    
    dc << "m_fZ = " << m_fZ << "\n"; 
    dc << "m_fX = " << m_fX << "\n";
    dc << "m_fW = " << m_fW << "\n";
    
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n";    
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void BLTool::SetDefault(void)
{                                                    
    m_fZ = TRUE;
    m_fX = FALSE;
    m_fW = TRUE;
    m_strMore = " ";  
    m_strPath = "c:\\icc51 ";
}

BOOL BLTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 3;
    
    char bch[nCnt];
    
    if(fread(bch, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_fZ = bch[0];
    m_fX = bch[1];
    m_fW = bch[2];
    
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}                 

BOOL BLTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 3;

    char bch[nCnt];
    
    bch[0] = m_fZ;
    bch[1] = m_fX;
    bch[2] = m_fW;    
    if(fwrite(bch, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = m_strMore.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    wLen = m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}

CString BLTool::GetOption(void)
{
    CString str = " ";

          
    if(m_fZ)
        str += "-c8051 ";
          
    if(m_fX)
        str += "-z ";
        
    if(m_fW)
        str += "-FDEBUG ";

    str += m_strMore;
    str += " ";
    
    return str;
}

