/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/BLIB.CPP   1.4   20 Jun 1996 09:29:20   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/BLIB.CPP  $
** 
**    Rev 1.4   20 Jun 1996 09:29:20   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.2   10 Jun 1996 10:23:58   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.0   29 May 1996 09:35:30   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// blib.cpp
//
// Roger Zhang
//                                                                           
// 5/2/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "blib.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void BLIBTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);                    
    dc << "m_nMemoryModel = " << m_nMemoryModel << "\n";
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void BLIBTool::SetDefault(void)
{                                                    
    m_nMemoryModel=0;
    m_strMore = " ";
    m_strPath = "c:\\icc51 ";
}

BOOL BLIBTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 1;
    
    char ach[nCnt];
    
    if(fread(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_nMemoryModel = ach[0];
        
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen); 
     
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen); 
    
    return TRUE;
}                 

BOOL BLIBTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 1;

    char ach[nCnt];
    
    ach[0] = m_nMemoryModel;
    if(fwrite(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = m_strMore.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    wLen = m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}
 
static char * ar1[6] = { "CL8051T.R03  ", "CL8051S.R03 ", "CL8051C.R03 ", "CL8051M.R03 ", "CL8051L.R03","CL8051B.R03 " }; 

CString BLIBTool::GetOption(void)
{
    CString str = " "; 
    
    CString blibstr;
    if(m_strPath[m_strPath.GetLength()-1]!='\\')
    blibstr = m_strPath + "\\"; 
    str += blibstr;
    str += ar1[m_nMemoryModel];
    
    str += m_strMore;
    str += " ";
    
    return str;
}

