/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/BOPT.CPP   1.5   20 Jun 1996 09:29:50   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/BOPT.CPP  $
** 
**    Rev 1.5   20 Jun 1996 09:29:50   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.3   10 Jun 1996 10:24:28   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.1   29 May 1996 09:36:30   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// bopt.cpp
//
// Michael Long
//                                                                           
// 5/16/1996
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "resource.h"

#include "toolopt.h"    
#include "bc.h"
#include "bcoption.h"
#include "ba.h"
#include "baoption.h"
#include "bl.h"
#include "bloption.h"
#include "be.h"
#include "beoption.h"
#include "blib.h"
#include "blibopti.h"
#include "btab.h"
#include "projopt.h"
#include "bopt.h"   

/////////////////////////////////////////////////////////////////////////////
// operations
void BOption::SetOption(CWnd *pParent)
{
    CBTab dlg(&m_bcTool, &m_baTool, &m_blTool, &m_blibTool,&m_beTool, pParent);
    dlg.DoModal();
}

BOOL BOption::SaveOption(FILE * fp)
{                              
    ASSERT(fp);
    
    if(!m_bcTool.SaveOption(fp))
        return FALSE;
    if(!m_baTool.SaveOption(fp))
        return FALSE;
    if(!m_blTool.SaveOption(fp))
        return FALSE;
    if(!m_blibTool.SaveOption(fp))
        return FALSE; 
    if(!m_beTool.SaveOption(fp))
        return FALSE; 
    if((_stricmp(m_beTool.m_strPath," ")!=0)&&(_stricmp(m_beTool.m_strProg,"c:\\ ")!=0))
       m_fValid=TRUE;
    else
       m_fValid=FALSE; 
    return TRUE;
}
                
BOOL BOption::LoadOption(FILE * fp)
{                              
    ASSERT(fp);
    
    if(!m_bcTool.LoadOption(fp))
        return FALSE;
    if(!m_baTool.LoadOption(fp))
        return FALSE;
    if(!m_blTool.LoadOption(fp))
        return FALSE;
    if(!m_blibTool.LoadOption(fp))
        return FALSE;
    if(!m_beTool.LoadOption(fp))
        return FALSE;
     if((_stricmp(m_beTool.m_strPath," ")!=0)&&(_stricmp(m_beTool.m_strProg,"c:\\ ")!=0))
       m_fValid=TRUE;
    else
       m_fValid=FALSE;     
    return TRUE;
}                
    
// return 0:c file, 1:asm file, 2:other file(library)    
int BOption::GetFileType(LPCSTR lpcszFile) const
{              
    ASSERT(lpcszFile);

    char ext[_MAX_EXT];

    _splitpath(lpcszFile, NULL, NULL, NULL, ext);
    if(_stricmp(ext, ".c") == 0) {
        return 0;                
    } else if(_stricmp(ext, ".S03") == 0) {
        return 1;
    } else {
        return 2;
    }
}        

BOOL BOption::CreateLinkCmdFile(const CStringList &lst, LPCSTR lpcszProj)
{
    POSITION pos;
    CString str1, str2;
    FILE * fp;
    int i;
    
    fp = fopen(GetName(lpcszProj, ".XCL"), "wt");
    if(!fp)
        goto CMDFAIL;
             
    for(i = 0, pos = lst.GetHeadPosition(); pos != NULL; i ++) {
        str2 = lst.GetNext(pos);
        
        if(GetFileType(str2) != 2)
            str1 = GetName(str2, ".R03");
        else
            str1 = str2;
            
        if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) 
            != 1)
            goto CMDFAIL;
        else
            str1.ReleaseBuffer();
            
        if(i < lst.GetCount() - 1) {
            if(fputc(',', fp) == EOF)          
                goto CMDFAIL;
        } else {
            if(fputc(' ', fp) == EOF)          
                goto CMDFAIL;
        }
        if(fputc('\n', fp) == EOF)          
            goto CMDFAIL;
    }
     str1 = ",";
    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else 
        str1.ReleaseBuffer();
        
    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;
                         
    
    str1 = m_blibTool.GetOption();

    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else
        str1.ReleaseBuffer();

    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;
 
                      
    str1 = m_blTool.GetOption();
    
    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else
        str1.ReleaseBuffer();

    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;
     
    str1 = " ";
    str1 += "-x ";
    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else
        str1.ReleaseBuffer();

    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;
        
    str1 =" ";
    str1+="-l ";
    str1+=GetName(lpcszProj,".map");
    
    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else
        str1.ReleaseBuffer();

    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;

    str1 =" ";
    str1+="-o ";
    if(m_blTool.m_fW==TRUE)
    str1+=GetName(lpcszProj,".DBG");  
    else
    str1+=GetName(lpcszProj,".A03");

    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else
        str1.ReleaseBuffer();

    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;

    fclose(fp);
    return TRUE;
                     
CMDFAIL:
    AfxMessageBox("Failed to create link command file!");                    
    if(fp)
        fclose(fp);
    return FALSE;
}                                              

BOOL BOption::WriteBatchFile(FILE * fp, LPCSTR lpcszText)
{
    ASSERT(fp);
    
    if(fwrite(lpcszText, lstrlen(lpcszText), 1, fp) != 1) 
        goto BATFAIL;
    if(fputc('\n', fp) == EOF)
        goto BATFAIL;
        
    return TRUE;

BATFAIL:    
    fclose(fp); 
    AfxMessageBox("Failed to create batch file!");
    return FALSE;
}


void BOption::Build(const CStringList &lst, LPCSTR lpcszProj)
{
    POSITION pos;   
    CString str;
    CString strBuild;
    CString cstr;
    CString astr;
    CString lstr;
    if((m_bcTool.m_strPath)[(m_bcTool.m_strPath).GetLength()-1]!='\\')
    cstr = m_bcTool.m_strPath + "\\";
    if((m_baTool.m_strPath)[(m_baTool.m_strPath).GetLength()-1]!='\\')
    astr = m_baTool.m_strPath + "\\";
    if((m_blTool.m_strPath)[(m_blTool.m_strPath).GetLength()-1]!='\\')
    lstr = m_blTool.m_strPath + "\\";    
    
    int nType;                   
    FILE * fp;
    
    fp = fopen(GetName(lpcszProj, ".bat"), "wt");
    if(!fp) {
        AfxMessageBox("Failed to create batch file!");
        return;
    }
    
    // compile or macro preprocess
    for(pos = lst.GetHeadPosition(); pos != NULL; ) {
        str = lst.GetNext(pos);
        nType = GetFileType(str);
        if(nType == 0) {    // c file
            strBuild = cstr + "ICC8051.exe ";
            strBuild += m_bcTool.GetOption();
            strBuild += str;
            strBuild += " -o ";
            strBuild += GetName(str, ".R03");           
        } else if(nType == 1) { // asm file
            strBuild = astr + "A8051.exe ";
            strBuild += str;
            strBuild += " ";
            strBuild += GetName(str,".LST");
            strBuild += " ";
            strBuild += GetName(str, ".R03");
            strBuild += " "; 
            strBuild +=m_baTool.GetOption();
                        
        } else {
            continue;
        }            
                
        if(!WriteBatchFile(fp, strBuild))
            return;
     
    }                                   
    
    // link
    if(!CreateLinkCmdFile(lst, lpcszProj))
        return;
    strBuild = lstr + "XLINK.exe ";
    strBuild += "-f "; 
    strBuild += GetName(lpcszProj, ".XCL");
    if(!WriteBatchFile(fp, strBuild))
        return;

    fclose(fp);
    
    WinExec(GetName(lpcszProj, ".bat"), SW_SHOW);
}
 
 void BOption::Editor(void)
  {
   CString str;             
   FILE *fp;                  
   fp = fopen("bedit.bat","wt");
    if(!fp) {
        AfxMessageBox("Failed to create batch file!");
        return;
    }
   
    char drive[_MAX_DRIVE], dir[_MAX_DIR];
    char fname[_MAX_FNAME],  ext[_MAX_EXT];
   
    _splitpath(m_beTool.m_strPath, drive, dir, fname, ext);
    if(_stricmp(ext,".exe")==0||_stricmp(ext,".com")==0)
    {
     AfxMessageBox("Editor command error!");
     return;
    
     }
   str = m_beTool.GetOption();
   if(!WriteBatchFile(fp, str))
        return;
   
   fclose(fp);
   WinExec("bedit.bat", SW_SHOW);
} 
                