/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/C51ADR.H__   1.8   20 Jun 1996 09:28:50   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/C51ADR.H__  $
** 
**    Rev 1.8   20 Jun 1996 09:28:50   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:23:28   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:34:46   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:00:12   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:16:46   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:31:06   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:56:20   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.0   12 Apr 1996 10:35:52   Shirley
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:      C51adr.h
**
**  Description:  The sub class C51adr deprived from the CFormatAddress
**                This class is process the 51 base family address
**                51 base family address has the format as following
**                      prefix:address
**                prefix is the space area. Those are :
**                      p: program
**                      x: external
**                      i: internal
**                      b: bit area
**                      r: SFR
**                The address has two format: Hex and Dec
**                      Hex has the prefix before address that is 0x
**                      Dec has no prefix
**
**                Another : the address is a symbol. The symbol has the format
**                as following:
**                      #ModuleName#SymbolName etc.
**                The process must deal all the statment described as before.
**
**  Status: Initialization
**          1996/02/15        Daniel Lin
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

#ifndef __C51ADR__H
#define __C51ADR__H


class C51Address : CFormatAddress
{
   private:
      BOOL     IsString;               // Construct from a string;
 ADDR_RETCODE  m_enumRetCode;          // Return code

      // Attribute
      CString  m_strSpace;             // The address space text string,
                                       // 'p'-->'Program';
   ADDR_SPACE  m_enumSpace;            // The enum space

   private:
      // Implenmentation
      void  Initialize();                    // Initialize all attributes
      BOOL  Process(CFormatType *format);    // Process the address server

   public:
      //Constructor
      C51Address() {
      	Initialize();
      }
      
      C51Address(const CString& str);        // from CString
      C51Address(const LPSTR lpsz);          // from LPSTR
      C51Address(const CString& str, 
                 const UINT isHex);          // from CString
      C51Address(const LPSTR lpsz,
                 const UINT isHex);          // from LPSTR
      C51Address(ADDR_SIZE dw);              // from ADDR_SIZE
      C51Address(ADDRESS  adr);              // from ADDRESS struct
      //C51Address(const C51Address &c51adr);// copy constructor

      //Inline function
      CString GetHexAddr();
      CString GetDecAddr();
 ADDR_RETCODE GetRetCode();
 ADDR_SPACE   GetSpace();
 ADDR_SIZE    GetAddress();
 
      // virtual function deprived from parent class
      virtual BOOL  ConvertCheck();                  // Convert the address and
                                                     // check it

      virtual BOOL  SplitPrefix(const char* lpsz);   // Split the prefix and
                                                     // address
};

#endif

////////////////////////////////(EOF)////////////////////////////////////////
