/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/CC.CPP   1.4   20 Jun 1996 09:29:20   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/CC.CPP  $
** 
**    Rev 1.4   20 Jun 1996 09:29:20   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.2   10 Jun 1996 10:23:58   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.0   29 May 1996 09:35:32   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// cc.cpp
//
// michael long
//                                                                           
// 5/15/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "cc.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void CCTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void CCTool::SetDefault(void)
{
    m_strMore = " ";
    m_strPath = "c:\\2500ad "; 
}

BOOL CCTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    return TRUE;
}                 

BOOL CCTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    WORD wLen = m_strMore.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    wLen = m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}   
                            
CString CCTool::GetOption(void) const
{
    CString str = " ";
           
    str += m_strMore;
    str += " ";
    
    return str;     
}

